/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.base.workbench;

import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureFile;
import com.hello2morrow.sonargraph.core.model.architecture.IArchitectureProvider;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.IDomainRoot;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.path.IComponent;
import com.hello2morrow.sonargraph.core.model.programming.LogicalModuleProgrammingElement;
import com.hello2morrow.sonargraph.foundation.utilities.IStandardEnumeration;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.ArchitectureViewShowInViewRequest;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchState;
import com.hello2morrow.sonargraph.ui.swt.common.ShowInView;
import com.hello2morrow.sonargraph.ui.swt.common.ShowInViewNode;
import com.hello2morrow.sonargraph.ui.swt.common.SupportsShowInView;
import java.util.ArrayList;
import java.util.List;

final class ArchitectureViewShowInViewSupport
extends SupportsShowInView {
    ArchitectureViewShowInViewSupport(String presentationName, String imageName) {
        super(presentationName, imageName);
    }

    @Override
    public boolean isPotentialDoubleClickTarget() {
        return false;
    }

    @Override
    public ShowInView supportsShowInViewFor(List<Element> selectedElements, List<IStandardEnumeration> options, String secondaryIdForReuse) {
        IArchitectureProvider provider;
        List elements;
        assert (selectedElements != null) : "Parameter 'selectedElements' of method 'supportsShowInViewFor' must not be null";
        assert (options != null) : "Parameter 'options' of method 'supportsShowInViewFor' must not be null";
        assert (secondaryIdForReuse == null) : "Parameter 'secondaryIdForReuse' of method 'supportsShowInViewFor' must  be null";
        if (!selectedElements.isEmpty() && WorkbenchRegistry.getInstance().hasState(WorkbenchState.SOFTWARE_SYSTEM_OPENED) && !(elements = (provider = (IArchitectureProvider)WorkbenchRegistry.getInstance().getProvider().getSoftwareSystem().getExtension(IArchitectureProvider.class)).getArchitectureRelatedElements(selectedElements)).isEmpty()) {
            List checkedArchitectureFiles;
            boolean includePhysical = false;
            boolean includeLogical = false;
            for (NamedElement next : elements) {
                if (next instanceof IComponent) {
                    includePhysical = true;
                    continue;
                }
                if (next instanceof LogicalModuleProgrammingElement) {
                    includeLogical = true;
                    continue;
                }
                includePhysical = false;
                includeLogical = false;
                break;
            }
            ArrayList<ArchitectureFile> physical = new ArrayList<ArchitectureFile>();
            ArrayList<ArchitectureFile> logical = new ArrayList<ArchitectureFile>();
            if ((includePhysical || includeLogical) && (includePhysical || includeLogical) && !(checkedArchitectureFiles = provider.getCheckedArchitectureFiles()).isEmpty()) {
                for (ArchitectureFile next : checkedArchitectureFiles) {
                    IDomainRoot.Domain nextDomain = next.getDomain();
                    assert (nextDomain != null) : "'nextDomain' of method 'supportsShowInViewFor' must not be null for architecture file";
                    if (nextDomain.isPhysical()) {
                        if (!includePhysical) continue;
                        physical.add(next);
                        continue;
                    }
                    if (!includeLogical) continue;
                    logical.add(next);
                }
            }
            if (physical.isEmpty() && logical.isEmpty()) {
                return new ShowInView(new ShowInViewNode("Show in " + this.getViewPresentationName() + " view", this.getImageName(), elements, new IStandardEnumeration[0]));
            }
            ShowInViewNode menu = new ShowInViewNode("Show in " + this.getViewPresentationName() + " view", this.getImageName());
            ShowInView showInView = new ShowInView(menu);
            menu.addChild(new ShowInViewNode("Show in " + this.getViewPresentationName() + " view", this.getImageName(), elements, new IStandardEnumeration[0]));
            for (ArchitectureFile next : physical) {
                menu.addChild(new ShowInViewNode("Show in " + this.getViewPresentationName() + " view (" + next.getIdentifyingPath() + " <physical>)", this.getImageName(), elements, new ArchitectureViewShowInViewRequest(next)));
            }
            for (ArchitectureFile next : logical) {
                menu.addChild(new ShowInViewNode("Show in " + this.getViewPresentationName() + " view (" + next.getIdentifyingPath() + " <logical>)", this.getImageName(), elements, new ArchitectureViewShowInViewRequest(next)));
            }
            return showInView;
        }
        return null;
    }
}

