/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.base.view;

import java.util.List;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public final class AggregatingViewerFilter
extends ViewerFilter {
    private final List<ViewerFilter> m_filters;
    private int m_filteredCount = 0;
    private int m_numberOfShownRootElements = 0;
    private final Class<?> m_rootElementClass;

    public AggregatingViewerFilter(List<ViewerFilter> filters, Class<?> rootElementClass) {
        assert (filters != null) : "Parameter 'filters' of method 'AggregatingViewerFilter' must not be null";
        assert (rootElementClass != null) : "Parameter 'rootElementClass' of method 'AggregatingViewerFilter' must not be null";
        this.m_filters = filters;
        this.m_rootElementClass = rootElementClass;
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        for (ViewerFilter next : this.m_filters) {
            if (next.select(viewer, parentElement, element)) continue;
            ++this.m_filteredCount;
            return false;
        }
        if (element != null && this.m_rootElementClass.isAssignableFrom(element.getClass())) {
            ++this.m_numberOfShownRootElements;
        }
        return true;
    }

    public int getFilteredCount() {
        return this.m_filteredCount;
    }

    public int getNumberOfShownRootElements() {
        return this.m_numberOfShownRootElements;
    }

    public List<ViewerFilter> getFilters() {
        return this.m_filters;
    }
}

