/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.base.textsearch;

import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.ui.swt.base.textsearch.OffsetBasedSelectedTextInfo;
import com.hello2morrow.sonargraph.ui.swt.base.textsearch.SelectedTextInfo;
import com.hello2morrow.sonargraph.ui.swt.base.textsearch.SourceBasedTextSearchHandler;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;

public final class StyledTextBasedTextSearchHandler
extends SourceBasedTextSearchHandler {
    public StyledTextBasedTextSearchHandler(StyledText styledText, boolean supportsReplace, String connectedTo) {
        super(styledText, supportsReplace, connectedTo);
    }

    @Override
    protected SelectedTextInfo getSelectedTextInfo() {
        return this.getSelectedTextInfoFromStyledText();
    }

    @Override
    protected int calculatePositionForFind() {
        return this.getStyledText().getCaretOffset();
    }

    public final OffsetBasedSelectedTextInfo getSelectedTextInfoFromStyledText() {
        String selectedText = this.getStyledText().getSelectionText();
        if (selectedText != null) {
            Point selectionRange = this.getStyledText().getSelectionRange();
            if (selectionRange.y != 0) {
                try {
                    char check;
                    int offsetOfSelection = selectionRange.x;
                    int lineNumber = this.getStyledText().getLineAtOffset(offsetOfSelection);
                    String content = this.getStyledText().getLine(lineNumber);
                    int offsetOfLine = this.getStyledText().getOffsetAtLine(lineNumber);
                    int relOffset = offsetOfSelection - offsetOfLine;
                    boolean leftIsWhitespaceOrNonIdentifierPart = false;
                    leftIsWhitespaceOrNonIdentifierPart = relOffset == 0 ? true : StringUtility.isWhitespace((char)(check = content.charAt(relOffset - 1))) || !Character.isJavaIdentifierPart(check);
                    boolean rightIsWhitespaceOrNonIdentifierPart = false;
                    if (leftIsWhitespaceOrNonIdentifierPart) {
                        char check2;
                        rightIsWhitespaceOrNonIdentifierPart = relOffset + selectedText.length() >= content.length() ? true : StringUtility.isWhitespace((char)(check2 = content.charAt(relOffset + selectedText.length()))) || !Character.isJavaIdentifierPart(check2);
                    }
                    boolean containsWhiteSpaceOrNonIdentifier = false;
                    if (leftIsWhitespaceOrNonIdentifierPart && rightIsWhitespaceOrNonIdentifierPart) {
                        int i = 0;
                        while (i < selectedText.length()) {
                            char nextChar = selectedText.charAt(i);
                            if (StringUtility.isWhitespace((char)nextChar) || !Character.isJavaIdentifierPart(nextChar)) {
                                containsWhiteSpaceOrNonIdentifier = true;
                                break;
                            }
                            ++i;
                        }
                    }
                    return new OffsetBasedSelectedTextInfo(selectedText, offsetOfSelection, leftIsWhitespaceOrNonIdentifierPart && rightIsWhitespaceOrNonIdentifierPart && !containsWhiteSpaceOrNonIdentifier, lineNumber);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        return OffsetBasedSelectedTextInfo.NO_SELECTION;
    }
}

