/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.base.draw2d;

import com.hello2morrow.draw2d.Dimension;
import com.hello2morrow.draw2d.ScalableFigure;
import com.hello2morrow.sonargraph.ui.swt.base.draw2d.ISizeProvider;

final class ZoomManager {
    private final ISizeProvider m_provider;
    private final ScalableFigure m_scalableFigure;
    private final double m_maxScale;
    private double m_scaleStep = 0.1f;
    private double m_minScale;

    ZoomManager(ISizeProvider provider, ScalableFigure scalableFigure, double minScale, double maxScale) {
        assert (provider != null) : "Parameter 'provider' of method 'ZoomManager' must not be null";
        assert (scalableFigure != null) : "Parameter 'scalableFigure' of method 'ZoomManager' must not be null";
        assert (minScale < maxScale) : "Min scale must be less than max scale";
        assert (minScale > 0.0) : "Min scale must not be nagative";
        assert (maxScale > 0.0) : "Max scale must not be nagative";
        this.m_provider = provider;
        this.m_scalableFigure = scalableFigure;
        this.m_minScale = minScale;
        this.m_maxScale = maxScale;
    }

    void zoomIn() {
        double newScale = Math.min(this.m_scalableFigure.getScale() + this.m_scaleStep, this.m_maxScale);
        this.m_scalableFigure.setScale(newScale);
    }

    void zoomOut() {
        double newScale = Math.max(this.m_scalableFigure.getScale() - this.m_scaleStep, this.m_minScale);
        this.m_scalableFigure.setScale(newScale);
    }

    void fitToView(FitMode fitMode) {
        assert (fitMode != null) : "Parameter 'fitMode' of method 'fitToView' must not be null";
        double newScale = this.getScaleForFitToView(fitMode);
        this.m_scalableFigure.setScale(newScale);
    }

    private double getScaleForFitToView(FitMode fitMode) {
        assert (fitMode != null) : "Parameter 'fitMode' of method 'getScaleForFitToView' must not be null";
        this.m_scalableFigure.getUpdateManager().performUpdate();
        Dimension needed = this.m_provider.getNeededSize();
        Dimension available = this.m_provider.getAvailableSize();
        double scale = fitMode == FitMode.HORIZONTAL ? (double)available.width / (double)needed.width : (double)available.height / (double)needed.height;
        return Math.min(scale, this.m_maxScale);
    }

    double getScale() {
        return this.m_scalableFigure.getScale();
    }

    void setScale(double zoomLevel) {
        this.m_scalableFigure.setScale(zoomLevel);
    }

    void setMinScale(double minScale) {
        this.m_minScale = minScale;
    }

    void setScaleStep(double scaleStep) {
        this.m_scaleStep = scaleStep;
    }

    static enum FitMode {
        HORIZONTAL,
        VERTICAL;

    }
}

