/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.base.draw2d;

import com.hello2morrow.draw2d.Dimension;
import com.hello2morrow.draw2d.Figure;
import com.hello2morrow.draw2d.FigureCanvas;
import com.hello2morrow.draw2d.IFigure;
import com.hello2morrow.draw2d.Layer;
import com.hello2morrow.draw2d.Point;
import com.hello2morrow.draw2d.Rectangle;
import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureFile;
import com.hello2morrow.sonargraph.core.model.common.PresentationMode;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.programming.CoreParserDependencyType;
import com.hello2morrow.sonargraph.core.model.programming.NodeAdapter;
import com.hello2morrow.sonargraph.core.model.representation.FocusMode;
import com.hello2morrow.sonargraph.core.model.representation.NodeAndEdgeRepresentation;
import com.hello2morrow.sonargraph.core.model.representation.RepresentationDependency;
import com.hello2morrow.sonargraph.core.model.representation.RepresentationEdge;
import com.hello2morrow.sonargraph.core.model.representation.RepresentationElement;
import com.hello2morrow.sonargraph.core.model.representation.RepresentationNode;
import com.hello2morrow.sonargraph.foundation.utilities.Pair;
import com.hello2morrow.sonargraph.foundation.utilities.ShortBitFieldUtil;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import com.hello2morrow.sonargraph.ui.swt.base.draw.DrawLightweightSystem;
import com.hello2morrow.sonargraph.ui.swt.base.draw.DrawViewport;
import com.hello2morrow.sonargraph.ui.swt.base.draw2d.AutozoomMode;
import com.hello2morrow.sonargraph.ui.swt.base.draw2d.DrawableNodeComparator;
import com.hello2morrow.sonargraph.ui.swt.base.draw2d.DrawableViewContentFigure;
import com.hello2morrow.sonargraph.ui.swt.base.draw2d.DrawableViewLayout;
import com.hello2morrow.sonargraph.ui.swt.base.draw2d.DrawableWidgetSelection;
import com.hello2morrow.sonargraph.ui.swt.base.draw2d.IDrawableFigure;
import com.hello2morrow.sonargraph.ui.swt.base.draw2d.IDrawableNode;
import com.hello2morrow.sonargraph.ui.swt.base.draw2d.IDrawableWidgetListener;
import com.hello2morrow.sonargraph.ui.swt.base.view.SelectionProviderAdapter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DrawableWidget
extends FigureCanvas
implements IDrawableFigure.IDrawableFigureListener,
ControlListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(DrawableWidget.class);
    private static final int NODE_OFFSET = 20;
    private final SelectionProviderAdapter m_selectionProviderAdapter;
    private final Map<RepresentationNode, IDrawableNode> m_nodeToFigure = new LinkedHashMap<RepresentationNode, IDrawableNode>();
    private final Map<RepresentationEdge<? extends RepresentationNode>, IDrawableNode.IDrawableEdge<? extends IDrawableNode>> m_edgeToEdgeFigure = new LinkedHashMap<RepresentationEdge<? extends RepresentationNode>, IDrawableNode.IDrawableEdge<? extends IDrawableNode>>();
    private final Map<Pair<NamedElement, NamedElement>, RepresentationEdge<? extends RepresentationNode>> m_dependencyToEdge = new LinkedHashMap<Pair<NamedElement, NamedElement>, RepresentationEdge<? extends RepresentationNode>>();
    private final DrawableWidgetSelection m_drawableWidgetSelection = new DrawableWidgetSelection();
    private final DrawableViewContentFigure m_contentFigure;
    private final AutozoomMode m_autozoomMode;
    private List<IDrawableNode> m_nodesSortedByUI;
    private NodeAndEdgeRepresentation m_currentRepresentation;
    private IDrawableWidgetListener m_drawableFigureListener;
    private short m_state;

    public DrawableWidget(Composite parent, SelectionProviderAdapter selectionProviderAdapter, DrawableViewLayout layout, AutozoomMode autozoomMode) {
        super(parent, new DrawLightweightSystem());
        assert (selectionProviderAdapter != null) : "Parameter 'selectionProviderAdapter' of method 'BaseView' must not be null";
        assert (layout != null) : "Parameter 'layout' of method 'DrawableView' must not be null";
        this.setBackground(UiResourceManager.getInstance().getBackgroundColor());
        this.m_selectionProviderAdapter = selectionProviderAdapter;
        this.m_contentFigure = new DrawableViewContentFigure(layout, (Control)this);
        this.setViewport(new DrawViewport());
        this.setContents(this.m_contentFigure);
        this.m_autozoomMode = autozoomMode;
        this.getFigureCanvas().setScrollBarVisibility(FigureCanvas.ALWAYS);
        this.setShowOnlyDependenciesOfSelectedNodes(false);
        this.setShowOnlyViolations(false);
        this.setHideSelfArcs(false);
        this.setAutozoomEnabled(true);
        this.setPerformControlResized(false);
        this.setAdjustEdges(false);
        this.setReactToMouseEvents(false);
    }

    @Override
    public void dispose() {
        this.m_contentFigure.dispose();
        this.removeControlListener(this);
        this.setReactToMouseEvents(false);
        super.dispose();
    }

    public final void setLayout(DrawableViewLayout layout) {
        assert (layout != null) : "Parameter 'layout' of method 'setLayout' must not be null";
        this.deselectAll();
        this.m_contentFigure.setLayout(layout);
        this.reLayout(true);
        this.processAutoZoom();
    }

    private final void setHighlightOriginalInput(boolean highlightOriginalInput) {
        this.m_state = highlightOriginalInput ? ShortBitFieldUtil.enableFlag((short)this.m_state, (short)((short)(1 << WidgetProperty.HIGHLIGHT_ORIGINAL_INPUT.ordinal()))) : ShortBitFieldUtil.disableFlag((short)this.m_state, (short)((short)(1 << WidgetProperty.HIGHLIGHT_ORIGINAL_INPUT.ordinal())));
    }

    public final boolean isHighlightOriginalInputEnabled() {
        return ShortBitFieldUtil.isFlagEnabled((short)this.m_state, (short)((short)(1 << WidgetProperty.HIGHLIGHT_ORIGINAL_INPUT.ordinal())));
    }

    private final void setShowOnlyDependenciesOfSelectedNodes(boolean showOnlyDependenciesOfSelectedNodes) {
        this.m_state = showOnlyDependenciesOfSelectedNodes ? ShortBitFieldUtil.enableFlag((short)this.m_state, (short)((short)(1 << WidgetProperty.SHOW_ONLY_DEPENDENCIES_OF_SELECTED_NODES.ordinal()))) : ShortBitFieldUtil.disableFlag((short)this.m_state, (short)((short)(1 << WidgetProperty.SHOW_ONLY_DEPENDENCIES_OF_SELECTED_NODES.ordinal())));
    }

    protected final boolean showOnlyDependenciesOfSelectedNodes() {
        return ShortBitFieldUtil.isFlagEnabled((short)this.m_state, (short)((short)(1 << WidgetProperty.SHOW_ONLY_DEPENDENCIES_OF_SELECTED_NODES.ordinal())));
    }

    private final void setShowOnlyViolations(boolean showOnlyViolations) {
        this.m_state = showOnlyViolations ? ShortBitFieldUtil.enableFlag((short)this.m_state, (short)((short)(1 << WidgetProperty.SHOW_ONLY_VIOLATIONS.ordinal()))) : ShortBitFieldUtil.disableFlag((short)this.m_state, (short)((short)(1 << WidgetProperty.SHOW_ONLY_VIOLATIONS.ordinal())));
    }

    public final boolean showOnlyViolations() {
        return ShortBitFieldUtil.isFlagEnabled((short)this.m_state, (short)((short)(1 << WidgetProperty.SHOW_ONLY_VIOLATIONS.ordinal())));
    }

    private final void setHideSelfArcs(boolean hideSelfArcs) {
        this.m_state = hideSelfArcs ? ShortBitFieldUtil.enableFlag((short)this.m_state, (short)((short)(1 << WidgetProperty.HIDE_SELF_ARCS.ordinal()))) : ShortBitFieldUtil.disableFlag((short)this.m_state, (short)((short)(1 << WidgetProperty.HIDE_SELF_ARCS.ordinal())));
    }

    protected final boolean hideSelfArcs() {
        return ShortBitFieldUtil.isFlagEnabled((short)this.m_state, (short)((short)(1 << WidgetProperty.HIDE_SELF_ARCS.ordinal())));
    }

    public final void setAutozoomEnabled(boolean autozoomEnabled) {
        this.m_state = autozoomEnabled ? ShortBitFieldUtil.enableFlag((short)this.m_state, (short)((short)(1 << WidgetProperty.AUTOZOOM_ENABLED.ordinal()))) : ShortBitFieldUtil.disableFlag((short)this.m_state, (short)((short)(1 << WidgetProperty.AUTOZOOM_ENABLED.ordinal())));
    }

    public final boolean autozoomEnabled() {
        return ShortBitFieldUtil.isFlagEnabled((short)this.m_state, (short)((short)(1 << WidgetProperty.AUTOZOOM_ENABLED.ordinal())));
    }

    private final void setPerformControlResized(boolean performControlResized) {
        this.m_state = performControlResized ? ShortBitFieldUtil.enableFlag((short)this.m_state, (short)((short)(1 << WidgetProperty.PERFORM_CONTROL_RESIZED.ordinal()))) : ShortBitFieldUtil.disableFlag((short)this.m_state, (short)((short)(1 << WidgetProperty.PERFORM_CONTROL_RESIZED.ordinal())));
    }

    private final boolean performControlResized() {
        return ShortBitFieldUtil.isFlagEnabled((short)this.m_state, (short)((short)(1 << WidgetProperty.PERFORM_CONTROL_RESIZED.ordinal())));
    }

    private final void setAdjustEdges(boolean adjustEdges) {
        this.m_state = adjustEdges ? ShortBitFieldUtil.enableFlag((short)this.m_state, (short)((short)(1 << WidgetProperty.ADJUST_EDGES.ordinal()))) : ShortBitFieldUtil.disableFlag((short)this.m_state, (short)((short)(1 << WidgetProperty.ADJUST_EDGES.ordinal())));
    }

    protected final boolean adjustEdges() {
        return ShortBitFieldUtil.isFlagEnabled((short)this.m_state, (short)((short)(1 << WidgetProperty.ADJUST_EDGES.ordinal())));
    }

    private void setReactToMouseEvents(boolean reactToMouseEvents) {
        this.m_state = reactToMouseEvents ? ShortBitFieldUtil.enableFlag((short)this.m_state, (short)((short)(1 << WidgetProperty.REACT_TO_MOUSE_EVENTS.ordinal()))) : ShortBitFieldUtil.disableFlag((short)this.m_state, (short)((short)(1 << WidgetProperty.REACT_TO_MOUSE_EVENTS.ordinal())));
    }

    private boolean reactToMouseEvents() {
        return ShortBitFieldUtil.isFlagEnabled((short)this.m_state, (short)((short)(1 << WidgetProperty.REACT_TO_MOUSE_EVENTS.ordinal())));
    }

    public final void setSelection(Set<NamedElement> selection) {
        assert (selection != null) : "Parameter 'selection' of method 'setSelection' must not be null";
        this.selected(selection.stream().map(element -> this.m_currentRepresentation.getNode(element)).filter(node -> node != null).filter(node -> node.isVisible()).map(node -> this.m_nodeToFigure.get(node)).filter(figure -> figure != null).collect(Collectors.toSet()), false, false);
    }

    public final void reveal(IDrawableNode node) {
        assert (node != null) : "Parameter 'node' of method 'reveal' must not be null";
        this.getViewport().validate();
        Rectangle nodeBoundingBox = node.getBounds();
        int scrollToX = (int)Math.min((double)this.getHorizontalBar().getMaximum(), (double)nodeBoundingBox.x * this.m_contentFigure.getScale() - (double)(nodeBoundingBox.width / 2) * this.m_contentFigure.getScale() - 20.0 * this.m_contentFigure.getScale());
        int scrollToY = (int)Math.min((double)this.getVerticalBar().getMaximum(), (double)nodeBoundingBox.y * this.m_contentFigure.getScale() - 20.0 * this.m_contentFigure.getScale());
        this.scrollTo(scrollToX, scrollToY);
    }

    protected boolean edgesHavePrecedence() {
        return true;
    }

    protected abstract <T extends NodeAndEdgeRepresentation> void showInternal(T var1, Map<NamedElement, Color> var2);

    public abstract void updateColors(Map<NamedElement, Color> var1, ArchitectureFile var2);

    public final void clear() {
        this.m_contentFigure.setVisible(false);
        this.m_currentRepresentation = null;
        this.m_nodesSortedByUI = null;
        this.m_nodeToFigure.clear();
        this.m_edgeToEdgeFigure.clear();
        this.m_dependencyToEdge.clear();
        this.m_contentFigure.clear();
        this.m_drawableWidgetSelection.clear();
        this.setPerformControlResized(false);
        this.m_contentFigure.setVisible(true);
        this.m_contentFigure.setValid(false);
        this.cleared();
    }

    protected void cleared() {
    }

    public final <T extends NodeAndEdgeRepresentation> void showRepresentation(T representation, EnumSet<ShowOption> showOptions, Map<NamedElement, Color> elementToColor) {
        assert (representation != null) : "Parameter 'representation' of method 'showRepresentation' must not be null";
        assert (showOptions != null) : "Parameter 'showOptions' of method 'showRepresentation' must not be null";
        assert (elementToColor != null) : "Parameter 'elementToColor' of method 'showRepresentation' must not be null";
        this.m_currentRepresentation = null;
        this.m_nodesSortedByUI = null;
        this.m_nodeToFigure.clear();
        this.m_edgeToEdgeFigure.clear();
        this.m_dependencyToEdge.clear();
        this.m_contentFigure.clear();
        this.m_drawableWidgetSelection.clear();
        this.cleared();
        this.m_currentRepresentation = representation;
        this.showInternal(representation, elementToColor);
        if (showOptions.contains((Object)ShowOption.FIT_TO_VIEW)) {
            this.fitToView();
            double scale = this.m_contentFigure.getScale();
            if (scale < (double)0.2f) {
                this.m_contentFigure.setMinScale(scale);
                this.m_contentFigure.setScaleStep(0.05f);
            }
        } else {
            this.m_contentFigure.getUpdateManager().performUpdate();
        }
        if (showOptions.contains((Object)ShowOption.SCROLL_TO_TOP)) {
            this.scrollTo(0, 0);
        }
        this.m_contentFigure.calculateSize();
        if (showOptions.contains((Object)ShowOption.REVEAL_INPUT)) {
            List<IDrawableNode> sortedNodes = this.getSortedElementsForSearch();
            IDrawableNode nodeToReveal = null;
            for (IDrawableNode drawableNode : sortedNodes) {
                if (!((RepresentationNode)drawableNode.getRepresentationElement()).isMainNode()) continue;
                nodeToReveal = drawableNode;
                break;
            }
            if (nodeToReveal != null) {
                this.reveal(nodeToReveal);
            } else {
                LOGGER.error("No node to reveal found for representation: " + String.valueOf(representation));
            }
        }
        this.updateEdgeHighlightState();
        this.revalidateNodesAndEdges();
    }

    protected final void forceUpdate() {
        this.setRedraw(false);
        this.m_contentFigure.invalidate();
        this.m_contentFigure.getUpdateManager().performUpdate();
        this.setRedraw(true);
    }

    public final <T extends NodeAndEdgeRepresentation> void show(T representation, EnumSet<ShowOption> showOptions) {
        assert (representation != null) : "Parameter 'representation' of method 'show' must not be null";
        assert (showOptions != null) : "Parameter 'showOptions' of method 'show' must not be null";
        this.clear();
        this.m_currentRepresentation = representation;
        this.showInternal(representation, Collections.emptyMap());
        this.addControlListener(this);
        this.setReactToMouseEvents(true);
        if (showOptions.contains((Object)ShowOption.FIT_TO_VIEW)) {
            this.fitToView();
            if (this.m_contentFigure.getScale() < (double)0.2f) {
                this.m_contentFigure.setMinScale(this.m_contentFigure.getScale());
                this.m_contentFigure.setScaleStep(0.05f);
            }
        } else {
            this.m_contentFigure.getUpdateManager().performUpdate();
        }
        if (showOptions.contains((Object)ShowOption.SCROLL_TO_TOP)) {
            this.scrollTo(0, 0);
        }
        this.m_contentFigure.calculateSize();
        if (showOptions.contains((Object)ShowOption.REVEAL_INPUT)) {
            List<IDrawableNode> sortedNodes = this.getSortedElementsForSearch();
            IDrawableNode nodeToReveal = null;
            for (IDrawableNode drawableNode : sortedNodes) {
                if (!((RepresentationNode)drawableNode.getRepresentationElement()).isMainNode()) continue;
                nodeToReveal = drawableNode;
                break;
            }
            if (nodeToReveal != null) {
                this.reveal(nodeToReveal);
            } else {
                LOGGER.error("No node to reveal found for representation: " + String.valueOf(representation));
            }
        }
        this.updateEdgeHighlightState();
        this.setPerformControlResized(true);
    }

    public final void revalidateNodesAndEdges() {
        assert (this.m_currentRepresentation != null) : "'m_currentRepresentation' of method 'revalidateNodesAndEdges' must not be null";
        for (IDrawableNode node : this.getNodes()) {
            Image image = UiResourceManager.getInstance().getImage((Element)((RepresentationNode)node.getRepresentationElement()).getUnderlyingObject());
            node.setImage(image);
            node.revalidate();
        }
        this.getEdgeFigures().forEach(e -> e.revalidate());
    }

    public final FigureCanvas getFigureCanvas() {
        return this;
    }

    public final double getZoomLevel() {
        return this.m_contentFigure.getZoomLevel();
    }

    public final void setZoomLevel(double zoomLevel) {
        this.m_contentFigure.setScale(zoomLevel);
    }

    public final boolean deselectAll() {
        if (this.innerDeselectAll()) {
            this.updateEdgeHighlightState();
            this.showOnlyDependenciesOfSelectedNodes(this.showOnlyDependenciesOfSelectedNodes());
            return true;
        }
        return false;
    }

    protected final boolean innerDeselectAll() {
        HashSet<RepresentationElement> selectedElements = new HashSet<RepresentationElement>(this.getSelectedElements());
        if (!selectedElements.isEmpty()) {
            for (RepresentationElement next : selectedElements) {
                IDrawableFigure figure = null;
                if (next instanceof RepresentationNode) {
                    figure = this.getNode((RepresentationNode)next);
                } else if (next instanceof RepresentationEdge) {
                    figure = this.m_edgeToEdgeFigure.get(next);
                } else assert (false) : "Unexpected class for element" + String.valueOf(next);
                this.innerDeselect(figure);
            }
            return true;
        }
        return false;
    }

    protected abstract RepresentationElement innerDeselect(IDrawableFigure var1);

    protected final Collection<RepresentationEdge<? extends RepresentationNode>> getIncomingAndOutgoingEdges(IDrawableNode figure) {
        assert (figure != null) : "Parameter 'figure' of method 'getIncomingAndOutgoingEdges' must not be null";
        LinkedHashSet<RepresentationEdge<? extends RepresentationNode>> allEdges = new LinkedHashSet<RepresentationEdge<? extends RepresentationNode>>();
        allEdges.addAll(((RepresentationNode)figure.getRepresentationElement()).getIncomingEdges());
        allEdges.addAll(((RepresentationNode)figure.getRepresentationElement()).getOutgoingEdges());
        return allEdges;
    }

    protected final void updateEdgeHighlightState() {
        Set<IDrawableNode> selectedNodes = this.m_drawableWidgetSelection.getSelectedDrawableNodes();
        Set<IDrawableNode.IDrawableEdge<? extends IDrawableNode>> selectedEdges = this.m_drawableWidgetSelection.getSelectedDrawableEdges();
        if (selectedNodes.isEmpty() && selectedEdges.isEmpty()) {
            this.m_edgeToEdgeFigure.values().forEach(e -> e.setHighlight(true));
        } else {
            LinkedHashSet<IDrawableNode.IDrawableEdge<? extends IDrawableNode>> edgesToHighlight = new LinkedHashSet<IDrawableNode.IDrawableEdge<? extends IDrawableNode>>();
            for (IDrawableNode iDrawableNode : selectedNodes) {
                for (RepresentationEdge<? extends RepresentationNode> edge : this.getIncomingAndOutgoingEdges(iDrawableNode)) {
                    IDrawableNode.IDrawableEdge<? extends IDrawableNode> drawableEdge = this.m_edgeToEdgeFigure.get(edge);
                    assert (drawableEdge != null) : "'drawableEdge' of method 'updateEdgeHighlightState' must not be null";
                    edgesToHighlight.add(drawableEdge);
                }
            }
            edgesToHighlight.addAll(selectedEdges);
            for (IDrawableNode.IDrawableEdge iDrawableEdge : this.m_edgeToEdgeFigure.values()) {
                if (edgesToHighlight.contains(iDrawableEdge)) {
                    IFigure parent = iDrawableEdge.getParent();
                    assert (parent != null && parent instanceof Layer) : "Unexpected class in method 'edgeOnTop': " + String.valueOf(parent);
                    parent.remove(iDrawableEdge);
                    parent.add(iDrawableEdge);
                    iDrawableEdge.setHighlight(true);
                    continue;
                }
                iDrawableEdge.setHighlight(false);
            }
        }
    }

    protected final void notifySelectionChanged(RepresentationElement element, boolean selected) {
        assert (element != null) : "Parameter 'element' of method 'notifySelectionChanged' must not be null";
        if (this.m_drawableFigureListener != null) {
            if (element instanceof RepresentationNode) {
                if (selected) {
                    this.m_drawableFigureListener.nodeSelected((RepresentationNode)element);
                } else {
                    this.m_drawableFigureListener.nodeDeselected((RepresentationNode)element);
                }
            } else if (element instanceof RepresentationEdge) {
                if (selected) {
                    this.m_drawableFigureListener.edgeSelected((RepresentationEdge<RepresentationNode>)((RepresentationEdge)element));
                } else {
                    this.m_drawableFigureListener.edgeDeselected((RepresentationEdge<RepresentationNode>)((RepresentationEdge)element));
                }
            } else assert (false) : "Unexpected class: " + String.valueOf(element.getClass()) + " in method 'notifySelectionChanged'";
        }
    }

    protected final void addToFullElementSelection(IDrawableFigure figure) {
        assert (figure != null) : "Parameter 'figure' of method 'addToFullElementSelection' must not be null";
        this.m_drawableWidgetSelection.addToSelection(figure);
    }

    protected final void removeFromFullElementSelection(IDrawableFigure figure) {
        assert (figure != null) : "Parameter 'figure' of method 'removeFromFullElementSelection' must not be null";
        this.m_drawableWidgetSelection.removeFromSelection(figure);
    }

    public final void zoomIn() {
        this.m_contentFigure.zoomIn();
        this.finishZoomOperation();
        this.setAutozoomEnabled(false);
        this.m_drawableFigureListener.zoomPerformed();
    }

    public final void zoomOut() {
        this.m_contentFigure.zoomOut();
        this.finishZoomOperation();
        this.setAutozoomEnabled(false);
        this.m_drawableFigureListener.zoomPerformed();
    }

    protected void finishZoomOperation() {
    }

    public final void autozoomEnabled(boolean enabled) {
        if (enabled) {
            this.addControlListener(this);
            this.fitToView();
        } else {
            this.removeControlListener(this);
        }
        this.setAutozoomEnabled(enabled);
    }

    public final void controlMoved(ControlEvent e) {
    }

    private void processAutoZoom() {
        if (this.autozoomEnabled() && this.m_autozoomMode != AutozoomMode.NONE) {
            boolean shouldGrow;
            IFigure contents = this.getContents();
            assert (contents != null && contents instanceof DrawableViewContentFigure) : "Unexpected class in method 'processAutoZoom': " + String.valueOf(contents);
            DrawableViewContentFigure rootFigure = (DrawableViewContentFigure)contents;
            Dimension preferredSize = this.getNodesLayer().getPreferredSize();
            double total = this.m_autozoomMode == AutozoomMode.HORIZONTAL_AUTOFIT ? preferredSize.width : preferredSize.height;
            org.eclipse.swt.graphics.Rectangle clientArea = this.getClientArea();
            double available = this.m_autozoomMode == AutozoomMode.HORIZONTAL_AUTOFIT ? clientArea.width : clientArea.height;
            double idealScaleForWidget = available / total;
            double currentScale = rootFigure.getScale();
            boolean isOnMinimumForAutofit = currentScale <= (double)0.6f;
            boolean needsMoreSpace = currentScale - idealScaleForWidget > 0.0;
            boolean isOnMaxZoom = currentScale >= (double)1.3f;
            boolean isMoreSpaceAvailable = currentScale - idealScaleForWidget < 0.0;
            boolean shouldShrink = !isOnMinimumForAutofit && needsMoreSpace;
            boolean bl = shouldGrow = !isOnMaxZoom && isMoreSpaceAvailable;
            if (shouldShrink || shouldGrow || this.m_autozoomMode.forceFit()) {
                this.setAdjustEdges(false);
                this.autofit();
            }
        }
    }

    public final void controlResized(ControlEvent e) {
        if (this.performControlResized()) {
            this.processAutoZoom();
        }
        this.setPerformControlResized(true);
    }

    protected void autofit() {
    }

    public void home() {
        this.m_contentFigure.home();
    }

    public final List<Element> getCurrentlySelectedElements() {
        return new ArrayList<RepresentationElement>(this.getSelectedElements());
    }

    public final Set<RepresentationElement> getSelectedElements() {
        return this.m_drawableWidgetSelection.getFullElementSelection();
    }

    public final Collection<? extends RepresentationDependency> getSelectedRepresentationDependencies() {
        return this.m_drawableWidgetSelection.getSelectedRepresentationDependencies();
    }

    public final IDrawableNode.IDrawableEdge<? extends IDrawableNode> getConnection(Pair<NamedElement, NamedElement> dependency) {
        assert (dependency != null) : "Parameter 'dependency' of method 'getConnection' must not be null";
        RepresentationEdge<? extends RepresentationNode> edge = this.m_dependencyToEdge.get(dependency);
        return edge != null ? this.m_edgeToEdgeFigure.get(edge) : null;
    }

    public final List<RepresentationElement> getUnselectedElements() {
        assert (this.m_currentRepresentation != null) : "'m_currentRepresentation' of method 'getUnselectedElements' must not be null";
        ArrayList<RepresentationElement> unselected = new ArrayList<RepresentationElement>();
        for (RepresentationNode node : this.m_currentRepresentation.getNodes()) {
            if (this.m_drawableWidgetSelection.getFullElementSelection().contains(node) || this.getNode(node) == null) continue;
            unselected.add((RepresentationElement)node);
        }
        return unselected;
    }

    public final void highlightOriginalInput() {
        this.setHighlightOriginalInput(true);
        for (IDrawableNode node : this.getNodes()) {
            RepresentationNode representationNode = (RepresentationNode)node.getRepresentationElement();
            if (!representationNode.isOriginalInputRelated()) continue;
            node.setIsHighlighted(true);
            this.nodeHighlighted(node);
        }
    }

    protected void nodeHighlighted(IDrawableNode node) {
        assert (node != null) : "Parameter 'node' of method 'nodeHighlighted' must not be null";
    }

    public final void unhighlightOriginalInput() {
        this.setHighlightOriginalInput(false);
        for (IDrawableNode node : this.getNodes()) {
            node.setIsHighlighted(false);
            this.nodeUnhighlighted(node);
        }
    }

    protected void nodeUnhighlighted(IDrawableNode node) {
        assert (node != null) : "Parameter 'node' of method 'nodeUnhighlighted' must not be null";
    }

    public final IDrawableNode getNode(NamedElement namedElement) {
        assert (namedElement != null) : "Parameter 'namedElement' of method 'getTreeNodeForNamedElement' must not be null";
        RepresentationNode representationNode = this.m_currentRepresentation.getNode(namedElement);
        return representationNode != null ? this.m_nodeToFigure.get(representationNode) : null;
    }

    public final IDrawableNode getNode(RepresentationNode node) {
        assert (node != null) : "Parameter 'node' of method 'getNode' must not be null";
        return this.m_nodeToFigure.get(node);
    }

    public final Collection<IDrawableNode> getNodes() {
        return Collections.unmodifiableCollection(this.m_nodeToFigure.values());
    }

    public final Collection<NamedElement> getMainNodes() {
        return this.m_currentRepresentation.getMainNodes();
    }

    public final Collection<NamedElement> getAdditionalElements() {
        return this.m_currentRepresentation.getAdditionalNodes();
    }

    public final void removeListeners() {
        this.m_drawableFigureListener = null;
        this.setReactToMouseEvents(false);
        this.removeControlListener(this);
    }

    public final void addListeners(IDrawableWidgetListener listener) {
        assert (listener != null) : "Parameter 'listener' of method 'setTreeListener' must not be null";
        this.m_drawableFigureListener = listener;
        this.setReactToMouseEvents(true);
        this.addControlListener(this);
    }

    public final void startDraw() {
        this.setEnabled(false);
        this.removeListeners();
        this.setRedraw(false);
    }

    public final void finishDraw(IDrawableWidgetListener listener) {
        assert (listener != null) : "Parameter 'listener' of method 'finishDraw' must not be null";
        this.addListeners(listener);
        this.setEnabled(true);
        this.getLightweightSystem().getUpdateManager().performUpdate();
        this.setRedraw(true);
    }

    protected final IDrawableWidgetListener getDrawableFigureListener() {
        return this.m_drawableFigureListener;
    }

    public final NodeAndEdgeRepresentation getUnderlyingRepresentation() {
        return this.m_currentRepresentation;
    }

    public final void showOnlyDependenciesOfSelectedNodes(boolean showOnlyDependenciesOfSelectedNodes) {
        Set selectedNodes = this.getSelectedElements().stream().filter(representationElement -> representationElement instanceof RepresentationNode).map(RepresentationNode.class::cast).collect(Collectors.toSet());
        for (IDrawableNode.IDrawableEdge<? extends IDrawableNode> edgeFigure : this.getEdgeFigures()) {
            boolean hide = false;
            if (showOnlyDependenciesOfSelectedNodes) {
                RepresentationNode from = (RepresentationNode)edgeFigure.getFrom().getRepresentationElement();
                RepresentationNode to = (RepresentationNode)edgeFigure.getTo().getRepresentationElement();
                if (!(selectedNodes.isEmpty() || selectedNodes.contains(from) || selectedNodes.contains(to))) {
                    hide = true;
                }
            }
            edgeFigure.setVisible(!hide);
        }
        this.setShowOnlyDependenciesOfSelectedNodes(showOnlyDependenciesOfSelectedNodes);
    }

    public final void showOnlyViolations(boolean showOnlyViolations) {
        this.m_edgeToEdgeFigure.values().forEach(e -> e.setPaintViolationsOnly(showOnlyViolations));
        this.setShowOnlyViolations(showOnlyViolations);
    }

    public final void hideSelfArcs(boolean hideSelfArcs) {
        for (IDrawableNode.IDrawableEdge<? extends IDrawableNode> edgeFigure : this.getEdgeFigures()) {
            edgeFigure.setHideSelfArcs(hideSelfArcs);
            edgeFigure.revalidate();
        }
        this.setHideSelfArcs(hideSelfArcs);
    }

    public final FocusMode getFocusMode() {
        assert (this.m_currentRepresentation != null) : "'m_currentTree' of method 'getFocusMode' must not be null";
        return this.m_currentRepresentation.getFocusMode();
    }

    protected final void addEdge(RepresentationEdge<? extends RepresentationNode> edge, IDrawableNode.IDrawableEdge<? extends IDrawableNode> edgeFigure) {
        assert (edge != null) : "Parameter 'edge' of method 'addEdge' must not be null";
        assert (edgeFigure != null) : "Parameter 'edgeFigure' of method 'addEdge' must not be null";
        this.m_edgeToEdgeFigure.put(edge, edgeFigure);
        this.m_dependencyToEdge.put((Pair<NamedElement, NamedElement>)new Pair((Object)edge.getFromEndPoint(), (Object)edge.getToEndPoint()), edge);
    }

    protected final void addNode(RepresentationNode node, IDrawableNode nodeFigure) {
        assert (node != null) : "Parameter 'node' of method 'addNode' must not be null";
        assert (nodeFigure != null) : "Parameter 'nodeFigure' of method 'addNode' must not be null";
        this.m_nodeToFigure.put(node, nodeFigure);
    }

    protected final Collection<IDrawableNode.IDrawableEdge<? extends IDrawableNode>> getEdgeFigures() {
        return Collections.unmodifiableCollection(this.m_edgeToEdgeFigure.values());
    }

    public final Element getElementAt(int x, int y) {
        if (this.reactToMouseEvents()) {
            IFigure selected;
            Point point = new Point(x, y);
            this.getNodesLayer().translateToRelative(point);
            IFigure nodesLayerFigure = this.getNodesLayer().findFigureAt(point);
            point = new Point(x, y);
            this.getEdgesLayer().translateToRelative(point);
            IFigure edgesLayerFigure = this.getEdgesLayer().findFigureAt(point);
            if (this.edgesHavePrecedence()) {
                selected = edgesLayerFigure != null ? edgesLayerFigure : nodesLayerFigure;
            } else {
                IFigure iFigure = selected = nodesLayerFigure != null ? nodesLayerFigure : edgesLayerFigure;
            }
            if (selected instanceof IDrawableFigure) {
                IDrawableFigure selectedFigure = (IDrawableFigure)selected;
                return selectedFigure.getRepresentationElement();
            }
        }
        return null;
    }

    public final void adjustSelection(int x, int y, boolean aggregateSelection) {
        if (this.reactToMouseEvents()) {
            IFigure selected;
            Point point = new Point(x, y);
            this.getNodesLayer().translateToRelative(point);
            IFigure nodesLayerFigure = this.getNodesLayer().findFigureAt(point);
            point = new Point(x, y);
            this.getEdgesLayer().translateToRelative(point);
            IFigure edgesLayerFigure = this.getEdgesLayer().findFigureAt(point);
            if (nodesLayerFigure == null && edgesLayerFigure == null) {
                if (this.deselectAll()) {
                    this.m_contentFigure.repaint();
                }
                if (this.m_drawableFigureListener != null) {
                    this.m_drawableFigureListener.canvasClicked();
                }
                return;
            }
            this.setRedraw(false);
            if (this.edgesHavePrecedence()) {
                selected = edgesLayerFigure != null ? edgesLayerFigure : nodesLayerFigure;
            } else {
                IFigure iFigure = selected = nodesLayerFigure != null ? nodesLayerFigure : edgesLayerFigure;
            }
            if (selected instanceof IDrawableFigure) {
                IDrawableFigure selectedFigure = (IDrawableFigure)selected;
                if (!selectedFigure.isSelected()) {
                    this.selected(Collections.singletonList(selectedFigure), aggregateSelection, true);
                } else if (aggregateSelection) {
                    this.deselected(selectedFigure, true);
                } else {
                    this.selected(Collections.singletonList(selectedFigure), aggregateSelection, true);
                }
            }
            this.finishWidgetClicked(x, y);
            this.setRedraw(true);
            this.m_contentFigure.repaint();
        }
    }

    protected void finishWidgetClicked(int x, int y) {
    }

    public final void reLayout(boolean recalculateSize) {
        this.m_contentFigure.getNodesLayerLayout().reLayout();
        if (recalculateSize) {
            int maxX = 0;
            int maxY = 0;
            for (IDrawableNode node : this.getNodes()) {
                Rectangle boundingBox = node.getBounds();
                maxX = Math.max(maxX, boundingBox.x + boundingBox.width + 20);
                maxY = Math.max(maxY, boundingBox.y + boundingBox.height + 20);
            }
            this.m_contentFigure.setPreferredSize(new Dimension(maxX, maxY));
        }
    }

    public final Layer getBottomLayer() {
        return this.m_contentFigure.getBottomLayer();
    }

    public final Layer getEdgesLayer() {
        return this.m_contentFigure.getEdgesLayer();
    }

    public final Layer getNodesLayer() {
        return this.m_contentFigure.getNodesLayer();
    }

    public final Layer getTopLayer() {
        return this.m_contentFigure.getTopLayer();
    }

    public final IFigure getFigureAt(int x, int y) {
        Point p = new Point(x, y);
        this.m_contentFigure.translateToParent(p);
        return this.m_contentFigure.findFigureAt(p);
    }

    public final void removeFigure(Figure figure) {
        assert (figure != null) : "Parameter 'figure' of method 'removeFigure' must not be null";
        this.m_contentFigure.remove(figure);
    }

    public final void addFigure(Figure figure, Layer layer) {
        assert (figure != null) : "Parameter 'figure' of method 'addFigure' must not be null";
        assert (layer != null) : "Parameter 'layer' of method 'addFigure' must not be null";
        this.m_contentFigure.add((IFigure)figure, layer);
    }

    public final <T extends IDrawableNode.IDrawableEdge<? extends IDrawableNode>> void addEdge(T edgeFigure) {
        assert (edgeFigure != null) : "Parameter 'edgeFigure' of method 'addEdge' must not be null";
        this.m_contentFigure.add(edgeFigure, this.getEdgesLayer(), 0);
    }

    public final <T extends IDrawableNode> void addNode(T nodeFigure) {
        assert (nodeFigure != null) : "Parameter 'nodeFigure' of method 'addNode' must not be null";
        this.m_contentFigure.add(nodeFigure, this.getNodesLayer());
        assert (this.m_currentRepresentation != null) : "'m_currentRepresentation' of method 'addNode' must not be null";
        NodeAdapter nodeAdapter = this.m_currentRepresentation.getNodeAdapterFromRepresentationNode((RepresentationNode)nodeFigure.getRepresentationElement());
        if (nodeAdapter != null) {
            this.m_contentFigure.getNodesLayerLayout().finishNodeCreation(nodeAdapter, nodeFigure);
        }
    }

    private void fitToView() {
        this.setAdjustEdges(true);
        this.autofit();
    }

    public final PresentationMode getPresentationMode() {
        NodeAndEdgeRepresentation underlyingRepresentation = this.getUnderlyingRepresentation();
        return underlyingRepresentation != null ? underlyingRepresentation.getPresentationMode() : null;
    }

    public final List<IDrawableNode> getSortedElementsForSearch() {
        if (this.m_nodesSortedByUI == null) {
            this.m_nodesSortedByUI = new ArrayList<IDrawableNode>(this.getNodes());
            Collections.sort(this.m_nodesSortedByUI, new DrawableNodeComparator());
        }
        return this.m_nodesSortedByUI;
    }

    public abstract Set<CoreParserDependencyType> getParserDependencyTypesForEdges();

    protected abstract RepresentationElement innerSelected(IDrawableFigure var1);

    @Override
    public final void selected(Collection<IDrawableFigure> figures, boolean aggregateSelection, boolean notifySelectionChanged) {
        assert (figures != null) : "Parameter 'figures' of method 'selected' must not be null";
        if (!aggregateSelection) {
            this.innerDeselectAll();
        }
        for (IDrawableFigure next : figures) {
            RepresentationElement element = this.innerSelected(next);
            if (!notifySelectionChanged) continue;
            this.notifySelectionChanged(element, false);
        }
        this.updateEdgeHighlightState();
        if (notifySelectionChanged) {
            this.m_selectionProviderAdapter.handleSelectionChanged(this.getCurrentlySelectedElements());
        }
        this.showOnlyDependenciesOfSelectedNodes(this.showOnlyDependenciesOfSelectedNodes());
    }

    @Override
    public void deselected(IDrawableFigure treeFigure, boolean notifySelectionChanged) {
        assert (treeFigure != null) : "Parameter 'treeFigure' of method 'innerDeselect' must not be null";
        RepresentationElement element = this.innerDeselect(treeFigure);
        this.updateEdgeHighlightState();
        if (notifySelectionChanged) {
            this.notifySelectionChanged(element, false);
        }
        this.showOnlyDependenciesOfSelectedNodes(this.showOnlyDependenciesOfSelectedNodes());
    }

    public static enum ShowOption {
        REVEAL_INPUT,
        SCROLL_TO_TOP,
        FIT_TO_VIEW;

    }

    static enum WidgetProperty {
        HIGHLIGHT_ORIGINAL_INPUT,
        SHOW_ONLY_DEPENDENCIES_OF_SELECTED_NODES,
        SHOW_ONLY_VIOLATIONS,
        HIDE_SELF_ARCS,
        AUTOZOOM_ENABLED,
        PERFORM_CONTROL_RESIZED,
        ADJUST_EDGES,
        REACT_TO_MOUSE_EVENTS;

    }
}

