/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.base.draw2d;

import com.hello2morrow.draw2d.Dimension;
import com.hello2morrow.draw2d.Figure;
import com.hello2morrow.draw2d.Graphics;
import com.hello2morrow.draw2d.IFigure;
import com.hello2morrow.draw2d.Insets;
import com.hello2morrow.draw2d.Point;
import com.hello2morrow.draw2d.Rectangle;
import com.hello2morrow.draw2d.TextUtilities;
import com.hello2morrow.draw2d.TreeSearch;
import org.eclipse.swt.graphics.Image;

public final class DrawableNodeLabel
extends Figure {
    private static final String EMPTY = "";
    private static final int GAP = 2;
    private final String m_text;
    private Image m_image;
    private final Dimension m_imageDimension;
    private Dimension m_textSize;
    private Point m_iconLocation;
    private Point m_textLocation;

    public DrawableNodeLabel(String text, Image image) {
        assert (text != null) : "Parameter 'text' of method 'TreeLabel' must not be null";
        assert (image != null) : "Parameter 'image' of method 'TreeLabel' must not be null";
        this.m_text = text;
        this.m_image = image;
        this.m_imageDimension = new Dimension(image);
    }

    public String getText() {
        return this.m_text;
    }

    public Image getImage() {
        return this.m_image;
    }

    public void setImage(Image image) {
        assert (image != null) : "Parameter 'image' of method 'setImage' must not be null";
        this.m_image = image;
    }

    private void calculateAlignment() {
        this.m_textLocation.y = (this.bounds.height - this.getTextSize().height) / 2;
        this.m_iconLocation.y = (this.bounds.height - this.m_imageDimension.height) / 2;
    }

    private Dimension calculateLabelSize(Dimension txtSize) {
        int gap = this.m_image == null || this.m_text.equals(EMPTY) ? 0 : 2;
        Dimension d = new Dimension(0, 0);
        d.width = this.m_imageDimension.width + gap + txtSize.width;
        d.height = Math.max(this.m_imageDimension.height, txtSize.height);
        return d;
    }

    private void calculateLocations() {
        this.m_textLocation = new Point();
        this.m_iconLocation = new Point();
        this.calculatePlacement();
        this.calculateAlignment();
        Dimension offset = this.getSize().getShrinked(this.getPreferredSize());
        offset.width += this.getTextSize().width - this.m_textSize.width;
        offset.scale(0.5);
        offset.height = 0;
        this.m_textLocation.translate(offset);
        this.m_iconLocation.translate(offset);
    }

    private void calculatePlacement() {
        int gap = this.m_image == null || this.m_text.equals(EMPTY) ? 0 : 2;
        Insets insets = this.getInsets();
        this.m_iconLocation.x = insets.left;
        this.m_textLocation.x = this.m_imageDimension.width + gap + insets.left;
    }

    private Point getImageLocation() {
        if (this.m_iconLocation == null) {
            this.calculateLocations();
        }
        return this.m_iconLocation;
    }

    @Override
    public Dimension getMinimumSize(int w, int h) {
        if (this.minSize != null) {
            return this.minSize;
        }
        this.minSize = new Dimension();
        if (this.getLayoutManager() != null) {
            this.minSize.setSize(this.getLayoutManager().getMinimumSize(this, w, h));
        }
        Dimension labelSize = this.calculateLabelSize(TextUtilities.INSTANCE.getTextExtents(this.m_text, this.getFont()));
        Insets insets = this.getInsets();
        labelSize.expand(insets.getWidth(), insets.getHeight());
        this.minSize.union(labelSize);
        return this.minSize;
    }

    @Override
    public Dimension getPreferredSize(int wHint, int hHint) {
        if (this.prefSize == null) {
            this.prefSize = this.calculateLabelSize(this.getTextSize());
            Insets insets = this.getInsets();
            this.prefSize.expand(insets.getWidth(), insets.getHeight());
            if (this.m_image != null) {
                this.prefSize.expand(20, 0);
            }
            if (this.getLayoutManager() != null) {
                this.prefSize.union(this.getLayoutManager().getPreferredSize(this, wHint, hHint));
            }
        }
        if (wHint >= 0 && wHint < this.prefSize.width) {
            Dimension minSize = this.getMinimumSize(wHint, hHint);
            Dimension result = this.prefSize.getCopy();
            result.width = Math.min(result.width, wHint);
            result.width = Math.max(minSize.width, result.width);
            return result;
        }
        return this.prefSize;
    }

    private Point getTextLocation() {
        if (this.m_textLocation != null) {
            return this.m_textLocation;
        }
        this.calculateLocations();
        return this.m_textLocation;
    }

    private Dimension getTextSize() {
        if (this.m_textSize == null) {
            this.m_textSize = TextUtilities.INSTANCE.getTextExtents(this.m_text, this.getFont());
        }
        return this.m_textSize;
    }

    @Override
    public void invalidate() {
        this.prefSize = null;
        this.minSize = null;
        this.m_iconLocation = null;
        this.m_textLocation = null;
        this.m_textSize = null;
        super.invalidate();
    }

    @Override
    protected void paintFigure(Graphics graphics) {
        Rectangle clip = Rectangle.SINGLETON;
        clip.x = this.bounds.x - 1;
        clip.y = this.bounds.y - 1;
        clip.width = this.bounds.width + 2;
        clip.height = this.bounds.height + 2;
        graphics.setClip(clip);
        Rectangle boundsInPaint = Rectangle.SINGLETON;
        boundsInPaint.x = this.bounds.x;
        boundsInPaint.y = this.bounds.y;
        boundsInPaint.width = this.bounds.width;
        boundsInPaint.height = this.bounds.height;
        graphics.translate(boundsInPaint.x, boundsInPaint.y);
        if (this.m_image != null) {
            graphics.drawImage(this.m_image, this.getImageLocation());
        }
        graphics.drawText(this.m_text, this.getTextLocation());
        graphics.translate(-boundsInPaint.x, -boundsInPaint.y);
    }

    @Override
    public boolean containsPoint(int x, int y) {
        Point pt = Point.SINGLETON;
        pt.setLocation(x, y);
        this.translateFromParent(pt);
        x = pt.x;
        y = pt.y;
        int i = 0;
        while (i < this.getChildren().size()) {
            IFigure child = (IFigure)this.getChildren().get(i);
            if (child.containsPoint(x, y)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public IFigure findFigureAt(int x, int y, TreeSearch search) {
        IFigure f = super.findFigureAt(x, y, search);
        if (f == this) {
            return null;
        }
        return f;
    }
}

