/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.base.draw;

import com.hello2morrow.draw2d.FigureCanvas;
import com.hello2morrow.draw2d.IFigure;
import com.hello2morrow.draw2d.LayoutListener;
import com.hello2morrow.draw2d.LightweightSystem;
import com.hello2morrow.draw2d.Point;
import com.hello2morrow.draw2d.Rectangle;
import com.hello2morrow.draw2d.UpdateManager;
import com.hello2morrow.draw2d.Viewport;
import com.hello2morrow.sonargraph.foundation.utilities.StrictPair;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import com.hello2morrow.sonargraph.ui.swt.base.draw.DrawConnectionFigure;
import com.hello2morrow.sonargraph.ui.swt.base.draw.DrawDefaultContentFigure;
import com.hello2morrow.sonargraph.ui.swt.base.draw.DrawExpandCollapseFigure;
import com.hello2morrow.sonargraph.ui.swt.base.draw.DrawFigure;
import com.hello2morrow.sonargraph.ui.swt.base.draw.DrawInteractiveFigure;
import com.hello2morrow.sonargraph.ui.swt.base.draw.DrawLightweightSystem;
import com.hello2morrow.sonargraph.ui.swt.base.draw.DrawModifier;
import com.hello2morrow.sonargraph.ui.swt.base.draw.DrawNodeAndConnectionFigureCanvasLayout;
import com.hello2morrow.sonargraph.ui.swt.base.draw.DrawNodeFigure;
import com.hello2morrow.sonargraph.ui.swt.base.draw.DrawScalableContentFigure;
import com.hello2morrow.sonargraph.ui.swt.base.draw.DrawUnifiedNodeAndConnectionLayersContentFigure;
import com.hello2morrow.sonargraph.ui.swt.base.draw.DrawUpdateManager;
import com.hello2morrow.sonargraph.ui.swt.base.draw.DrawUtilities;
import com.hello2morrow.sonargraph.ui.swt.base.draw.DrawViewport;
import java.util.List;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Scrollable;

public final class DrawNodeAndConnectionFigureCanvas<N, C, L extends DrawNodeAndConnectionFigureCanvasLayout<N, C>>
extends FigureCanvas
implements ControlListener,
MouseListener,
MouseMoveListener,
KeyListener {
    private static final int AUTOSCROLL_THRESHOLD = 10;
    private static final int SCROLL_OFFSET = 10;
    private DrawUpdateManager m_updateManager;
    private DrawScalableContentFigure<N, C> m_contentFigure;
    private L m_layout;
    private IListener m_listener;
    private Cursor m_draggingCursor;

    public DrawNodeAndConnectionFigureCanvas(Composite parent, L layout, boolean addConnectionsToNodesLayer) {
        super(parent, new DrawLightweightSystem());
        assert (parent != null) : "Parameter 'parent' of method 'DrawNodeAndConnectionFigureCanvas' must not be null";
        assert (layout != null) : "Parameter 'layout' of method 'DrawNodeAndConnectionFigureCanvas' must not be null";
        LightweightSystem lightweightSystem = this.getLightweightSystem();
        assert (lightweightSystem != null && lightweightSystem instanceof DrawLightweightSystem) : "Unexpected class in method 'DrawFigureCanvas': " + String.valueOf(lightweightSystem);
        UpdateManager updateManager = ((DrawLightweightSystem)lightweightSystem).getUpdateManager();
        assert (updateManager != null && updateManager instanceof DrawUpdateManager) : "Unexpected class in method 'DrawFigureCanvas': " + String.valueOf(updateManager);
        this.m_updateManager = (DrawUpdateManager)updateManager;
        this.m_contentFigure = addConnectionsToNodesLayer ? new DrawUnifiedNodeAndConnectionLayersContentFigure() : new DrawDefaultContentFigure();
        this.m_layout = layout;
        ((DrawNodeAndConnectionFigureCanvasLayout)this.m_layout).connect((Scrollable)this, this.m_contentFigure);
        this.setViewport(new DrawViewport());
        this.setContents(this.m_contentFigure);
        this.setScrollBarVisibility(FigureCanvas.ALWAYS);
        this.setBackground(UiResourceManager.getInstance().getBackgroundColor());
        this.addMouseMoveListener(this);
        this.addControlListener(this);
        this.addMouseListener(this);
        this.addKeyListener(this);
        this.setDragDetect(true);
    }

    public DrawNodeAndConnectionFigureCanvas(Composite parent, L layout) {
        this(parent, layout, false);
    }

    private void performUpdate() {
        assert (this.m_updateManager != null) : "'m_updateManager' of method 'performUpdate' must not be null";
        this.m_updateManager.performUpdate();
    }

    public L getCanvasLayout() {
        return this.m_layout;
    }

    public void setListener(IListener listener) {
        this.m_listener = listener;
    }

    public void addLayoutListener(LayoutListener listener) {
        assert (listener != null) : "Parameter 'listener' of method 'addLayoutListener' must not be null";
        this.m_contentFigure.addLayoutListener(listener);
    }

    public void setNeedsLayout() {
        ((DrawNodeAndConnectionFigureCanvasLayout)this.m_layout).setNeedsLayout();
    }

    public boolean isResetZoomPossible() {
        return ((DrawNodeAndConnectionFigureCanvasLayout)this.m_layout).isResetZoomPossible();
    }

    public void resetZoom() {
        ((DrawNodeAndConnectionFigureCanvasLayout)this.m_layout).resetZoom();
    }

    public boolean zoomInPossible() {
        return ((DrawNodeAndConnectionFigureCanvasLayout)this.m_layout).zoomInPossible();
    }

    public boolean zoomOutPossible() {
        return ((DrawNodeAndConnectionFigureCanvasLayout)this.m_layout).zoomOutPossible();
    }

    public void zoomIn() {
        ((DrawNodeAndConnectionFigureCanvasLayout)this.m_layout).zoomIn();
    }

    public void zoomOut() {
        ((DrawNodeAndConnectionFigureCanvasLayout)this.m_layout).zoomOut();
    }

    public double getScale() {
        return ((DrawNodeAndConnectionFigureCanvasLayout)this.m_layout).getScale();
    }

    public void setScale(double scale) {
        ((DrawNodeAndConnectionFigureCanvasLayout)this.m_layout).setScale(scale);
    }

    public void updateFromModel() {
        boolean updated = false;
        StrictPair<List<DrawNodeFigure<N>>, List<DrawConnectionFigure<C>>> nodeAndConnections = this.m_contentFigure.getNodeAndConnectionFigures();
        for (Object next : (List)nodeAndConnections.getFirst()) {
            assert (next instanceof DrawInteractiveFigure) : "Unexpected class in method 'updateFromModel': " + String.valueOf(next);
            updated |= ((DrawInteractiveFigure)next).update();
        }
        for (Object next : (List)nodeAndConnections.getSecond()) {
            assert (next instanceof DrawInteractiveFigure) : "Unexpected class in method 'updateFromModel': " + String.valueOf(next);
            updated |= ((DrawInteractiveFigure)next).update();
        }
        if (updated) {
            ((DrawNodeAndConnectionFigureCanvasLayout)this.m_layout).forceUpdate();
            this.performUpdate();
        }
    }

    public void addToBasementLayer(IFigure figure) {
        assert (figure != null) : "Parameter 'figure' of method 'addToBasementLayer' must not be null";
        this.m_contentFigure.getBasementLayer().add(figure);
    }

    public void removeFromBasementLayer(IFigure figure) {
        assert (figure != null) : "Parameter 'figure' of method 'removeFromBasementLayer' must not be null";
        this.m_contentFigure.getBasementLayer().remove(figure);
    }

    public void addToFirstFloorLayer(IFigure figure) {
        assert (figure != null) : "Parameter 'figure' of method 'addToFirstFloorLayer' must not be null";
        this.m_contentFigure.getFirstFloorLayer().add(figure);
    }

    public void removeFromFirstFloorLayer(IFigure figure) {
        assert (figure != null) : "Parameter 'figure' of method 'removeFromFirstFloorLayer' must not be null";
        this.m_contentFigure.getFirstFloorLayer().remove(figure);
    }

    public void addToSecondFloorLayer(IFigure figure) {
        assert (figure != null) : "Parameter 'figure' of method 'addToSecondFloorLayer' must not be null";
        this.m_contentFigure.getSecondFloorLayer().add(figure);
    }

    public void removeFromSecondFloorLayer(IFigure figure) {
        assert (figure != null) : "Parameter 'figure' of method 'removeFromSecondFloorLayer' must not be null";
        this.m_contentFigure.getSecondFloorLayer().remove(figure);
    }

    public void addConnectionFigure(DrawConnectionFigure<C> connectionFigure) {
        assert (connectionFigure != null) : "Parameter 'connectionFigure' of method 'addConnectionFigure' must not be null";
        this.m_contentFigure.addConnectionFigure(connectionFigure);
    }

    public void removeConnectionFigure(DrawConnectionFigure<C> connectionFigure) {
        assert (connectionFigure != null) : "Parameter 'connectionFigure' of method 'removeConnectionFigure' must not be null";
        this.m_contentFigure.removeConnectionFigure(connectionFigure);
    }

    public void addNodeFigure(DrawNodeFigure<N> nodeFigure) {
        assert (nodeFigure != null) : "Parameter 'nodeFigure' of method 'addNodeFigure' must not be null";
        this.m_contentFigure.addNodeFigure(nodeFigure);
    }

    public void removeNodeFigure(DrawNodeFigure<N> nodeFigure) {
        assert (nodeFigure != null) : "Parameter 'nodeFigure' of method 'removeNodeFigure' must not be null";
        this.m_contentFigure.removeNodeFigure(nodeFigure);
    }

    public void addToAtticLayer(IFigure figure) {
        assert (figure != null) : "Parameter 'figure' of method 'addToAtticLayer' must not be null";
        this.m_contentFigure.getAtticLayer().add(figure);
    }

    public void removeFromAtticLayer(IFigure figure) {
        assert (figure != null) : "Parameter 'figure' of method 'removeFromAtticLayer' must not be null";
        this.m_contentFigure.getAtticLayer().remove(figure);
    }

    public List<DrawNodeFigure<N>> getNodeFigures() {
        return (List)this.m_contentFigure.getNodeAndConnectionFigures().getFirst();
    }

    public List<DrawConnectionFigure<C>> getConnectionFigures() {
        return (List)this.m_contentFigure.getNodeAndConnectionFigures().getSecond();
    }

    public void forceUpdate() {
        ((DrawNodeAndConnectionFigureCanvasLayout)this.m_layout).forceUpdate();
        this.performUpdate();
    }

    public void clear() {
        this.m_contentFigure.clear();
    }

    @Override
    public void dispose() {
        assert (this.m_contentFigure != null) : "Parameter 'm_contentFigure' of method 'dispose' must not be null";
        this.m_updateManager = null;
        this.m_contentFigure.clear();
        this.m_contentFigure = null;
        this.m_draggingCursor = null;
        this.m_layout = null;
        this.m_listener = null;
        super.dispose();
    }

    public void revealNode(DrawNodeFigure<N> node) {
        assert (node != null) : "Parameter 'node' of method 'revealNode' must not be null";
        Viewport viewPort = this.getViewport();
        Rectangle viewPortBounds = viewPort.getBounds().getCopy();
        viewPortBounds.translate(viewPort.getViewLocation());
        Rectangle figureBounds = node.getBounds().getCopy();
        node.translateToAbsolute(figureBounds);
        figureBounds.translate(viewPort.getViewLocation());
        if (!viewPortBounds.contains(figureBounds)) {
            int newX = viewPortBounds.x;
            int newY = viewPortBounds.y;
            if (viewPortBounds.x > figureBounds.x) {
                newX = figureBounds.x;
            } else if (viewPortBounds.x + viewPortBounds.getRight().x < figureBounds.getRight().x) {
                newX = figureBounds.getRight().x - viewPortBounds.width;
            }
            if (viewPortBounds.y > figureBounds.y) {
                newY = figureBounds.y;
            } else if (viewPortBounds.getBottom().y < figureBounds.getBottom().y) {
                newY = figureBounds.getBottom().y - viewPortBounds.height;
            }
            this.scrollSmoothTo(newX, newY);
        }
    }

    public void setTopMostVisibleNode(DrawNodeFigure<N> node) {
        assert (node != null) : "Parameter 'node' of method 'setTopMostVisibleNode' must not be null";
        Viewport viewPort = this.getViewport();
        Rectangle viewPortBounds = viewPort.getBounds().getCopy();
        viewPortBounds.translate(viewPort.getViewLocation());
        Rectangle figureBounds = node.getBounds().getCopy();
        node.translateToAbsolute(figureBounds);
        figureBounds.translate(viewPort.getViewLocation());
        this.scrollSmoothTo(figureBounds.x, figureBounds.y);
    }

    public DrawNodeFigure<N> getTopMostVisibleNode() {
        Viewport viewPort = this.getViewport();
        Rectangle viewPortClientArea = viewPort.getClientArea();
        Point viewPortLocation = viewPort.getViewLocation();
        for (DrawNodeFigure<N> nextNodeFigure : this.getNodeFigures()) {
            Point nextLocation = nextNodeFigure.getBounds().getLeft();
            nextNodeFigure.translateToAbsolute(nextLocation);
            nextLocation.translate(viewPortLocation);
            if (!viewPortClientArea.contains(nextLocation)) continue;
            return nextNodeFigure;
        }
        return null;
    }

    public DrawFigure getFigureAt(org.eclipse.swt.graphics.Point location) {
        assert (location != null) : "Parameter 'location' of method 'getFigureAt' must not be null";
        Point point = new Point(location.x, location.y);
        this.getViewport().translateFromParent(point);
        IFigure found = this.m_contentFigure.findFigureAt(point);
        if (found != null && found instanceof DrawFigure) {
            return (DrawFigure)found;
        }
        return null;
    }

    private void resetCursor() {
        if (this.m_draggingCursor != null) {
            this.getShell().setCursor(null);
            this.m_draggingCursor = null;
        }
    }

    public void controlMoved(ControlEvent event) {
    }

    public void controlResized(ControlEvent event) {
        if (((DrawNodeAndConnectionFigureCanvasLayout)this.m_layout).drawAreaResized()) {
            this.performUpdate();
            if (this.m_listener != null) {
                this.m_listener.drawAreaResized();
            }
        }
    }

    public void mouseDown(MouseEvent event) {
        assert (event != null) : "Parameter 'event' of method 'mouseDown' must not be null";
        if (event.button == 1 && DrawInteractiveFigure.inMouseDown() == null && this.m_listener != null) {
            Point location = new Point(event.x, event.y);
            this.m_contentFigure.translateFromParent(location);
            this.m_listener.handleNoNodeOrConnectionClicked(DrawUtilities.getModifier(event), location);
        }
    }

    public void mouseUp(MouseEvent event) {
        assert (event != null) : "Parameter 'event' of method 'mouseUp' must not be null";
        if (event.button == 1) {
            Point location = new Point(event.x, event.y);
            this.m_contentFigure.translateFromParent(location);
            DrawInteractiveFigure.finishMouseDown(null, location);
            this.resetCursor();
        }
    }

    private DrawNodeFigure<?> getDrawNodeFigureParent(DrawExpandCollapseFigure figure) {
        assert (figure != null) : "Parameter 'figure' of method 'getDrawNodeFigureParent' must not be null";
        IFigure currentParent = figure.getParent();
        while (currentParent != null) {
            if (currentParent instanceof DrawNodeFigure) {
                return (DrawNodeFigure)currentParent;
            }
            currentParent = currentParent.getParent();
        }
        return null;
    }

    public void mouseMove(MouseEvent event) {
        if (DrawNodeFigure.isDragging()) {
            Point point;
            IFigure figure;
            if (this.m_draggingCursor == null) {
                this.m_draggingCursor = UiResourceManager.getInstance().getCursor(UiResourceManager.CursorId.OPEN_HAND);
                this.getShell().setCursor(this.m_draggingCursor);
            }
            if ((figure = this.m_contentFigure.findFigureAt(point = new Point(event.x, event.y))) instanceof DrawExpandCollapseFigure) {
                DrawNodeFigure<?> nodeFigure = this.getDrawNodeFigureParent((DrawExpandCollapseFigure)figure);
                assert (nodeFigure != null) : "DrawNodeFigure parent not found for: " + String.valueOf(figure);
                nodeFigure.expand((DrawExpandCollapseFigure)figure);
                return;
            }
            Viewport viewport = this.getViewport();
            Rectangle isInsideCheck = new Rectangle();
            viewport.getClientArea(isInsideCheck);
            viewport.translateToParent(isInsideCheck);
            viewport.translateToAbsolute(isInsideCheck);
            if (isInsideCheck.getPosition(point) == 0) {
                Point viewLocation = viewport.getViewLocation();
                Rectangle clientArea = viewport.getClientArea();
                Rectangle rect = new Rectangle(clientArea.x, clientArea.y + 10, clientArea.width, clientArea.height - 20);
                viewport.translateToParent(rect);
                viewport.translateToAbsolute(rect);
                int region = rect.getPosition(point);
                if ((region & 1) != 0) {
                    viewLocation.y -= 10;
                    viewport.setViewLocation(viewLocation);
                } else if ((region & 4) != 0) {
                    viewLocation.y += 10;
                    viewport.setViewLocation(viewLocation);
                }
            }
        }
    }

    public void keyPressed(KeyEvent event) {
        assert (event != null) : "Parameter 'event' of method 'keyPressed' must not be null";
        if (event.keyCode == 27) {
            DrawInteractiveFigure.finishMouseDown(null, null);
            this.resetCursor();
        } else if (this.m_listener != null) {
            if (event.keyCode == 0x1000001) {
                if ((event.stateMask & 0x20000) != 0) {
                    this.m_listener.handleArrowUp(DrawModifier.SHIFT);
                } else {
                    this.m_listener.handleArrowUp(DrawModifier.NONE);
                }
            } else if (event.keyCode == 0x1000002) {
                if ((event.stateMask & 0x20000) != 0) {
                    this.m_listener.handleArrowDown(DrawModifier.SHIFT);
                } else {
                    this.m_listener.handleArrowDown(DrawModifier.NONE);
                }
            } else if (event.keyCode == 0x1000003) {
                if ((event.stateMask & 0x20000) != 0) {
                    this.m_listener.handleArrowLeft(DrawModifier.SHIFT);
                } else {
                    this.m_listener.handleArrowLeft(DrawModifier.NONE);
                }
            } else if (event.keyCode == 0x1000004) {
                if ((event.stateMask & 0x20000) != 0) {
                    this.m_listener.handleArrowRight(DrawModifier.SHIFT);
                } else {
                    this.m_listener.handleArrowRight(DrawModifier.NONE);
                }
            } else if ((event.stateMask & SWT.MOD1) != 0 && (event.character == 'a' || event.character == 'A')) {
                this.m_listener.handleSelectAll();
            }
        }
    }

    public void keyReleased(KeyEvent event) {
    }

    public void mouseDoubleClick(MouseEvent event) {
    }

    public static interface IListener {
        default public void handleNoNodeOrConnectionClicked(DrawModifier modifier, Point location) {
        }

        default public void handleArrowUp(DrawModifier modifier) {
        }

        default public void handleArrowDown(DrawModifier modifier) {
        }

        default public void handleArrowLeft(DrawModifier modifier) {
        }

        default public void handleArrowRight(DrawModifier modifier) {
        }

        default public void handleSelectAll() {
        }

        default public void drawAreaResized() {
        }
    }
}

