/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.draw2d;

import com.hello2morrow.draw2d.CompoundDirectedGraph;
import com.hello2morrow.draw2d.DirectedGraph;
import com.hello2morrow.draw2d.GraphVisitor;
import com.hello2morrow.draw2d.NestingTree;
import com.hello2morrow.draw2d.Node;
import com.hello2morrow.draw2d.NodeList;
import com.hello2morrow.draw2d.NodePair;
import com.hello2morrow.draw2d.Rank;
import com.hello2morrow.draw2d.RankList;
import com.hello2morrow.draw2d.Subgraph;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

class SortSubgraphs
extends GraphVisitor {
    CompoundDirectedGraph g;
    NestingTree[] nestingTrees;
    Set orderingGraphEdges = new HashSet();
    Set orderingGraphNodes = new HashSet();
    NodePair pair = new NodePair();

    SortSubgraphs() {
    }

    private void breakSubgraphCycles() {
        ArrayList noLefts = new ArrayList();
        int index = 1;
        for (Node node : this.orderingGraphNodes) {
            if (node.x != 0) continue;
            this.sortedInsert(noLefts, node);
        }
        block1: while (true) {
            if (noLefts.size() > 0) {
                Node node;
                node = (Node)noLefts.remove(noLefts.size() - 1);
                node.sortValue = index++;
                this.orderingGraphNodes.remove(node);
                NodeList rightOf = this.rightOf(node);
                if (rightOf == null) continue;
                int i = 0;
                while (true) {
                    if (i >= rightOf.size()) continue block1;
                    Node right = rightOf.getNode(i);
                    --right.x;
                    if (right.x == 0) {
                        this.sortedInsert(noLefts, right);
                    }
                    ++i;
                }
            }
            Node cycleRoot = null;
            double min = Double.MAX_VALUE;
            for (Node node : this.orderingGraphNodes) {
                if (!(node.sortValue < min)) continue;
                cycleRoot = node;
                min = node.sortValue;
            }
            if (cycleRoot != null) {
                this.sortedInsert(noLefts, cycleRoot);
                cycleRoot.x = -1;
            }
            if (cycleRoot == null) break;
        }
    }

    private void buildSubgraphOrderingGraph() {
        NestingTree entry;
        RankList ranks = this.g.ranks;
        this.nestingTrees = new NestingTree[ranks.size()];
        int r = 0;
        while (r < ranks.size()) {
            this.nestingTrees[r] = entry = NestingTree.buildNestingTreeForRank(ranks.getRank(r));
            entry.calculateSortValues();
            entry.recursiveSort(false);
            ++r;
        }
        int i = 0;
        while (i < this.nestingTrees.length) {
            entry = this.nestingTrees[i];
            this.buildSubgraphOrderingGraph(entry);
            ++i;
        }
    }

    private void buildSubgraphOrderingGraph(NestingTree entry) {
        NodePair pair = new NodePair();
        if (entry.isLeaf) {
            return;
        }
        int i = 0;
        while (i < entry.contents.size()) {
            Object right = entry.contents.get(i);
            if (right instanceof Node) {
                pair.n2 = (Node)right;
            } else {
                pair.n2 = ((NestingTree)right).subgraph;
                this.buildSubgraphOrderingGraph((NestingTree)right);
            }
            if (pair.n1 != null && !this.orderingGraphEdges.contains(pair)) {
                this.orderingGraphEdges.add(pair);
                this.leftToRight(pair.n1, pair.n2);
                this.orderingGraphNodes.add(pair.n1);
                this.orderingGraphNodes.add(pair.n2);
                ++pair.n2.x;
                pair = new NodePair(pair.n2, null);
            } else {
                pair.n1 = pair.n2;
            }
            ++i;
        }
    }

    private void calculateSortValues() {
        RankList ranks = this.g.ranks;
        this.g.subgraphs.resetSortValues();
        this.g.subgraphs.resetIndices();
        int r = 0;
        while (r < ranks.size()) {
            Rank rank = ranks.getRank(r);
            int j = 0;
            while (j < rank.count()) {
                Node node = rank.getNode(j);
                node.sortValue = node.index;
                Subgraph parent = node.getParent();
                while (parent != null) {
                    parent.sortValue += node.sortValue;
                    parent.index = parent.index + 1;
                    parent = parent.getParent();
                }
                ++j;
            }
            ++r;
        }
        int i = 0;
        while (i < this.g.subgraphs.size()) {
            Subgraph subgraph = (Subgraph)this.g.subgraphs.get(i);
            subgraph.sortValue /= (double)subgraph.index;
            ++i;
        }
    }

    private void repopulateRanks() {
        int i = 0;
        while (i < this.nestingTrees.length) {
            Rank rank = this.g.ranks.getRank(i);
            rank.clear();
            this.nestingTrees[i].repopulateRank(rank);
            ++i;
        }
    }

    private NodeList rightOf(Node left) {
        return (NodeList)left.workingData[0];
    }

    private void leftToRight(Node left, Node right) {
        this.rightOf(left).add(right);
    }

    void sortedInsert(List list, Node node) {
        int insert = 0;
        while (insert < list.size() && ((Node)list.get((int)insert)).sortValue > node.sortValue) {
            ++insert;
        }
        list.add(insert, node);
    }

    private void topologicalSort() {
        int i = 0;
        while (i < this.nestingTrees.length) {
            this.nestingTrees[i].getSortValueFromSubgraph();
            this.nestingTrees[i].recursiveSort(false);
            ++i;
        }
    }

    void init() {
        int r = 0;
        while (r < this.g.ranks.size()) {
            Rank rank = this.g.ranks.getRank(r);
            int i = 0;
            while (i < rank.count()) {
                Node n = (Node)rank.get(i);
                n.workingData[0] = new NodeList();
                ++i;
            }
            ++r;
        }
        int i = 0;
        while (i < this.g.subgraphs.size()) {
            Subgraph s = (Subgraph)this.g.subgraphs.get(i);
            s.workingData[0] = new NodeList();
            ++i;
        }
    }

    @Override
    public void visit(DirectedGraph dg) {
        this.g = (CompoundDirectedGraph)dg;
        this.init();
        this.buildSubgraphOrderingGraph();
        this.calculateSortValues();
        this.breakSubgraphCycles();
        this.topologicalSort();
        this.repopulateRanks();
    }
}

