/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.draw2d;

import com.hello2morrow.draw2d.Dimension;
import com.hello2morrow.draw2d.Graphics;
import com.hello2morrow.draw2d.LayeredPane;
import com.hello2morrow.draw2d.Rectangle;
import com.hello2morrow.draw2d.ScalableFigure;
import com.hello2morrow.draw2d.ScaledGraphics;
import com.hello2morrow.draw2d.Translatable;

public class ScalableLayeredPane
extends LayeredPane
implements ScalableFigure {
    private double scale = 1.0;

    @Override
    public Rectangle getClientArea(Rectangle rect) {
        super.getClientArea(rect);
        rect.width = (int)((double)rect.width / this.scale);
        rect.height = (int)((double)rect.height / this.scale);
        rect.x = (int)((double)rect.x / this.scale);
        rect.y = (int)((double)rect.y / this.scale);
        return rect;
    }

    @Override
    public Dimension getMinimumSize(int wHint, int hHint) {
        Dimension d = super.getMinimumSize(wHint != -1 ? (int)((double)wHint / this.getScale()) : -1, hHint != -1 ? (int)((double)hHint / this.getScale()) : -1);
        int w = this.getInsets().getWidth();
        int h = this.getInsets().getHeight();
        return d.getExpanded(-w, -h).scale(this.scale).expand(w, h);
    }

    @Override
    public Dimension getPreferredSize(int wHint, int hHint) {
        Dimension d = super.getPreferredSize(wHint != -1 ? (int)((double)wHint / this.getScale()) : -1, hHint != -1 ? (int)((double)hHint / this.getScale()) : -1);
        int w = this.getInsets().getWidth();
        int h = this.getInsets().getHeight();
        return d.getExpanded(-w, -h).scale(this.scale).expand(w, h);
    }

    @Override
    public double getScale() {
        return this.scale;
    }

    @Override
    public boolean isCoordinateSystem() {
        return true;
    }

    @Override
    protected void paintClientArea(Graphics graphics) {
        if (this.getChildren().isEmpty()) {
            return;
        }
        if (this.scale == 1.0) {
            super.paintClientArea(graphics);
        } else {
            boolean optimizeClip;
            ScaledGraphics g = new ScaledGraphics(graphics);
            boolean bl = optimizeClip = this.getBorder() == null || this.getBorder().isOpaque();
            if (!optimizeClip) {
                g.clipRect(this.getBounds().getCropped(this.getInsets()));
            }
            g.scale(this.scale);
            g.pushState();
            this.paintChildren(g);
            g.dispose();
            graphics.restoreState();
        }
    }

    @Override
    public void setScale(double newZoom) {
        if (this.scale == newZoom) {
            return;
        }
        this.scale = newZoom;
        this.fireMoved();
        this.revalidate();
        this.repaint();
    }

    @Override
    public void translateFromParent(Translatable t) {
        t.performScale(1.0 / this.scale);
    }

    @Override
    public void translateToParent(Translatable t) {
        t.performScale(this.scale);
    }
}

