/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.draw2d;

import com.hello2morrow.draw2d.Dimension;
import com.hello2morrow.draw2d.FreeformFigure;
import com.hello2morrow.draw2d.IFigure;
import com.hello2morrow.draw2d.Rectangle;
import com.hello2morrow.draw2d.Viewport;
import com.hello2morrow.draw2d.ViewportLayout;

public class FreeformViewport
extends Viewport {
    public FreeformViewport() {
        super(true);
        this.setLayoutManager(new FreeformViewportLayout());
    }

    @Override
    protected void readjustScrollBars() {
        if (this.getContents() == null) {
            return;
        }
        if (!(this.getContents() instanceof FreeformFigure)) {
            return;
        }
        FreeformFigure ff = (FreeformFigure)this.getContents();
        Rectangle clientArea = this.getClientArea();
        Rectangle bounds = ff.getFreeformExtent().getCopy();
        bounds.union(0, 0, clientArea.width, clientArea.height);
        ff.setFreeformBounds(bounds);
        this.getVerticalRangeModel().setAll(bounds.y, clientArea.height, bounds.bottom());
        this.getHorizontalRangeModel().setAll(bounds.x, clientArea.width, bounds.right());
    }

    @Override
    protected boolean useLocalCoordinates() {
        return true;
    }

    class FreeformViewportLayout
    extends ViewportLayout {
        FreeformViewportLayout() {
        }

        @Override
        protected Dimension calculatePreferredSize(IFigure parent, int wHint, int hHint) {
            FreeformViewport.this.getContents().validate();
            wHint = Math.max(0, wHint);
            hHint = Math.max(0, hHint);
            return ((FreeformFigure)FreeformViewport.this.getContents()).getFreeformExtent().getExpanded(FreeformViewport.this.getInsets()).union(0, 0).union(wHint - 1, hHint - 1).getSize();
        }

        @Override
        protected boolean isSensitiveHorizontally(IFigure parent) {
            return true;
        }

        @Override
        protected boolean isSensitiveVertically(IFigure parent) {
            return true;
        }

        @Override
        public void layout(IFigure figure) {
        }
    }
}

