/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.draw2d;

import com.hello2morrow.draw2d.ButtonModel;
import com.hello2morrow.draw2d.ChangeEvent;
import com.hello2morrow.draw2d.ChangeListener;
import com.hello2morrow.draw2d.Clickable;
import com.hello2morrow.draw2d.FigureListener;
import com.hello2morrow.draw2d.FocusEvent;
import com.hello2morrow.draw2d.FocusListener;
import com.hello2morrow.draw2d.IFigure;
import com.hello2morrow.draw2d.KeyEvent;
import com.hello2morrow.draw2d.KeyListener;
import com.hello2morrow.draw2d.MouseEvent;
import com.hello2morrow.draw2d.MouseListener;
import com.hello2morrow.draw2d.MouseMotionListener;

class ClickableEventHandler
extends MouseMotionListener.Stub
implements MouseListener,
FigureListener,
ChangeListener,
KeyListener,
FocusListener {
    private MouseEvent lastEvent;

    ClickableEventHandler() {
    }

    @Override
    public void focusLost(FocusEvent fe) {
        Clickable loser = (Clickable)fe.loser;
        loser.repaint();
        loser.getModel().setArmed(false);
        loser.getModel().setPressed(false);
    }

    @Override
    public void focusGained(FocusEvent fe) {
        Clickable clickable = (Clickable)fe.gainer;
        clickable.repaint();
    }

    @Override
    public void figureMoved(IFigure source) {
        if (this.lastEvent == null) {
            return;
        }
        this.mouseDragged(this.lastEvent);
    }

    @Override
    public void handleStateChanged(ChangeEvent change) {
        Clickable clickable = (Clickable)change.getSource();
        if (change.getPropertyName() == "mouseover" && !clickable.isRolloverEnabled()) {
            return;
        }
        clickable.repaint();
    }

    @Override
    public void mouseDoubleClicked(MouseEvent me) {
    }

    @Override
    public void mouseDragged(MouseEvent me) {
        this.lastEvent = me;
        Clickable click = (Clickable)me.getSource();
        ButtonModel model = click.getModel();
        if (model.isPressed()) {
            boolean over = click.containsPoint(me.getLocation());
            model.setArmed(over);
            model.setMouseOver(over);
        }
    }

    @Override
    public void mouseEntered(MouseEvent me) {
        Clickable click = (Clickable)me.getSource();
        click.getModel().setMouseOver(true);
        click.addFigureListener(this);
    }

    @Override
    public void mouseExited(MouseEvent me) {
        Clickable click = (Clickable)me.getSource();
        click.getModel().setMouseOver(false);
        click.removeFigureListener(this);
    }

    @Override
    public void mouseMoved(MouseEvent me) {
    }

    @Override
    public void mousePressed(MouseEvent me) {
        if (me.button != 1) {
            return;
        }
        this.lastEvent = me;
        Clickable click = (Clickable)me.getSource();
        ButtonModel model = click.getModel();
        click.requestFocus();
        model.setArmed(true);
        model.setPressed(true);
        me.consume();
    }

    @Override
    public void mouseReleased(MouseEvent me) {
        if (me.button != 1) {
            return;
        }
        ButtonModel model = ((Clickable)me.getSource()).getModel();
        if (!model.isPressed()) {
            return;
        }
        model.setPressed(false);
        model.setArmed(false);
        me.consume();
    }

    @Override
    public void keyPressed(KeyEvent ke) {
        ButtonModel model = ((Clickable)ke.getSource()).getModel();
        if (ke.character == ' ' || ke.character == '\r') {
            model.setPressed(true);
            model.setArmed(true);
        }
    }

    @Override
    public void keyReleased(KeyEvent ke) {
        ButtonModel model = ((Clickable)ke.getSource()).getModel();
        if (ke.character == ' ' || ke.character == '\r') {
            model.setPressed(false);
            model.setArmed(false);
        }
    }
}

