/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.license;

import com.hello2morrow.sonargraph.core.command.common.SonargraphLicenseHandler;
import com.hello2morrow.sonargraph.license.model.LicenseServerHost;
import com.hello2morrow.sonargraph.ui.swt.dialog.StandardDialog;
import com.hello2morrow.sonargraph.ui.swt.license.LicenseServerComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public final class LicenseServerDialog
extends StandardDialog
implements LicenseServerComposite.IListener {
    private LicenseServerComposite m_licenseServerComposite;
    private final SonargraphLicenseHandler m_licenseHandler;

    private LicenseServerDialog(Shell parentShell, SonargraphLicenseHandler licenseHandler) {
        super(parentShell, "License Server Settings", 34912);
        assert (licenseHandler != null) : "Parameter 'licenseHandler' of method 'LicenseServerDialog' must not be null";
        this.m_licenseHandler = licenseHandler;
    }

    @Override
    protected int getNumberOfColumns() {
        return 1;
    }

    @Override
    protected final void fillDialogArea(Composite composite) {
        super.fillDialogArea(composite);
        this.m_licenseServerComposite = new LicenseServerComposite(composite, this.m_licenseHandler, this);
        this.m_licenseServerComposite.setLayoutData(new GridData(4, 4, true, true));
    }

    protected final void createButtonsForButtonBar(Composite parent) {
        Button button = this.createButton(parent, 1024, "Restore Defaults", false);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LicenseServerDialog.this.m_licenseServerComposite.resetToDefaults();
            }
        });
        super.createButtonsForButtonBar(parent);
    }

    @Override
    protected void applyData() {
        Button restoreDefaultsButton = this.getButton(1024);
        if (restoreDefaultsButton != null) {
            restoreDefaultsButton.setEnabled(this.m_licenseServerComposite.resetToDefaultsPossible());
        }
        super.applyData();
    }

    @Override
    public boolean hasValidData() {
        return this.m_licenseServerComposite.hasValidData();
    }

    protected void okPressed() {
        this.m_licenseServerComposite.storeSettings();
        super.okPressed();
    }

    @Override
    public void inputModified(boolean inputIsValid, boolean settingsChanged) {
        Button restoreDefaultsButton;
        Button okButton = this.getButton(0);
        if (okButton != null) {
            okButton.setEnabled(inputIsValid && settingsChanged);
        }
        if ((restoreDefaultsButton = this.getButton(1024)) != null) {
            restoreDefaultsButton.setEnabled(this.m_licenseServerComposite.resetToDefaultsPossible());
        }
    }

    public static LicenseServerHost configureLicenseServerHost(Shell shell, SonargraphLicenseHandler licenseHandler) {
        LicenseServerDialog dialog = new LicenseServerDialog(shell, licenseHandler);
        if (dialog.open() == 0) {
            return LicenseServerComposite.createLicenseServerSettings(true);
        }
        return null;
    }
}

