/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.license;

import com.hello2morrow.sonargraph.foundation.utilities.HttpConnectionCheck;
import com.hello2morrow.sonargraph.foundation.utilities.Pair;
import com.hello2morrow.sonargraph.foundation.utilities.ProxySettings;
import com.hello2morrow.sonargraph.httpclient.model.ServerInfo;
import com.hello2morrow.sonargraph.ui.swt.base.IProxySettingsProvider;
import com.hello2morrow.sonargraph.ui.swt.base.SwtUtility;
import com.hello2morrow.sonargraph.ui.swt.dialog.MessageDialogWithContent;
import com.hello2morrow.sonargraph.ui.swt.dialog.StandardDialog;
import com.hello2morrow.sonargraph.ui.swt.license.ConnectionMode;
import java.util.List;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public final class ConnectionDialog
extends StandardDialog {
    private final boolean m_offerExit;
    private Response m_response;
    private Button m_online;
    private Button m_offline;
    private Button m_configureProxy;
    private Button m_exit;
    private final IProxySettingsProvider m_proxySettingsProvider;

    ConnectionDialog(Shell shell, IProxySettingsProvider proxySettingsProvider, ConnectionMode connectionMode, boolean offerExit) {
        super(shell, "Internet Connection Settings", 34912);
        assert (connectionMode != null) : "Parameter 'connectionMode' of method 'ConnectionDialog' must not be null";
        assert (proxySettingsProvider != null) : "Parameter 'proxySettingsProvider' of method 'ConnectionDialog' must not be null";
        switch (connectionMode) {
            case OFFLINE: {
                this.m_response = Response.OFFLINE;
                break;
            }
            case ONLINE: {
                this.m_response = Response.ONLINE;
                break;
            }
            default: {
                assert (false) : "Unhandled connection mode: " + String.valueOf((Object)connectionMode);
                break;
            }
        }
        this.m_proxySettingsProvider = proxySettingsProvider;
        this.m_offerExit = offerExit;
    }

    @Override
    protected boolean useCalculatedSizeAsMinimumSize() {
        return true;
    }

    protected Point getInitialLocation(Point initialSize) {
        Shell shell;
        if (initialSize != null && (shell = this.getShell()) != null && !shell.isDisposed()) {
            SwtUtility.disableEscape(shell);
            Point location = SwtUtility.calculateScreenCenteredLocation(shell, initialSize);
            if (location != null) {
                return location;
            }
        }
        return super.getInitialLocation(initialSize);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, "OK", true);
    }

    @Override
    protected Control createButtonBar(Composite parent) {
        Control control = super.createButtonBar(parent);
        if (this.getButton(0) != null) {
            this.getButton(0).setEnabled(true);
        }
        return control;
    }

    @Override
    protected void fillDialogArea(Composite composite) {
        assert (composite != null) : "Parameter 'composite' of method 'fillDialogArea' must not be null";
        Label text = new Label(composite, 64);
        StringBuilder info = new StringBuilder();
        if (this.m_response == Response.ONLINE) {
            info.append("The servers at hello2morrow are reachable.");
        } else {
            info.append("The servers at hello2morrow are not reachable. Either you are not connected to the Internet, you are behind a proxy\n or the servers at hello2morrow are down.");
        }
        info.append("\n\n");
        info.append("What do you want to do?");
        text.setText(info.toString());
        text.setLayoutData((Object)new GridData(4, 0, true, false));
        Group group = new Group(composite, 0);
        group.setLayout((Layout)new RowLayout(512));
        group.setLayoutData((Object)new GridData(4, 4, true, true));
        if (this.m_response == Response.ONLINE) {
            this.m_online = new Button((Composite)group, 16);
            this.m_online.setText("Stay 'online'.");
            this.m_online.setSelection(true);
            this.m_online.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    ConnectionDialog.this.m_response = Response.ONLINE;
                }
            });
        }
        this.m_offline = new Button((Composite)group, 16);
        this.m_offline.setText("Use in \"offline\" mode (activation code install, automatic ticket renewal, update check and feedback unavailable).");
        this.m_offline.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ConnectionDialog.this.m_response = Response.OFFLINE;
            }
        });
        this.m_offline.setSelection(this.m_response == Response.OFFLINE);
        this.m_configureProxy = new Button((Composite)group, 16);
        this.m_configureProxy.setText(this.m_proxySettingsProvider.getProxySettings(false) == null ? "Configure a proxy." : "Reconfigure proxy.");
        this.m_configureProxy.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ConnectionDialog.this.m_response = Response.CONFIGURE_PROXY;
            }
        });
        if (this.m_offerExit) {
            this.m_exit = new Button((Composite)group, 16);
            this.m_exit.setText("Exit Sonargraph.");
            this.m_exit.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    ConnectionDialog.this.m_response = Response.EXIT;
                }
            });
        }
    }

    private Response getResponse() {
        return this.m_response;
    }

    public static ConnectionMode getConnectionMode(IProxySettingsProvider proxySettingsProvider) {
        assert (proxySettingsProvider != null) : "Parameter 'proxySettingsProvider' of method 'getConnectionMode' must not be null";
        ProxySettings proxySettings = proxySettingsProvider.getProxySettings(false);
        Pair hostAndProxySettings = HttpConnectionCheck.getReachableHostWithProxySettings((List)ServerInfo.HTTPS_AND_HTTP_HOSTS, (String)"/license_contracts/test_connection", (String)"OK\n", (ProxySettings)proxySettings);
        return hostAndProxySettings.getFirst() != null ? ConnectionMode.ONLINE : ConnectionMode.OFFLINE;
    }

    public static Pair<ConnectionMode, ProxySettings> getOrConfigureConnectionMode(IProxySettingsProvider proxySettingsProvider) {
        assert (proxySettingsProvider != null) : "Parameter 'proxySettingsProvider' of method 'getOrConfigureConnectionMode' must not be null";
        ProxySettings proxySettings = proxySettingsProvider.getProxySettings(false);
        Pair hostAndProxySettings = HttpConnectionCheck.getReachableHostWithProxySettings((List)ServerInfo.HTTPS_AND_HTTP_HOSTS, (String)"/license_contracts/test_connection", (String)"OK\n", (ProxySettings)proxySettings);
        ConnectionMode connectionMode = hostAndProxySettings.getFirst() != null ? ConnectionMode.ONLINE : ConnectionMode.OFFLINE;
        ProxySettings usedProxySettings = (ProxySettings)hostAndProxySettings.getSecond();
        if (connectionMode == ConnectionMode.OFFLINE) {
            ConnectionDialog dialog = new ConnectionDialog(null, proxySettingsProvider, connectionMode, true);
            dialog.open();
            Response response = dialog.getResponse();
            switch (response) {
                case EXIT: {
                    return null;
                }
                case ONLINE: {
                    return new Pair((Object)ConnectionMode.ONLINE, (Object)usedProxySettings);
                }
                case OFFLINE: {
                    return new Pair((Object)ConnectionMode.OFFLINE, (Object)usedProxySettings);
                }
                case CONFIGURE_PROXY: {
                    int returnCode = proxySettingsProvider.configureProxySettings(null);
                    if (returnCode == 1) {
                        return ConnectionDialog.getOrConfigureConnectionMode(proxySettingsProvider);
                    }
                    if (!HttpConnectionCheck.canConnect((List)ServerInfo.CONNECTION_CHECK_URLS, null, (ProxySettings)proxySettingsProvider.getProxySettings(false))) {
                        new MessageDialogWithContent(null, "The servers at hello2morrow are not reachable with the specified proxy settings.", 4, null).open();
                        return ConnectionDialog.getOrConfigureConnectionMode(proxySettingsProvider);
                    }
                    return new Pair((Object)ConnectionMode.ONLINE, (Object)usedProxySettings);
                }
            }
            assert (false) : "Unhandled response: " + String.valueOf((Object)response);
            return new Pair((Object)ConnectionMode.OFFLINE, (Object)usedProxySettings);
        }
        return new Pair((Object)ConnectionMode.ONLINE, (Object)usedProxySettings);
    }

    public static ConnectionMode getOrConfigureConnectionMode(Shell shell, boolean offerExit, boolean forceDialog, IProxySettingsProvider proxySettingsProvider) {
        assert (proxySettingsProvider != null) : "Parameter 'proxySettingsProvider' of method 'getOrConfigureConnectionMode' must not be null";
        ConnectionMode connectionMode = ConnectionDialog.getConnectionMode(proxySettingsProvider);
        if (connectionMode == ConnectionMode.OFFLINE || forceDialog) {
            ConnectionDialog dialog = new ConnectionDialog(shell, proxySettingsProvider, connectionMode, offerExit);
            dialog.open();
            Response response = dialog.getResponse();
            switch (response) {
                case EXIT: {
                    return null;
                }
                case ONLINE: {
                    return ConnectionMode.ONLINE;
                }
                case OFFLINE: {
                    return ConnectionMode.OFFLINE;
                }
                case CONFIGURE_PROXY: {
                    int returnCode = proxySettingsProvider.configureProxySettings(shell);
                    if (returnCode == 1) {
                        return ConnectionDialog.getOrConfigureConnectionMode(shell, offerExit, false, proxySettingsProvider);
                    }
                    if (!HttpConnectionCheck.canConnect((List)ServerInfo.CONNECTION_CHECK_URLS, null, (ProxySettings)proxySettingsProvider.getProxySettings(false))) {
                        new MessageDialogWithContent(shell, "The servers at hello2morrow are not reachable with the specified proxy settings.", 4, null).open();
                        return ConnectionDialog.getOrConfigureConnectionMode(shell, offerExit, false, proxySettingsProvider);
                    }
                    return ConnectionMode.ONLINE;
                }
            }
            assert (false) : "Unhandled response: " + String.valueOf((Object)response);
            return ConnectionMode.OFFLINE;
        }
        return ConnectionMode.ONLINE;
    }

    static enum Response {
        ONLINE,
        OFFLINE,
        CONFIGURE_PROXY,
        EXIT;

    }
}

