/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.graph;

import com.hello2morrow.draw2d.Dimension;
import com.hello2morrow.draw2d.IFigure;
import com.hello2morrow.draw2d.Label;
import com.hello2morrow.draw2d.Layer;
import com.hello2morrow.draw2d.Point;
import com.hello2morrow.draw2d.Rectangle;
import com.hello2morrow.sonargraph.core.model.programming.NodeAdapter;
import com.hello2morrow.sonargraph.foundation.utilities.Pair;
import com.hello2morrow.sonargraph.ui.swt.base.draw2d.DrawableViewLayout;
import com.hello2morrow.sonargraph.ui.swt.base.draw2d.IDrawableNode;
import com.hello2morrow.sonargraph.ui.swt.graph.GraphLevelFigure;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.swt.widgets.Control;

public final class LevelizedLayout
extends DrawableViewLayout {
    public static final String LEVEL = "Level";
    public static final String COMPARE_NAME = "CompareName";
    public static final String CYCLE_GROUP_INDEX = "CycleGroupIndex";
    private static final int INITIAL_HORIZONTAL_OFFSET = 30;
    private static final int HORIZONTAL_NODE_SEPARATION = 40;
    private static final int UPPER_LEVEL_OFFSET = 60;
    private static final int LOWER_LEVEL_OFFSET = 30;
    private static final int MIMIMUM_LEVEL_HEIGHT = 90;
    private final List<Pair<Label, GraphLevelFigure>> m_levelRelated = new ArrayList<Pair<Label, GraphLevelFigure>>();
    private Layer m_levelsLayer;

    @Override
    protected DrawableViewLayout.NodeAllocation getDefaultNodeAllocation() {
        return DrawableViewLayout.NodeAllocation.VERTICAL;
    }

    @Override
    protected void connect(Control displayingControl, Layer bottomLayer, Layer edgesLayer, Layer nodesLayer, Layer topLayer) {
        assert (bottomLayer != null) : "Parameter 'bottomLayer' of method 'connect' must not be null";
        assert (this.m_levelsLayer == null) : "'m_levelsLayer' of method 'connect' must be null";
        this.m_levelsLayer = bottomLayer;
        super.connect(displayingControl, bottomLayer, edgesLayer, nodesLayer, topLayer);
    }

    @Override
    protected void clear() {
        this.m_levelRelated.clear();
        super.clear();
    }

    @Override
    protected Dimension layout(List<IDrawableNode> nodes, DrawableViewLayout.NodeAllocation nodeAllocation) {
        assert (nodes != null && !nodes.isEmpty()) : "Parameter 'nodes' of method 'layout' must not be empty";
        assert (nodeAllocation != null) : "Parameter 'nodeAllocation' of method 'layout' must not be null";
        assert (this.m_levelsLayer != null) : "'m_levelsLayer' of method 'layout' must not be null";
        if (nodeAllocation != DrawableViewLayout.NodeAllocation.NONE && EnumSet.of(DrawableViewLayout.NodeAllocation.HORIZONTAL_AND_VERTICAL, DrawableViewLayout.NodeAllocation.VERTICAL).contains((Object)nodeAllocation)) {
            for (Pair<Label, GraphLevelFigure> next : this.m_levelRelated) {
                this.m_levelsLayer.remove((IFigure)next.getFirst());
                this.m_levelsLayer.remove((IFigure)next.getSecond());
            }
            this.m_levelRelated.clear();
        }
        int height = this.getDisplayingControl().getBounds().height;
        int width = this.getDisplayingControl().getBounds().width;
        TreeMap<Integer, List<IDrawableNode>> levelToElements = new TreeMap<Integer, List<IDrawableNode>>(new Comparator<Integer>(){

            @Override
            public int compare(Integer i1, Integer i2) {
                if (!$assertionsDisabled && i1 == null) {
                    throw new AssertionError((Object)"Parameter 'i1' of method 'compare' must not be null");
                }
                if (!$assertionsDisabled && i2 == null) {
                    throw new AssertionError((Object)"Parameter 'i2' of method 'compare' must not be null");
                }
                return i2 - i1;
            }
        });
        for (IDrawableNode nextNode : nodes) {
            Object nextLevelAsObject = nextNode.getData(LEVEL);
            assert (nextLevelAsObject != null && nextLevelAsObject instanceof Integer) : "Unexpected class in method 'applyLayout': " + String.valueOf(nextLevelAsObject);
            Integer nextLevel = (Integer)nextLevelAsObject;
            ArrayList<IDrawableNode> nextElementsInLevel = (ArrayList<IDrawableNode>)levelToElements.get(nextLevel);
            if (nextElementsInLevel == null) {
                nextElementsInLevel = new ArrayList<IDrawableNode>();
                levelToElements.put(nextLevel, nextElementsInLevel);
            }
            nextElementsInLevel.add(nextNode);
        }
        this.orderElementsInLevel(levelToElements);
        int numberOfLevels = levelToElements.size();
        int requiredSpacePerLevel = (int)Math.floor((double)height / (double)numberOfLevels);
        requiredSpacePerLevel = Math.max(requiredSpacePerLevel, 90);
        double currentVerticalOffset = 60.0;
        int currentHorizontalOffset = 30;
        int[] levelSeparators = new int[numberOfLevels - 1];
        int requiredWidth = 0;
        int requiredHeight = requiredSpacePerLevel * numberOfLevels;
        int horizontalExtent = 0;
        for (Map.Entry nextEntry : levelToElements.entrySet()) {
            List nextNodesInLevel = (List)nextEntry.getValue();
            int levelNumber = (Integer)nextEntry.getKey();
            int maxNodeHeight = 0;
            for (IDrawableNode nextNode : nextNodesInLevel) {
                Dimension nodePreferredSize = nextNode.getPreferredSize();
                maxNodeHeight = Math.max(maxNodeHeight, nodePreferredSize.height);
                double halfHeight = (double)nodePreferredSize.height / 2.0;
                if (nodeAllocation != DrawableViewLayout.NodeAllocation.NONE) {
                    Rectangle bounds = Rectangle.SINGLETON;
                    bounds.x = EnumSet.of(DrawableViewLayout.NodeAllocation.HORIZONTAL, DrawableViewLayout.NodeAllocation.HORIZONTAL_AND_VERTICAL).contains((Object)nodeAllocation) ? currentHorizontalOffset - 4 : nextNode.getBounds().x;
                    bounds.y = EnumSet.of(DrawableViewLayout.NodeAllocation.VERTICAL, DrawableViewLayout.NodeAllocation.HORIZONTAL_AND_VERTICAL).contains((Object)nodeAllocation) ? (int)Math.floor(currentVerticalOffset - halfHeight - 4.0) : nextNode.getBounds().y;
                    bounds.width = nodePreferredSize.width + 8;
                    bounds.height = nodePreferredSize.height + 8;
                    nextNode.setBounds(bounds);
                }
                currentHorizontalOffset += 40;
                currentHorizontalOffset += nodePreferredSize.width;
                int nexNodeRightExtent = nextNode.getBounds().x + nodePreferredSize.width;
                if (nexNodeRightExtent <= horizontalExtent) continue;
                horizontalExtent = nexNodeRightExtent;
            }
            if (levelNumber - 1 < levelSeparators.length) {
                levelSeparators[levelNumber - 1] = requiredSpacePerLevel * levelNumber;
            }
            currentVerticalOffset = levelNumber == numberOfLevels && numberOfLevels != 2 ? (double)requiredSpacePerLevel * 1.5 + 10.0 : (levelNumber == 2 ? (double)(requiredHeight - 30) : (currentVerticalOffset += (double)requiredSpacePerLevel));
            requiredWidth = Math.max(requiredWidth, currentHorizontalOffset);
            currentHorizontalOffset = 30;
        }
        if (EnumSet.of(DrawableViewLayout.NodeAllocation.HORIZONTAL_AND_VERTICAL, DrawableViewLayout.NodeAllocation.VERTICAL).contains((Object)nodeAllocation)) {
            this.addLevels(Math.max(width, horizontalExtent), levelSeparators);
        }
        Dimension size = new Dimension(requiredWidth, requiredHeight);
        this.setNeededSize(size);
        return size;
    }

    private void orderElementsInLevel(Map<Integer, List<IDrawableNode>> levelToElements) {
        assert (levelToElements != null) : "Parameter 'levelToElements' of method 'orderInLevel' must not be null";
        for (Map.Entry<Integer, List<IDrawableNode>> nextEntry : levelToElements.entrySet()) {
            List<IDrawableNode> nextElements = nextEntry.getValue();
            Collections.sort(nextElements, new Comparator<IDrawableNode>(){

                @Override
                public int compare(IDrawableNode node1, IDrawableNode node2) {
                    if (!$assertionsDisabled && node1 == null) {
                        throw new AssertionError((Object)"Parameter 'entity1' of method 'compare' must not be null");
                    }
                    if (!$assertionsDisabled && node2 == null) {
                        throw new AssertionError((Object)"Parameter 'entity2' of method 'compare' must not be null");
                    }
                    Object graphNode1CompareName = node1.getData(LevelizedLayout.COMPARE_NAME);
                    if (!($assertionsDisabled || graphNode1CompareName != null && graphNode1CompareName instanceof String)) {
                        throw new AssertionError((Object)("Unexpected class in method 'compare': " + String.valueOf(graphNode1CompareName)));
                    }
                    Object graphNode2CompareName = node2.getData(LevelizedLayout.COMPARE_NAME);
                    if (!($assertionsDisabled || graphNode2CompareName != null && graphNode2CompareName instanceof String)) {
                        throw new AssertionError((Object)("Unexpected class in method 'compare': " + String.valueOf(graphNode2CompareName)));
                    }
                    return ((String)graphNode1CompareName).compareTo((String)graphNode2CompareName);
                }
            });
        }
    }

    private void addLevels(int width, int[] levelSeparators) {
        assert (levelSeparators != null) : "Parameter 'levelSeparators' of method 'addLevels' must not be null";
        assert (this.m_levelsLayer != null) : "'m_levelsLayer' of method 'addLevels' must not be null";
        if (levelSeparators.length > 0) {
            Label levelLabel = new Label(String.valueOf(levelSeparators.length + 1));
            Point labelLocation = new Point(10, 10);
            levelLabel.setLocation(labelLocation);
            levelLabel.setBounds(new Rectangle(labelLocation.x - 10, labelLocation.y - 10, 20, 20));
            this.m_levelRelated.add((Pair<Label, GraphLevelFigure>)new Pair((Object)levelLabel, (Object)new GraphLevelFigure(new Point(), new Point())));
            int i = 0;
            while (i < levelSeparators.length) {
                GraphLevelFigure levelDivision = new GraphLevelFigure(new Point(0, levelSeparators[i]), new Point(width, levelSeparators[i]));
                levelLabel = new Label(String.valueOf(levelSeparators.length - i));
                labelLocation = new Point(10, levelSeparators[i] + 10);
                levelLabel.setLocation(labelLocation);
                levelLabel.setBounds(new Rectangle(labelLocation.x - 10, labelLocation.y - 10, 20, 20));
                this.m_levelRelated.add((Pair<Label, GraphLevelFigure>)new Pair((Object)levelLabel, (Object)levelDivision));
                ++i;
            }
            for (Pair<Label, GraphLevelFigure> next : this.m_levelRelated) {
                this.m_levelsLayer.add((IFigure)next.getFirst());
                this.m_levelsLayer.add((IFigure)next.getSecond());
            }
        }
    }

    @Override
    public void finishNodeCreation(NodeAdapter nodeAdapter, IDrawableNode node) {
        assert (nodeAdapter != null) : "Parameter 'nodeAdapter' of method 'finishNodeCreation' must not be null";
        assert (node != null) : "Parameter 'node' of method 'finishNodeCreation' must not be null";
        node.setData(LEVEL, nodeAdapter.getLevel());
        node.setData(COMPARE_NAME, nodeAdapter.getUnderlyingObject().getPresentationName(false));
        node.enableToolTip(true);
    }
}

