/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.graph;

import com.hello2morrow.draw2d.Dimension;
import com.hello2morrow.draw2d.Rectangle;
import com.hello2morrow.sonargraph.core.model.programming.IncludeDependencyNodeAdapter;
import com.hello2morrow.sonargraph.core.model.programming.NodeAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.draw2d.DrawableViewLayout;
import com.hello2morrow.sonargraph.ui.swt.base.draw2d.IDrawableNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class HorizontalTreeLayout
extends DrawableViewLayout {
    private static final String GENERATION = "Generation";
    private static final String OFFSET = "Offset";
    private static final String HEIGHT = "Height";
    private static final int BOUNDS_OFFSET = 30;
    private int m_maxHeight = 0;
    private int m_maxWidth = 0;

    @Override
    protected DrawableViewLayout.NodeAllocation getDefaultNodeAllocation() {
        return DrawableViewLayout.NodeAllocation.NONE;
    }

    @Override
    protected Dimension layout(List<IDrawableNode> nodes, DrawableViewLayout.NodeAllocation nodeAllocation) {
        assert (nodes != null) : "Parameter 'nodes' of method 'layout' must not be null";
        assert (nodeAllocation != null) : "Parameter 'nodeAllocation' of method 'layout' must not be null";
        for (IDrawableNode node : nodes) {
            Dimension nodePreferredSize = node.getPreferredSize();
            this.m_maxWidth = Math.max(this.m_maxWidth, nodePreferredSize.width + 8);
            this.m_maxHeight = Math.max(this.m_maxHeight, nodePreferredSize.height + 8);
        }
        LinkedHashMap<IDrawableNode, LinkedHashSet<IDrawableNode>> rootNodeToChildren = new LinkedHashMap<IDrawableNode, LinkedHashSet<IDrawableNode>>();
        for (IDrawableNode node : nodes) {
            if (node.getIncomingEdges() == null || !node.getIncomingEdges().isEmpty()) continue;
            LinkedHashSet<IDrawableNode> children = new LinkedHashSet<IDrawableNode>();
            children.add(node);
            this.collectChildrenForRootNode(node, children);
            rootNodeToChildren.put(node, children);
        }
        assert (rootNodeToChildren != null && !rootNodeToChildren.isEmpty()) : "Parameter 'rootNodeToChildren' of method 'layout' must not be empty";
        Dimension size = new Dimension();
        int nextHeight = 0;
        for (Map.Entry nextEntry : rootNodeToChildren.entrySet()) {
            IDrawableNode rootNode = (IDrawableNode)nextEntry.getKey();
            rootNode.setData(GENERATION, 0);
            rootNode.setData(OFFSET, nextHeight);
            nextHeight += this.setChildrenLocation(rootNode, this.getOutgoingEdgesEndpoints(rootNode), new ArrayList<Integer>(), 1, nextHeight);
            Dimension subTreeSize = this.layoutNodes((Collection)nextEntry.getValue(), nodeAllocation);
            size.width = Math.max(size.width, subTreeSize.width);
            size.height = Math.max(size.height, subTreeSize.height);
        }
        this.setNeededSize(size);
        return size;
    }

    private Dimension layoutNodes(Collection<IDrawableNode> nodesToLayout, DrawableViewLayout.NodeAllocation nodeAllocation) {
        assert (nodesToLayout != null) : "Parameter 'nodesToLayout' of method 'layoutNodes' must not be null";
        assert (nodeAllocation != null) : "Parameter 'nodeAllocation' of method 'layoutNodes' must not be null";
        int neededWidth = 0;
        int neededHeight = 0;
        for (IDrawableNode node : nodesToLayout) {
            Dimension nodePreferredSize = node.getPreferredSize();
            double x = 30.0;
            double y = 30.0;
            double nodeWidth = nodePreferredSize.width + 8;
            double nodeHeight = nodePreferredSize.height + 8;
            int generation = (Integer)node.getData(GENERATION);
            int offset = (Integer)node.getData(OFFSET);
            int height = (Integer)node.getData(HEIGHT);
            x += (double)(generation * this.m_maxWidth) * 2.0 - 4.0;
            y += (double)(offset * this.m_maxHeight) * 2.0 + (double)((height - 1) * this.m_maxHeight) - 4.0;
            if (nodeAllocation != DrawableViewLayout.NodeAllocation.NONE) {
                Rectangle boundingBox = new Rectangle();
                boundingBox.x = (int)Math.floor(x);
                boundingBox.y = (int)Math.floor(y);
                boundingBox.width = (int)Math.floor(nodeWidth);
                boundingBox.height = (int)Math.floor(nodeHeight);
                node.setBounds(boundingBox);
            }
            neededWidth = Math.max(neededWidth, (int)Math.floor(x + nodeWidth + 30.0));
            neededHeight = Math.max(neededHeight, (int)Math.floor(y + nodeHeight + 30.0));
        }
        return new Dimension(neededWidth, neededHeight);
    }

    private int setChildrenLocation(IDrawableNode parent, List<IDrawableNode> children, List<Integer> nextOffsetList, int level, int baseOffset) {
        assert (parent != null) : "Parameter 'parent' of method 'setChildrenLocation' must not be null";
        assert (children != null) : "Parameter 'children' of method 'setChildrenLocation' must not be null";
        assert (nextOffsetList != null) : "Parameter 'nextOffsetList' of method 'setChildrenLocation' must not be null";
        int height = 0;
        if (nextOffsetList.size() < level) {
            nextOffsetList.add(baseOffset);
        } else {
            baseOffset = Math.max(nextOffsetList.get(level - 1), baseOffset);
        }
        for (IDrawableNode node : children) {
            node.setData(GENERATION, level);
            node.setData(OFFSET, baseOffset + height);
            height += this.setChildrenLocation(node, this.getOutgoingEdgesEndpoints(node), nextOffsetList, level + 1, baseOffset + height);
        }
        height = height == 0 ? 1 : height;
        nextOffsetList.set(level - 1, baseOffset + height);
        parent.setData(HEIGHT, height);
        return height;
    }

    private void collectChildrenForRootNode(IDrawableNode rootNode, Set<IDrawableNode> collector) {
        assert (rootNode != null) : "Parameter 'rootNode' of method 'collectChildrenForRootNode' must not be null";
        assert (collector != null) : "Parameter 'collector' of method 'collectChildrenForRootNode' must not be null";
        for (IDrawableNode.IDrawableEdge<? extends IDrawableNode> edge : rootNode.getOutgoingEdges()) {
            IDrawableNode child = edge.getTo();
            collector.add(child);
            this.collectChildrenForRootNode(child, collector);
        }
    }

    private List<IDrawableNode> getOutgoingEdgesEndpoints(IDrawableNode node) {
        assert (node != null) : "Parameter 'node' of method 'getOutgoingEdgesEndpoints' must not be null";
        Set<IDrawableNode.IDrawableEdge<? extends IDrawableNode>> outgoingEdges = node.getOutgoingEdges();
        ArrayList<IDrawableNode> outgoingEdgesEndpoints = new ArrayList<IDrawableNode>(outgoingEdges.size());
        for (IDrawableNode.IDrawableEdge<? extends IDrawableNode> edge : outgoingEdges) {
            outgoingEdgesEndpoints.add(edge.getTo());
        }
        return outgoingEdgesEndpoints;
    }

    @Override
    protected void finishNodeCreation(NodeAdapter nodeAdapter, IDrawableNode node) {
        assert (nodeAdapter != null && nodeAdapter instanceof IncludeDependencyNodeAdapter) : "Unexpected class in method 'finishNodeCreation': " + String.valueOf(nodeAdapter);
        assert (node != null) : "Parameter 'node' of method 'finishNodeCreation' must not be null";
        node.enableToolTip(true);
    }
}

