/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.dialog;

import com.hello2morrow.sonargraph.foundation.common.SwtResourceProviderAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.PreferencesUtility;
import com.hello2morrow.sonargraph.ui.swt.base.SwtUtility;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import com.hello2morrow.sonargraph.ui.swt.base.help.HelpAdapter;
import com.hello2morrow.sonargraph.ui.swt.common.IDialogId;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public abstract class StandardDialog
extends TrayDialog
implements Listener,
DisposeListener {
    private Composite m_dialogArea;
    private String m_title;

    public StandardDialog(Shell shell, String title) {
        super(shell);
        assert (title != null && title.length() > 0) : "Parameter 'title' of method 'StandardDialog' must not be empty";
        this.m_title = SwtResourceProviderAdapter.getInstance().getString("standalone.label.application.name", new Object[0]) + " - " + title;
        this.setShellStyle(this.getShellStyle() | 0x4F0);
        this.setReturnCode(1);
    }

    public StandardDialog(Shell shell, String title, int shellStyle) {
        super(shell);
        assert (title != null && title.length() > 0) : "Parameter 'title' of method 'StandardDialog' must not be empty";
        this.m_title = SwtResourceProviderAdapter.getInstance().getString("standalone.label.application.name", new Object[0]) + " - " + title;
        this.setShellStyle(shellStyle);
        this.setReturnCode(1);
    }

    public StandardDialog(int shellStyle) {
        super(null);
        this.m_title = SwtResourceProviderAdapter.getInstance().getString("standalone.label.application.name", new Object[0]);
        this.setShellStyle(shellStyle);
        this.setReturnCode(1);
    }

    protected final void configureShell(Shell shell) {
        assert (shell != null) : "Parameter 'shell' of method 'configureShell' must not be null";
        super.configureShell(shell);
        shell.setImage(UiResourceManager.getInstance().getImage("icon_64x64"));
    }

    public final void handleEvent(Event event) {
        assert (event != null) : "Parameter 'event' of method 'handleEvent' must not be null";
        if (event.type == 28 && this.getTray() == null && HelpAdapter.getHelpAdapter() != null) {
            HelpAdapter.getHelpAdapter().showHelp(this, null);
        }
    }

    protected final Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        if (this.getDialogId() != null && HelpAdapter.getHelpAdapter() != null) {
            HelpAdapter.getHelpAdapter().register(this, this, (Object)this, this.getDialogId().getId());
        }
        return control;
    }

    protected final void changeTitle(String title) {
        assert (title != null && title.length() > 0) : "Parameter 'title' of method 'changeTitle' must not be empty";
        this.m_title = SwtResourceProviderAdapter.getInstance().getString("standalone.label.application.name", new Object[0]) + " - " + title;
        Shell shell = this.getShell();
        if (shell != null && !shell.isDisposed()) {
            shell.setText(this.m_title);
        }
        this.setReturnCode(1);
    }

    protected final IEclipsePreferences getPreferences(String bundleId) {
        assert (bundleId != null && bundleId.length() > 0) : "Parameter 'bundleId' of method 'getSettings' must not be empty";
        IDialogId dialogId = this.getDialogId();
        assert (dialogId != null) : "Parameter 'dialogId' of method 'getSettings' must not be null";
        return PreferencesUtility.getPreferences(bundleId, dialogId);
    }

    protected final IDialogSettings getDialogBoundsSettings() {
        return null;
    }

    protected final void initializeBounds() {
        super.initializeBounds();
    }

    protected final int getDialogBoundsStrategy() {
        return -1;
    }

    protected boolean useCalculatedSizeAsMinimumSize() {
        return false;
    }

    protected final Point getInitialSize() {
        Shell shell = this.getShell();
        Point minSize = this.getMinimumSize();
        Point size = SwtUtility.calculateSize(shell, minSize, this.getMaximumSize(), this.getPreferredSize());
        if (this.useCalculatedSizeAsMinimumSize()) {
            shell.setMinimumSize(size);
        } else {
            shell.setMinimumSize(minSize);
        }
        shell.setText(this.m_title);
        shell.addDisposeListener((DisposeListener)this);
        return size;
    }

    protected int getNumberOfColumns() {
        return 1;
    }

    protected void fillDialogArea(Composite composite) {
        assert (composite != null) : "Parameter 'composite' of method 'fillDialogArea' must not be null";
    }

    public final boolean isHelpAvailable() {
        return this.getDialogId() != null && HelpAdapter.getHelpAdapter() != null;
    }

    public final void create() {
        super.create();
        this.applyData();
    }

    protected IDialogId getDialogId() {
        return null;
    }

    protected void applyData() {
    }

    protected IEclipsePreferences saveData() {
        return null;
    }

    protected GridLayout createGridLayout() {
        return new GridLayout(this.getNumberOfColumns(), false);
    }

    protected final Control createDialogArea(Composite parent) {
        assert (parent != null) : "Parameter 'parent' of method 'createDialogArea' must not be null";
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        composite.setLayout((Layout)this.createGridLayout());
        this.fillDialogArea(composite);
        StandardDialog.applyDialogFont((Control)composite);
        this.m_dialogArea = parent;
        return composite;
    }

    protected final void reLayout() {
        if (this.m_dialogArea != null && !this.m_dialogArea.isDisposed()) {
            this.m_dialogArea.layout(true, true);
        }
    }

    protected Control createButtonBar(Composite parent) {
        Control control = super.createButtonBar(parent);
        Button okButton = this.getButton(0);
        if (okButton != null) {
            okButton.setEnabled(false);
            okButton.setText("&" + okButton.getText());
        }
        return control;
    }

    protected Point getMinimumSize() {
        return SwtUtility.DEFAULT_MINIMUM_DIALOG_SIZE;
    }

    protected Point getMaximumSize() {
        return SwtUtility.DEFAULT_MAXIMUM_DIALOG_SIZE;
    }

    protected Point getPreferredSize() {
        return null;
    }

    public boolean hasValidData() {
        return true;
    }

    public boolean close() {
        IEclipsePreferences preferences = this.saveData();
        if (preferences != null) {
            PreferencesUtility.save(preferences);
        }
        if (this.getDialogId() != null && HelpAdapter.getHelpAdapter() != null) {
            HelpAdapter.getHelpAdapter().unregister((Object)this);
        }
        return super.close();
    }

    public void widgetDisposed(DisposeEvent event) {
    }
}

