/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.cyclesview;

import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.graphview.GraphViewNode;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.DropLocation;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.PropertyTableViewer;
import com.hello2morrow.sonargraph.ui.swt.cyclesview.CycleView;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Control;

final class CycleBreakUpViewDragAndDropAdapter
implements DragSourceListener {
    private static final Transfer[] TRANSFER = new Transfer[]{TextTransfer.getInstance()};
    private final List<PropertyTableViewer<GraphViewNode.GraphViewDependency>> m_viewers;
    private final IListener m_listener;
    private DragSource m_cycleViewDragSource;
    private CycleView m_cycleView;
    private PropertyTableViewer<GraphViewNode.GraphViewDependency> m_sourceViewer;
    private List<GraphViewNode.GraphViewDependency> m_currentSelection;
    private GraphViewNode.GraphViewDependency m_target;
    private DropLocation m_location;

    CycleBreakUpViewDragAndDropAdapter(List<PropertyTableViewer<GraphViewNode.GraphViewDependency>> viewers, IListener listener) {
        assert (viewers != null && !viewers.isEmpty()) : "Parameter 'viewers' of method 'DragAndDropAdapter' must not be empty";
        assert (listener != null) : "Parameter 'listener' of method 'DragAndDropAdapter' must not be null";
        this.m_viewers = viewers;
        this.m_listener = listener;
        for (PropertyTableViewer<GraphViewNode.GraphViewDependency> nextViewer : this.m_viewers) {
            TableViewer nextTableViewer = nextViewer.getTableViewer();
            nextTableViewer.addDragSupport(2, TRANSFER, (DragSourceListener)this);
            nextTableViewer.addDropSupport(2, TRANSFER, (DropTargetListener)new DropAdapter((Viewer)nextTableViewer));
        }
    }

    void connect(CycleView view) {
        assert (view != null) : "Parameter 'view' of method 'connect' must not be null";
        if (this.m_cycleView != view) {
            if (this.m_cycleView != null) {
                this.disconnect();
            }
            this.m_cycleView = view;
            this.m_cycleViewDragSource = new DragSource(view.getMainControl(), 2);
            this.m_cycleViewDragSource.setTransfer(TRANSFER);
            this.m_cycleViewDragSource.addDragListener((DragSourceListener)this);
            this.m_cycleViewDragSource.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    CycleBreakUpViewDragAndDropAdapter.this.m_cycleViewDragSource.removeDragListener((DragSourceListener)CycleBreakUpViewDragAndDropAdapter.this);
                }
            });
        }
    }

    void disconnect() {
        if (this.m_cycleView != null) {
            this.m_cycleView = null;
            assert (this.m_cycleViewDragSource != null) : "'m_cycleViewDragSource' of method 'disconnect' must not be null";
            if (!this.m_cycleViewDragSource.isDisposed()) {
                this.m_cycleViewDragSource.dispose();
            }
            this.m_cycleViewDragSource = null;
        }
    }

    private PropertyTableViewer<GraphViewNode.GraphViewDependency> getSourceViewer(DragSourceEvent event) {
        assert (event != null) : "Parameter 'event' of method 'getSourceViewer' must not be null";
        Object source = event.getSource();
        assert (source != null && source instanceof DragSource) : "Unexpected class in method 'getSourceViewer': " + String.valueOf(source);
        DragSource dragSource = (DragSource)source;
        Control control = dragSource.getControl();
        for (PropertyTableViewer<GraphViewNode.GraphViewDependency> nextViewer : this.m_viewers) {
            if (nextViewer.getTable() != control) continue;
            return nextViewer;
        }
        assert (false) : "No source viewer found";
        return null;
    }

    private PropertyTableViewer<GraphViewNode.GraphViewDependency> getTargetViewer(Viewer viewer) {
        assert (viewer != null) : "Parameter 'viewer' of method 'getTargetViewer' must not be null";
        for (PropertyTableViewer<GraphViewNode.GraphViewDependency> nextViewer : this.m_viewers) {
            if (nextViewer.getTableViewer() != viewer) continue;
            return nextViewer;
        }
        assert (false) : "No target viewer found";
        return null;
    }

    public void dragStart(DragSourceEvent event) {
        assert (event != null) : "Parameter 'event' of method 'dragStart' must not be null";
        if (event.getSource() == this.m_cycleViewDragSource) {
            assert (this.m_cycleView != null) : "'m_cycleView' of method 'dragStart' must not be null";
            if (this.m_cycleView.getElementInteractor().dragAndDropStarted()) {
                ArrayList<GraphViewNode.GraphViewDependency> edges = new ArrayList<GraphViewNode.GraphViewDependency>();
                for (Element next : this.m_cycleView.getSelectedElements()) {
                    GraphViewNode.GraphViewDependency nextDependency;
                    if (!(next instanceof GraphViewNode.GraphViewDependency) || (nextDependency = (GraphViewNode.GraphViewDependency)next).getFrom() == nextDependency.getTo()) continue;
                    edges.add(nextDependency);
                }
                if (!edges.isEmpty()) {
                    this.m_sourceViewer = null;
                    this.m_currentSelection = edges;
                    return;
                }
            }
            event.doit = false;
        } else {
            this.m_sourceViewer = this.getSourceViewer(event);
            List selection = this.m_sourceViewer.getSelection().toList();
            if (selection.isEmpty()) {
                this.m_currentSelection = Collections.emptyList();
            } else {
                this.m_currentSelection = new ArrayList<GraphViewNode.GraphViewDependency>(selection.size());
                for (Object nextSelected : selection) {
                    assert (nextSelected != null && nextSelected instanceof GraphViewNode.GraphViewDependency) : "Unexpected class in method 'dragStart': " + String.valueOf(nextSelected);
                    this.m_currentSelection.add((GraphViewNode.GraphViewDependency)nextSelected);
                }
            }
        }
    }

    public void dragSetData(DragSourceEvent event) {
        assert (this.m_currentSelection != null && !this.m_currentSelection.isEmpty()) : "'m_currentSelection' of method 'dragSetData' must not be empty";
        StringBuilder builder = new StringBuilder();
        for (GraphViewNode.GraphViewDependency next : this.m_currentSelection) {
            builder.append(next.toString());
            builder.append(",");
        }
        builder.deleteCharAt(builder.length() - 1);
        event.data = builder.toString();
    }

    public void dragFinished(DragSourceEvent event) {
        assert (event != null) : "Parameter 'event' of method 'dragFinished' must not be null";
        if (event.getSource() == this.m_cycleViewDragSource) {
            assert (this.m_cycleView != null) : "'m_cycleView' of method 'dragStart' must not be null";
            this.m_cycleView.getElementInteractor().dragAndDropFinished();
        }
    }

    private class DropAdapter
    extends ViewerDropAdapter {
        DropAdapter(Viewer viewer) {
            super(viewer);
        }

        public boolean validateDrop(Object target, int operation, TransferData transferType) {
            return true;
        }

        public void drop(DropTargetEvent event) {
            Object target = this.determineTarget(event);
            if (target != null) {
                int location = this.determineLocation(event);
                switch (location) {
                    case 1: {
                        CycleBreakUpViewDragAndDropAdapter.this.m_location = DropLocation.BEFORE;
                        break;
                    }
                    case 2: {
                        CycleBreakUpViewDragAndDropAdapter.this.m_location = DropLocation.AFTER;
                        break;
                    }
                    case 3: {
                        CycleBreakUpViewDragAndDropAdapter.this.m_location = DropLocation.ON;
                        break;
                    }
                    default: {
                        CycleBreakUpViewDragAndDropAdapter.this.m_location = DropLocation.AFTER;
                    }
                }
                assert (target != null && target instanceof GraphViewNode.GraphViewDependency) : "Unexpected class in method 'drop': " + String.valueOf(target);
                CycleBreakUpViewDragAndDropAdapter.this.m_target = (GraphViewNode.GraphViewDependency)target;
            }
            super.drop(event);
        }

        public boolean performDrop(Object data) {
            CycleBreakUpViewDragAndDropAdapter.this.m_listener.perform(CycleBreakUpViewDragAndDropAdapter.this.m_target, CycleBreakUpViewDragAndDropAdapter.this.m_location, CycleBreakUpViewDragAndDropAdapter.this.m_currentSelection, CycleBreakUpViewDragAndDropAdapter.this.m_sourceViewer, CycleBreakUpViewDragAndDropAdapter.this.getTargetViewer(this.getViewer()));
            CycleBreakUpViewDragAndDropAdapter.this.m_sourceViewer = null;
            CycleBreakUpViewDragAndDropAdapter.this.m_currentSelection = null;
            CycleBreakUpViewDragAndDropAdapter.this.m_target = null;
            CycleBreakUpViewDragAndDropAdapter.this.m_location = null;
            return true;
        }
    }

    static interface IListener {
        public boolean perform(GraphViewNode.GraphViewDependency var1, DropLocation var2, List<GraphViewNode.GraphViewDependency> var3, PropertyTableViewer<GraphViewNode.GraphViewDependency> var4, PropertyTableViewer<GraphViewNode.GraphViewDependency> var5);
    }
}

