/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.common;

import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.IElementGroup;
import com.hello2morrow.sonargraph.core.model.element.IElementResolver;
import com.hello2morrow.sonargraph.core.model.element.INavigationState;
import com.hello2morrow.sonargraph.core.model.element.IStateData;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.foundation.utilities.IStandardEnumeration;
import com.hello2morrow.sonargraph.foundation.utilities.Pair;
import com.hello2morrow.sonargraph.ui.swt.common.ViewKey;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NavigationState
implements INavigationState {
    private static final Logger LOGGER = LoggerFactory.getLogger(NavigationState.class);
    private static final DeadStateInfoProvider DEFAULT_DEAD_STATE_INFO_PROVIDER = new DeadStateInfoProvider();
    private final int m_id;
    private Type m_type;
    private Map<IElementGroup, Collection<String>> m_singleElementCollection;
    private Map<IElementGroup, Collection<Pair<String, String>>> m_endPointCollections;
    private Map<IStateData, Set<Pair<String, Class<? extends Enum<?>>>>> m_standardEnumerationCollections;
    private Map<IStateData, Object> m_stateData;
    private IDeadStateInfoProvider m_deadStateInfoProvider;
    private ViewKey m_viewKey;
    private boolean m_isZombie;
    private boolean m_isInvolvedInUndoRedoOperation;
    private boolean m_mayBeReplacedByMoreDetailedState = true;

    NavigationState(ViewKey viewKey, Type type, int id) {
        assert (viewKey != null) : "Parameter 'viewKey' of method 'NavigationState' must not be null";
        assert (type != null) : "Parameter 'type' of method 'NavigationState' must not be null";
        this.m_viewKey = viewKey;
        this.m_type = type;
        this.m_id = id;
        this.m_deadStateInfoProvider = DEFAULT_DEAD_STATE_INFO_PROVIDER;
    }

    void setViewKey(ViewKey viewKey) {
        assert (viewKey != null) : "Parameter 'viewKey' of method 'setViewKey' must not be null";
        assert (!this.m_viewKey.equals(viewKey)) : "View keys are equal";
        this.m_viewKey = viewKey;
    }

    public ViewKey getViewKey() {
        return this.m_viewKey;
    }

    public void setType(Type type) {
        assert (type != null) : "Parameter 'type' of method 'setType' must not be null";
        this.m_type = type;
    }

    public Type getType() {
        return this.m_type;
    }

    public int getId() {
        return this.m_id;
    }

    public void setMayBeReplacedByMoreDetailedState(boolean replace) {
        this.m_mayBeReplacedByMoreDetailedState = replace;
    }

    public boolean mayBeReplacedByMoreDetailedState() {
        return this.m_mayBeReplacedByMoreDetailedState;
    }

    public void markAsZombie() {
        this.m_isZombie = true;
    }

    public boolean isZombie() {
        return this.m_isZombie;
    }

    public void setDeadStateInfoProvider(IDeadStateInfoProvider deadStateInfoProvider) {
        assert (deadStateInfoProvider != null) : "Parameter 'deadStateInfoProvider' of method 'setDeadStateInfoProvider' must not be null";
        this.m_deadStateInfoProvider = deadStateInfoProvider;
    }

    public boolean isDeadState(IElementResolver resolver) {
        return this.m_deadStateInfoProvider.meetsDeadStateCriteria(this, resolver);
    }

    public boolean containsAllElementsFrom(NavigationState other) {
        Collection<String> nextValues;
        assert (other != null) : "Parameter 'other' of method 'containsAllElementFrom' must not be null";
        if (this == other) {
            return true;
        }
        if (other.m_singleElementCollection != null) {
            for (Map.Entry<IElementGroup, Collection<String>> entry : other.m_singleElementCollection.entrySet()) {
                if (entry.getValue().isEmpty()) continue;
                if (this.m_singleElementCollection == null) {
                    return false;
                }
                nextValues = this.m_singleElementCollection.get(entry.getKey());
                if (nextValues == null) {
                    return false;
                }
                if (nextValues.equals(entry.getValue())) continue;
                return false;
            }
        }
        if (other.m_endPointCollections != null) {
            for (Map.Entry<IElementGroup, Collection<String>> entry : other.m_endPointCollections.entrySet()) {
                if (entry.getValue().isEmpty()) continue;
                if (this.m_endPointCollections == null) {
                    return false;
                }
                nextValues = this.m_endPointCollections.get(entry.getKey());
                if (nextValues == null) {
                    return false;
                }
                if (nextValues.equals(entry.getValue())) continue;
                return false;
            }
        }
        return true;
    }

    public <T extends Enum<T>> void addConstant(IStateData stateData, T constant) {
        assert (stateData != null) : "Parameter 'viewData' of method 'addConstant' must not be null";
        assert (constant != null) : "Parameter 'constant' of method 'addConstant' must not be null";
        this.addConstants(stateData, Collections.singleton(constant));
    }

    public <T extends Enum<T>> void addConstants(IStateData stateData, Collection<T> data) {
        assert (stateData != null) : "Parameter 'elementGroup' of method 'addGroupOfData' must not be null";
        assert (data != null) : "Parameter 'data' of method 'addGroupOfData' must not be null";
        if (this.m_standardEnumerationCollections == null) {
            this.m_standardEnumerationCollections = new THashMap();
        }
        Set<Pair<String, Class<T>>> descriptors = this.getStandardNames(data);
        THashSet set = new THashSet(descriptors.size());
        for (Pair<String, Class<T>> pair : descriptors) {
            set.add(new Pair((Object)((String)pair.getFirst()), (Object)((Class)pair.getSecond())));
        }
        this.m_standardEnumerationCollections.put(stateData, (Set<Pair<String, Class<Enum<?>>>>)set);
    }

    public <T extends Enum<T>> void addFullViewData(Map<IStateData, Object> fullViewData) {
        assert (fullViewData != null) : "Parameter 'fullViewData' of method 'addFullViewData' must not be null";
        for (Map.Entry<IStateData, Object> entry : fullViewData.entrySet()) {
            IStateData data = entry.getKey();
            Object object = entry.getValue();
            if (object instanceof Integer) {
                this.addInt(data, (Integer)object);
                continue;
            }
            if (object instanceof Double) {
                this.addDouble(data, (Double)object);
                continue;
            }
            if (object instanceof Boolean) {
                this.addBoolean(data, (Boolean)object);
                continue;
            }
            if (object instanceof String) {
                this.addString(data, (String)object);
                continue;
            }
            if (object instanceof Enum && object instanceof IStandardEnumeration) {
                this.addConstant(data, (Enum)object);
                continue;
            }
            assert (false) : "Unexpected class: " + String.valueOf(object);
        }
    }

    public void removeViewData(IStateData data) {
        assert (data != null) : "Parameter 'data' of method 'removeViewData' must not be null";
        if (this.m_stateData != null) {
            this.m_stateData.remove(data);
        }
    }

    public void addViewData(IStateData data, Object object) {
        assert (data != null) : "Parameter 'data' of method 'addBoolean' must not be null";
        assert (object != null) : "Parameter 'object' of method 'addBoolean' must not be null";
        if (this.m_stateData == null) {
            this.m_stateData = new THashMap();
        }
        this.m_stateData.put(data, object);
    }

    public void addInt(IStateData data, int object) {
        this.addViewData(data, object);
    }

    public void addBoolean(IStateData data, boolean object) {
        this.addViewData(data, object);
    }

    public void addString(IStateData data, String object) {
        this.addViewData(data, object);
    }

    public void addDouble(IStateData data, double object) {
        this.addViewData(data, object);
    }

    public void addElementsInformation(IElementGroup aspect, Set<String> descriptors) {
        assert (aspect != null) : "Parameter 'aspect' of method 'addInformationFromViewAspect' must not be null";
        assert (descriptors != null) : "Parameter 'descriptors' of method 'addInformationFromViewAspect' must not be null";
        assert (aspect.informationType() == IElementGroup.InformationType.SINGLE_ELEMENT) : "Unexpected information type: '" + String.valueOf(aspect.informationType()) + "'";
        if (this.m_singleElementCollection == null) {
            this.m_singleElementCollection = new THashMap();
        }
        this.m_singleElementCollection.put(aspect, descriptors);
    }

    public void addDependenciesInformation(IElementGroup aspect, Set<Pair<String, String>> descriptors) {
        assert (aspect != null) : "Parameter 'aspect' of method 'addDependenciesInformation' must not be null";
        assert (descriptors != null) : "Parameter 'descriptors' of method 'addDependenciesInformation' must not be null";
        assert (aspect.informationType() == IElementGroup.InformationType.ENDPOINTS) : "Unexpected information type: '" + String.valueOf(aspect.informationType()) + "'";
        if (this.m_endPointCollections == null) {
            this.m_endPointCollections = new THashMap();
        }
        this.m_endPointCollections.put(aspect, descriptors);
    }

    public <T extends Element> List<T> getElements(IElementGroup aspect, Class<T> clazz, IElementResolver resolver) {
        Collection<String> descriptors;
        assert (aspect != null) : "Parameter 'aspect' of method 'getElements' must not be null";
        assert (resolver != null) : "Parameter 'resolver' of method 'getElements' must not be null";
        if (this.m_singleElementCollection != null && (descriptors = this.m_singleElementCollection.get(aspect)) != null) {
            return Collections.unmodifiableList(this.getElementsByClass(descriptors, clazz, resolver));
        }
        return Collections.emptyList();
    }

    public Set<Pair<NamedElement, NamedElement>> getDependenciesEndpoints(IElementGroup aspect, IElementResolver resolver) {
        Collection<Pair<String, String>> descriptors;
        assert (aspect != null) : "Parameter 'option' of method 'getDependenciesEndpoints' must not be null";
        assert (resolver != null) : "Parameter 'resolver' of method 'getDependenciesEndpoints' must not be null";
        if (this.m_endPointCollections != null && (descriptors = this.m_endPointCollections.get(aspect)) != null) {
            return this.getNamedElementsForEndPoints(descriptors, resolver);
        }
        return Collections.emptySet();
    }

    public boolean hasDependenciesEndpoints(IElementGroup aspect) {
        Collection<Pair<String, String>> descriptors;
        assert (aspect != null) : "Parameter 'aspect' of method 'hasDependenciesEndpoints' must not be null";
        return this.m_endPointCollections != null && (descriptors = this.m_endPointCollections.get(aspect)) != null;
    }

    public <T extends IStandardEnumeration> Set<T> getConstants(IStateData stateData) {
        Set<Pair<String, Class<? extends Enum<?>>>> descriptors;
        assert (stateData != null) : "Parameter 'aspect' of method 'getStandardEnums' must not be null";
        if (this.m_standardEnumerationCollections != null && (descriptors = this.m_standardEnumerationCollections.get(stateData)) != null) {
            return Collections.unmodifiableSet(this.getConstantsFromStandardNames(descriptors));
        }
        return Collections.emptySet();
    }

    public Object getDataAsObject(IStateData option) {
        assert (option != null) : "Parameter 'option' of method 'getBoolean' must not be null";
        if (this.m_stateData != null) {
            return this.m_stateData.get(option);
        }
        return null;
    }

    public Integer getInt(IStateData option) {
        assert (option != null) : "Parameter 'option' of method 'getViewData' must not be null";
        Object object = this.getDataAsObject(option);
        if (object != null) assert (object instanceof Integer) : "Unexpected class in method 'getViewData': " + String.valueOf(object);
        return (Integer)object;
    }

    public Boolean getBoolean(IStateData option) {
        assert (option != null) : "Parameter 'option' of method 'getViewData' must not be null";
        Object object = this.getDataAsObject(option);
        if (object != null) assert (object instanceof Boolean) : "Unexpected class in method 'getViewData': " + String.valueOf(object);
        return (Boolean)object;
    }

    public Double getDouble(IStateData option) {
        assert (option != null) : "Parameter 'option' of method 'getViewData' must not be null";
        Object object = this.getDataAsObject(option);
        if (object != null) assert (object instanceof Double) : "Unexpected class in method 'getViewData': " + String.valueOf(object);
        return (Double)object;
    }

    public String getString(IStateData option) {
        assert (option != null) : "Parameter 'option' of method 'getViewData' must not be null";
        Object object = this.getDataAsObject(option);
        if (object != null) assert (object instanceof String) : "Unexpected class in method 'getViewData': " + String.valueOf(object);
        return (String)object;
    }

    public <T extends Enum<T>> T getConstant(IStateData option) {
        assert (option != null) : "Parameter 'option' of method 'getConstant' must not be null";
        Set<T> constants = this.getConstants(option);
        assert (constants.size() == 1) : "Only 1 constant expected for IStateData '" + String.valueOf(option) + "' but was: " + constants.size();
        return (T)((Enum)constants.iterator().next());
    }

    public boolean hasConstant(IStateData option) {
        assert (option != null) : "Parameter 'option' of method 'getConstant' must not be null";
        return !this.getConstants(option).isEmpty();
    }

    public static <T extends Element> Set<String> getDescriptors(Collection<T> elementsToAdd, IElementResolver resolver) {
        assert (elementsToAdd != null) : "Parameter 'elementsToAdd' of method 'addDescriptors' must not be null";
        assert (resolver != null) : "Parameter 'resolver' of method 'getDescriptors' must not be null";
        THashSet descriptors = new THashSet(elementsToAdd.size());
        for (Element next : elementsToAdd) {
            String descriptor = resolver.getDescriptor(next);
            if (descriptor != null) {
                descriptors.add(descriptor);
                continue;
            }
            LOGGER.warn("Null descriptor for element of class: '" + String.valueOf(next.getClass()) + "'.");
        }
        return descriptors;
    }

    private <T extends Enum<T>> Set<Pair<String, Class<T>>> getStandardNames(Collection<T> elementsToAdd) {
        assert (elementsToAdd != null) : "Parameter 'elementsToAdd' of method 'getStandardNames' must not be null";
        THashSet standardNames = new THashSet(elementsToAdd.size());
        for (IStandardEnumeration element : elementsToAdd) {
            Enum enumConstant = (Enum)element;
            String constantName = enumConstant.name();
            if (constantName == null) continue;
            standardNames.add(new Pair((Object)constantName, element.getClass()));
        }
        return standardNames;
    }

    private <T> List<T> getElementsByClass(Collection<String> descriptors, Class<T> clazz, IElementResolver resolver) {
        assert (descriptors != null) : "Parameter 'descriptors' of method 'getNamedElements' must not be null";
        assert (resolver != null) : "Parameter 'resolver' of method 'getElementsByClass' must not be null";
        LinkedHashSet<Element> namedElements = new LinkedHashSet<Element>();
        for (String descriptor : descriptors) {
            Element resolved = resolver.resolve(descriptor);
            if (resolved == null) continue;
            assert (clazz.isAssignableFrom(resolved.getClass())) : "Unexpected class: " + resolved.getClass().getName() + " in method 'getElementsByClass'";
            namedElements.add(resolved);
        }
        return new ArrayList(namedElements);
    }

    private Set<Pair<NamedElement, NamedElement>> getNamedElementsForEndPoints(Collection<Pair<String, String>> descriptors, IElementResolver resolver) {
        assert (descriptors != null) : "Parameter 'descriptors' of method 'getNamedElementsForEndPoints' must not be null";
        assert (resolver != null) : "Parameter 'resolver' of method 'getNamedElementsForEndPoints' must not be null";
        LinkedHashSet<Pair<NamedElement, NamedElement>> endPoints = new LinkedHashSet<Pair<NamedElement, NamedElement>>();
        for (Pair<String, String> fromTo : descriptors) {
            Element from = resolver.resolve((String)fromTo.getFirst());
            Element to = resolver.resolve((String)fromTo.getSecond());
            if (from == null || to == null) continue;
            assert (from instanceof NamedElement) : "Unexpected class: " + from.getClass().getName() + " in method 'getNamedElementsForEndPoints'";
            assert (to instanceof NamedElement) : "Unexpected class: " + to.getClass().getName() + " in method 'getNamedElementsForEndPoints'";
            endPoints.add((Pair<NamedElement, NamedElement>)new Pair((Object)((NamedElement)from), (Object)((NamedElement)to)));
        }
        return endPoints;
    }

    private <T extends Enum<T>> Set<IStandardEnumeration> getConstantsFromStandardNames(Collection<Pair<String, Class<? extends Enum<?>>>> standardNames) {
        assert (standardNames != null) : "Parameter 'standardNames' of method 'getStandardEnums' must not be null";
        LinkedHashSet<IStandardEnumeration> enums = new LinkedHashSet<IStandardEnumeration>();
        for (Pair<String, Class<Enum<?>>> pair : standardNames) {
            String standardName = (String)pair.getFirst();
            Class clazz = (Class)pair.getSecond();
            Object enumConstant = Enum.valueOf(clazz, standardName);
            assert (enumConstant != null) : "'enumConstant' of method 'getConstantsFromStandardNames' must not be null";
            enums.add((IStandardEnumeration)enumConstant);
        }
        return enums;
    }

    public Map<IStateData, Object> getAllViewData() {
        return this.m_stateData == null ? Collections.EMPTY_MAP : Collections.unmodifiableMap(this.m_stateData);
    }

    public boolean isInvolvedInUndoRedoOperation() {
        return this.m_isInvolvedInUndoRedoOperation;
    }

    public void setInvolvedInUndoRedoOperation(boolean isInvolvedInUndoRedoOperation) {
        this.m_isInvolvedInUndoRedoOperation = isInvolvedInUndoRedoOperation;
    }

    public int hashCode() {
        int result = 0;
        result = 31 * result + this.m_viewKey.hashCode();
        result = 31 * result + this.m_type.hashCode();
        result = 31 * result + (this.m_endPointCollections == null ? 0 : this.m_endPointCollections.hashCode());
        result = 31 * result + (this.m_singleElementCollection == null ? 0 : this.m_singleElementCollection.hashCode());
        result = 31 * result + (this.m_standardEnumerationCollections == null ? 0 : this.m_standardEnumerationCollections.hashCode());
        result = 31 * result + (this.m_stateData == null ? 0 : this.m_stateData.hashCode());
        return result;
    }

    public boolean equalsContent(NavigationState other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (this.m_endPointCollections == null ? other.m_endPointCollections != null : !this.m_endPointCollections.equals(other.m_endPointCollections)) {
            return false;
        }
        if (this.m_singleElementCollection == null ? other.m_singleElementCollection != null : !this.m_singleElementCollection.equals(other.m_singleElementCollection)) {
            return false;
        }
        if (this.m_standardEnumerationCollections == null ? other.m_standardEnumerationCollections != null : !this.m_standardEnumerationCollections.equals(other.m_standardEnumerationCollections)) {
            return false;
        }
        return !(this.m_stateData == null ? other.m_stateData != null : !this.m_stateData.equals(other.m_stateData));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        NavigationState other = (NavigationState)obj;
        if (!this.m_viewKey.equals(other.m_viewKey)) {
            return false;
        }
        if (!this.m_type.equals((Object)other.m_type)) {
            return false;
        }
        return this.equalsContent(other);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.m_viewKey).append(": ").append(this.m_type.name()).append(", ID: ").append(this.m_id).append(" [").append(Integer.toHexString(this.hashCode())).append("]").append(this.m_mayBeReplacedByMoreDetailedState ? " (may be replaced)" : " (may not be replaced)");
        builder.append("\n");
        builder.append("Dead state info provider: ");
        builder.append(this.m_deadStateInfoProvider);
        builder.append("\n");
        if (this.m_stateData != null) {
            builder.append("View data: ");
            builder.append("\n");
            for (Map.Entry<Object, Object> entry : this.m_stateData.entrySet()) {
                builder.append(entry.getKey()).append(": ");
                Object nextValue = entry.getValue();
                builder.append(" [").append(nextValue.getClass().getSimpleName()).append("] ");
                if (nextValue instanceof Collection) {
                    builder.append(((Collection)nextValue).size());
                } else {
                    builder.append(nextValue);
                }
                builder.append("\n");
            }
        }
        if (this.m_singleElementCollection != null) {
            builder.append("Single element(s): ");
            for (Map.Entry<Object, Object> entry : this.m_singleElementCollection.entrySet()) {
                builder.append(entry.getKey());
                builder.append(" [" + ((Collection)entry.getValue()).size() + "]");
                builder.append(" ");
            }
            builder.append("\n");
        }
        if (this.m_endPointCollections != null) {
            builder.append("End point(s): ");
            for (Map.Entry<Object, Object> entry : this.m_endPointCollections.entrySet()) {
                builder.append(entry.getKey());
                builder.append(" [" + ((Collection)entry.getValue()).size() + "]");
                builder.append(" ");
            }
            builder.append("\n");
        }
        if (this.m_standardEnumerationCollections != null) {
            builder.append("Standard enumerations(s): ");
            for (Map.Entry<Object, Object> entry : this.m_standardEnumerationCollections.entrySet()) {
                builder.append(entry.getKey());
                builder.append(" [" + ((Set)entry.getValue()).size() + "]: ");
                for (Pair nextConstant : (Set)entry.getValue()) {
                    builder.append((String)nextConstant.getFirst()).append(" ");
                }
                builder.append("\n");
            }
        }
        return builder.toString();
    }

    private static final class DeadStateInfoProvider
    implements IDeadStateInfoProvider {
        private DeadStateInfoProvider() {
        }

        @Override
        public boolean meetsDeadStateCriteria(NavigationState navigationState, IElementResolver resolver) {
            assert (navigationState != null) : "Parameter 'navigationState' of method 'meetsDeadStateCriteria' must not be null";
            assert (resolver != null) : "Parameter 'resolver' of method 'meetsDeadStateCriteria' must not be null";
            if (navigationState.m_singleElementCollection != null && !navigationState.m_singleElementCollection.isEmpty()) {
                for (IElementGroup elementGroup : navigationState.m_singleElementCollection.keySet()) {
                    if (!navigationState.m_singleElementCollection.get(elementGroup).isEmpty() && (navigationState.m_singleElementCollection.get(elementGroup).isEmpty() || navigationState.getElements(elementGroup, Element.class, resolver).isEmpty())) continue;
                    return false;
                }
            }
            if (navigationState.m_endPointCollections != null && !navigationState.m_endPointCollections.isEmpty()) {
                for (IElementGroup elementGroup : navigationState.m_endPointCollections.keySet()) {
                    if (!navigationState.m_endPointCollections.get(elementGroup).isEmpty() && (navigationState.m_endPointCollections.get(elementGroup).isEmpty() || navigationState.getDependenciesEndpoints(elementGroup, resolver).isEmpty())) continue;
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            return "DEFAULT_DEAD_STATE_INFO_PROVIDER";
        }
    }

    public static interface IDeadStateInfoProvider {
        public boolean meetsDeadStateCriteria(NavigationState var1, IElementResolver var2);
    }

    public static enum Type {
        LINK(false),
        VIEW_SELECTED(false),
        VIEW_OPTIONS_CHANGED(false),
        CONTENT_SELECTED(true),
        CONTENT_COLLAPSED(true),
        CONTENT_EXPANDED(true),
        CONTENT_MODIFIED(true),
        CONTENT_VIEW_INSTANCE_REUSED(true),
        CONTENT_FOCUSED(true),
        CONTENT_EXTENDED_FOCUS_WITH_DEPENDENCIES(true),
        CONTENT_EXPANDED_DEPENDENCY_TO_COMPONENTS(true),
        CONTENT_FLATTENED(true),
        CONTENT_ZOOM_CHANGED(true),
        CONTENT_MARKED(true),
        CONTENT_UNMARKED(true),
        CONTENT_ALL_UNMARKED(true);

        private boolean m_contentRelated;

        private Type(boolean contentRelated) {
            this.m_contentRelated = contentRelated;
        }

        public boolean isContentRelated() {
            return this.m_contentRelated;
        }
    }
}

