/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.base.workbench;

import com.hello2morrow.sonargraph.core.model.common.IAnalyzerId;
import com.hello2morrow.sonargraph.core.model.context.IContext;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.IElementResolver;
import com.hello2morrow.sonargraph.core.model.event.AnalyzerModificationEvent;
import com.hello2morrow.sonargraph.core.model.event.ConfigurationModifiedEvent;
import com.hello2morrow.sonargraph.core.model.event.InstallationEvent;
import com.hello2morrow.sonargraph.core.model.event.InstallationModifiedEvent;
import com.hello2morrow.sonargraph.core.model.event.Modification;
import com.hello2morrow.sonargraph.core.model.event.SearchPathModifiedEvent;
import com.hello2morrow.sonargraph.core.model.event.SoftwareSystemClosedEvent;
import com.hello2morrow.sonargraph.core.model.event.SoftwareSystemModifiedEvent;
import com.hello2morrow.sonargraph.core.model.event.SoftwareSystemOpenedEvent;
import com.hello2morrow.sonargraph.core.model.event.SoftwareSystemProviderEvent;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.Installation;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.foundation.event.EventHandler;
import com.hello2morrow.sonargraph.foundation.event.EventManager;
import com.hello2morrow.sonargraph.foundation.event.IRegistrantRequestPerformed;
import com.hello2morrow.sonargraph.ui.swt.base.ISonargraphUIContribution;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import com.hello2morrow.sonargraph.ui.swt.base.help.HelpAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.textsearch.ITextSearchHandler;
import com.hello2morrow.sonargraph.ui.swt.base.textsearch.TextSearchData;
import com.hello2morrow.sonargraph.ui.swt.base.view.Gesture;
import com.hello2morrow.sonargraph.ui.swt.base.view.IWorkbenchView;
import com.hello2morrow.sonargraph.ui.swt.base.view.Search;
import com.hello2morrow.sonargraph.ui.swt.base.view.SelectionProviderAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.ElementInteractor;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import com.hello2morrow.sonargraph.ui.swt.common.NavigationState;
import com.hello2morrow.sonargraph.ui.swt.common.ViewNavigationManager;
import com.hello2morrow.sonargraph.ui.swt.dialog.TextSearchDialog;
import jakarta.annotation.PostConstruct;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class WorkbenchView
implements IWorkbenchView,
ISonargraphUIContribution,
Listener {
    private static final Logger LOGGER = LoggerFactory.getLogger(WorkbenchView.class);
    private Composite m_viewContentArea;
    private IEclipseContext m_eclipseContext;
    private EPartService m_partService;
    private MPart m_part;
    private SelectionProviderAdapter m_selectionProviderAdapter;
    private ElementInteractor m_elementInteractor;
    private TextSearchData m_textSearchData;
    private String m_secondaryId;
    private String m_initialPartName;
    private Boolean m_isAsleep;
    private boolean m_dragging;
    private boolean m_inRestoreState;

    protected WorkbenchView() {
        LOGGER.debug("[" + String.valueOf(this.getViewId()) + "] Instantiated");
    }

    @Override
    public final IEclipseContext getEclipseContext() {
        return this.m_eclipseContext;
    }

    @Override
    public final EPartService getPartService() {
        return this.m_partService;
    }

    @Override
    public final MPart getPart() {
        return this.m_part;
    }

    protected final SelectionProviderAdapter getSelectionProviderAdapter() {
        return this.m_selectionProviderAdapter;
    }

    protected EnumSet<Gesture> getDisabledGestures() {
        return EnumSet.noneOf(Gesture.class);
    }

    protected EnumSet<EventCategory> getDisabledEventCategories() {
        return EnumSet.noneOf(EventCategory.class);
    }

    protected boolean supportsSleep() {
        return true;
    }

    protected final boolean isAsleep() {
        return this.supportsSleep() && this.m_isAsleep != null && this.m_isAsleep != false;
    }

    public final ElementInteractor getElementInteractor() {
        assert (this.m_elementInteractor != null) : "'m_elementInteractor' of method 'getElementInteractor' must not be null";
        return this.m_elementInteractor;
    }

    protected abstract void createViewContent(Composite var1);

    @PostConstruct
    public final void createViewContent(IEclipseContext eclipseContext, EPartService partService, MPart part, ESelectionService selectionService, Composite parent) {
        assert (eclipseContext != null) : "Parameter 'eclipseContext' of method 'createViewContent' must not be null";
        assert (partService != null) : "Parameter 'partService' of method 'createViewContent' must not be null";
        assert (part != null) : "Parameter 'part' of method 'createViewContent' must not be null";
        assert (selectionService != null) : "Parameter 'selectionService' of method 'createPartControl' must not be null";
        assert (parent != null) : "'parent' must not be null";
        this.m_eclipseContext = eclipseContext;
        this.m_partService = partService;
        this.m_part = part;
        this.m_initialPartName = this.m_part.getLabel();
        this.m_selectionProviderAdapter = new SelectionProviderAdapter(this, selectionService, eclipseContext);
        Composite viewContentArea = new Composite(parent, 0);
        parent.setData("data.workbenchViewOfComposite", (Object)this);
        viewContentArea.setData("data.workbenchViewOfComposite", (Object)this);
        viewContentArea.setBackground(UiResourceManager.getInstance().getBackgroundColor());
        viewContentArea.setLayout((Layout)new FillLayout());
        this.createViewContent(viewContentArea);
        EnumSet<EventCategory> disabledEventCategories = this.getDisabledEventCategories();
        if (!disabledEventCategories.isEmpty()) {
            LOGGER.debug("[" + String.valueOf(this.getViewId()) + "] Disable event categories: " + String.valueOf(disabledEventCategories));
        }
        if (this.supportsSleep()) {
            LOGGER.debug("[" + String.valueOf(this.getViewId()) + "] Supports 'Sleep'");
            assert (!disabledEventCategories.contains((Object)EventCategory.SOFTWARE_SYSTEM)) : "View supporting 'Sleep' must not disable events of category '" + String.valueOf((Object)EventCategory.SOFTWARE_SYSTEM) + "': " + String.valueOf(this.getViewId());
        } else {
            LOGGER.debug("[" + String.valueOf(this.getViewId()) + "] Does no support 'Sleep'");
        }
        if (!disabledEventCategories.contains((Object)EventCategory.INSTALLATION)) {
            EventManager.getInstance().attach((EventHandler)new EventHandler<InstallationModifiedEvent>(InstallationModifiedEvent.class, (Object)this){

                public void handleEvent(InstallationModifiedEvent event) {
                    WorkbenchView.this.handleInstallationEvent((InstallationEvent)event);
                }
            });
            EventManager.getInstance().attach((EventHandler)new EventHandler<ConfigurationModifiedEvent>(ConfigurationModifiedEvent.class, (Object)this){

                public void handleEvent(ConfigurationModifiedEvent event) {
                    WorkbenchView.this.handleInstallationEvent((InstallationEvent)event);
                }
            });
            EventManager.getInstance().attach((EventHandler)new EventHandler<SearchPathModifiedEvent>(SearchPathModifiedEvent.class, (Object)this){

                public void handleEvent(SearchPathModifiedEvent event) {
                    WorkbenchView.this.handleInstallationEvent((InstallationEvent)event);
                }
            });
        }
        if (!disabledEventCategories.contains((Object)EventCategory.SOFTWARE_SYSTEM)) {
            EventManager.getInstance().attach((EventHandler)new EventHandler<SoftwareSystemOpenedEvent>(SoftwareSystemOpenedEvent.class, (Object)this){

                public void handleEvent(SoftwareSystemOpenedEvent event) {
                    WorkbenchView.this.handleSoftwareSystemOpenedEvent(event);
                }
            });
            EventManager.getInstance().attach((EventHandler)new EventHandler<SoftwareSystemModifiedEvent>(SoftwareSystemModifiedEvent.class, (Object)this){

                public void handleEvent(SoftwareSystemModifiedEvent event) {
                    WorkbenchView.this.handleSoftwareSystemModifiedEvent(event);
                }
            });
            EventManager.getInstance().attach((EventHandler)new EventHandler<AnalyzerModificationEvent>(AnalyzerModificationEvent.class, (Object)this){

                public void handleEvent(AnalyzerModificationEvent event) {
                    WorkbenchView.this.handleAnalyzerModificationEvent(event);
                }
            });
            EventManager.getInstance().attach((EventHandler)new EventHandler<SoftwareSystemClosedEvent>(SoftwareSystemClosedEvent.class, (Object)this){

                public void handleEvent(SoftwareSystemClosedEvent event) {
                    WorkbenchView.this.handleSoftwareSystemClosedEvent(event);
                }
            });
        }
        if (this.supportsSleep()) {
            parent.addListener(22, (Listener)this);
            parent.addListener(23, (Listener)this);
        } else {
            this.m_isAsleep = Boolean.FALSE;
        }
        viewContentArea.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                WorkbenchView.this.destroyViewContent();
            }
        });
        this.m_viewContentArea = viewContentArea;
        this.m_elementInteractor = new ElementInteractor(this, this.getDisabledGestures());
        if (WorkbenchRegistry.isRunning()) {
            if (!disabledEventCategories.contains((Object)EventCategory.INSTALLATION)) {
                this.installationModified();
            }
            if (!disabledEventCategories.contains((Object)EventCategory.SOFTWARE_SYSTEM) && this.getSoftwareSystem() != null) {
                this.handleSoftwareSystemShow(ShowMode.OPEN);
            }
        }
    }

    @Override
    public String getHelpContextId() {
        return this.getViewId().getContextId();
    }

    protected final void recreateElementInteractor() {
        this.m_elementInteractor = new ElementInteractor(this, this.getDisabledGestures());
    }

    protected void destroyViewContent() {
        EnumSet<EventCategory> disabledEventCategories;
        if (HelpAdapter.getHelpAdapter() != null) {
            HelpAdapter.getHelpAdapter().unregister(this);
        }
        if (!(disabledEventCategories = this.getDisabledEventCategories()).contains((Object)EventCategory.INSTALLATION)) {
            EventManager.getInstance().detach(InstallationModifiedEvent.class, (Object)this);
            EventManager.getInstance().detach(ConfigurationModifiedEvent.class, (Object)this);
            EventManager.getInstance().detach(SearchPathModifiedEvent.class, (Object)this);
        }
        if (!disabledEventCategories.contains((Object)EventCategory.SOFTWARE_SYSTEM)) {
            EventManager.getInstance().detach(SoftwareSystemOpenedEvent.class, (Object)this);
            EventManager.getInstance().detach(SoftwareSystemModifiedEvent.class, (Object)this);
            EventManager.getInstance().detach(AnalyzerModificationEvent.class, (Object)this);
            EventManager.getInstance().detach(SoftwareSystemClosedEvent.class, (Object)this);
        }
        if (WorkbenchRegistry.isRunning()) {
            WorkbenchRegistry.getInstance().viewClosed(this);
        }
        Shell[] shellArray = WorkbenchRegistry.getInstance().getDisplay().getShells();
        int n = shellArray.length;
        int n2 = 0;
        while (n2 < n) {
            Shell nextShell = shellArray[n2];
            Object dndManager = nextShell.getData("DnDManager");
            if (dndManager != null) {
                nextShell.setData("DnDManager", null);
            }
            ++n2;
        }
        this.m_viewContentArea = null;
        this.m_eclipseContext = null;
        this.m_partService = null;
        this.m_part = null;
        this.m_initialPartName = null;
        this.m_selectionProviderAdapter = null;
        this.m_textSearchData = null;
        this.m_elementInteractor = null;
        this.m_secondaryId = null;
        this.m_isAsleep = null;
        LOGGER.debug("[" + String.valueOf(this.getViewId()) + "] Destroyed");
    }

    @Override
    public final boolean isActive() {
        return this.m_part != null && this.m_viewContentArea != null && !this.m_viewContentArea.isDisposed() && WorkbenchRegistry.isRunning();
    }

    @Override
    public final Composite getContentArea() {
        assert (this.isActive()) : "Not active: " + String.valueOf(this.getViewId());
        return this.m_viewContentArea;
    }

    @Override
    public final Shell getShell() {
        return this.isActive() ? this.m_viewContentArea.getShell() : null;
    }

    protected final boolean canHandleEvent(SoftwareSystemProviderEvent event) {
        assert (event != null) : "Parameter 'event' of method 'canDispatchEvent' must not be null";
        return this.isActive() && event.getProvider() == this.getSoftwareSystemProvider();
    }

    @Override
    public final void startDraggingView() {
        LOGGER.debug("[" + String.valueOf(this.getViewId()) + "] Start dragging");
        assert (!this.m_dragging) : "Already dragging: " + String.valueOf(this.getViewId());
        this.m_dragging = true;
    }

    @Override
    public final void stopDraggingView() {
        LOGGER.debug("[" + String.valueOf(this.getViewId()) + "] Stop dragging");
        assert (this.m_dragging) : "Not dragging: " + String.valueOf(this.getViewId());
        this.m_dragging = false;
        LOGGER.debug("[" + String.valueOf(this.getViewId()) + "] Re-select after dragging");
        WorkbenchRegistry.getInstance().selectView(this);
    }

    public final void handleEvent(Event event) {
        assert (event != null) : "Parameter 'event' of method 'handleEvent' must not be null";
        if (this.m_isAsleep == null || this.isActive()) {
            assert (this.supportsSleep()) : "Does not support sleep: " + String.valueOf(this.getViewId());
            LOGGER.debug("[" + String.valueOf(this.getViewId()) + "] Handle show/hide event");
            if (this.m_dragging) {
                switch (event.type) {
                    case 22: {
                        LOGGER.debug("[" + String.valueOf(this.getViewId()) + "] Ignore 'Shown' during 'Dragging'");
                        break;
                    }
                    case 23: {
                        LOGGER.debug("[" + String.valueOf(this.getViewId()) + "] Ignore 'Hidden' during 'Dragging'");
                    }
                }
            } else {
                switch (event.type) {
                    case 22: {
                        LOGGER.debug("[" + String.valueOf(this.getViewId()) + "] Show");
                        if (this.m_isAsleep == null) {
                            this.m_isAsleep = Boolean.FALSE;
                            if (!this.supportsSleep()) break;
                            LOGGER.debug("[" + String.valueOf(this.getViewId()) + "] Initialized => " + String.valueOf(IRegistrantRequestPerformed.RegistrantState.AWAKE));
                            break;
                        }
                        if (!this.m_isAsleep.booleanValue()) {
                            LOGGER.warn("[" + String.valueOf(this.getViewId()) + "] Already awake");
                            break;
                        }
                        EventManager.getInstance().wakeUp((Object)this, new IRegistrantRequestPerformed(){

                            public void performed(IRegistrantRequestPerformed.RegistrantState state) {
                                if (!$assertionsDisabled && state == null) {
                                    throw new AssertionError((Object)"Parameter 'state' of method 'performed' must not be null");
                                }
                                if (WorkbenchView.this.getSoftwareSystem() != null) {
                                    WorkbenchView.this.handleSoftwareSystemShow(ShowMode.AWAKE);
                                }
                                WorkbenchView.this.m_isAsleep = Boolean.FALSE;
                                LOGGER.debug("[" + String.valueOf(WorkbenchView.this.getViewId()) + "] State changed => " + String.valueOf(state));
                            }
                        });
                        break;
                    }
                    case 23: {
                        LOGGER.debug("[" + String.valueOf(this.getViewId()) + "] Hide");
                        if (this.m_isAsleep == null) {
                            LOGGER.debug("[" + String.valueOf(this.getViewId()) + "] Not yet initialized -> ignore");
                            break;
                        }
                        if (this.m_isAsleep.booleanValue()) {
                            LOGGER.warn("[" + String.valueOf(this.getViewId()) + "] Already asleep");
                            break;
                        }
                        if (this.m_part == null) break;
                        EventManager.getInstance().putToSleep((Object)this, new IRegistrantRequestPerformed(){

                            public void performed(IRegistrantRequestPerformed.RegistrantState state) {
                                if (!$assertionsDisabled && state == null) {
                                    throw new AssertionError((Object)"Parameter 'state' of method 'performed' must not be null");
                                }
                                if (WorkbenchView.this.getSoftwareSystem() != null) {
                                    WorkbenchView.this.handleSoftwareSystemHide(HideMode.ASLEEP);
                                }
                                WorkbenchView.this.m_isAsleep = Boolean.TRUE;
                                LOGGER.debug("[" + String.valueOf(WorkbenchView.this.getViewId()) + "] State changed => " + String.valueOf(state));
                            }
                        });
                    }
                }
            }
            LOGGER.debug("[" + String.valueOf(this.getViewId()) + "] Handle show/hide event - done");
        }
    }

    protected final void hideView() {
        if (this.m_part != null) {
            try {
                MPart part = this.m_part;
                this.m_part = null;
                this.m_partService.hidePart(part);
            }
            catch (Throwable throwable) {}
        }
    }

    protected void performRestoreNavigationState(NavigationState state, boolean viewCreated) {
        assert (state != null) : "Parameter 'state' of method 'performRestoreNavigationState' must not be null";
        assert (this.supportsNavigation()) : "Navigation not supported";
    }

    @Override
    public final void restoreNavigationState(NavigationState state, boolean viewCreated) {
        LOGGER.debug("[" + String.valueOf(this.getViewId()) + "] Restore navigation state");
        this.m_inRestoreState = true;
        if (this.m_isAsleep != null) {
            if (this.m_isAsleep.booleanValue()) {
                LOGGER.debug("[" + String.valueOf(this.getViewId()) + "] 'Activate' to awake view, make visible and focus");
                this.m_partService.showPart(this.m_part, EPartService.PartState.ACTIVATE);
            } else {
                LOGGER.debug("[" + String.valueOf(this.getViewId()) + "] 'Activate' to make view visible and focus");
                this.m_partService.showPart(this.m_part, EPartService.PartState.ACTIVATE);
            }
            LOGGER.debug("[" + String.valueOf(this.getViewId()) + "] Perform restore navigation state");
            this.performRestoreNavigationState(state, viewCreated);
            LOGGER.debug("[" + String.valueOf(this.getViewId()) + "] Select view");
            WorkbenchRegistry.getInstance().selectView(this);
        } else {
            LOGGER.warn("[" + String.valueOf(this.getViewId()) + "] Not yet initialized 'm_isAsleep'");
        }
        this.m_inRestoreState = false;
        LOGGER.debug("[" + String.valueOf(this.getViewId()) + "] Restore navigation state - done");
    }

    protected void componentSelected(Control component) {
        assert (component != null) : "Parameter 'component' of method 'differentComponentSelected' must not be null";
    }

    protected void performViewSelected(IWorkbenchView view) {
    }

    @Override
    public final void viewSelected(IWorkbenchView view, Control component, boolean differentViewSelected) {
        if (this.isActive() && !this.isAsleep()) {
            if (this == view && (component != null || differentViewSelected)) {
                if (!this.m_inRestoreState) {
                    if (component != null) {
                        this.componentSelected(component);
                    }
                    if (this.supportsNavigation() && this.getSoftwareSystem() != null) {
                        NavigationState state = ViewNavigationManager.getInstance().createNavigationState(this.getViewId(), this.getSecondaryId(), NavigationState.Type.VIEW_SELECTED);
                        this.completeViewNavigationState(state);
                        ViewNavigationManager.getInstance().addNavigationState(state);
                    }
                }
                this.initializeTextSearchData();
                this.m_selectionProviderAdapter.handleSelectionChanged(this.getSelectedElements());
            }
            this.performViewSelected(view);
        }
    }

    protected void performViewSelectionChanged(IWorkbenchView view, List<Element> elements) {
        assert (elements != null) : "Parameter 'elements' of method 'viewSelectionChanged' must not be null";
    }

    @Override
    public final void viewSelectionChanged(IWorkbenchView view, List<Element> elements) {
        assert (elements != null) : "Parameter 'elements' of method 'viewSelectionChanged' must not be null";
        LOGGER.trace("[" + String.valueOf(this.getViewId()) + "] View/elements selection changed: " + String.valueOf(view != null ? view.getViewId() : "<no view>") + " " + elements.size() + " element(s)");
        this.performViewSelectionChanged(view, elements);
        LOGGER.trace("[" + String.valueOf(this.getViewId()) + "] View/elements selection changed: " + String.valueOf(view != null ? view.getViewId() : "<no view>") + " " + elements.size() + " element(s) - done");
    }

    protected void performViewClosed(IWorkbenchView view) {
        assert (view != null) : "Parameter 'view' of method 'performViewClosed' must not be null";
    }

    @Override
    public final void viewClosed(IWorkbenchView view) {
        assert (view != null) : "Parameter 'view' of method 'viewClosed' must not be null";
        LOGGER.debug("[" + String.valueOf(this.getViewId()) + "] View closed: " + String.valueOf(view.getViewId()));
        this.performViewClosed(view);
        LOGGER.debug("[" + String.valueOf(this.getViewId()) + "] View closed: " + String.valueOf(view.getViewId()) + " - done");
    }

    private void postUpdate(List<Element> selectedPre) {
        List<Element> selectedPost;
        assert (this.isActive()) : "Not active: " + String.valueOf(this.getViewId());
        if (selectedPre != null && !selectedPre.equals(selectedPost = this.getSelectedElements())) {
            this.m_selectionProviderAdapter.handleSelectionChanged(selectedPost == null ? Collections.emptyList() : selectedPost);
        }
    }

    private void handleInstallationEvent(InstallationEvent event) {
        if (this.canHandleEvent((SoftwareSystemProviderEvent)event)) {
            this.m_elementInteractor.disable();
            List<Element> selectedElements = this.getSelectedElements();
            this.installationModified();
            if (this.isActive()) {
                this.postUpdate(selectedElements);
                this.m_elementInteractor.enable();
            }
        }
    }

    private void handleSoftwareSystemOpenedEvent(SoftwareSystemOpenedEvent event) {
        if (this.canHandleEvent((SoftwareSystemProviderEvent)event)) {
            this.m_elementInteractor.disable();
            List<Element> selectedElements = this.getSelectedElements();
            this.handleSoftwareSystemShow(ShowMode.OPEN);
            if (this.isActive()) {
                this.postUpdate(selectedElements);
                this.m_elementInteractor.enable();
            }
        }
    }

    private void handleSoftwareSystemModifiedEvent(SoftwareSystemModifiedEvent event) {
        SoftwareSystem softwareSystem;
        ISoftwareSystemProvider provider;
        if (this.canHandleEvent((SoftwareSystemProviderEvent)event) && (provider = event.getProvider()).hasSoftwareSystem() && (softwareSystem = provider.getSoftwareSystem()).isValid()) {
            this.m_elementInteractor.disable();
            List<Element> selectedElements = this.getSelectedElements();
            LOGGER.trace("[" + String.valueOf(this.getViewId()) + "] Perform 'softwareSystemModified()'");
            this.softwareSystemModified(event.getModification(), event.restoredFromHistory());
            if (this.isActive()) {
                this.postUpdate(selectedElements);
                this.m_elementInteractor.enable();
            }
            LOGGER.trace("[" + String.valueOf(this.getViewId()) + "] Perform 'softwareSystemModified()' - done");
        }
    }

    private void handleAnalyzerModificationEvent(AnalyzerModificationEvent event) {
        ISoftwareSystemProvider provider;
        assert (event != null) : "Parameter 'event' of method 'handleAnalyzerModificationEvent' must not be null";
        if (this.canHandleEvent((SoftwareSystemProviderEvent)event) && (provider = event.getProvider()).hasSoftwareSystem()) {
            SoftwareSystem softwareSystem = provider.getSoftwareSystem();
            if (softwareSystem.isValid()) {
                this.m_elementInteractor.disable();
                List<Element> selectedElements = this.getSelectedElements();
                LOGGER.trace("[" + String.valueOf(this.getViewId()) + "] Perform 'analyzerModification()'");
                this.analyzerModification(event.getModification(), event.getAnalyzerId());
                LOGGER.trace("[" + String.valueOf(this.getViewId()) + "] Perform 'analyzerModification()' - done");
                if (this.isActive()) {
                    this.postUpdate(selectedElements);
                    this.m_elementInteractor.enable();
                }
            } else {
                LOGGER.warn("System already invalid '" + softwareSystem.getName() + "': " + String.valueOf(this.getViewId()));
            }
        }
    }

    private void handleSoftwareSystemClosedEvent(SoftwareSystemClosedEvent event) {
        assert (event != null) : "Parameter 'event' of method 'handleSoftwareSystemClosedEvent' must not be null";
        if (this.canHandleEvent((SoftwareSystemProviderEvent)event)) {
            this.m_selectionProviderAdapter.handleSelectionChanged();
            this.m_elementInteractor.disable();
            this.handleSoftwareSystemHide(HideMode.CLOSE);
            if (this.isActive()) {
                this.m_elementInteractor.enable();
            }
        }
    }

    protected final ISoftwareSystemProvider getSoftwareSystemProvider() {
        return WorkbenchRegistry.getInstance().getProvider();
    }

    protected final IElementResolver getElementResolver() {
        return WorkbenchRegistry.getInstance().getProvider().getElementResolver();
    }

    public final Installation getInstallation() {
        return WorkbenchRegistry.getInstance().getInstallation();
    }

    @Override
    public IContext getContext() {
        return this.getSoftwareSystemProvider().getDefaultContext();
    }

    protected final SoftwareSystem getSoftwareSystem() {
        return WorkbenchRegistry.getInstance().getSoftwareSystem();
    }

    protected void installationModified() {
    }

    protected void softwareSystemShow(ShowMode mode) {
        assert (mode != null) : "Parameter 'mode' of method 'softwareSystemShow' must not be null";
    }

    private void handleSoftwareSystemShow(ShowMode mode) {
        assert (mode != null) : "Parameter 'mode' of method 'handleSoftwareSystemShow' must not be null";
        LOGGER.debug("[" + String.valueOf(this.getViewId()) + "] Perform software system show [" + String.valueOf((Object)mode) + "]");
        this.softwareSystemShow(mode);
        switch (mode) {
            case OPEN: {
                IWorkbenchView workbenchView;
                if (!this.supportsNavigation() || (workbenchView = WorkbenchRegistry.getInstance().getCurrentlySelectedView()) != this) break;
                NavigationState state = ViewNavigationManager.getInstance().createNavigationState(this.getViewId(), this.getSecondaryId(), NavigationState.Type.VIEW_SELECTED);
                this.completeViewNavigationState(state);
                ViewNavigationManager.getInstance().addNavigationState(state);
                break;
            }
            case AWAKE: {
                assert (this.supportsSleep()) : "[" + String.valueOf(this.getViewId()) + "] does not support sleep";
                this.m_selectionProviderAdapter.handleSelectionChanged(this.getSelectedElements());
                break;
            }
            default: {
                assert (false) : "Unhandled mode: " + String.valueOf((Object)mode);
                break;
            }
        }
        LOGGER.debug("[" + String.valueOf(this.getViewId()) + "] Perform software system show [" + String.valueOf((Object)mode) + "] - done");
    }

    protected void softwareSystemHide(HideMode mode) {
        assert (mode != null) : "Parameter 'mode' of method 'softwareSystemHide' must not be null";
    }

    private void handleSoftwareSystemHide(HideMode mode) {
        assert (mode != null) : "Parameter 'mode' of method 'handleSoftwareSystemHide' must not be null";
        LOGGER.debug("[" + String.valueOf(this.getViewId()) + "] Perform software system hide [" + String.valueOf((Object)mode) + "]");
        this.softwareSystemHide(mode);
        switch (mode) {
            case CLOSE: {
                break;
            }
            case ASLEEP: {
                assert (this.supportsSleep()) : "[" + String.valueOf(this.getViewId()) + "] does not support sleep";
                break;
            }
            default: {
                assert (false) : "Unhandled mode: " + String.valueOf((Object)mode);
                break;
            }
        }
        LOGGER.debug("[" + String.valueOf(this.getViewId()) + "] Perform software system hide [" + String.valueOf((Object)mode) + "] - done");
    }

    public final boolean ignoreModification(EnumSet<Modification> modifications, EnumSet<Modification> ignore) {
        assert (modifications != null) : "Parameter 'modifications' of method 'ignoreModification' must not be null";
        assert (ignore != null) : "Parameter 'ignore' of method 'ignoreModification' must not be null";
        if (modifications.isEmpty() || ignore.isEmpty()) {
            return false;
        }
        if (modifications.size() > ignore.size()) {
            return false;
        }
        for (Modification nextModification : modifications) {
            if (ignore.contains(nextModification)) continue;
            return false;
        }
        return true;
    }

    protected void softwareSystemModified(EnumSet<Modification> modification, boolean restoredFromHistory) {
        assert (modification != null) : "Parameter 'modification' of method 'softwareSystemModified' must not be null";
    }

    protected void analyzerModification(EnumSet<AnalyzerModificationEvent.AnalyzerModification> modification, IAnalyzerId analyzerId) {
        assert (modification != null) : "Parameter 'modification' of method 'analyzerModification' must not be null";
    }

    protected void completeViewNavigationState(NavigationState state) {
        assert (state != null) : "Parameter 'state' of method 'completeViewNavigationState' must not be null";
    }

    @Override
    public final void setSecondaryId(String secondaryId) {
        this.m_secondaryId = secondaryId;
    }

    @Override
    public final String getSecondaryId() {
        return this.m_secondaryId;
    }

    protected void searchElementsRequested() {
    }

    @Override
    public final void searchRequested(Search search) {
        assert (search != null) : "Parameter 'search' of method 'searchRequested' must not be null";
        switch (search) {
            case FIND_TEXT: 
            case FIND_REPLACE_TEXT: {
                ITextSearchHandler handler = this.getTextSearchHandler();
                assert (handler != null) : "'handler' of method 'textSearchRequested' must not be null";
                this.m_textSearchData = TextSearchDialog.show(this.getTextSearchHandler(), WorkbenchRegistry.getInstance().getMainApplicationWindowShell());
                break;
            }
            case FIND_ELEMENTS: {
                this.searchElementsRequested();
                break;
            }
            case NONE: {
                assert (false) : "Search not possible: " + String.valueOf((Object)search);
                break;
            }
            default: {
                assert (false) : "Unhandled search: " + String.valueOf((Object)search);
                break;
            }
        }
    }

    @Override
    public final boolean isRevealNextInSearchPossible() {
        return this.m_textSearchData != null && this.m_textSearchData.isFindPossible();
    }

    @Override
    public final void revealNextInSearch() {
        if (this.m_textSearchData != null && this.m_textSearchData.isFindPossible()) {
            ITextSearchHandler handler = this.getTextSearchHandler();
            assert (handler != null) : "'provider' of method 'revealNextOccurrence' must not be null";
            if (handler.needsNewFindInfo()) {
                TextSearchData newTextSearchData = handler.getTextSearchData();
                newTextSearchData.setSearchText(this.m_textSearchData.getSearchText());
                if (handler.supportsReplace()) {
                    newTextSearchData.setReplaceText(this.m_textSearchData.getReplaceText());
                }
                newTextSearchData.setCaseSensitive(this.m_textSearchData.isCaseSensitive());
                newTextSearchData.setWholeWord(this.m_textSearchData.isWholeWord());
                this.m_textSearchData = newTextSearchData;
                handler.notRequestNewFindInfo();
            }
            TextSearchDialog.revealNextOccurrence(handler, this.m_textSearchData);
        }
    }

    protected ITextSearchHandler getTextSearchHandler() {
        return null;
    }

    protected final void initializeTextSearchData() {
        Search search = this.supportsSearch();
        if (search.equals((Object)Search.FIND_TEXT) || search.equals((Object)Search.FIND_REPLACE_TEXT)) {
            ITextSearchHandler handler = this.getTextSearchHandler();
            assert (handler != null) : "'handler' of method 'initializeTextSearchData' must not be null";
            TextSearchData textSearchData = TextSearchDialog.connectIfPossible(handler, this.m_textSearchData);
            if (textSearchData != null) {
                this.m_textSearchData = textSearchData;
            }
        }
    }

    protected final void setPartName(String partName) {
        assert (partName != null && partName.length() > 0) : "Parameter 'partName' of method 'setPartName' must not be empty";
        if (this.m_part != null) {
            this.m_part.setLabel(partName);
        } else {
            LOGGER.warn("'m_part' already null for: " + String.valueOf(this.getViewId()));
        }
    }

    protected final void resetPartName() {
        if (this.m_part != null) {
            this.m_part.setLabel(this.m_initialPartName);
        } else {
            LOGGER.warn("'m_part' already null for: " + String.valueOf(this.getViewId()));
        }
    }

    protected final void setTitleTooltip(String tooltip) {
        if (this.m_part != null) {
            this.m_part.setTooltip(tooltip);
        } else {
            LOGGER.warn("'m_part' already null for: " + String.valueOf(this.getViewId()));
        }
    }

    public String toString() {
        return this.getPresentationName();
    }

    protected static enum EventCategory {
        INSTALLATION,
        SOFTWARE_SYSTEM;

    }

    protected static enum HideMode {
        CLOSE,
        ASLEEP;

    }

    protected static enum ShowMode {
        OPEN,
        AWAKE;

    }
}

