/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.base.workbench;

import com.hello2morrow.sonargraph.core.command.common.CommandRegistry;
import com.hello2morrow.sonargraph.core.command.common.SonargraphLicenseHandler;
import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.model.common.AnalyzerExecutionLevel;
import com.hello2morrow.sonargraph.core.model.element.IElementResolver;
import com.hello2morrow.sonargraph.core.model.element.INavigationState;
import com.hello2morrow.sonargraph.core.model.event.AnalyzersFinishedEvent;
import com.hello2morrow.sonargraph.core.model.event.AnalyzersStartedEvent;
import com.hello2morrow.sonargraph.core.model.event.ConfigurationModifiedEvent;
import com.hello2morrow.sonargraph.core.model.event.ExportFinishedEvent;
import com.hello2morrow.sonargraph.core.model.event.ExportStartedEvent;
import com.hello2morrow.sonargraph.core.model.event.ModifiableFileCreatedEvent;
import com.hello2morrow.sonargraph.core.model.event.ModifiableFileDeletedEvent;
import com.hello2morrow.sonargraph.core.model.event.Modification;
import com.hello2morrow.sonargraph.core.model.event.MultipleModifiableFileModifiedEvent;
import com.hello2morrow.sonargraph.core.model.event.RemoteSelectionRequestEvent;
import com.hello2morrow.sonargraph.core.model.event.RemoteSelectionServerStatusEvent;
import com.hello2morrow.sonargraph.core.model.event.SearchPathModifiedEvent;
import com.hello2morrow.sonargraph.core.model.event.SnapshotSavedEvent;
import com.hello2morrow.sonargraph.core.model.event.SoftwareSystemClosedEvent;
import com.hello2morrow.sonargraph.core.model.event.SoftwareSystemModifiedEvent;
import com.hello2morrow.sonargraph.core.model.event.SoftwareSystemOpenedEvent;
import com.hello2morrow.sonargraph.core.model.event.UndoRedoAvailabilityEvent;
import com.hello2morrow.sonargraph.core.model.path.IModifiableFile;
import com.hello2morrow.sonargraph.core.model.path.IQualityModelImportExportProvider;
import com.hello2morrow.sonargraph.core.model.system.IFiles;
import com.hello2morrow.sonargraph.core.model.system.INamedElementResolver;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.Installation;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystemMode;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystemState;
import com.hello2morrow.sonargraph.foundation.common.SwtResourceProviderAdapter;
import com.hello2morrow.sonargraph.foundation.event.EventHandler;
import com.hello2morrow.sonargraph.foundation.event.EventManager;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.foundation.file.PersistentRecentlyUsedList;
import com.hello2morrow.sonargraph.foundation.utilities.CategoryProvider;
import com.hello2morrow.sonargraph.foundation.utilities.ExceptionUtility;
import com.hello2morrow.sonargraph.ui.swt.base.PreferencesUtility;
import com.hello2morrow.sonargraph.ui.swt.base.view.IContextMenuContributor;
import com.hello2morrow.sonargraph.ui.swt.base.view.IViewBasedContentFilter;
import com.hello2morrow.sonargraph.ui.swt.base.view.IViewCategoryProvider;
import com.hello2morrow.sonargraph.ui.swt.base.view.IWorkbenchView;
import com.hello2morrow.sonargraph.ui.swt.base.view.RcpUtility;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.ContextMenuContributionInfo;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.ViewAccessor;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.ViewEventListener;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchState;
import com.hello2morrow.sonargraph.ui.swt.common.IImportantInformationDetector;
import com.hello2morrow.sonargraph.ui.swt.common.IViewContentExclusionFilter;
import com.hello2morrow.sonargraph.ui.swt.common.IViewId;
import com.hello2morrow.sonargraph.ui.swt.common.NavigationState;
import com.hello2morrow.sonargraph.ui.swt.common.ViewNavigationManager;
import de.schlichtherle.truezip.file.TFile;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuItem;
import org.eclipse.e4.ui.workbench.IWorkbench;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WorkbenchRegistry
implements ViewEventListener.IViewSelectionListener {
    public static final String IMPORTANT_INFORMATION_MARK = "(!)";
    public static final String INFORMATION_HAS_CHANGED_MARK = "(*)";
    private static final Logger LOGGER = LoggerFactory.getLogger(WorkbenchRegistry.class);
    private static WorkbenchRegistry s_instance;
    private final Set<IViewId> m_availableViewIds = new LinkedHashSet<IViewId>();
    private final Map<IViewId, List<IViewContentExclusionFilter>> m_viewIdToContentFilters = new THashMap();
    private final Map<IViewId, List<CategoryProvider>> m_viewIdToCategoryProviders = new THashMap();
    private final Map<String, ContextMenuContributionInfo> m_commandIdToContributionInfo = new THashMap();
    private final Map<String, String> m_viewIdToInitialLabel = new THashMap();
    private final ViewAccessor m_viewAccessor;
    private final MWindow m_mainApplicationWindow;
    private final EnumSet<WorkbenchState> m_state = EnumSet.noneOf(WorkbenchState.class);
    private final Set<Language> m_usedLanguages = new THashSet();
    private final ILinkSelectionListener m_linkSelectionListener;
    private final ISoftwareSystemProvider m_provider;
    private final Mode m_mode;
    private boolean m_workbenchIsRunning;
    private boolean m_isExporting;
    private boolean m_areAnalyzersRunning;

    private static void updateVisibilityOfViews(IEclipseContext eclipseContext, Set<Language> usedLanguages, Set<IViewId> availableViewIds) {
        assert (eclipseContext != null) : "Parameter 'eclipseContext' of method 'updateVisibilityOfViews' must not be null";
        assert (usedLanguages != null) : "Parameter 'usedLanguages' of method 'updateVisibilityOfViews' must not be null";
        assert (availableViewIds != null) : "Parameter 'availableViewIds' of method 'updateVisibilityOfViews' must not be null";
        if (usedLanguages.isEmpty()) {
            for (IViewId next : availableViewIds) {
                MPart part;
                if (!next.hasProperty(IViewId.Property.IS_MASTER_VIEW) || (part = RcpUtility.findPart(eclipseContext, next, null)) == null) continue;
                part.setVisible(next.isAvailableForLanguage(null));
            }
        } else {
            for (IViewId next : availableViewIds) {
                if (!next.hasProperty(IViewId.Property.IS_MASTER_VIEW)) continue;
                boolean nextSupportsLanguage = false;
                for (Language nextUsedLanguage : usedLanguages) {
                    if (!next.isAvailableForLanguage(nextUsedLanguage)) continue;
                    nextSupportsLanguage = true;
                    break;
                }
                MPart part = RcpUtility.findPart(eclipseContext, next, null);
                if (part == null) continue;
                part.setVisible(nextSupportsLanguage);
            }
        }
    }

    private WorkbenchRegistry(final IEclipseContext eclipseContext, IEventBroker eventBroker, Display display, MWindow mainApplicationWindow, ISoftwareSystemProvider provider, final Set<IViewId> availableViewIds, ILinkSelectionListener linkSelectionListener, List<IViewBasedContentFilter> viewContentFilters, List<IViewCategoryProvider> viewCategoryProviders, Mode mode) {
        assert (eclipseContext != null) : "Parameter 'eclipseContext' of method 'WorkbenchRegistry' must not be null";
        assert (eventBroker != null) : "Parameter 'eventBroker' of method 'WorkbenchRegistry' must not be null";
        assert (display != null) : "Parameter 'display' of method 'WorkbenchRegistry' must not be null";
        assert (mainApplicationWindow != null) : "Parameter 'mainApplicationWindow' of method 'WorkbenchRegistry' must not be null";
        assert (provider != null) : "Parameter 'provider' of method 'WorkbenchRegistry' must not be null";
        assert (availableViewIds != null) : "Parameter 'availableViewIds' of method 'WorkbenchRegistry' must not be null";
        assert (linkSelectionListener != null) : "Parameter 'linkSelectionListener' of method 'WorkbenchRegistry' must not be null";
        assert (viewContentFilters != null) : "Parameter 'viewContentFilters' of method 'WorkbenchRegistry' must not be null";
        assert (mode != null) : "Parameter 'mode' of method 'WorkbenchRegistry' must not be null";
        this.m_viewAccessor = new ViewAccessor(eclipseContext, eventBroker, display);
        this.m_mainApplicationWindow = mainApplicationWindow;
        this.m_provider = provider;
        this.m_mode = mode;
        this.m_availableViewIds.addAll(availableViewIds);
        for (IViewId nextViewId : this.m_availableViewIds) {
            IImportantInformationDetector nextDetector = nextViewId.getImportantInformationDetector();
            if (nextDetector == null) continue;
            assert (!nextViewId.hasProperty(IViewId.Property.ALLOWS_MULTIPLE_INSTANCES)) : "Important information detector not supported for views allowing multiple instances: " + String.valueOf(nextViewId);
            MPart nextCorrespondingViewPart = RcpUtility.findUniqueModelElement(eclipseContext, (MUIElement)this.m_mainApplicationWindow, nextViewId.getId(), MPart.class);
            assert (nextCorrespondingViewPart != null) : "Parameter 'nextCorrespondingViewPart' of method 'WorkbenchRegistry' must not be null";
            this.m_viewIdToInitialLabel.put(nextViewId.getId(), nextCorrespondingViewPart.getLabel());
        }
        for (IViewBasedContentFilter nextContentFilter : viewContentFilters) {
            List<IViewContentExclusionFilter> contentFilter = this.m_viewIdToContentFilters.get(nextContentFilter.getViewId());
            if (contentFilter == null) {
                contentFilter = new ArrayList<IViewContentExclusionFilter>();
                this.m_viewIdToContentFilters.put(nextContentFilter.getViewId(), contentFilter);
            }
            assert (!contentFilter.contains(nextContentFilter)) : "'filter' of method 'WorkbenchRegistry' already added";
            contentFilter.add(nextContentFilter);
        }
        for (IViewCategoryProvider nextCategoryProvider : viewCategoryProviders) {
            List<CategoryProvider> categoryProviders = this.m_viewIdToCategoryProviders.get(nextCategoryProvider.getViewId());
            if (categoryProviders == null) {
                categoryProviders = new ArrayList<CategoryProvider>();
                this.m_viewIdToCategoryProviders.put(nextCategoryProvider.getViewId(), categoryProviders);
            }
            categoryProviders.add(nextCategoryProvider.getCategoryProvider());
        }
        this.m_linkSelectionListener = linkSelectionListener;
        EventManager.getInstance().attach((EventHandler)new EventHandler<SoftwareSystemOpenedEvent>(SoftwareSystemOpenedEvent.class, (Object)this){

            public void handleEvent(SoftwareSystemOpenedEvent event) {
                if (!$assertionsDisabled && event == null) {
                    throw new AssertionError((Object)"Parameter 'event' of method 'handleEvent' must not be null");
                }
                if (!$assertionsDisabled && event.getProvider() != WorkbenchRegistry.this.m_provider) {
                    throw new AssertionError((Object)"provider must not change");
                }
                SoftwareSystem softwareSystem = WorkbenchRegistry.this.getSoftwareSystem();
                if (!$assertionsDisabled && softwareSystem == null) {
                    throw new AssertionError((Object)"'softwareSystem' of method 'handleEvent' must not be null");
                }
                WorkbenchRegistry.this.updateState(WorkbenchState.SOFTWARE_SYSTEM_OPENED, true);
                WorkbenchRegistry.this.updateState(WorkbenchState.SOFTWARE_SYSTEM_NEEDS_REPARSE, softwareSystem.needsReparse());
                WorkbenchRegistry.this.updateState(WorkbenchState.SOFTWARE_SYSTEM_IS_CLEARABLE, softwareSystem.isClearable());
                WorkbenchRegistry.this.updateState(WorkbenchState.VIRTUAL_MODEL_IS_MODIFIABLE, softwareSystem.getCurrentModel().isModifiable());
                WorkbenchRegistry.this.updateState(WorkbenchState.QUALITY_MODEL_DATA_AVAILABLE, ((IQualityModelImportExportProvider)softwareSystem.getExtension(IQualityModelImportExportProvider.class)).isExportPossible());
                WorkbenchRegistry.this.updateState(WorkbenchState.CALCULATING, false);
                WorkbenchRegistry.this.updateState(WorkbenchState.MODIFIABLE_FILE_NEEDS_SAVE, ((IFiles)event.getProvider().getSoftwareSystem().getUniqueExistingChild(IFiles.class)).modifiableFilesNeedSave());
                WorkbenchRegistry.this.checkExportAvailability();
                WorkbenchRegistry.this.m_usedLanguages.addAll(softwareSystem.getUsedLanguages());
                WorkbenchRegistry.updateVisibilityOfViews(eclipseContext, WorkbenchRegistry.this.m_usedLanguages, availableViewIds);
                WorkbenchRegistry.this.handleUpdate();
                WorkbenchRegistry.this.updateRecentlyUsedList(softwareSystem, true);
            }
        });
        EventManager.getInstance().attach((EventHandler)new EventHandler<SoftwareSystemModifiedEvent>(SoftwareSystemModifiedEvent.class, (Object)this){

            public void handleEvent(SoftwareSystemModifiedEvent event) {
                if (!$assertionsDisabled && event == null) {
                    throw new AssertionError((Object)"Parameter 'event' of method 'handleEvent' must not be null");
                }
                SoftwareSystem softwareSystem = WorkbenchRegistry.this.getSoftwareSystem();
                if (!$assertionsDisabled && softwareSystem == null) {
                    throw new AssertionError((Object)"'softwareSystem' of method 'handleEvent' must not be null");
                }
                WorkbenchRegistry.this.updateState(WorkbenchState.SOFTWARE_SYSTEM_NEEDS_REPARSE, softwareSystem.needsReparse());
                WorkbenchRegistry.this.updateState(WorkbenchState.SOFTWARE_SYSTEM_IS_CLEARABLE, softwareSystem.isClearable());
                WorkbenchRegistry.this.updateState(WorkbenchState.VIRTUAL_MODEL_IS_MODIFIABLE, softwareSystem.getCurrentModel().isModifiable());
                if (event.getModification().contains(Modification.AVAILABLE_LANGUAGES_MODIFIED)) {
                    WorkbenchRegistry.this.m_usedLanguages.clear();
                    WorkbenchRegistry.this.m_usedLanguages.addAll(softwareSystem.getUsedLanguages());
                    WorkbenchRegistry.updateVisibilityOfViews(eclipseContext, WorkbenchRegistry.this.m_usedLanguages, availableViewIds);
                }
                WorkbenchRegistry.this.handleUpdate();
                if (softwareSystem.getMode() != SoftwareSystemMode.SYSTEM_LOADED_FROM_SNAPSHOT && event.getModification().contains(Modification.SYSTEM_LOCATION_CHANGED)) {
                    WorkbenchRegistry.this.updateRecentlyUsedList(softwareSystem, false);
                }
            }
        });
        EventManager.getInstance().attach((EventHandler)new EventHandler<SoftwareSystemClosedEvent>(SoftwareSystemClosedEvent.class, (Object)this){

            public void handleEvent(SoftwareSystemClosedEvent event) {
                if (!$assertionsDisabled && event == null) {
                    throw new AssertionError((Object)"Parameter 'event' of method 'handleEvent' must not be null");
                }
                boolean exportPossible = WorkbenchRegistry.this.m_state.contains((Object)WorkbenchState.EXPORT_NOT_BLOCKED);
                WorkbenchRegistry.this.m_state.clear();
                if (exportPossible) {
                    WorkbenchRegistry.this.m_state.add(WorkbenchState.EXPORT_NOT_BLOCKED);
                }
                WorkbenchRegistry.this.m_usedLanguages.clear();
                WorkbenchRegistry.updateVisibilityOfViews(eclipseContext, WorkbenchRegistry.this.m_usedLanguages, availableViewIds);
                ViewNavigationManager.getInstance().clear();
                WorkbenchRegistry.this.handleUpdate();
            }
        });
        EventManager.getInstance().attach((EventHandler)new EventHandler<SnapshotSavedEvent>(SnapshotSavedEvent.class, (Object)this){

            public void handleEvent(SnapshotSavedEvent event) {
                if (!$assertionsDisabled && event == null) {
                    throw new AssertionError((Object)"'event' must not be null");
                }
                WorkbenchRegistry.this.updateRecentlyUsedList(event.getFullPath(), true);
                WorkbenchRegistry.this.handleUpdate();
            }
        });
        EventManager.getInstance().attach((EventHandler)new EventHandler<ModifiableFileCreatedEvent>(ModifiableFileCreatedEvent.class, (Object)this){

            public void handleEvent(ModifiableFileCreatedEvent event) {
                if (!$assertionsDisabled && event == null) {
                    throw new AssertionError((Object)"Parameter 'event' of method 'handleEvent' must not be null");
                }
                SoftwareSystem softwareSystem = WorkbenchRegistry.this.getSoftwareSystem();
                if (!$assertionsDisabled && softwareSystem == null) {
                    throw new AssertionError((Object)"'softwareSystem' of method 'handleEvent' must not be null");
                }
                WorkbenchRegistry.this.updateState(WorkbenchState.QUALITY_MODEL_DATA_AVAILABLE, ((IQualityModelImportExportProvider)softwareSystem.getExtension(IQualityModelImportExportProvider.class)).isExportPossible());
                WorkbenchRegistry.this.handleUpdate();
            }
        });
        EventManager.getInstance().attach((EventHandler)new EventHandler<MultipleModifiableFileModifiedEvent>(MultipleModifiableFileModifiedEvent.class, (Object)this){

            public void handleEvent(MultipleModifiableFileModifiedEvent event) {
                INavigationState navigationState;
                if (!$assertionsDisabled && event == null) {
                    throw new AssertionError((Object)"Parameter 'event' of method 'handleEvent' must not be null");
                }
                SoftwareSystem softwareSystem = WorkbenchRegistry.this.getSoftwareSystem();
                if (!$assertionsDisabled && softwareSystem == null) {
                    throw new AssertionError((Object)"'softwareSystem' of method 'handleEvent' must not be null");
                }
                WorkbenchRegistry.this.updateState(WorkbenchState.QUALITY_MODEL_DATA_AVAILABLE, ((IQualityModelImportExportProvider)softwareSystem.getExtension(IQualityModelImportExportProvider.class)).isExportPossible());
                WorkbenchRegistry.this.updateState(WorkbenchState.MODIFIABLE_FILE_NEEDS_SAVE, ((IFiles)event.getProvider().getSoftwareSystem().getUniqueExistingChild(IFiles.class)).modifiableFilesNeedSave());
                WorkbenchRegistry.this.handleUpdate();
                if (event.isRestoredFromHistory() && (navigationState = event.getNavigationState()) != null) {
                    if (!$assertionsDisabled && !(navigationState instanceof NavigationState)) {
                        throw new AssertionError((Object)("Unexpected class in method 'handleEvent': " + String.valueOf(navigationState)));
                    }
                    NavigationState state = (NavigationState)navigationState;
                    INamedElementResolver resolver = WorkbenchRegistry.this.m_provider.getElementResolver();
                    MPart part = RcpUtility.findPart(WorkbenchRegistry.this.m_viewAccessor.getEclipseContext(), state.getViewKey().getId(), state.getViewKey().getSecondaryId());
                    IWorkbenchView view = null;
                    if (part != null) {
                        view = RcpUtility.getWorkbenchView(part, IWorkbenchView.class);
                    }
                    if (view != null && !state.isDeadState((IElementResolver)resolver)) {
                        state.setInvolvedInUndoRedoOperation(true);
                        if (!ViewNavigationManager.getInstance().hasNavigationState(state.getId())) {
                            ViewNavigationManager.getInstance().addNavigationState(state);
                        }
                        ViewNavigationManager.getInstance().restoreNavigationState(state);
                        state.setInvolvedInUndoRedoOperation(false);
                    }
                }
            }
        });
        EventManager.getInstance().attach((EventHandler)new EventHandler<ModifiableFileDeletedEvent>(ModifiableFileDeletedEvent.class, (Object)this){

            public void handleEvent(ModifiableFileDeletedEvent event) {
                if (!$assertionsDisabled && event == null) {
                    throw new AssertionError((Object)"Parameter 'event' of method 'handleEvent' must not be null");
                }
                SoftwareSystem softwareSystem = WorkbenchRegistry.this.getSoftwareSystem();
                if (!$assertionsDisabled && softwareSystem == null) {
                    throw new AssertionError((Object)"'softwareSystem' of method 'handleEvent' must not be null");
                }
                WorkbenchRegistry.this.updateState(WorkbenchState.MODIFIABLE_FILE_NEEDS_SAVE, ((IFiles)softwareSystem.getUniqueExistingChild(IFiles.class)).modifiableFilesNeedSave());
                WorkbenchRegistry.this.updateState(WorkbenchState.QUALITY_MODEL_DATA_AVAILABLE, ((IQualityModelImportExportProvider)softwareSystem.getExtension(IQualityModelImportExportProvider.class)).isExportPossible());
                WorkbenchRegistry.this.handleUpdate();
            }
        });
        EventManager.getInstance().attach((EventHandler)new EventHandler<ConfigurationModifiedEvent>(ConfigurationModifiedEvent.class, (Object)this){

            public void handleEvent(ConfigurationModifiedEvent event) {
                WorkbenchRegistry.this.handleUpdate();
            }
        });
        EventManager.getInstance().attach((EventHandler)new EventHandler<SearchPathModifiedEvent>(SearchPathModifiedEvent.class, (Object)this){

            public void handleEvent(SearchPathModifiedEvent event) {
                WorkbenchRegistry.this.handleUpdate();
            }
        });
        EventManager.getInstance().attach((EventHandler)new EventHandler<UndoRedoAvailabilityEvent>(UndoRedoAvailabilityEvent.class, (Object)this){

            public void handleEvent(UndoRedoAvailabilityEvent event) {
                if (!$assertionsDisabled && event == null) {
                    throw new AssertionError((Object)"Parameter 'event' of method 'handleEvent' must not be null");
                }
                WorkbenchRegistry.this.handleUpdate();
            }
        });
        EventManager.getInstance().attach((EventHandler)new EventHandler<ExportStartedEvent>(ExportStartedEvent.class, (Object)this){

            public void handleEvent(ExportStartedEvent event) {
                if (!$assertionsDisabled && event == null) {
                    throw new AssertionError((Object)"Parameter 'event' of method 'handleEvent' must not be null");
                }
                WorkbenchRegistry.this.m_isExporting = true;
                WorkbenchRegistry.this.checkExportAvailability();
                WorkbenchRegistry.this.handleUpdate();
            }
        });
        EventManager.getInstance().attach((EventHandler)new EventHandler<ExportFinishedEvent>(ExportFinishedEvent.class, (Object)this){

            public void handleEvent(ExportFinishedEvent event) {
                if (!$assertionsDisabled && event == null) {
                    throw new AssertionError((Object)"Parameter 'event' of method 'handleEvent' must not be null");
                }
                WorkbenchRegistry.this.m_isExporting = false;
                WorkbenchRegistry.this.checkExportAvailability();
                WorkbenchRegistry.this.handleUpdate();
            }
        });
        EventManager.getInstance().attach((EventHandler)new EventHandler<AnalyzersStartedEvent>(AnalyzersStartedEvent.class, (Object)this){

            public void handleEvent(AnalyzersStartedEvent event) {
                if (!$assertionsDisabled && event == null) {
                    throw new AssertionError((Object)"Parameter 'event' of method 'handleEvent' must not be null");
                }
                WorkbenchRegistry.this.updateState(WorkbenchState.CALCULATING, true);
                WorkbenchRegistry.this.m_areAnalyzersRunning = true;
                WorkbenchRegistry.this.checkExportAvailability();
            }
        });
        EventManager.getInstance().attach((EventHandler)new EventHandler<AnalyzersFinishedEvent>(AnalyzersFinishedEvent.class, (Object)this){

            public void handleEvent(AnalyzersFinishedEvent event) {
                if (!$assertionsDisabled && event == null) {
                    throw new AssertionError((Object)"Parameter 'event' of method 'handleEvent' must not be null");
                }
                WorkbenchRegistry.this.updateState(WorkbenchState.CALCULATING, false);
                WorkbenchRegistry.this.m_areAnalyzersRunning = false;
                WorkbenchRegistry.this.checkExportAvailability();
                WorkbenchRegistry.this.updatePartNames();
            }
        });
        EventManager.getInstance().attach((EventHandler)new EventHandler<RemoteSelectionRequestEvent>(RemoteSelectionRequestEvent.class, (Object)this){

            public void handleEvent(RemoteSelectionRequestEvent event) {
                WorkbenchRegistry.this.handleUpdate();
            }
        });
        EventManager.getInstance().attach((EventHandler)new EventHandler<RemoteSelectionServerStatusEvent>(RemoteSelectionServerStatusEvent.class, (Object)this){

            public void handleEvent(RemoteSelectionServerStatusEvent event) {
                WorkbenchRegistry.this.handleUpdate();
            }
        });
        this.updateState(WorkbenchState.CALCULATING, false);
        this.checkExportAvailability();
        this.updateTitle();
        ViewNavigationManager.createInstance(this.m_viewAccessor);
        new ViewEventListener(this.getDisplay(), this);
    }

    public static boolean hasInstance() {
        return s_instance != null;
    }

    public static void createInstance(IEclipseContext eclipseContext, IEventBroker eventBroker, Display display, MWindow mainApplicationWindow, ISoftwareSystemProvider provider, Set<IViewId> availableViewIds, ILinkSelectionListener linkSelectionListener, List<IViewBasedContentFilter> viewContentFilters, List<IViewCategoryProvider> viewCategoryProviders, Mode mode) {
        assert (!WorkbenchRegistry.hasInstance()) : "Instance already created";
        s_instance = new WorkbenchRegistry(eclipseContext, eventBroker, display, mainApplicationWindow, provider, availableViewIds, linkSelectionListener, viewContentFilters, viewCategoryProviders, mode);
    }

    public static WorkbenchRegistry getInstance() {
        assert (WorkbenchRegistry.hasInstance()) : "Instance not created";
        return s_instance;
    }

    public static void delete() {
        if (s_instance != null) {
            EventManager.getInstance().detach(ModifiableFileDeletedEvent.class, (Object)s_instance);
            EventManager.getInstance().detach(MultipleModifiableFileModifiedEvent.class, (Object)s_instance);
            EventManager.getInstance().detach(ModifiableFileCreatedEvent.class, (Object)s_instance);
            EventManager.getInstance().detach(SoftwareSystemClosedEvent.class, (Object)s_instance);
            EventManager.getInstance().detach(SoftwareSystemModifiedEvent.class, (Object)s_instance);
            EventManager.getInstance().detach(SoftwareSystemOpenedEvent.class, (Object)s_instance);
            EventManager.getInstance().detach(SnapshotSavedEvent.class, (Object)s_instance);
            EventManager.getInstance().detach(ExportStartedEvent.class, (Object)s_instance);
            EventManager.getInstance().detach(ExportFinishedEvent.class, (Object)s_instance);
            EventManager.getInstance().detach(UndoRedoAvailabilityEvent.class, (Object)s_instance);
            EventManager.getInstance().detach(SearchPathModifiedEvent.class, (Object)s_instance);
            EventManager.getInstance().detach(ConfigurationModifiedEvent.class, (Object)s_instance);
            EventManager.getInstance().detach(AnalyzersStartedEvent.class, (Object)s_instance);
            EventManager.getInstance().detach(AnalyzersFinishedEvent.class, (Object)s_instance);
            EventManager.getInstance().detach(RemoteSelectionRequestEvent.class, (Object)s_instance);
            s_instance.resetPartNames();
            ViewNavigationManager.getInstance().delete();
            s_instance = null;
        }
    }

    public static AnalyzerExecutionLevel readAnalyzerExecutionLevel() {
        AnalyzerExecutionLevel level;
        IEclipsePreferences preferences = PreferencesUtility.getPreferences("com.hello2morrow.sonargraph.ui.swt");
        if (preferences != null) {
            String levelFromPreferences = preferences.get(AnalyzerExecutionLevel.class.getName(), AnalyzerExecutionLevel.getDefault().getStandardName());
            try {
                level = AnalyzerExecutionLevel.fromStandardName((String)levelFromPreferences);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                level = AnalyzerExecutionLevel.getDefault();
                LOGGER.warn("Unable to set analyzer execution level: " + levelFromPreferences + " (using default '" + String.valueOf(level) + "')");
            }
        } else {
            level = AnalyzerExecutionLevel.getDefault();
            LOGGER.warn("Unable to retrieve analyzer execution level - preferences not found: com.hello2morrow.sonargraph.ui.swt (using default '" + String.valueOf(level) + "')");
        }
        assert (level != null) : "'level' of method 'readAnalyzerExecutionLevel' must not be null";
        return level;
    }

    public void saveAnalyzerExecutionLevel(AnalyzerExecutionLevel level) {
        assert (level != null) : "Parameter 'level' of method 'saveAnalyzerExecutionLevel' must not be null";
        IEclipsePreferences preferences = PreferencesUtility.getPreferences("com.hello2morrow.sonargraph.ui.swt");
        if (preferences != null) {
            preferences.put(AnalyzerExecutionLevel.class.getName(), level.getStandardName());
            PreferencesUtility.save(preferences);
        } else {
            LOGGER.warn("Unable to save analyzer execution level - preferences not found: com.hello2morrow.sonargraph.ui.swt");
        }
    }

    public void startupComplete() {
        List<IWorkbenchView> views;
        ContextInjectionFactory.inject((Object)this.m_linkSelectionListener, (IEclipseContext)this.m_viewAccessor.getEclipseContext());
        this.m_workbenchIsRunning = true;
        this.updatePartNames();
        if (Mode.STANDALONE.equals((Object)this.m_mode) && !(views = RcpUtility.getWorkbenchViews(this.m_viewAccessor.getEclipseContext())).isEmpty()) {
            this.selectView(views.get(0));
        }
    }

    public void shutdownStarted() {
        ContextInjectionFactory.uninject((Object)this.m_linkSelectionListener, (IEclipseContext)this.m_viewAccessor.getEclipseContext());
        this.m_workbenchIsRunning = false;
        if (Mode.STANDALONE.equals((Object)this.m_mode)) {
            this.m_mainApplicationWindow.setLabel(SwtResourceProviderAdapter.getInstance().getString("standalone.label.application.name", new Object[0]));
        }
    }

    public IWorkbench getWorkbench() {
        IWorkbench workbench = (IWorkbench)this.m_viewAccessor.getEclipseContext().get(IWorkbench.class);
        assert (workbench != null) : "Parameter 'workbench' of method 'getWorkbench' must not be null";
        return workbench;
    }

    public Display getDisplay() {
        return this.m_viewAccessor.getDisplay();
    }

    public static boolean isRunning() {
        return s_instance != null && WorkbenchRegistry.s_instance.m_workbenchIsRunning && !s_instance.getDisplay().isDisposed();
    }

    public void viewClosed(IWorkbenchView view) {
        assert (view != null) : "Parameter 'view' of method 'viewClosed' must not be null";
        if (this.m_workbenchIsRunning) {
            this.m_viewAccessor.viewClosed(view);
        }
    }

    public IWorkbenchView getCurrentlySelectedView() {
        return this.m_viewAccessor.getCurrentlySelectedView();
    }

    public Control getCurrentlySelectedViewComponent() {
        return this.m_viewAccessor.getCurrentlySelectedViewComponent();
    }

    public <T extends IWorkbenchView> T getCurrentlySelectedView(Class<T> clazz) {
        return this.m_viewAccessor.getCurrentlySelectedView(clazz);
    }

    public List<IWorkbenchView> getViewSelectionChain() {
        return this.m_viewAccessor.getViewSelectionChain();
    }

    @Override
    public boolean mayProcessMouseEvents() {
        return WorkbenchRegistry.isRunning();
    }

    @Override
    public void selectView(IWorkbenchView view, Control control) {
        assert (view != null) : "Parameter 'view' of method 'selectView' must not be null";
        if (this.m_workbenchIsRunning) {
            this.m_viewAccessor.selectView(view, control);
        }
    }

    public void selectView(IWorkbenchView view) {
        assert (view != null) : "Parameter 'view' of method 'selectView' must not be null";
        if (this.m_workbenchIsRunning) {
            this.m_viewAccessor.selectView(view, view.getSelectedViewComponent());
        }
    }

    private void updateState(WorkbenchState state, boolean set) {
        assert (state != null) : "Parameter 'state' of method 'updateState' must not be null";
        if (set) {
            this.m_state.add(state);
        } else {
            this.m_state.remove((Object)state);
        }
    }

    private void updateRecentlyUsedList(String path, boolean forceAdd) {
        assert (path != null && path.length() > 0) : "Parameter 'path' of method 'update' must not be empty";
        PersistentRecentlyUsedList persistentRecentlyUsedList = this.m_provider.getRecentlyUsedList();
        if (forceAdd || !persistentRecentlyUsedList.contains(path)) {
            persistentRecentlyUsedList.lastRecentlyUsed(path);
        }
    }

    private void updateRecentlyUsedList(SoftwareSystem softwareSystem, boolean forceAdd) {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'updateLruList' must not be null";
        SoftwareSystemMode mode = softwareSystem.getMode();
        String path = mode == SoftwareSystemMode.SYSTEM_LOADED_FROM_SNAPSHOT ? FileUtility.calculateRelativePath((TFile)((IFiles)softwareSystem.getUniqueExistingChild(IFiles.class)).getSystemDirectory().getFile().getParentFile(), null) : (mode == SoftwareSystemMode.SYSTEM_EXTRACTED_AND_ATTACHED_TO_SNAPSHOT ? FileUtility.calculateRelativePath((TFile)softwareSystem.getSnapshot(), null) : FileUtility.calculateRelativePath((TFile)((IFiles)softwareSystem.getUniqueExistingChild(IFiles.class)).getSystemDirectory().getFile(), null));
        this.updateRecentlyUsedList(path, forceAdd);
    }

    private void checkExportAvailability() {
        this.updateState(WorkbenchState.EXPORT_NOT_BLOCKED, !this.m_isExporting && !this.m_areAnalyzersRunning);
    }

    public boolean hasState(WorkbenchState ... states) {
        assert (states != null && states.length > 0) : "Parameter 'states' of method 'hasState' must not be empty";
        return this.m_state.containsAll(Arrays.asList(states));
    }

    public boolean isLanguageUsed(Language language) {
        assert (language != null) : "Parameter 'language' of method 'isLanguageUsed' must not be null";
        return this.m_usedLanguages.contains(language);
    }

    public void refreshUIElements() {
        this.m_viewAccessor.refreshUIElements();
    }

    private void updateTitle() {
        if (Mode.STANDALONE.equals((Object)this.m_mode)) {
            SoftwareSystemState state;
            SoftwareSystem softwareSystem;
            String licenseType;
            StringBuilder title = new StringBuilder(SwtResourceProviderAdapter.getInstance().getString("standalone.label.application.name", new Object[0]));
            SonargraphLicenseHandler licenseHandler = CommandRegistry.getInstance().getLicenseHandler();
            String prop = System.getProperty("logback.configurationFile");
            if (prop != null && prop.endsWith("logback-test.xml")) {
                title.append(" ").append(licenseHandler.getProductVersion().toString()).append(" [DEVELOPMENT]");
            }
            if ((licenseType = licenseHandler.getLicenseType()) != null && !licenseType.isEmpty()) {
                title.append(" [" + licenseType + "]");
            }
            if ((softwareSystem = this.getSoftwareSystem()) != null && (state = softwareSystem.getState()) != SoftwareSystemState.UNDEFINED && state != SoftwareSystemState.CLOSED) {
                title.append(" - ").append(softwareSystem.getName());
                if (softwareSystem.modifiableFilesNeedSave()) {
                    title.append(INFORMATION_HAS_CHANGED_MARK);
                }
                title.append(" - ").append(softwareSystem.state());
            }
            this.m_mainApplicationWindow.setLabel(title.toString());
        }
    }

    private void handleUpdate() {
        this.refreshUIElements();
        this.updatePartNames();
        this.updateTitle();
    }

    public ISoftwareSystemProvider getProvider() {
        return this.m_provider;
    }

    public Installation getInstallation() {
        return this.m_provider.getInstallation();
    }

    public SoftwareSystem getSoftwareSystem() {
        return this.m_provider.hasSoftwareSystem() ? this.m_provider.getSoftwareSystem() : null;
    }

    public MWindow getMainApplicationWindow() {
        return this.m_mainApplicationWindow;
    }

    public Shell getMainApplicationWindowShell() {
        Shell shell;
        Object widget = this.m_mainApplicationWindow.getWidget();
        if (widget instanceof Shell && !(shell = (Shell)widget).isDisposed()) {
            return shell;
        }
        LOGGER.error("No main application window shell available: " + ExceptionUtility.collectAll((Throwable)new Throwable()));
        return new Shell(this.getDisplay());
    }

    public IEclipseContext getEclipseContext() {
        return this.m_mainApplicationWindow.getContext();
    }

    public EPartService getPartService() {
        return (EPartService)this.m_mainApplicationWindow.getContext().get(EPartService.class);
    }

    public List<IViewContentExclusionFilter> getViewContentFilters(IViewId viewId) {
        assert (viewId != null) : "Parameter 'viewId' of method 'getActiveViewContentFilter' must not be null";
        List<IViewContentExclusionFilter> contentFilter = this.m_viewIdToContentFilters.get(viewId);
        return contentFilter != null ? new ArrayList<IViewContentExclusionFilter>(contentFilter) : Collections.emptyList();
    }

    public List<CategoryProvider> getViewCategoryProviders(IViewId viewId) {
        assert (viewId != null) : "Parameter 'viewId' of method 'getCategoryProvider' must not be null";
        List<CategoryProvider> categoryProviders = this.m_viewIdToCategoryProviders.get(viewId);
        return categoryProviders != null ? new ArrayList<CategoryProvider>(categoryProviders) : Collections.emptyList();
    }

    public void registerContextMenuContributor(String commandId, MMenuItem menuItem, IContextMenuContributor contributor) {
        assert (commandId != null && commandId.length() > 0) : "Parameter 'commandId' of method 'registerContextMenuContributor' must not be empty";
        assert (menuItem != null) : "Parameter 'menuItem' of method 'registerContextMenuContributor' must not be null for: " + commandId;
        assert (contributor != null) : "Parameter 'contributor' of method 'registerContextMenuContributor' must not be null for: " + commandId;
        ContextMenuContributionInfo put = new ContextMenuContributionInfo(commandId, menuItem, contributor);
        ContextMenuContributionInfo previous = this.m_commandIdToContributionInfo.put(commandId, put);
        if (previous != null && !previous.equals(put)) {
            LOGGER.warn("Different contribution info added.");
        }
    }

    public Collection<ContextMenuContributionInfo> getContextMenuContributionInfo() {
        return Collections.unmodifiableCollection(this.m_commandIdToContributionInfo.values());
    }

    public Set<IViewId> getAvailableViewIds() {
        return Collections.unmodifiableSet(this.m_availableViewIds);
    }

    private void resetPartNames() {
        for (MPart nextPart : RcpUtility.findModelElements(this.m_viewAccessor.getEclipseContext(), (MUIElement)this.m_mainApplicationWindow, MPart.class)) {
            String nextLabel = nextPart.getLabel();
            String rawLabel = nextLabel.replaceAll(Pattern.quote(IMPORTANT_INFORMATION_MARK), "");
            rawLabel = rawLabel.replaceAll(Pattern.quote(INFORMATION_HAS_CHANGED_MARK), "");
            rawLabel = rawLabel.trim();
            nextPart.setLabel(rawLabel);
        }
    }

    private void updatePartNames() {
        if (!this.hasState(WorkbenchState.CALCULATING)) {
            THashMap elementIdToPart = new THashMap();
            for (MPart nextPart : RcpUtility.findModelElements(this.m_viewAccessor.getEclipseContext(), (MUIElement)this.m_mainApplicationWindow, MPart.class)) {
                elementIdToPart.put(nextPart.getElementId(), nextPart);
            }
            for (IViewId nextViewId : this.m_availableViewIds) {
                MPart part;
                IImportantInformationDetector nextDetector = nextViewId.getImportantInformationDetector();
                if (nextDetector != null) {
                    assert (!nextViewId.hasProperty(IViewId.Property.ALLOWS_MULTIPLE_INSTANCES)) : "Important information detector not supported for views allowing multiple instances: " + String.valueOf(nextViewId);
                    MPart nextCorrespondingViewPart = (MPart)elementIdToPart.get(nextViewId.getId());
                    assert (nextCorrespondingViewPart != null) : "Parameter 'nextCorrespondingViewPart' of method 'updatePartNames' must not be null";
                    boolean hasImportantInformation = nextViewId.getImportantInformationDetector().hasImportantInformation(this.m_provider);
                    String initialName = this.m_viewIdToInitialLabel.get(nextViewId.getId());
                    assert (initialName != null && initialName.length() > 0) : "Parameter 'initialName' of method 'updatePartNames' must not be empty";
                    String newName = (hasImportantInformation ? "(!) " : "") + initialName;
                    nextCorrespondingViewPart.setLabel(newName);
                }
                if (!nextViewId.hasProperty(IViewId.Property.ALLOWS_SOURCE_MODIFICATION) || (part = (MPart)elementIdToPart.get(nextViewId.getId())) == null) continue;
                this.updatePartNameForModifiableFileState(part, null);
            }
        }
    }

    public void updatePartNameForModifiableFileState(MPart part, String currentLabel) {
        assert (part != null) : "Parameter 'part' of method 'updatePartName' must not be null";
        Object associatedObject = part.getObject();
        if (associatedObject != null) {
            assert (associatedObject != null && associatedObject instanceof IWorkbenchView) : "Unexpected class in method 'updatePartNames': " + String.valueOf(associatedObject);
            Object label = currentLabel;
            if (currentLabel == null) {
                label = part.getLabel().replaceAll(Pattern.quote(INFORMATION_HAS_CHANGED_MARK), "");
            }
            label = ((String)label).trim();
            IWorkbenchView workbenchView = (IWorkbenchView)associatedObject;
            IModifiableFile modifiableFile = workbenchView.getModifiableFile();
            if (modifiableFile != null && modifiableFile.needsSave()) {
                label = "(*) " + (String)label;
            }
            if (!((String)label).equals(part.getLabel())) {
                part.setLabel((String)label);
            }
            this.refreshUIElements();
        }
    }

    public static interface ILinkSelectionListener {
    }

    public static enum Mode {
        STANDALONE,
        INTEGRATED;

    }
}

