/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.base.workbench;

import com.hello2morrow.sonargraph.ui.swt.base.view.IWorkbenchView;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.IControlProvider;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ViewEventListener
implements Listener {
    private static final Logger LOGGER = LoggerFactory.getLogger(ViewEventListener.class);
    private final IViewSelectionListener m_listener;
    private IWorkbenchView m_draggingView;

    ViewEventListener(Display display, IViewSelectionListener listener) {
        assert (display != null) : "Parameter 'display' of method 'ViewEventListener' must not be null";
        assert (listener != null) : "Parameter 'listener' of method 'ViewEventListener' must not be null";
        this.m_listener = listener;
        display.syncExec(() -> {
            display.addFilter(4, (Listener)this);
            display.addFilter(3, (Listener)this);
            display.addFilter(29, (Listener)this);
            display.addFilter(8, (Listener)this);
            display.addFilter(7, (Listener)this);
            display.addFilter(6, (Listener)this);
            display.addFilter(13, (Listener)this);
        });
    }

    private String getEventType(int type) {
        switch (type) {
            case 4: {
                return "MouseUp";
            }
            case 3: {
                return "MouseDown";
            }
            case 29: {
                return "DragDetect";
            }
            case 8: {
                return "MouseDoubleClick";
            }
            case 7: {
                return "MouseExit";
            }
            case 6: {
                return "MouseEnter";
            }
            case 13: {
                return "Selection";
            }
        }
        LOGGER.error("Unknown SWT event type: " + type);
        return "Unknown: " + type;
    }

    private void handleSelection(IWorkbenchView view, Control control) {
        if (view != null && view.isActive() && (control == null || !control.isDisposed())) {
            LOGGER.debug("View/control selected '" + String.valueOf(view.getViewId()) + "'");
            if (control instanceof IControlProvider) {
                this.m_listener.selectView(view, ((IControlProvider)control).getControl());
            } else {
                this.m_listener.selectView(view, control);
            }
            LOGGER.debug("View/control selected '" + String.valueOf(view.getViewId()) + "' - done");
        }
    }

    private IWorkbenchView getWorkbenchView(CTabFolder tabFolder) {
        assert (tabFolder != null) : "Parameter 'tabFolder' of method 'getWorkbenchView' must not be null";
        if (!tabFolder.isDisposed()) {
            CTabItem[] cTabItemArray = tabFolder.getItems();
            int n = cTabItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object data;
                CTabItem nextItem = cTabItemArray[n2];
                Control nextControl = nextItem.getControl();
                if (nextControl != null && !nextControl.isDisposed() && nextItem.getControl().isVisible() && (data = nextControl.getData("data.workbenchViewOfComposite")) instanceof IWorkbenchView) {
                    return (IWorkbenchView)data;
                }
                ++n2;
            }
        }
        return null;
    }

    private void stopDragging() {
        if (this.m_draggingView != null) {
            LOGGER.debug("Stop dragging '" + String.valueOf(this.m_draggingView.getViewId()) + "'");
            this.m_draggingView.stopDraggingView();
            this.m_draggingView = null;
        }
    }

    public void handleEvent(Event event) {
        assert (event != null) : "Parameter 'event' of method 'handleEvent' must not be null";
        Widget widget = event.widget;
        if (this.m_listener.mayProcessMouseEvents() && widget != null && !widget.isDisposed()) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Handle event '" + this.getEventType(event.type) + "': " + String.valueOf(widget));
            }
            if (event.type == 4) {
                IWorkbenchView workbenchView;
                this.stopDragging();
                if (widget instanceof CTabFolder && (workbenchView = this.getWorkbenchView((CTabFolder)widget)) != null) {
                    this.handleSelection(workbenchView, null);
                }
            } else if (event.type == 3 || event.type == 13) {
                Object data;
                this.stopDragging();
                Control control = null;
                if (widget instanceof Control) {
                    control = (Control)widget;
                } else if (widget instanceof Item && (data = widget.getData("data.controlOfItem")) instanceof Control) {
                    control = (Control)data;
                }
                if (control != null) {
                    Control current = control;
                    while (current != null) {
                        Composite composite;
                        Object data2;
                        if (current instanceof Composite && (data2 = (composite = (Composite)current).getData("data.workbenchViewOfComposite")) instanceof IWorkbenchView) {
                            CTabFolder tabFolder;
                            CTabItem tabItem;
                            IWorkbenchView view = (IWorkbenchView)data2;
                            if (control instanceof CTabFolder && (tabItem = (tabFolder = (CTabFolder)control).getItem(new Point(event.x, event.y))) != null) {
                                control = tabItem.getControl();
                            }
                            this.handleSelection(view, control);
                            break;
                        }
                        current = current.getParent();
                    }
                }
            } else if (event.type == 29) {
                this.stopDragging();
                if (widget instanceof CTabFolder) {
                    this.m_draggingView = this.getWorkbenchView((CTabFolder)widget);
                    if (this.m_draggingView != null) {
                        LOGGER.debug("Start dragging '" + String.valueOf(this.m_draggingView.getViewId()) + "'");
                        this.m_draggingView.startDraggingView();
                    }
                }
            } else {
                this.stopDragging();
            }
        }
    }

    public static interface IViewSelectionListener {
        public boolean mayProcessMouseEvents();

        public void selectView(IWorkbenchView var1, Control var2);
    }
}

