/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.base.workbench;

import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.foundation.utilities.IStandardEnumeration;
import com.hello2morrow.sonargraph.ui.swt.base.view.IContextMenuInteractionListener;
import com.hello2morrow.sonargraph.ui.swt.base.view.IContextMenuSelectionAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.view.IWorkbenchView;
import com.hello2morrow.sonargraph.ui.swt.base.view.RcpUtility;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import com.hello2morrow.sonargraph.ui.swt.common.IShowInViewOptionProvider;
import com.hello2morrow.sonargraph.ui.swt.common.IViewId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.swt.events.SelectionEvent;

public final class ShowInViewSelectionAdapter
implements IContextMenuSelectionAdapter {
    private final List<IStandardEnumeration> m_options = new ArrayList<IStandardEnumeration>();
    private final IContextMenuInteractionListener m_listener;
    private final IWorkbenchView m_sourceView;
    private final IViewId m_targetViewId;
    private final String m_secondaryId;
    private final List<Element> m_elements;
    private final String m_text;
    private final String m_imageResourcename;
    private final boolean m_reuseViewInstance;
    private IShowInViewOptionProvider m_showInViewOptionProvider;

    public ShowInViewSelectionAdapter(IContextMenuInteractionListener listener, IWorkbenchView sourceView, IViewId targetViewId, String secondaryId, List<IStandardEnumeration> options, List<Element> elements, String text, String imageResourceName, boolean reuseViewInstance) {
        assert (listener != null) : "Parameter 'listener' of method 'ShowInViewSelectionAdapter' must not be null";
        assert (sourceView != null) : "Parameter 'sourceView' of method 'ShowInViewAction' must not be null";
        assert (targetViewId != null) : "Parameter 'targetViewId' of method 'ShowInViewAction' must not be null";
        assert (elements != null && !elements.isEmpty()) : "Parameter 'elements' of method 'ShowInViewAction' must not be empty";
        assert (text != null && text.length() > 0) : "Parameter 'text' of method 'ShowInViewSelectionAdapter' must not be empty";
        this.m_listener = listener;
        this.m_sourceView = sourceView;
        this.m_targetViewId = targetViewId;
        this.m_secondaryId = secondaryId;
        this.m_options.addAll(options);
        this.m_elements = elements;
        this.m_text = text;
        this.m_imageResourcename = imageResourceName;
        this.m_reuseViewInstance = reuseViewInstance;
    }

    public ShowInViewSelectionAdapter(IContextMenuInteractionListener listener, IWorkbenchView sourceView, IViewId targetViewId, String secondaryId, List<Element> elements, String text, String imageResourceName, List<IStandardEnumeration> parentOptions, IShowInViewOptionProvider showInViewOptionProvider, boolean reuseViewInstance) {
        this(listener, sourceView, targetViewId, secondaryId, parentOptions, elements, text, imageResourceName, reuseViewInstance);
        assert (showInViewOptionProvider != null) : "Parameter 'optionProviderDialog' of method 'ShowInViewSelectionAdapter' must not be null";
        this.m_showInViewOptionProvider = showInViewOptionProvider;
    }

    public String getText() {
        return this.m_text;
    }

    public String getImageResourcename() {
        return this.m_imageResourcename;
    }

    private static void showInView(IEclipseContext eclipseContext, EPartService partService, IWorkbenchView sourceView, IViewId targetViewId, String secondaryId, List<IStandardEnumeration> options, List<Element> elements, boolean secondaryIdReused) {
        assert (eclipseContext != null) : "Parameter 'eclipseContext' of method 'showInView' must not be null";
        assert (partService != null) : "Parameter 'partService' of method 'showInView' must not be null";
        assert (targetViewId != null) : "Parameter 'targetViewId' of method 'showInView' must not be null";
        assert (elements != null && !elements.isEmpty()) : "Parameter 'elements' of method 'showInView' must not be empty";
        assert (options != null) : "Parameter 'options' of method 'showInView' must not be null";
        try {
            IWorkbenchView workbenchView;
            if (sourceView != null) {
                sourceView.aboutToShowInView();
            }
            if ((workbenchView = secondaryId != null ? RcpUtility.createView(eclipseContext, partService, targetViewId, secondaryId) : RcpUtility.createView(eclipseContext, partService, targetViewId)) != null) {
                workbenchView.showInView(sourceView != null ? sourceView.getContext() : WorkbenchRegistry.getInstance().getProvider().getDefaultContext(), elements, options, secondaryIdReused);
                if (secondaryId != null) {
                    RcpUtility.activateView(eclipseContext, partService, targetViewId, secondaryId);
                } else {
                    RcpUtility.activateView(eclipseContext, partService, targetViewId);
                }
                workbenchView.finishShowInView(sourceView != null ? sourceView.getViewId() : null, elements, options);
            }
        }
        finally {
            if (sourceView != null) {
                sourceView.finishShowInView();
            }
        }
    }

    public void widgetSelected(SelectionEvent event) {
        try {
            if (this.m_showInViewOptionProvider != null) {
                List<IStandardEnumeration> optionsFromProvider = this.m_showInViewOptionProvider.getOptions();
                if (optionsFromProvider == null) {
                    return;
                }
                this.m_options.addAll(optionsFromProvider);
            }
            ShowInViewSelectionAdapter.showInView(this.m_sourceView.getEclipseContext(), this.m_sourceView.getPartService(), this.m_sourceView, this.m_targetViewId, this.m_secondaryId, this.m_options, this.m_elements, this.m_reuseViewInstance);
        }
        finally {
            this.m_listener.interactionFinished();
        }
    }

    public static void showInView(IWorkbenchView sourceView, IViewId targetViewId, String secondaryId, List<IStandardEnumeration> options, List<Element> elements, boolean reuseViewInstance) {
        assert (sourceView != null) : "Parameter 'sourceView' of method 'showInView' must not be null";
        assert (targetViewId != null) : "Parameter 'targetViewId' of method 'showInView' must not be null";
        assert (elements != null && !elements.isEmpty()) : "Parameter 'elements' of method 'showInView' must not be empty";
        assert (options != null) : "Parameter 'options' of method 'showInView' must not be null";
        ShowInViewSelectionAdapter.showInView(sourceView.getEclipseContext(), sourceView.getPartService(), sourceView, targetViewId, secondaryId, options, elements, reuseViewInstance);
    }

    public static void showInView(IWorkbenchView sourceView, IViewId targetViewId, String secondaryId, List<Element> elements, boolean reuseViewInstance) {
        assert (sourceView != null) : "Parameter 'sourceView' of method 'showInView' must not be null";
        assert (targetViewId != null) : "Parameter 'targetViewId' of method 'showInView' must not be null";
        assert (elements != null && !elements.isEmpty()) : "Parameter 'elements' of method 'showInView' must not be empty";
        ShowInViewSelectionAdapter.showInView(sourceView.getEclipseContext(), sourceView.getPartService(), sourceView, targetViewId, secondaryId, Collections.emptyList(), elements, reuseViewInstance);
    }

    public static void showInView(IEclipseContext eclipseContext, EPartService partService, IViewId targetViewId, String secondaryId, List<IStandardEnumeration> options, List<Element> elements, boolean reuseViewInstance) {
        assert (eclipseContext != null) : "Parameter 'eclipseContext' of method 'showInView' must not be null";
        assert (partService != null) : "Parameter 'partService' of method 'showInView' must not be null";
        assert (targetViewId != null) : "Parameter 'targetViewId' of method 'showInView' must not be null";
        assert (elements != null && !elements.isEmpty()) : "Parameter 'elements' of method 'showInView' must not be empty";
        assert (options != null) : "Parameter 'options' of method 'showInView' must not be null";
        ShowInViewSelectionAdapter.showInView(eclipseContext, partService, null, targetViewId, secondaryId, options, elements, reuseViewInstance);
    }

    public static void showInView(IEclipseContext eclipseContext, EPartService partService, IViewId viewId, String secondaryId, IStandardEnumeration viewComponent) {
        assert (eclipseContext != null) : "Parameter 'eclipseContext' of method 'showInView' must not be null";
        assert (partService != null) : "Parameter 'partService' of method 'showInView' must not be null";
        assert (viewId != null) : "Parameter 'targetViewId' of method 'showInView' must not be null";
        assert (viewComponent != null) : "Parameter 'viewComponent' of method 'showInView' must not be null";
        IWorkbenchView workbenchView = secondaryId != null ? RcpUtility.createView(eclipseContext, partService, viewId, secondaryId) : RcpUtility.createView(eclipseContext, partService, viewId);
        if (workbenchView != null) {
            if (secondaryId != null) {
                RcpUtility.activateView(eclipseContext, partService, viewId, secondaryId);
            } else {
                RcpUtility.activateView(eclipseContext, partService, viewId);
            }
            workbenchView.showViewComponent(viewComponent);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.m_text);
        builder.append(" [");
        if (this.m_imageResourcename != null) {
            builder.append("no image");
        } else {
            builder.append(this.m_imageResourcename);
        }
        builder.append("] ");
        builder.append(this.m_targetViewId);
        builder.append("/");
        builder.append(this.m_secondaryId);
        builder.append('\n');
        builder.append(this.m_options);
        return builder.toString();
    }
}

