/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.base.workbench;

import com.hello2morrow.sonargraph.foundation.propertyreader.BeanPropertyReader;
import com.hello2morrow.sonargraph.foundation.propertyreader.IPropertyReader;
import com.hello2morrow.sonargraph.foundation.utilities.NumberUtility;
import com.hello2morrow.sonargraph.foundation.utilities.Platform;
import com.hello2morrow.sonargraph.foundation.utilities.StrictPair;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.ui.swt.base.SwtUtility;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import com.hello2morrow.sonargraph.ui.swt.base.view.IPropertyTableViewer;
import com.hello2morrow.sonargraph.ui.swt.base.view.TextFilterWidget;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.AggregatingPropertyTableTextFilter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.IControlProvider;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.PropertyCellLabelProvider;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.PropertyTableEnumFilter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.PropertyTableSorter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.PropertyTableTextFilter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import gnu.trove.map.hash.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class PropertyTableViewer<T>
extends Composite
implements IPropertyTableViewer<T>,
IControlProvider,
SelectionListener,
ControlListener {
    private static final String IMAGE = "image";
    private static final String SORT = "sort";
    private static final String ENUM = "enum";
    private static final String COLUMN_TYPE = "type";
    private static final String CSV_SEPARATOR = ";";
    private final List<Integer> m_columnWidthWeights = new ArrayList<Integer>();
    private final Set<String> m_properties = new LinkedHashSet<String>();
    private final TableViewer m_tableViewer;
    private final IPropertyReader<T> m_propertyReader;
    private final PropertyTableSorter<T> m_sorter;
    private ICellImageProvider<T> m_cellImageProvider;
    private ICellColorProvider<T> m_cellBackgroundColorProvider;
    private Map<String, Map<Object, String>> m_propertyToValueToText;
    private int m_totalColumnWidthWeights;
    private int m_totalCheckColumnWidths;
    private TableColumn m_firstColumn;
    private String m_firstColumnTitle;
    private String m_additionalFirstColumnInfo;
    private boolean m_firstScrollEvent;
    private boolean m_usedDefinedColumnSizes;
    private boolean m_adaptingColumnSizes;
    private boolean m_inDisposeColumn;
    private TextFilterWidget m_filterComposite;
    private GridData m_filterLayoutData;
    private boolean m_autoAdjustColumnWidths;

    protected static final void reset(GridLayout gridLayout) {
        assert (gridLayout != null) : "Parameter 'gridLayout' of method 'reset' must not be null";
        gridLayout.horizontalSpacing = 0;
        gridLayout.marginBottom = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginLeft = 0;
        gridLayout.marginRight = 0;
        gridLayout.marginTop = 0;
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = 0;
    }

    public PropertyTableViewer(Composite composite, BeanPropertyReader.BeanAdapter<T> adapter, SelectionType selectionType) {
        this(composite, (IPropertyReader<T>)new BeanPropertyReader(adapter), selectionType, null);
    }

    public PropertyTableViewer(Composite composite, IPropertyReader<T> propertyReader, SelectionType selectionType, StrictPair<String, Boolean> sortOrder) {
        this(composite, propertyReader, selectionType, sortOrder, 0);
    }

    public PropertyTableViewer(Composite composite, BeanPropertyReader.BeanAdapter<T> adapter, String sortProperty, boolean ascending, SelectionType selectionType) {
        this(composite, adapter, sortProperty, ascending, selectionType, 0);
    }

    public PropertyTableViewer(Composite composite, BeanPropertyReader.BeanAdapter<T> adapter, String sortProperty, boolean ascending, SelectionType selectionType, int swtFlags) {
        this(composite, (IPropertyReader<T>)new BeanPropertyReader(adapter), selectionType, (StrictPair<String, Boolean>)(sortProperty != null ? new StrictPair((Object)sortProperty, (Object)ascending) : null), swtFlags);
    }

    public PropertyTableViewer(Composite composite, IPropertyReader<T> propertyReader, SelectionType selectionType, StrictPair<String, Boolean> sortOrder, int swtFlags) {
        this(composite, propertyReader, selectionType, sortOrder, swtFlags, true);
    }

    public PropertyTableViewer(Composite composite, IPropertyReader<T> propertyReader, SelectionType selectionType, StrictPair<String, Boolean> sortOrder, int swtFlags, boolean autoAdjustColumnWidths) {
        super(composite, 0);
        assert (composite != null) : "Parameter 'composite' of method 'PropertyTableViewer' must not be null";
        assert (propertyReader != null) : "Parameter 'propertyReader' of method 'PropertyTableViewer' must not be null";
        assert (selectionType != null) : "Parameter 'selectionType' of method 'PropertyTableViewer' must not be null";
        this.m_autoAdjustColumnWidths = autoAdjustColumnWidths;
        GridLayout gridLayout = new GridLayout(1, false);
        PropertyTableViewer.reset(gridLayout);
        this.setLayout((Layout)gridLayout);
        this.m_filterComposite = new TextFilterWidget(this, new TextFilterWidget.ITextFilterCallback(){

            @Override
            public void applyTextFilter(String text) {
                PropertyTableViewer.this.applyTextFilter(text);
            }
        }, new TextFilterWidget.IRegexFilterCallback(){

            @Override
            public void applyRegexFilter(Pattern regex) {
                PropertyTableViewer.this.applyRegexFilter(regex);
            }
        });
        this.m_filterLayoutData = new GridData(4, 4, true, false);
        this.m_filterComposite.setLayoutData(this.m_filterLayoutData);
        this.m_filterComposite.getFilterText().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 27) {
                    PropertyTableViewer.this.toggleVisibilityOfTextFilter(PropertyTableViewer.this.m_filterLayoutData, PropertyTableViewer.this.m_filterComposite.getFilterText(), false);
                }
            }
        });
        this.m_filterLayoutData.exclude = true;
        this.m_filterComposite.setVisible(false);
        swtFlags |= 0x10000200;
        switch (selectionType) {
            case SINGLE_FULL_LINE: {
                swtFlags = swtFlags | 0x10000 | 4;
                break;
            }
            case MULTI_FULL_LINE: {
                swtFlags = swtFlags | 2 | 0x10000;
                break;
            }
            case SINGLE_COLUMN: {
                swtFlags |= 4;
                break;
            }
            default: {
                assert (false) : "Unhandled selection type: " + String.valueOf((Object)selectionType);
                break;
            }
        }
        this.m_tableViewer = new TableViewer((Composite)this, swtFlags);
        this.m_tableViewer.getTable().setLayoutData((Object)new GridData(4, 4, true, true));
        this.m_tableViewer.setUseHashlookup(true);
        this.m_propertyReader = propertyReader;
        this.m_tableViewer.getTable().setHeaderVisible(true);
        this.m_tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.m_sorter = new PropertyTableSorter(this.m_propertyReader, sortOrder);
        this.m_tableViewer.setComparator(this.m_sorter);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.m_tableViewer, (int)2);
        this.m_tableViewer.getTable().addControlListener((ControlListener)this);
        KeyAdapter keyListener = new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (!$assertionsDisabled && event == null) {
                    throw new AssertionError((Object)"Parameter 'event' of method 'keyPressed' must not be null");
                }
                if ((event.stateMask & 0x40000) == 262144 && (event.stateMask & 0x20000) == 131072 && event.keyCode == 102) {
                    PropertyTableViewer.this.toggleVisibilityOfTextFilter(PropertyTableViewer.this.m_filterLayoutData, PropertyTableViewer.this.m_filterComposite.getFilterText(), true);
                } else if (event.keyCode == 27) {
                    PropertyTableViewer.this.toggleVisibilityOfTextFilter(PropertyTableViewer.this.m_filterLayoutData, PropertyTableViewer.this.m_filterComposite.getFilterText(), false);
                } else if (!((event.stateMask & SWT.MOD1) != SWT.MOD1 || event.keyCode != 65 && event.keyCode != 97 || PropertyTableViewer.this.m_tableViewer == null || PropertyTableViewer.this.m_tableViewer.getTable().isDisposed())) {
                    PropertyTableViewer.this.m_tableViewer.getTable().selectAll();
                }
            }
        };
        this.m_tableViewer.getTable().addKeyListener((KeyListener)keyListener);
        ScrollBar vScrollBar = this.m_tableViewer.getTable().getVerticalBar();
        if (vScrollBar != null) {
            vScrollBar.addSelectionListener((SelectionListener)this);
        }
        this.m_tableViewer.getTable().setBackground(UiResourceManager.getInstance().getBackgroundColor());
        if (Platform.isLinux() && this.m_autoAdjustColumnWidths) {
            this.m_tableViewer.getTable().addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent e) {
                    PropertyTableViewer.this.adaptColumnSizes();
                    PropertyTableViewer.this.m_tableViewer.getTable().removePaintListener((PaintListener)this);
                }
            });
        }
    }

    private void toggleVisibilityOfTextFilter(GridData filterLayoutData, Text filterTextField, boolean show) {
        boolean doIt;
        assert (filterLayoutData != null) : "Parameter 'filterLayoutData' of method 'toggleVisibilityOfTextFilter' must not be null";
        boolean bl = doIt = show && !this.m_filterComposite.isVisible() || !show && this.m_filterComposite.isVisible();
        if (doIt) {
            this.m_filterComposite.setVisible(show);
            filterLayoutData.exclude = !show;
            this.layout(true);
            if (show) {
                assert (filterTextField != null) : "Parameter 'filterTextField' of method 'toggleVisibilityOfTextFilter' must not be null";
                filterTextField.setFocus();
                filterTextField.setSelection(0, filterTextField.getText().length());
            } else {
                this.applyTextFilter("");
            }
            WorkbenchRegistry.getInstance().refreshUIElements();
        }
    }

    public final boolean isTextFilterShown() {
        return !this.m_filterComposite.isDisposed() && this.m_filterComposite.isVisible();
    }

    public final void showTextFilter() {
        if (this.m_filterComposite.isDisposed()) {
            return;
        }
        this.toggleVisibilityOfTextFilter(this.m_filterLayoutData, this.m_filterComposite.getFilterText(), true);
    }

    public final void hideTextFilter() {
        if (this.m_filterComposite.isDisposed()) {
            return;
        }
        this.toggleVisibilityOfTextFilter(this.m_filterLayoutData, null, false);
    }

    private void applyRegexFilter(Pattern pattern) {
        assert (pattern != null) : "Parameter 'pattern' of method 'applyRegexFilter' must not be null";
        ArrayList<ViewerFilter> filters = new ArrayList<ViewerFilter>();
        ViewerFilter[] viewerFilterArray = this.getFilters();
        int n = viewerFilterArray.length;
        int n2 = 0;
        while (n2 < n) {
            ViewerFilter next = viewerFilterArray[n2];
            if (!(next instanceof AggregatingPropertyTableTextFilter)) {
                filters.add(next);
            }
            ++n2;
        }
        filters.add(new AggregatingPropertyTableTextFilter<T>(this.m_propertyReader, new ArrayList<String>(this.m_properties), pattern));
        this.setFilters(filters.toArray(new ViewerFilter[0]));
    }

    private void applyTextFilter(String filterText) {
        assert (filterText != null) : "Parameter 'filterText' of method 'applyTextFilter' must not be null";
        ArrayList<ViewerFilter> filters = new ArrayList<ViewerFilter>();
        ViewerFilter[] viewerFilterArray = this.getFilters();
        int n = viewerFilterArray.length;
        int n2 = 0;
        while (n2 < n) {
            ViewerFilter next = viewerFilterArray[n2];
            if (!(next instanceof AggregatingPropertyTableTextFilter)) {
                filters.add(next);
            }
            ++n2;
        }
        if (!filterText.isEmpty() && !filterText.trim().isEmpty()) {
            AggregatingPropertyTableTextFilter<T> filter = new AggregatingPropertyTableTextFilter<T>(this.m_propertyReader, new ArrayList<String>(this.m_properties), filterText.trim());
            filters.add(filter);
        }
        this.setFilters(filters.toArray(new ViewerFilter[0]));
    }

    public void dispose() {
        this.m_tableViewer.getControl().dispose();
        super.dispose();
    }

    public final void enableSort(boolean enable) {
        this.m_tableViewer.setComparator(enable ? this.m_sorter : null);
    }

    public final void addSortProperty(String propertyName, boolean ascending, boolean reset) {
        assert (propertyName != null && propertyName.length() > 0) : "Parameter 'propertyName' of method 'addSortProperty' must not be empty";
        this.m_sorter.addSortProperty(propertyName, ascending, reset);
    }

    public final void setSortOrder(List<StrictPair<String, Boolean>> sortProperties) {
        this.m_sorter.setSortOrder(sortProperties);
    }

    public final TableViewerColumn addColumn(String title, String propertyName, String sortProperty, String imageProperty, int widthWeight, ColumnType columnType) {
        assert (title != null && title.length() > 0) : "Parameter 'title' of method 'addColumn' must not be empty";
        assert (propertyName != null) : "Parameter 'propertyName' of method 'addColumn' must not be null";
        assert (widthWeight > 0) : "'widthWeight' must be greater than 0";
        assert (columnType != null) : "Parameter 'columnType' of method 'addColumn' must not be null";
        boolean success = this.m_properties.add(propertyName);
        assert (success) : "Property already added: " + propertyName;
        TableViewerColumn tableViewerColumn = new TableViewerColumn(this.m_tableViewer, switch (columnType) {
            case ColumnType.DATE -> 32;
            case ColumnType.NUMBER -> 131072;
            case ColumnType.TEXT -> 0;
            case ColumnType.IMAGE -> 0;
            default -> {
                if (!$assertionsDisabled) {
                    throw new AssertionError((Object)("Unhandled column type: " + String.valueOf((Object)columnType)));
                }
                yield 0;
            }
        });
        tableViewerColumn.setLabelProvider(new PropertyCellLabelProvider(this, propertyName));
        TableColumn tableColumn = tableViewerColumn.getColumn();
        tableColumn.setData("data.controlOfItem", (Object)this);
        this.m_columnWidthWeights.add(widthWeight);
        this.m_totalColumnWidthWeights += widthWeight;
        tableColumn.setWidth(widthWeight);
        tableColumn.setText(title);
        tableColumn.setData((Object)propertyName);
        tableColumn.setToolTipText(title);
        tableColumn.setResizable(true);
        tableColumn.addControlListener(new ControlListener(){

            public void controlResized(ControlEvent event) {
                if (!PropertyTableViewer.this.m_adaptingColumnSizes) {
                    PropertyTableViewer.this.m_usedDefinedColumnSizes = true;
                }
            }

            public void controlMoved(ControlEvent event) {
            }
        });
        tableColumn.setData(COLUMN_TYPE, (Object)columnType);
        if (imageProperty != null) {
            tableColumn.setData(IMAGE, (Object)imageProperty);
        }
        if (sortProperty != null) {
            tableColumn.setData(SORT, (Object)sortProperty);
            tableColumn.addSelectionListener((SelectionListener)this);
            if (sortProperty.equals(this.m_sorter.getSortProperty())) {
                Boolean isAscending = this.m_sorter.isAscendingSort();
                this.m_tableViewer.getTable().setSortColumn(tableColumn);
                this.m_tableViewer.getTable().setSortDirection(Boolean.TRUE == isAscending ? 128 : 1024);
            }
        }
        if (this.m_firstColumn == null) {
            this.m_firstColumn = tableColumn;
            this.m_firstColumnTitle = title;
        } else {
            tableColumn.setMoveable(true);
        }
        return tableViewerColumn;
    }

    public final void removeColumn(TableViewerColumn column, int widthWeight) {
        assert (column != null) : "Parameter 'column' of method 'removeColumn' must not be null";
        TableColumn tableColumn = column.getColumn();
        String sortPropertyName = (String)tableColumn.getData(SORT);
        if (sortPropertyName != null) {
            this.m_sorter.removeSortProperty(sortPropertyName);
        }
        String propName = (String)tableColumn.getData();
        this.m_properties.remove(propName);
        this.m_columnWidthWeights.remove(this.m_columnWidthWeights.indexOf(widthWeight));
        this.m_totalColumnWidthWeights -= widthWeight;
        try {
            this.m_inDisposeColumn = true;
            if (tableColumn == this.m_firstColumn) {
                this.m_firstColumn = null;
            }
            tableColumn.dispose();
        }
        finally {
            this.m_inDisposeColumn = false;
        }
    }

    public final void addColumnValueMapper(String propertyName, Object columnValue, String columnText) {
        THashMap valueToText;
        assert (propertyName != null && propertyName.length() > 0) : "Parameter 'propertyName' of method 'addColumnValueMapper' must not be empty";
        assert (columnText != null) : "Parameter 'columnText' of method 'add' must not be null";
        if (this.m_propertyToValueToText == null) {
            this.m_propertyToValueToText = new THashMap();
        }
        if ((valueToText = this.m_propertyToValueToText.get(propertyName)) == null) {
            valueToText = new THashMap();
            this.m_propertyToValueToText.put(propertyName, (Map<Object, String>)valueToText);
        }
        String previousText = valueToText.put(columnValue, columnText);
        assert (previousText == null) : "'previousText' of method 'addColumnValueMapper' must be null";
    }

    public final void setCellImageProvider(ICellImageProvider<T> provider) {
        this.m_cellImageProvider = provider;
    }

    public final void setCellColorProvider(ICellColorProvider<T> provider) {
        this.m_cellBackgroundColorProvider = provider;
    }

    private int getWidthReduction() {
        ScrollBar scrollBar;
        if (Platform.isMac() && ((scrollBar = this.m_tableViewer.getTable().getVerticalBar()) == null || scrollBar.getSize().x == 0)) {
            return 15;
        }
        return 0;
    }

    public final void adaptColumnSizes() {
        if (this.m_inDisposeColumn) {
            return;
        }
        if (!this.m_autoAdjustColumnWidths) {
            return;
        }
        this.m_adaptingColumnSizes = true;
        Table table = this.m_tableViewer.getTable();
        TableColumn[] columns = table.getColumns();
        int numberOfColumns = columns.length;
        if (numberOfColumns > 0) {
            this.m_tableViewer.getTable().removeControlListener((ControlListener)this);
            int availableWidth = table.getClientArea().width - this.getWidthReduction() - this.m_totalCheckColumnWidths;
            float factor = (float)availableWidth / (float)this.m_totalColumnWidthWeights;
            int usedWidth = 0;
            int colIndex = 0;
            while (colIndex < numberOfColumns - 1) {
                int newWidth;
                TableColumn nextColumn = columns[colIndex];
                Integer nextColumnWidthWeight = this.m_columnWidthWeights.get(colIndex);
                assert (nextColumnWidthWeight != null) : "Parameter 'nextColumnWidthWeight' of method 'adaptColumnSizes' must not be null";
                if (nextColumnWidthWeight != 0) {
                    newWidth = (int)((float)nextColumnWidthWeight.intValue() * factor);
                    nextColumn.setWidth(newWidth);
                } else {
                    newWidth = nextColumn.getWidth();
                }
                usedWidth += newWidth;
                ++colIndex;
            }
            Integer lastColumnWidthWeight = this.m_columnWidthWeights.get(colIndex);
            if (lastColumnWidthWeight != 0) {
                columns[colIndex].setWidth(availableWidth - usedWidth);
            }
            this.m_tableViewer.getTable().addControlListener((ControlListener)this);
        }
        this.m_adaptingColumnSizes = false;
    }

    public final void controlMoved(ControlEvent event) {
    }

    public final void controlResized(ControlEvent event) {
        assert (event != null) : "Parameter 'event' of method 'controlResized' must not be null";
        Object source = event.getSource();
        assert (source != null && source instanceof Table) : "Unexpected class in method 'controlResized': " + String.valueOf(source);
        if (!this.m_usedDefinedColumnSizes) {
            this.adaptColumnSizes();
        }
    }

    public final TableViewer getTableViewer() {
        return this.m_tableViewer;
    }

    @Override
    public final Control getControl() {
        return this.m_tableViewer.getTable();
    }

    public final Table getTable() {
        return this.m_tableViewer.getTable();
    }

    public void select(List<T> elements) {
        if (elements != null && !elements.isEmpty()) {
            this.getTableViewer().setSelection((ISelection)new StructuredSelection(elements), true);
        }
    }

    public final IStructuredSelection getSelection() {
        return this.m_tableViewer.getStructuredSelection();
    }

    public final List<T> getSelected() {
        IStructuredSelection selection = this.getSelection();
        if (selection.isEmpty()) {
            return Collections.emptyList();
        }
        List list = selection.toList();
        ArrayList selected = new ArrayList(list.size());
        for (Object next : list) {
            selected.add(next);
        }
        return selected;
    }

    protected final Collection<? extends T> getVisibleElements(Collection<? extends T> input) {
        if (input == null) {
            return Collections.emptyList();
        }
        ViewerFilter[] filters = this.getFilters();
        if (filters.length == 0) {
            return input;
        }
        ArrayList<T> filteredElements = new ArrayList<T>();
        TableViewer tableViewer = this.getTableViewer();
        for (T nextElement : input) {
            boolean show = true;
            ViewerFilter[] viewerFilterArray = filters;
            int n = filters.length;
            int n2 = 0;
            while (n2 < n) {
                ViewerFilter nextFilter = viewerFilterArray[n2];
                if (!nextFilter.select((Viewer)tableViewer, nextElement, nextElement)) {
                    show = false;
                    break;
                }
                ++n2;
            }
            if (!show) continue;
            filteredElements.add(nextElement);
        }
        return filteredElements;
    }

    public final Collection<? extends T> getVisibleItems() {
        return this.getVisibleElements(this.getInputData());
    }

    @Override
    public final Image getColumnImage(T object, int columnIndex) {
        TableColumn col = this.m_tableViewer.getTable().getColumn(columnIndex);
        String imageProperty = (String)col.getData(IMAGE);
        if (imageProperty != null && !imageProperty.isEmpty()) {
            return (Image)this.m_propertyReader.readProperty(object, imageProperty);
        }
        return null;
    }

    @Override
    public final boolean getBooleanProperty(T object, String propertyName) {
        Object value = this.m_propertyReader.readProperty(object, propertyName);
        if (value != null) {
            assert (value != null && value instanceof Boolean) : "Unexpected class in method 'getBooleanProperty': " + String.valueOf(value);
            return (Boolean)value;
        }
        return false;
    }

    private String getColumnText(T object, String propertyName, boolean forTooltip) {
        String text;
        Map<Object, String> valueToText;
        assert (propertyName != null && propertyName.length() > 0) : "Parameter 'propertyName' of method 'getColumnText' must not be empty";
        Object value = this.m_propertyReader.readProperty(object, propertyName);
        if (this.m_propertyToValueToText != null && (valueToText = this.m_propertyToValueToText.get(propertyName)) != null && (text = valueToText.get(value)) != null) {
            if (text.trim().length() > 0) {
                return text;
            }
            return null;
        }
        if (value != null) {
            if (value instanceof Date) {
                return StringUtility.getDateTimeStringFromLocale((Date)((Date)value));
            }
            if (value instanceof Number) {
                return NumberUtility.format((Number)((Number)value));
            }
            String valueString = value.toString().trim();
            if (valueString.length() == 0) {
                return null;
            }
            return forTooltip ? SwtUtility.wrapTextForTooltip(valueString) : valueString;
        }
        return null;
    }

    @Override
    public final String getColumnText(T object, String propertyName) {
        return this.getColumnText(object, propertyName, false);
    }

    @Override
    public final String getTooltipText(T object, String propertyName) {
        if (this.m_propertyReader.hasProperty(propertyName + "Tooltip")) {
            String tooltip = (String)this.m_propertyReader.readProperty(object, propertyName + "Tooltip");
            if (tooltip != null && !tooltip.isEmpty()) {
                return SwtUtility.wrapTextForTooltip(tooltip);
            }
            return tooltip;
        }
        return null;
    }

    @Override
    public final Image getCellImage(T object, String propertyName, Image columnImage) {
        return this.m_cellImageProvider == null ? null : this.m_cellImageProvider.getCellImage(this, object, propertyName, columnImage);
    }

    @Override
    public Color getCellColor(T object, String propertyName) {
        return this.m_cellBackgroundColorProvider == null ? null : this.m_cellBackgroundColorProvider.getCellColor(this, object, propertyName);
    }

    @Override
    public Color getForeground(T object, String propertyName) {
        return this.m_cellBackgroundColorProvider == null ? null : this.m_cellBackgroundColorProvider.getForeground(this, object, propertyName);
    }

    public final void setAdditionalFirstColumnInfo(String info) {
        this.m_additionalFirstColumnInfo = info;
    }

    public final String getSortProperty() {
        return this.m_sorter.getSortProperty();
    }

    public final Boolean isAscendingSort() {
        return this.m_sorter.isAscendingSort();
    }

    protected final PropertyTableSorter<T> getSorter() {
        return this.m_sorter;
    }

    protected int getItemCount() {
        return this.getTable().getItemCount();
    }

    private String getFirstColumnHeader(Collection<?> processedInput, int filteredSize) {
        assert (this.m_firstColumnTitle != null && this.m_firstColumnTitle.length() > 0) : "'m_firstColumnTitle' of method 'getFirstColumnHeader' must not be empty";
        if (processedInput != null) {
            if (this.m_additionalFirstColumnInfo != null) {
                return String.format("%s [%s] (%s)", this.m_firstColumnTitle, NumberUtility.format((Number)filteredSize), this.m_additionalFirstColumnInfo);
            }
            return String.format("%s [%s]", this.m_firstColumnTitle, NumberUtility.format((Number)filteredSize));
        }
        if (this.m_additionalFirstColumnInfo != null) {
            return String.format("%s (%s)", this.m_firstColumnTitle, this.m_additionalFirstColumnInfo);
        }
        return this.m_firstColumnTitle;
    }

    protected Collection<? extends T> getProcessedInput(Collection<? extends T> input) {
        return input == null ? Collections.emptyList() : input;
    }

    public final void showData(Collection<? extends T> input) {
        if (!this.isDisposed() && !this.m_tableViewer.getTable().isDisposed()) {
            this.setEnabled(false);
            this.setRedraw(false);
            this.m_firstScrollEvent = true;
            if (Platform.isLinux()) {
                TableItem[] tableItemArray = this.m_tableViewer.getTable().getItems();
                int n = tableItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem next = tableItemArray[n2];
                    next.setData(null);
                    ++n2;
                }
                this.m_tableViewer.getTable().removeAll();
                this.m_tableViewer.setInput(null);
            }
            Collection<? extends T> processedInput = this.getProcessedInput(input);
            this.m_tableViewer.setInput(processedInput);
            if (this.m_firstColumn != null) {
                this.m_firstColumn.setText(this.getFirstColumnHeader(processedInput, this.getItemCount()));
            }
            this.setRedraw(true);
            this.setEnabled(true);
        }
    }

    public Collection<T> getInputData() {
        return (Collection)this.m_tableViewer.getInput();
    }

    public Collection<? extends T> getFilteredInputData() {
        return this.getVisibleElements((Collection)this.m_tableViewer.getInput());
    }

    public final void refresh() {
        this.setRedraw(false);
        Collection input = (Collection)this.m_tableViewer.getInput();
        if (input != null) {
            this.m_tableViewer.refresh();
            if (this.m_firstColumn != null) {
                this.m_firstColumn.setText(this.getFirstColumnHeader(input, this.getItemCount()));
            }
        } else if (this.m_firstColumn != null) {
            this.m_firstColumn.setText(this.getFirstColumnHeader(input, 0));
        }
        this.setRedraw(true);
    }

    public final T getFirstVisibleEntry() {
        Table table = this.m_tableViewer.getTable();
        if (this.getItemCount() > 0) {
            TableItem tableItem = table.getItem(0);
            return (T)tableItem.getData();
        }
        return null;
    }

    public final void widgetDefaultSelected(SelectionEvent e) {
    }

    protected void sortPropertyChanged(String propertyName) {
        assert (propertyName != null) : "Parameter 'propertyName' of method 'sortPropertyChanged' must not be null";
        this.m_tableViewer.refresh();
    }

    public final void widgetSelected(SelectionEvent event) {
        assert (event != null) : "Parameter 'event' of method 'widgetSelected' must not be null";
        Widget widget = (Widget)event.getSource();
        if (widget instanceof ScrollBar) {
            if (this.m_firstScrollEvent) {
                if (!this.m_usedDefinedColumnSizes) {
                    this.adaptColumnSizes();
                }
                this.m_firstScrollEvent = false;
            }
        } else {
            String propertyName = (String)widget.getData(SORT);
            if (propertyName != null) {
                this.m_sorter.setSortBy(propertyName);
                Boolean isAscending = this.m_sorter.isAscendingSort();
                TableColumn column = (TableColumn)widget;
                this.m_tableViewer.getTable().setSortColumn(column);
                this.m_tableViewer.getTable().setSortDirection(Boolean.TRUE == isAscending ? 128 : 1024);
                this.sortPropertyChanged(propertyName);
            }
        }
    }

    public final boolean hasCopyToClipBoardData() {
        return !this.getSelected().isEmpty();
    }

    public final String getCopyToClipboardData() {
        StringBuilder builder = new StringBuilder();
        TableColumn[] tableColumnArray = this.m_tableViewer.getTable().getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn column = tableColumnArray[n2];
            String columnHeader = column.getToolTipText();
            builder.append(columnHeader).append(CSV_SEPARATOR);
            ++n2;
        }
        builder.append(StringUtility.LINE_SEPARATOR);
        for (T next : this.getSelected()) {
            TableColumn[] tableColumnArray2 = this.m_tableViewer.getTable().getColumns();
            int n3 = tableColumnArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                TableColumn column = tableColumnArray2[n4];
                String columnText = this.getColumnText(next, (String)column.getData());
                builder.append(columnText != null ? columnText : "").append(CSV_SEPARATOR);
                ++n4;
            }
            builder.append(StringUtility.LINE_SEPARATOR);
        }
        return builder.toString();
    }

    public final TableViewerColumn addEnumColumn(String title, String propertyName, String sortProperty, String imageProperty, int widthWeight, Class<? extends Enum<?>> enumClass) {
        TableViewerColumn enumColumn = this.addColumn(title, propertyName, sortProperty, imageProperty, widthWeight, ColumnType.TEXT);
        enumColumn.getColumn().setData(ENUM, enumClass);
        return enumColumn;
    }

    public void setFilters(ViewerFilter[] filters) {
        assert (filters != null) : "Parameter 'filters' of method 'setFilter' must not be null";
        this.m_tableViewer.setFilters(filters);
        this.setFilterBackground();
        this.refresh();
    }

    public ViewerFilter[] getFilters() {
        return this.m_tableViewer.getFilters();
    }

    protected final void setFilterBackground() {
        this.getTable().setBackground(this.isFiltered() ? UiResourceManager.getInstance().getViewHasFilteredElementsColor() : UiResourceManager.getInstance().getBackgroundColor());
    }

    public boolean isFiltered() {
        int unfilteredSize = 0;
        int filteredSize = this.getItemCount();
        Object input = this.getTableViewer().getInput();
        if (input instanceof Collection) {
            unfilteredSize = ((Collection)input).size();
        }
        return filteredSize < unfilteredSize;
    }

    public void resetFilters() {
        this.m_tableViewer.resetFilters();
        this.setFilterBackground();
        this.refresh();
    }

    public final <E extends Enum<E>> ViewerFilter createEnumFilter(String propertyName, EnumSet<E> allowedEnumValues) {
        assert (propertyName != null && propertyName.length() > 0) : "Parameter 'propertyName' of method 'createEnumFilter' must not be empty";
        assert (allowedEnumValues != null) : "Parameter 'allowedEnumValues' of method 'createEnumFilter' must not be null";
        assert (this.m_propertyReader.hasProperty(propertyName)) : "Cannot create enum filter for unknown property";
        return new PropertyTableEnumFilter<T, E>(propertyName, allowedEnumValues, this.m_propertyReader);
    }

    public final ViewerFilter createTextFilter(String propertyName, String text) {
        assert (propertyName != null && propertyName.length() > 0) : "Parameter 'propertyName' of method 'createTextFilter' must not be empty";
        assert (text != null) : "Parameter 'text' of method 'createTextFilter' must not be null";
        return new PropertyTableTextFilter<T>(propertyName, text, this.m_propertyReader);
    }

    @Override
    public final boolean isTextualColumn(int colIndex) {
        TableColumn column = this.m_tableViewer.getTable().getColumn(colIndex);
        assert (column != null) : "No column available for index " + colIndex;
        return (ColumnType)((Object)column.getData(COLUMN_TYPE)) != ColumnType.IMAGE;
    }

    public boolean hasInputData() {
        return !this.m_tableViewer.getTable().isDisposed() && this.m_tableViewer.getInput() != null && !((Collection)this.m_tableViewer.getInput()).isEmpty();
    }

    public static enum ColumnType {
        TEXT,
        NUMBER,
        DATE,
        IMAGE;

    }

    public static interface ICellColorProvider<T> {
        public Color getCellColor(PropertyTableViewer<T> var1, T var2, String var3);

        public Color getForeground(PropertyTableViewer<T> var1, T var2, String var3);
    }

    public static interface ICellImageProvider<T> {
        public Image getCellImage(PropertyTableViewer<T> var1, T var2, String var3, Image var4);
    }

    public static enum SelectionType {
        SINGLE_FULL_LINE,
        MULTI_FULL_LINE,
        SINGLE_COLUMN;

    }
}

