/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.base.workbench;

import com.hello2morrow.sonargraph.foundation.common.SwtResourceProviderAdapter;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;

public final class ModalDialog
implements IProgressMonitor {
    private static final int DIALOG_WIDTH = 500;
    private final Shell m_modalDialog;
    private final Label m_messages;
    private final ProgressBar m_progressBar;
    private int m_currentWorked;
    private boolean m_canceled;

    private static void locateParentCentered(Shell shell) {
        Shell parentShell;
        assert (shell != null) : "'shell' must not be null";
        Composite composite = shell.getParent();
        if (composite != null && (parentShell = composite.getShell()) != null) {
            Rectangle rect = shell.getBounds();
            Rectangle parentRect = parentShell.getBounds();
            int widthOffset = parentRect.width - rect.width;
            int heightOffset = parentRect.height - rect.height;
            if (widthOffset <= 0) {
                widthOffset = parentRect.width;
            }
            if (heightOffset <= 0) {
                heightOffset = parentRect.height;
            }
            Point parentShellLocation = parentShell.getLocation();
            int x = parentShellLocation.x + widthOffset / 2;
            int y = parentShellLocation.y + heightOffset / 2;
            shell.setLocation(x, y);
            return;
        }
    }

    public ModalDialog(Shell parentShell, String addToTitle, boolean providesProgress, boolean enableCancel) {
        assert (parentShell != null) : "Parameter 'parentShell' of method 'ModalDialog' must not be null";
        assert (addToTitle != null) : "Parameter 'addToTitle' of method 'ModalDialog' must not be null";
        this.m_modalDialog = new Shell(parentShell, 65584);
        this.m_modalDialog.setText(SwtResourceProviderAdapter.getInstance().getString("standalone.label.application.name", new Object[0]) + (String)(addToTitle.isEmpty() ? "" : " - " + addToTitle));
        this.m_modalDialog.setLayout((Layout)new GridLayout(1, false));
        this.m_modalDialog.setMinimumSize(100, 100);
        this.m_messages = new Label((Composite)this.m_modalDialog, 64);
        this.m_messages.setText("ADDLF" + StringUtility.LINE_SEPARATOR + "ADDLF" + StringUtility.LINE_SEPARATOR + "ADDLF");
        this.m_messages.setLayoutData((Object)new GridData(4, 4, true, true));
        this.m_messages.setBackground(UiResourceManager.getInstance().getBackgroundColor());
        if (providesProgress) {
            this.m_progressBar = new ProgressBar((Composite)this.m_modalDialog, 65792);
            this.m_progressBar.setLayoutData((Object)new GridData(4, 4, true, false));
        } else {
            this.m_progressBar = null;
        }
        if (enableCancel) {
            Button button = new Button((Composite)this.m_modalDialog, 8);
            button.setLayoutData((Object)new GridData(0x1000008, 0, true, false));
            button.setText("Cancel");
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ModalDialog.this.m_canceled = true;
                }
            });
        }
        this.m_modalDialog.addListener(31, new Listener(){

            public void handleEvent(Event event) {
                if (!$assertionsDisabled && event == null) {
                    throw new AssertionError((Object)"Parameter 'event' of method 'handleEvent' must not be null");
                }
                if (event.detail == 2) {
                    event.doit = false;
                }
            }
        });
        this.m_modalDialog.addListener(21, new Listener(){

            public void handleEvent(Event event) {
                if (!$assertionsDisabled && event == null) {
                    throw new AssertionError((Object)"Parameter 'event' of method 'handleEvent' must not be null");
                }
                event.doit = false;
            }
        });
        this.m_modalDialog.pack();
        Point size = new Point(500, this.m_modalDialog.getSize().y);
        this.m_modalDialog.setSize(size);
        this.m_modalDialog.setMinimumSize(size);
        this.m_messages.setText("");
        ModalDialog.locateParentCentered(this.m_modalDialog);
        this.m_modalDialog.open();
    }

    public void beginTask(String name, int totalWork) {
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'beginTask' must not be empty";
        this.m_messages.setText(name);
    }

    public void done() {
        if (!this.m_modalDialog.isDisposed()) {
            this.m_modalDialog.close();
            this.m_modalDialog.dispose();
        }
    }

    public void internalWorked(double work) {
    }

    public boolean isCanceled() {
        return this.m_canceled;
    }

    public void setCanceled(boolean value) {
        assert (false) : "'setCanceled' not supported";
    }

    public void setTaskName(String name) {
        assert (name != null) : "Parameter 'name' of method 'setTaskName' must not be null";
        if (!name.isEmpty() && !this.m_modalDialog.isDisposed()) {
            this.m_messages.setText(name);
        }
    }

    public void subTask(String name) {
        assert (name != null) : "Parameter 'name' of method 'subTask' must not be null";
        if (!name.isEmpty() && !this.m_modalDialog.isDisposed()) {
            this.m_messages.setText(name);
        }
    }

    public void worked(int work) {
        if (this.m_progressBar != null && work != 0 && !this.m_modalDialog.isDisposed()) {
            this.m_currentWorked += work;
            this.m_progressBar.setSelection(this.m_currentWorked);
        }
    }
}

