/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.base.workbench;

import com.hello2morrow.sonargraph.ui.swt.base.view.IContextMenuInteractionListener;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.IContextMenuContentProvider;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MenuHandler
implements IContextMenuInteractionListener,
MenuListener,
DisposeListener {
    private static Logger LOGGER = LoggerFactory.getLogger(MenuHandler.class);
    private final IContextMenuContentProvider m_provider;
    private final Control m_control;
    private Menu m_menu;

    public MenuHandler(IContextMenuContentProvider provider, Control control) {
        assert (provider != null) : "Parameter 'provider' of method 'MenuHandler' must not be null";
        assert (control != null) : "Parameter 'control' of method 'MenuHandler' must not be null";
        this.m_provider = provider;
        this.m_control = control;
        this.m_menu = new Menu(this.m_control);
        this.m_menu.addMenuListener((MenuListener)this);
        this.m_menu.addDisposeListener((DisposeListener)this);
        control.setMenu(this.m_menu);
        LOGGER.debug("Empty menu created");
    }

    private void disposeMenu() {
        if (this.m_menu != null) {
            this.m_menu.dispose();
            this.m_menu = null;
        }
    }

    public void menuShown(MenuEvent event) {
        assert (event != null) : "Parameter 'event' of method 'menuShown' must not be null";
        this.m_provider.aboutToShowContextMenu(this.m_menu, this.m_control, this);
        LOGGER.debug("Menu filled");
    }

    public void menuHidden(MenuEvent event) {
        if (!this.m_control.isDisposed()) {
            new MenuHandler(this.m_provider, this.m_control);
            Display display = this.m_control.getDisplay();
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    MenuHandler.this.disposeMenu();
                }
            });
        }
    }

    public void widgetDisposed(DisposeEvent event) {
        LOGGER.debug("Menu disposed");
    }

    @Override
    public void interactionFinished() {
        this.disposeMenu();
    }

    void dispose() {
        if (this.m_menu != null && !this.m_menu.isDisposed()) {
            this.m_menu.removeMenuListener((MenuListener)this);
            this.m_menu.removeDisposeListener((DisposeListener)this);
            this.m_menu.dispose();
        }
        this.m_menu = null;
    }
}

