/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.base.workbench;

import com.hello2morrow.sonargraph.core.model.context.IContext;
import com.hello2morrow.sonargraph.core.model.element.Element;

public interface IContextWorkbenchView {
    default public boolean areEqual(ContextAndElement<?> one, ContextAndElement<?> two) {
        if (one != null && two != null) {
            return one.equals(two);
        }
        return one == two;
    }

    public static final class ContextAndElement<T extends Element> {
        private final IContext m_context;
        private final T m_element;

        public ContextAndElement(IContext context, T element) {
            assert (context != null) : "Parameter 'context' of method 'ContextAndElement' must not be null";
            assert (element != null) : "Parameter 'element' of method 'ContextAndElement' must not be null";
            this.m_context = context;
            this.m_element = element;
        }

        public IContext getContext() {
            return this.m_context;
        }

        public T getElement() {
            return this.m_element;
        }

        public boolean isValid() {
            return this.m_context.isValid() && this.m_element.isValid();
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + this.m_context.hashCode();
            result = 31 * result + this.m_element.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            ContextAndElement other = (ContextAndElement)obj;
            return this.m_context.equals(other.m_context) && this.m_element.equals(other.m_element);
        }

        public String toString() {
            return "[" + this.getClass().getSimpleName() + "] " + String.valueOf(this.m_context) + ": " + String.valueOf(this.m_element);
        }
    }
}

