/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.base.workbench;

import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerCycleGroup;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.graphview.GraphViewOnDemand;
import com.hello2morrow.sonargraph.foundation.utilities.IStandardEnumeration;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import gnu.trove.set.hash.THashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;

public final class GraphViewShowInViewRequest
implements IStandardEnumeration {
    private final Type m_type;
    private final GraphViewOnDemand m_onDemand;
    private final Set<NamedElement> m_namedElements;
    private final AnalyzerCycleGroup m_cycleGroup;
    private final boolean m_expandCycles;

    public GraphViewShowInViewRequest(Type type, GraphViewOnDemand onDemand, Collection<NamedElement> namedElements, AnalyzerCycleGroup cycleGroup, boolean expandCycles) {
        assert (type != null) : "Parameter 'type' of method 'ExplorationViewShowInViewRequest' must not be null";
        assert (onDemand != null) : "Parameter 'onDemand' of method 'GraphViewShowInViewRequest' must not be null";
        assert (namedElements != null && !namedElements.isEmpty()) : "Parameter 'namedElements' of method 'GraphViewShowInViewRequest' must not be empty";
        this.m_type = type;
        this.m_onDemand = onDemand;
        this.m_namedElements = new THashSet(namedElements);
        this.m_cycleGroup = cycleGroup;
        this.m_expandCycles = expandCycles;
    }

    public Type getType() {
        return this.m_type;
    }

    public GraphViewOnDemand getOnDemand() {
        return this.m_onDemand;
    }

    public Set<NamedElement> getNamedElements() {
        return Collections.unmodifiableSet(this.m_namedElements);
    }

    public boolean expandCycles() {
        return this.m_expandCycles;
    }

    public AnalyzerCycleGroup getCycleGroup() {
        return this.m_cycleGroup;
    }

    public String getStandardName() {
        return this.m_type.getStandardName();
    }

    public String getPresentationName() {
        return this.m_type.getPresentationName();
    }

    String getImageResourceName() {
        return this.m_type.getImageResourceName();
    }

    public String toString() {
        return this.m_type.name();
    }

    public static final class Type
    extends Enum<Type>
    implements IStandardEnumeration {
        public static final /* enum */ Type ON_DEMAND_CYCLE = new Type("CycleView");
        private final String m_imageResourceName;
        private static final /* synthetic */ Type[] ENUM$VALUES;

        static {
            ENUM$VALUES = new Type[]{ON_DEMAND_CYCLE};
        }

        private Type(String imageResourceName) {
            assert (imageResourceName != null && imageResourceName.length() > 0) : "Parameter 'imageResourceName' of method 'Type' must not be empty";
            this.m_imageResourceName = imageResourceName;
        }

        public String getStandardName() {
            return StringUtility.convertConstantNameToStandardName((String)this.name());
        }

        public String getPresentationName() {
            return StringUtility.convertConstantNameToPresentationName((String)this.name());
        }

        String getImageResourceName() {
            return this.m_imageResourceName;
        }

        public static Type[] values() {
            Type[] typeArray = ENUM$VALUES;
            int n = typeArray.length;
            Type[] typeArray2 = new Type[n];
            System.arraycopy(ENUM$VALUES, 0, typeArray2, 0, n);
            return typeArray2;
        }

        public static Type valueOf(String string) {
            return Enum.valueOf(Type.class, string);
        }
    }
}

