/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.base.workbench;

import com.hello2morrow.sonargraph.core.model.common.SonargraphException;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.IExceptionHandlingSupport;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import java.util.Collection;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EclipseApplicationExceptionHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(EclipseApplicationExceptionHandler.class);
    protected static final String ORG_CODEHAUS_GROOVY_ECLIPSE_CORE = "org.codehaus.groovy.eclipse.core";
    protected static final String ORG_ECLIPSE_JDT_CORE = "org.eclipse.jdt.core";
    protected static final String ORG_ECLIPSE_CORE_NET = "org.eclipse.core.net";
    private static final String SEPARATOR = "+++++++++++++++++++++++++++++++++++++++++++++++++++++";
    private final IExceptionHandlingSupport m_exceptionHandlingSupport;
    private int m_lastHandledThrowableHashCode;
    private boolean m_alreadyShowingWarningOrErrorDialog;
    private boolean m_hasCriticalExceptionAlreadyOccurred;

    public EclipseApplicationExceptionHandler(IExceptionHandlingSupport exceptionHandlingSupport) {
        assert (exceptionHandlingSupport != null) : "Parameter 'exceptionHandlingSupport' of method 'EclipseApplicationExceptionHandler' must not be null";
        this.m_exceptionHandlingSupport = exceptionHandlingSupport;
    }

    public final void processException(final IStatus status, String plugin, final Throwable throwable) {
        assert (status != null) : "Parameter 'status' of method 'processException' must not be null";
        assert (plugin != null && plugin.length() > 0) : "Parameter 'plugin' of method 'processException' must not be empty";
        assert (throwable != null) : "Parameter 'throwable' of method 'processException' must not be null";
        if (this.exceptionHandledPriorToStandardHandling(status, plugin, throwable)) {
            return;
        }
        if (throwable.hashCode() == this.getLastHandledThrowableHashCode()) {
            return;
        }
        this.setLastHandledThrowableHashCode(throwable.hashCode());
        if (!this.isRelevant(plugin, status, throwable)) {
            LOGGER.debug("Filtered out exception as 'not relevant' (plugin/status): " + plugin + "/" + String.valueOf(status), throwable);
            return;
        }
        if (!this.isCritical(status)) {
            if (!this.m_alreadyShowingWarningOrErrorDialog && this.m_exceptionHandlingSupport.isRunning()) {
                this.m_alreadyShowingWarningOrErrorDialog = true;
                UserInterfaceAdapter.getInstance().displayUiElement(new Runnable(){

                    @Override
                    public void run() {
                        if (UserInterfaceAdapter.hasInstance()) {
                            UserInterfaceAdapter.getInstance().openDialog(4, EclipseApplicationExceptionHandler.this.convertTitle(status), EclipseApplicationExceptionHandler.this.convertDetailMessage(status));
                        }
                        EclipseApplicationExceptionHandler.this.m_alreadyShowingWarningOrErrorDialog = false;
                    }
                });
            }
            return;
        }
        if (throwable instanceof SonargraphException && ((SonargraphException)throwable).getSeverity() == SonargraphException.Severity.WARNING) {
            if (!this.m_alreadyShowingWarningOrErrorDialog && this.m_exceptionHandlingSupport.isRunning()) {
                this.m_alreadyShowingWarningOrErrorDialog = true;
                UserInterfaceAdapter.getInstance().displayUiElement(new Runnable(){

                    @Override
                    public void run() {
                        if (UserInterfaceAdapter.hasInstance()) {
                            SonargraphException exception = (SonargraphException)throwable;
                            UserInterfaceAdapter.getInstance().openDialog(4, EclipseApplicationExceptionHandler.this.convertTitle(status), exception.getLocalizedMessage());
                        }
                        EclipseApplicationExceptionHandler.this.m_alreadyShowingWarningOrErrorDialog = false;
                    }
                });
            }
            return;
        }
        if (this.m_hasCriticalExceptionAlreadyOccurred) {
            LOGGER.error(StringUtility.LINE_SEPARATOR + SEPARATOR + StringUtility.LINE_SEPARATOR + "THE ABOVE EXCEPTION FOLLOWS A PREVIOUS CRITICAL EXCEPTION!" + StringUtility.LINE_SEPARATOR + SEPARATOR + StringUtility.LINE_SEPARATOR);
        }
        this.m_hasCriticalExceptionAlreadyOccurred = true;
        if (!this.m_alreadyShowingWarningOrErrorDialog && this.m_exceptionHandlingSupport.isRunning()) {
            this.m_alreadyShowingWarningOrErrorDialog = true;
            ISoftwareSystemProvider systemProvider = this.m_exceptionHandlingSupport.getSoftwareSystemProvider();
            if (systemProvider != null && systemProvider.hasSoftwareSystem()) {
                SoftwareSystem softwareSystem = this.m_exceptionHandlingSupport.getSoftwareSystemProvider().getSoftwareSystem();
                Collection languages = softwareSystem.getUsedLanguages().stream().map(language -> language.getPresentationName()).collect(Collectors.toList());
                LOGGER.error(StringUtility.LINE_SEPARATOR + SEPARATOR + StringUtility.LINE_SEPARATOR + "Error occurred while working with system [" + softwareSystem.getName() + "] using languages [" + StringUtility.concat((Collection)languages, (String)StringUtility.LINE_SEPARATOR) + "]" + StringUtility.LINE_SEPARATOR + SEPARATOR);
            } else {
                LOGGER.error(StringUtility.LINE_SEPARATOR + SEPARATOR + StringUtility.LINE_SEPARATOR + "Error occurred while working with no system opened." + StringUtility.LINE_SEPARATOR + SEPARATOR + StringUtility.LINE_SEPARATOR);
            }
            UserInterfaceAdapter.getInstance().displayUiElement(new Runnable(){

                @Override
                public void run() {
                    EclipseApplicationExceptionHandler.this.handleFeedbackInteraction(status, throwable);
                    EclipseApplicationExceptionHandler.this.m_alreadyShowingWarningOrErrorDialog = false;
                }
            });
        }
    }

    protected boolean exceptionHandledPriorToStandardHandling(IStatus status, String plugin, Throwable throwable) {
        assert (status != null) : "Parameter 'status' of method 'exceptionHandledPriorToStandardHandling' must not be null";
        assert (plugin != null && plugin.length() > 0) : "Parameter 'plugin' of method 'exceptionHandledPriorToStandardHandling' must not be empty";
        assert (throwable != null) : "Parameter 'throwable' of method 'exceptionHandledPriorToStandardHandling' must not be null";
        return false;
    }

    protected abstract void handleFeedbackInteraction(IStatus var1, Throwable var2);

    protected abstract boolean isRelevant(String var1, IStatus var2, Throwable var3);

    protected boolean isCritical(IStatus status) {
        assert (status != null) : "Parameter 'status' of method 'isCritical' must not be null";
        return !status.getPlugin().equals(ORG_ECLIPSE_CORE_NET);
    }

    protected final IExceptionHandlingSupport getExceptionHandlingSupport() {
        return this.m_exceptionHandlingSupport;
    }

    protected final boolean alreadyShowingWarningOrErrorDialog() {
        return this.m_alreadyShowingWarningOrErrorDialog;
    }

    protected final void setAlreadyShowingWarningOrErrorDialog(boolean alreadyShowingWarningOrErrorDialog) {
        this.m_alreadyShowingWarningOrErrorDialog = alreadyShowingWarningOrErrorDialog;
    }

    protected final void setHasCriticalExceptionAlreadyOccurred(boolean hasCriticalExceptionAlreadyOccurred) {
        this.m_hasCriticalExceptionAlreadyOccurred = hasCriticalExceptionAlreadyOccurred;
    }

    protected final boolean hasCriticalExceptionAlreadyOccurred() {
        return this.m_hasCriticalExceptionAlreadyOccurred;
    }

    protected final int getLastHandledThrowableHashCode() {
        return this.m_lastHandledThrowableHashCode;
    }

    protected final void setLastHandledThrowableHashCode(int lastHandledThrowableHashCode) {
        this.m_lastHandledThrowableHashCode = lastHandledThrowableHashCode;
    }

    private String convertDetailMessage(IStatus status) {
        assert (status != null) : "Parameter 'status' of method 'convertDetailMessage' must not be null";
        if (status.getPlugin().equals(ORG_ECLIPSE_CORE_NET)) {
            return "Please check your proxy configuration.\n\nError:\n" + status.getMessage();
        }
        return status.getMessage();
    }

    private String convertTitle(IStatus status) {
        assert (status != null) : "Parameter 'status' of method 'convertTitle' must not be null";
        if (status.getPlugin().equals(ORG_ECLIPSE_CORE_NET)) {
            return "Network Connection Problem";
        }
        if (status.getSeverity() == 2) {
            return "Warning";
        }
        return "Error";
    }
}

