/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.base.wizard;

import com.hello2morrow.sonargraph.ui.swt.base.wizard.SonargraphWizardAdapter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.contributions.IContributionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WizardRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(WizardRegistry.class);
    private static final String EXTENSION_POINT = "com.hello2morrow.sonargraph.ui.swt.wizards";
    private static final String ELEMENT_WIZARD_ADAPTER = "wizardAdapter";
    private static final String ATTRIBUTE_CLASS = "class";
    private static WizardRegistry s_instance;
    private final Map<String, SonargraphWizardAdapter> m_nameToWizardAdapter = new LinkedHashMap<String, SonargraphWizardAdapter>();
    private final List<SonargraphWizardAdapter> m_wizardAdapters;
    private final IEclipseContext m_eclipseContext;

    private WizardRegistry(IEclipseContext eclipseContext) {
        assert (eclipseContext != null) : "Parameter 'eclipseContext' of method 'WizardRegistry' must not be null";
        this.m_eclipseContext = eclipseContext;
        IExtensionRegistry extensionRegistry = (IExtensionRegistry)this.m_eclipseContext.get(IExtensionRegistry.class);
        IContributionFactory factory = (IContributionFactory)this.m_eclipseContext.get(IContributionFactory.class);
        IExtensionPoint[] iExtensionPointArray = extensionRegistry.getExtensionPoints();
        int n = iExtensionPointArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtensionPoint ep = iExtensionPointArray[n2];
            LOGGER.debug("Extension Point {}", (Object)ep.getLabel());
            ++n2;
        }
        IExtensionPoint theEp = extensionRegistry.getExtensionPoint(EXTENSION_POINT);
        LOGGER.debug("The Extension point is label: {}, namespace: {}, simple: {}, unique: {}", new Object[]{theEp.getLabel(), theEp.getNamespaceIdentifier(), theEp.getSimpleIdentifier(), theEp.getUniqueIdentifier()});
        IConfigurationElement[] configurationElements = extensionRegistry.getConfigurationElementsFor(EXTENSION_POINT);
        LOGGER.debug("Found {} configuration elements for extension point {}", (Object)configurationElements.length, (Object)EXTENSION_POINT);
        IConfigurationElement[] iConfigurationElementArray = configurationElements;
        int n3 = configurationElements.length;
        int n4 = 0;
        while (n4 < n3) {
            IConfigurationElement nextConfigurationElement = iConfigurationElementArray[n4];
            String bundleId = nextConfigurationElement.getNamespaceIdentifier();
            LOGGER.debug("Configuration element {} found for bundleId {}", (Object)nextConfigurationElement.getName(), (Object)bundleId);
            if (nextConfigurationElement.getName().equals(ELEMENT_WIZARD_ADAPTER)) {
                LOGGER.debug("Name is {} as expected", (Object)ELEMENT_WIZARD_ADAPTER);
                String clazz = nextConfigurationElement.getAttribute(ATTRIBUTE_CLASS);
                if (clazz != null && !clazz.isEmpty()) {
                    LOGGER.debug("Class name is {}", (Object)clazz);
                    Object object = factory.create("bundleclass://" + bundleId + "/" + clazz, this.m_eclipseContext);
                    assert (object != null && object instanceof SonargraphWizardAdapter) : "Unexpected class in method 'getWizards': " + String.valueOf(object);
                    SonargraphWizardAdapter nextWizard = (SonargraphWizardAdapter)object;
                    String nextWizardName = nextWizard.getName();
                    SonargraphWizardAdapter alreadyPresentWizard = this.m_nameToWizardAdapter.put(nextWizardName, nextWizard);
                    assert (alreadyPresentWizard == null) : "Wizard already registered: " + nextWizardName;
                } else assert (false) : "Expected element: class: " + clazz;
            } else assert (false) : "Expected element: wizardAdapter";
            ++n4;
        }
        this.m_wizardAdapters = new ArrayList<SonargraphWizardAdapter>(this.m_nameToWizardAdapter.values());
        this.m_wizardAdapters.sort(new Comparator<SonargraphWizardAdapter>(){

            @Override
            public int compare(SonargraphWizardAdapter w1, SonargraphWizardAdapter w2) {
                if (!$assertionsDisabled && w1 == null) {
                    throw new AssertionError((Object)"Parameter 'w1' of method 'compare' must not be null");
                }
                if (!$assertionsDisabled && w2 == null) {
                    throw new AssertionError((Object)"Parameter 'w2' of method 'compare' must not be null");
                }
                if (!$assertionsDisabled && w1 == w2) {
                    throw new AssertionError((Object)"Same instances");
                }
                int compared = w1.getCategory().ordinal() - w2.getCategory().ordinal();
                if (compared == 0 && (compared = w1.getBundleId().compareTo(w2.getBundleId())) == 0) {
                    compared = 1;
                }
                return compared;
            }
        });
        LOGGER.debug("WizardRegistry holds {} wizards", (Object)this.m_wizardAdapters.size());
    }

    public static void createInstance(IEclipseContext eclipseContext) {
        assert (!WizardRegistry.hasInstance()) : "Instance already created";
        s_instance = new WizardRegistry(eclipseContext);
    }

    public static boolean hasInstance() {
        return s_instance != null;
    }

    public static WizardRegistry getInstance() {
        assert (WizardRegistry.hasInstance()) : "Instance not created";
        return s_instance;
    }

    public static void delete() {
        if (s_instance != null) {
            s_instance = null;
        }
    }

    public SonargraphWizardAdapter getWizardAdapter(String name) {
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'getWizard' must not be empty";
        SonargraphWizardAdapter wizard = this.m_nameToWizardAdapter.get(name);
        assert (wizard != null) : "Parameter 'wizard' of method 'getWizard' must not be null";
        return wizard;
    }

    public List<SonargraphWizardAdapter> getWizardAdapters() {
        return Collections.unmodifiableList(this.m_wizardAdapters);
    }
}

