/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.base.view;

import com.hello2morrow.sonargraph.foundation.utilities.Platform;
import com.hello2morrow.sonargraph.ui.swt.base.SwtUtility;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

final class TreeTextFilterWidget
extends Composite {
    private final Text m_filterTextField;

    TreeTextFilterWidget(Composite parent, final ITextFilterCallback callback) {
        super(parent, 0);
        assert (callback != null) : "Parameter 'callback' of method 'TextFilterWidget' must not be null";
        GridLayout filterLayout = SwtUtility.createMultipleRootWidgetGridLayoutWithoutMargin(4);
        this.setLayout((Layout)filterLayout);
        this.m_filterTextField = new Text((Composite)this, 2948);
        this.m_filterTextField.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        this.m_filterTextField.addTraverseListener(e -> {
            switch (e.detail) {
                case 2: 
                case 4: {
                    e.doit = false;
                }
            }
        });
        Point preferredSize = this.m_filterTextField.computeSize(-1, -1);
        int height = preferredSize.y + 2;
        Button filterButton = new Button((Composite)this, 8);
        filterButton.setToolTipText("Apply text as filter to shown elements");
        filterButton.setImage(UiResourceManager.getInstance().getImage("Filter"));
        filterButton.setLayoutData((Object)this.createFilterButtonGridData(height));
        final Button leafsOnly = new Button((Composite)this, 2);
        leafsOnly.setToolTipText("Search for leaf elements only");
        leafsOnly.setImage(UiResourceManager.getInstance().getImage("LeafsOnly"));
        leafsOnly.setLayoutData((Object)this.createFilterButtonGridData(height));
        leafsOnly.setSelection(true);
        this.m_filterTextField.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                callback.applyTextFilter(TreeTextFilterWidget.this.m_filterTextField.getText(), leafsOnly.getSelection());
            }
        });
        this.m_filterTextField.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent event) {
                if (event.detail == 256) {
                    callback.applyTextFilter("", leafsOnly.getSelection());
                } else {
                    callback.applyTextFilter(TreeTextFilterWidget.this.m_filterTextField.getText(), leafsOnly.getSelection());
                }
            }
        });
        filterButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                callback.applyTextFilter(TreeTextFilterWidget.this.m_filterTextField.getText(), leafsOnly.getSelection());
            }
        });
        leafsOnly.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String imageName = leafsOnly.getSelection() ? "LeafsOnly" : "LeafsOnlyInactive";
                leafsOnly.setImage(UiResourceManager.getInstance().getImage(imageName));
                callback.applyTextFilter(TreeTextFilterWidget.this.m_filterTextField.getText(), leafsOnly.getSelection());
            }
        });
    }

    public Text getFilterText() {
        return this.m_filterTextField;
    }

    private GridData createFilterButtonGridData(int height) {
        GridData filterButtonGridData = new GridData(0x1000000, 0x1000000, false, false);
        if (Platform.isWindows()) {
            filterButtonGridData.heightHint = height;
            filterButtonGridData.widthHint = height;
        }
        return filterButtonGridData;
    }

    public static interface ITextFilterCallback {
        public void applyTextFilter(String var1, boolean var2);
    }
}

