/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.base.textsearch;

import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.ui.swt.base.textsearch.BaseTextSearchHandler;
import com.hello2morrow.sonargraph.ui.swt.base.textsearch.OffsetBasedSelectedTextInfo;
import com.hello2morrow.sonargraph.ui.swt.base.textsearch.OffsetBasedTextSearchData;
import com.hello2morrow.sonargraph.ui.swt.base.textsearch.SelectedTextInfo;
import com.hello2morrow.sonargraph.ui.swt.base.textsearch.TextSearchData;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import org.eclipse.swt.custom.StyledText;

public abstract class SourceBasedTextSearchHandler
extends BaseTextSearchHandler {
    private final StyledText m_styledText;
    private final boolean m_supportsReplace;

    public SourceBasedTextSearchHandler(StyledText styledText, boolean supportsReplace, String connectedTo) {
        super(connectedTo);
        assert (styledText != null) : "Parameter 'styledText' of method 'SourceBasedTextSearchHandler' must not be null";
        this.m_styledText = styledText;
        this.m_supportsReplace = supportsReplace;
    }

    @Override
    public boolean canConnect() {
        return !this.m_styledText.isDisposed();
    }

    @Override
    public boolean isTextSearchDataCompatible(TextSearchData textSearchData) {
        assert (textSearchData != null) : "Parameter 'textSearchData' of method 'isTextSearchDataCompatible' must not be null";
        return textSearchData instanceof OffsetBasedTextSearchData;
    }

    @Override
    protected void onCheckWholeWordClicked(TextSearchData textSearchData) {
    }

    @Override
    protected void onCheckCaseSensitiveClicked(TextSearchData textSearchData) {
    }

    @Override
    protected void onCheckRegularExpressionClicked(TextSearchData textSearchData) {
    }

    @Override
    protected void onButtonReplaceAllClicked(TextSearchData textSearchData) {
        assert (textSearchData != null && textSearchData instanceof OffsetBasedTextSearchData) : "Unexpected class in method 'onButtonReplaceAllClicked': " + String.valueOf(textSearchData);
        OffsetBasedTextSearchData offsetBasedTextSearchData = (OffsetBasedTextSearchData)textSearchData;
        int offset = this.replaceAll(offsetBasedTextSearchData.getSearchText(), offsetBasedTextSearchData.getCurrentOffset(), offsetBasedTextSearchData.isCaseSensitive(), offsetBasedTextSearchData.isWholeWord(), offsetBasedTextSearchData.isRegularExpression(), offsetBasedTextSearchData.getReplaceText());
        offsetBasedTextSearchData.setCurrentOffset(offset);
        offsetBasedTextSearchData.setSelectedTextInfo(this.getSelectedTextInfo());
    }

    @Override
    protected void onButtonReplaceClicked(TextSearchData textSearchData) {
        assert (textSearchData != null && textSearchData instanceof OffsetBasedTextSearchData) : "Unexpected class in method 'onButtonReplaceClicked': " + String.valueOf(textSearchData);
        OffsetBasedTextSearchData offsetBasedTextSearchData = (OffsetBasedTextSearchData)textSearchData;
        int offset = this.replace(offsetBasedTextSearchData.getSearchText(), offsetBasedTextSearchData.getCurrentOffsetOfSelectedText(), offsetBasedTextSearchData.getCurrentOffset(), offsetBasedTextSearchData.isCaseSensitive(), offsetBasedTextSearchData.isWholeWord(), offsetBasedTextSearchData.isRegularExpression(), offsetBasedTextSearchData.getReplaceText(), false);
        offsetBasedTextSearchData.setCurrentOffset(offset);
        offsetBasedTextSearchData.setSelectedTextInfo(this.getSelectedTextInfo());
    }

    @Override
    protected void onButtonReplaceFindClicked(TextSearchData textSearchData) {
        assert (textSearchData != null && textSearchData instanceof OffsetBasedTextSearchData) : "Unexpected class in method 'onButtonReplaceFindClicked': " + String.valueOf(textSearchData);
        OffsetBasedTextSearchData offsetBasedTextSearchData = (OffsetBasedTextSearchData)textSearchData;
        int offset = this.replace(offsetBasedTextSearchData.getSearchText(), offsetBasedTextSearchData.getCurrentOffsetOfSelectedText(), offsetBasedTextSearchData.getCurrentOffset(), offsetBasedTextSearchData.isCaseSensitive(), offsetBasedTextSearchData.isWholeWord(), offsetBasedTextSearchData.isRegularExpression(), offsetBasedTextSearchData.getReplaceText(), true);
        offsetBasedTextSearchData.setCurrentOffset(offset);
        offsetBasedTextSearchData.setSelectedTextInfo(this.getSelectedTextInfo());
    }

    @Override
    protected void onButtonFindClicked(TextSearchData textSearchData) {
        assert (textSearchData != null && textSearchData instanceof OffsetBasedTextSearchData) : "Unexpected class in method 'onButtonFindClicked': " + String.valueOf(textSearchData);
        OffsetBasedTextSearchData offsetBasedTextSearchData = (OffsetBasedTextSearchData)textSearchData;
        int offset = this.findText(offsetBasedTextSearchData.getSearchText(), offsetBasedTextSearchData.getCurrentOffset(), offsetBasedTextSearchData.isCaseSensitive(), offsetBasedTextSearchData.isWholeWord(), offsetBasedTextSearchData.isRegularExpression());
        offsetBasedTextSearchData.setCurrentOffset(offset);
        offsetBasedTextSearchData.setSelectedTextInfo(this.getSelectedTextInfo());
    }

    @Override
    protected void onRevealNextOccurrence(TextSearchData textSearchData) {
        assert (textSearchData != null && textSearchData instanceof OffsetBasedTextSearchData) : "Unexpected class in method 'onRevealNextOccurrence': " + String.valueOf(textSearchData);
        OffsetBasedTextSearchData offsetBasedTextSearchData = (OffsetBasedTextSearchData)textSearchData;
        offsetBasedTextSearchData.setCurrentOffset(this.getCurrentSearchPosition());
        int offset = this.findText(offsetBasedTextSearchData.getSearchText(), offsetBasedTextSearchData.getCurrentOffset(), offsetBasedTextSearchData.isCaseSensitive(), offsetBasedTextSearchData.isWholeWord(), offsetBasedTextSearchData.isRegularExpression());
        offsetBasedTextSearchData.setCurrentOffset(offset);
    }

    @Override
    protected void onConnect(TextSearchData textSearchData) {
        assert (textSearchData != null) : "Parameter 'textSearchData' of method 'onConnect' must not be null";
        OffsetBasedTextSearchData offsetBasedTextSearchData = (OffsetBasedTextSearchData)textSearchData;
        offsetBasedTextSearchData.setSelectedTextInfo(this.getSelectedTextInfo());
        offsetBasedTextSearchData.setCurrentOffset(this.getCurrentSearchPosition());
    }

    @Override
    protected void onReset(TextSearchData textSearchData) {
        assert (textSearchData != null && textSearchData instanceof OffsetBasedTextSearchData) : "Unexpected class in method 'onReset': " + String.valueOf(textSearchData);
        OffsetBasedTextSearchData offsetBasedTextSearchData = (OffsetBasedTextSearchData)textSearchData;
        OffsetBasedSelectedTextInfo selectedTextInfo = (OffsetBasedSelectedTextInfo)this.getSelectedTextInfo();
        offsetBasedTextSearchData.setSearchText(selectedTextInfo.getSelectedText());
        offsetBasedTextSearchData.setSelectedTextInfo(selectedTextInfo);
        offsetBasedTextSearchData.setCurrentOffset(this.getCurrentSearchPosition());
    }

    @Override
    protected abstract SelectedTextInfo getSelectedTextInfo();

    @Override
    protected abstract int calculatePositionForFind();

    @Override
    protected int getCurrentSearchPosition() {
        int findInfo = this.calculatePositionForFind();
        this.setCurrentSearchPosition(findInfo);
        return findInfo;
    }

    @Override
    protected TextSearchData createTextSearchData(SelectedTextInfo selectedTextInfo) {
        return new OffsetBasedTextSearchData(selectedTextInfo.getSelectedText(), this.getCurrentSearchPosition(), (OffsetBasedSelectedTextInfo)selectedTextInfo);
    }

    private int replace(String searchText, int startOffsetOfSearchText, int currentOffset, boolean caseSensitive, boolean wholeWord, boolean regex, String newText, boolean find) {
        return this.replace(startOffsetOfSearchText, currentOffset, searchText, caseSensitive, wholeWord, regex, newText, find);
    }

    private final int replaceAll(String searchText, int currentOffset, boolean caseSensistive, boolean wholeWord, boolean regex, String newText) {
        return this.replaceAll(currentOffset, searchText, caseSensistive, wholeWord, regex, newText);
    }

    @Override
    public boolean supportsReplace() {
        return this.m_supportsReplace;
    }

    @Override
    public boolean isReplacePossible(TextSearchData textSearchData) {
        assert (textSearchData != null) : "Parameter 'textSearchData' of method 'isReplacePossible' must not be null";
        if (!this.m_supportsReplace) {
            return false;
        }
        if (textSearchData.isFindPossible() && !textSearchData.getSelectedTextInfo().isEmpty() && (!textSearchData.isWholeWord() || textSearchData.getSelectedTextInfo().isWord())) {
            String selectedText = textSearchData.getSelectedTextInfo().getSelectedText();
            String searchText = textSearchData.getSearchText();
            if (!textSearchData.isRegularExpression()) {
                if (textSearchData.isCaseSensitive()) {
                    return selectedText.equals(searchText);
                }
                return selectedText.toLowerCase().equals(searchText.toLowerCase());
            }
            try {
                Matcher matcher = this.createMatcher(selectedText, searchText, textSearchData.isCaseSensitive(), false, true);
                try {
                    String replacement = matcher.replaceFirst(this.escapeReplacementText(textSearchData.getReplaceText()));
                    return !selectedText.equals(replacement);
                }
                catch (Exception exception) {
                    return false;
                }
            }
            catch (Exception exception) {
                return false;
            }
        }
        return false;
    }

    @Override
    protected int find(int currentOffset, String searchText, boolean caseSensitive, boolean wholeWord, boolean regexp) {
        boolean fromOffsetZero;
        assert (searchText != null && searchText.length() > 0) : "Parameter 'searchText' of method 'findOrReplaceText2' must not be empty";
        String content = this.m_styledText.getText();
        Matcher matcher = this.createMatcher(content, searchText, caseSensitive, wholeWord, regexp);
        int newOffset = this.find(this.m_styledText, currentOffset, content, searchText, matcher, true);
        boolean bl = fromOffsetZero = currentOffset == 0;
        if (newOffset == -1 && !fromOffsetZero) {
            newOffset = this.find(this.m_styledText, 0, content, searchText, matcher, true);
        }
        return newOffset == -1 ? currentOffset : newOffset;
    }

    private int find(StyledText source, int currentOffset, String content, String searchText, Matcher matcher, boolean setSelection) {
        assert (source != null) : "Parameter 'source' of method 'find' must not be null";
        assert (currentOffset >= 0) : "Offset negative";
        assert (content != null) : "Parameter 'content' of method 'find' must not be null";
        assert (searchText != null) : "Parameter 'searchText' of method 'find' must not be null";
        assert (matcher != null) : "Parameter 'matcher' of method 'find' must not be null";
        if (matcher.find(currentOffset)) {
            currentOffset = matcher.end();
            if (setSelection) {
                source.setSelection(matcher.start(), matcher.end());
            }
            return currentOffset;
        }
        return -1;
    }

    private int replace(int startOffsetOfSearchText, int currentOffset, String searchText, boolean caseSensitive, boolean wholeWord, boolean regex, String newText, boolean find) {
        assert (currentOffset >= 0) : "Offset negative";
        assert (searchText != null && searchText.length() > 0) : "Parameter 'searchText' of method 'replace' must not be empty";
        assert (newText != null) : "Parameter 'newText' of method 'replace' must not be null";
        assert (!searchText.equals(newText)) : "Search text equals new text";
        String content = this.m_styledText.getText();
        int searchTextLength = searchText.length();
        Matcher matcher = this.createMatcher(content, searchText, caseSensitive, wholeWord, regex);
        int endOffsetOfMatch = this.find(this.m_styledText, startOffsetOfSearchText, content, searchText, matcher, true);
        assert (endOffsetOfMatch != -1) : "No match";
        this.m_styledText.setRedraw(false);
        if (!regex) {
            int startOffset = endOffsetOfMatch - searchTextLength;
            this.m_styledText.replaceTextRange(startOffset, searchTextLength, this.escapeReplacementText(newText));
        } else {
            MatchResult matchResult = matcher.toMatchResult();
            String match = content.substring(matchResult.start(), matchResult.end());
            Matcher regexMatcher = this.createMatcher(match, searchText, caseSensitive, wholeWord, regex);
            String replacement = regexMatcher.replaceFirst(this.escapeReplacementText(newText));
            this.m_styledText.replaceTextRange(matchResult.start(), match.length(), replacement);
        }
        this.m_styledText.setRedraw(true);
        int newOffset = this.m_styledText.getCaretOffset();
        if (!find) {
            return newOffset;
        }
        return this.find(newOffset, searchText, caseSensitive, wholeWord, regex);
    }

    private int replaceAll(int currentOffset, String searchText, boolean caseSensitive, boolean wholeWord, boolean regex, String newText) {
        assert (currentOffset >= 0) : "Offset negative";
        assert (searchText != null && searchText.length() > 0) : "Parameter 'searchText' of method 'replace' must not be empty";
        assert (newText != null) : "Parameter 'newText' of method 'replaceAll' must not be null";
        assert (!searchText.equals(newText)) : "Search text equals new text";
        String currentContent = this.m_styledText.getText();
        Matcher matcher = this.createMatcher(currentContent, searchText, caseSensitive, wholeWord, regex);
        this.m_styledText.setRedraw(false);
        String replacementText = this.escapeReplacementText(newText);
        String replaceContent = matcher.replaceAll(replacementText);
        this.m_styledText.setText(replaceContent);
        this.m_styledText.setRedraw(true);
        return currentOffset > replaceContent.length() - 1 ? replaceContent.length() - 1 : currentOffset;
    }

    private String escapeReplacementText(String text) {
        return text.replace("\\R", StringUtility.LINE_SEPARATOR);
    }

    protected final StyledText getStyledText() {
        return this.m_styledText;
    }
}

