/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.base.textsearch;

import com.hello2morrow.sonargraph.core.foundation.common.base.ValidationResult;
import com.hello2morrow.sonargraph.ui.swt.base.textsearch.ITextSearchHandler;
import com.hello2morrow.sonargraph.ui.swt.base.textsearch.SelectedTextInfo;
import com.hello2morrow.sonargraph.ui.swt.base.textsearch.TextSearchData;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public abstract class BaseTextSearchHandler
implements ITextSearchHandler {
    private static final String TO_BE_ESCAPED = "\\.{}[]$()+*-?^$|";
    private static final String WORD_BOUNDARY = "(\\b)";
    private final String m_connectedTo;
    private int m_currentPositionForSearch;
    private boolean m_newFindInfo = false;

    public BaseTextSearchHandler(String connectedTo) {
        assert (connectedTo != null && connectedTo.length() > 0) : "Parameter 'connectedTo' of method 'BaseTextSearchHandler' must not be empty";
        this.m_connectedTo = connectedTo;
    }

    private static String escape(String input) {
        assert (input != null) : "Parameter 'input' of method 'escape' must not be null";
        StringBuilder escapedInput = new StringBuilder();
        int i = 0;
        while (i < input.length()) {
            char c = input.charAt(i);
            if (TO_BE_ESCAPED.indexOf(c) != -1) {
                escapedInput.append("\\");
                escapedInput.append(c);
            } else {
                escapedInput.append(c);
            }
            ++i;
        }
        return escapedInput.toString();
    }

    protected final Matcher createMatcher(String content, String searchText, boolean caseSensistive, boolean wholeWord, boolean regex) {
        Pattern pattern;
        assert (content != null) : "Parameter 'content' of method 'createMatcher' must not be null";
        assert (searchText != null) : "Parameter 'searchText' of method 'createMatcher' must not be null";
        if (!regex) {
            String escapedSearchText = BaseTextSearchHandler.escape(searchText);
            Object usedPattern = wholeWord ? WORD_BOUNDARY + escapedSearchText + WORD_BOUNDARY : escapedSearchText;
            pattern = caseSensistive ? Pattern.compile((String)usedPattern) : Pattern.compile((String)usedPattern, 2);
        } else {
            pattern = caseSensistive ? Pattern.compile(searchText) : Pattern.compile(searchText, 2);
        }
        return pattern.matcher(content);
    }

    @Override
    public ValidationResult isValidRegularSearchExpression(String regex) {
        assert (regex != null) : "Parameter 'regex' of method 'isValidRegularExpression' must not be null";
        ValidationResult result = new ValidationResult(true);
        try {
            Pattern.compile(regex);
        }
        catch (PatternSyntaxException ex) {
            result.addError(ex.getMessage());
        }
        return result;
    }

    @Override
    public ValidationResult isValidRegularReplaceExpression(String searchText, String replacement, String textToMatch) {
        assert (searchText != null) : "Parameter 'searchText' of method 'isValidRegularReplaceExpression' must not be null";
        assert (replacement != null) : "Parameter 'replacement' of method 'isValidRegularReplaceExpression' must not be null";
        assert (textToMatch != null) : "Parameter 'textToMatch' of method 'isValidRegularReplaceExpression' must not be null";
        ValidationResult result = new ValidationResult(true);
        try {
            Matcher matcher = Pattern.compile(searchText).matcher(textToMatch);
            try {
                matcher.replaceFirst(replacement);
            }
            catch (Exception ex) {
                result.addError(ex.getMessage());
            }
        }
        catch (Exception exception) {}
        return result;
    }

    @Override
    public final TextSearchData getTextSearchData() {
        SelectedTextInfo selectedTextInfo = this.getSelectedTextInfo();
        return this.createTextSearchData(selectedTextInfo);
    }

    @Override
    public final void updateTextSearchData(TextSearchData textSearchData, ITextSearchHandler.UpdateOperation updateOperation) {
        assert (textSearchData != null) : "Parameter 'textSearchData' of method 'updateTextSearchData' must not be null";
        assert (updateOperation != null) : "Parameter 'updateOperation' of method 'updateTextSearchData' must not be null";
        switch (updateOperation) {
            case RESET: {
                this.onReset(textSearchData);
                break;
            }
            case CONNECT: {
                this.onConnect(textSearchData);
                break;
            }
            case REVEAL_NEXT_OCCURRENCE: {
                this.onRevealNextOccurrence(textSearchData);
                break;
            }
            case BUTTON_FIND_CLICKED: {
                this.onButtonFindClicked(textSearchData);
                break;
            }
            case BUTTON_REPLACE_FIND_CLICKED: {
                this.onButtonReplaceFindClicked(textSearchData);
                break;
            }
            case BUTTON_REPLACE_CLICKED: {
                this.onButtonReplaceClicked(textSearchData);
                break;
            }
            case BUTTON_REPLACE_ALL_CLICKED: {
                this.onButtonReplaceAllClicked(textSearchData);
                break;
            }
            case CHECK_CASE_SENSITIVE_CLICKED: {
                this.onCheckCaseSensitiveClicked(textSearchData);
                break;
            }
            case CHECK_WHOLE_WORD_CLICKED: {
                this.onCheckWholeWordClicked(textSearchData);
                break;
            }
            case CHECK_REGULAR_EXPRESSION_CLICKED: {
                this.onCheckRegularExpressionClicked(textSearchData);
                break;
            }
            default: {
                assert (false) : "Unexpected updateOperation '" + String.valueOf((Object)updateOperation) + "'";
                break;
            }
        }
    }

    protected abstract void onCheckWholeWordClicked(TextSearchData var1);

    protected abstract void onCheckCaseSensitiveClicked(TextSearchData var1);

    protected abstract void onCheckRegularExpressionClicked(TextSearchData var1);

    protected abstract void onButtonReplaceAllClicked(TextSearchData var1);

    protected abstract void onButtonReplaceClicked(TextSearchData var1);

    protected abstract void onButtonReplaceFindClicked(TextSearchData var1);

    protected abstract void onButtonFindClicked(TextSearchData var1);

    protected abstract void onRevealNextOccurrence(TextSearchData var1);

    protected abstract void onConnect(TextSearchData var1);

    protected abstract void onReset(TextSearchData var1);

    protected abstract int find(int var1, String var2, boolean var3, boolean var4, boolean var5);

    protected final int findText(String searchText, int currentSearchPosition, boolean caseSensitive, boolean wholeWord, boolean regex) {
        this.m_currentPositionForSearch = this.find(currentSearchPosition, searchText, caseSensitive, wholeWord, regex);
        return this.m_currentPositionForSearch;
    }

    protected int getCurrentSearchPosition() {
        return this.m_currentPositionForSearch;
    }

    protected void setCurrentSearchPosition(int currentSearchPosition) {
        this.m_currentPositionForSearch = currentSearchPosition;
    }

    public final void requestNewFindInfo() {
        this.m_newFindInfo = true;
    }

    @Override
    public final void notRequestNewFindInfo() {
        this.m_newFindInfo = false;
    }

    @Override
    public final boolean needsNewFindInfo() {
        return this.m_newFindInfo;
    }

    @Override
    public final String getConnectedTo() {
        return this.m_connectedTo;
    }

    public static String escapeLinesForRegexp(List<String> lines) {
        assert (lines != null) : "Parameter 'lines' of method 'escapeLinesForRegexp' must not be null";
        StringBuilder result = new StringBuilder();
        int i = 0;
        while (i < lines.size()) {
            String next = lines.get(i);
            if (next.length() != 0) {
                result.append(BaseTextSearchHandler.escape(next));
                if (i < lines.size() - 1) {
                    result.append("\\R");
                }
            }
            ++i;
        }
        return result.toString();
    }

    protected abstract SelectedTextInfo getSelectedTextInfo();

    protected abstract int calculatePositionForFind();

    protected abstract TextSearchData createTextSearchData(SelectedTextInfo var1);
}

