/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.base.draw;

import com.hello2morrow.draw2d.Figure;
import com.hello2morrow.draw2d.Graphics;
import com.hello2morrow.draw2d.IFigure;
import com.hello2morrow.draw2d.MouseEvent;
import com.hello2morrow.draw2d.MouseMotionListener;
import com.hello2morrow.draw2d.Point;
import com.hello2morrow.sonargraph.ui.swt.base.draw.DrawExpandCollapseFigure;
import com.hello2morrow.sonargraph.ui.swt.base.draw.DrawInteractiveFigure;
import com.hello2morrow.sonargraph.ui.swt.base.draw.DrawModifier;
import com.hello2morrow.sonargraph.ui.swt.base.draw.DrawUtilities;
import java.util.List;
import org.eclipse.swt.graphics.Color;

public abstract class DrawNodeFigure<N>
extends DrawInteractiveFigure
implements MouseMotionListener {
    private static DrawNodeFigure<?> s_currentDraggingNode;
    private static DrawNodeFigure<?> s_currentTargetNode;
    private static DropPosition s_dropPosition;
    private final N m_node;
    private INodeFigureProvider<N> m_provider;

    static final boolean isDragging() {
        return s_currentDraggingNode != null;
    }

    private static void resetDraggingInfo() {
        s_currentDraggingNode = null;
        s_currentTargetNode = null;
        s_dropPosition = null;
    }

    protected DrawNodeFigure(N node) {
        assert (node != null) : "Parameter 'node' of method 'DrawNodeFigure' must not be null";
        this.m_node = node;
    }

    public final N getNode() {
        return this.m_node;
    }

    protected final INodeFigureProvider<N> getProvider() {
        return this.m_provider;
    }

    protected abstract void performInitialize(N var1);

    protected final void initialize(INodeFigureProvider<N> provider) {
        assert (provider != null) : "Parameter 'provider' of method 'initialize' must not be null";
        assert (this.m_provider == null) : "'m_provider' of method 'initialize' must be null";
        this.m_provider = provider;
        this.performInitialize(this.getNode());
        List<DrawExpandCollapseFigure> expandCollapseFigures = DrawUtilities.findChildFigures(DrawExpandCollapseFigure.class, this, f -> !(f instanceof DrawNodeFigure));
        assert (expandCollapseFigures.size() <= 1) : "Not more than 1 expand collapse figure expected";
    }

    private void drop(DrawNodeFigure<N> dragged) {
        assert (dragged != null) : "Parameter 'dragged' of method 'drop' must not be null";
        assert (s_dropPosition != null) : "'s_dropPosition' of method 'drop' must not be null";
        this.m_provider.dragFinishedWithDrop(dragged, this, s_dropPosition);
        DrawNodeFigure.resetDraggingInfo();
    }

    private void dragCancelled() {
        this.m_provider.dragCancelled(this);
        DrawNodeFigure.resetDraggingInfo();
    }

    private void dragFinished(Point location) {
        assert (location != null) : "Parameter 'location' of method 'dragFinished' must not be null";
        this.m_provider.dragFinished(this, location);
        DrawNodeFigure.resetDraggingInfo();
    }

    protected boolean performUpdate(N node) {
        assert (node != null) : "Parameter 'node' of method 'performUpdate' must not be null";
        return false;
    }

    @Override
    public final boolean update() {
        assert (this.m_provider != null) : "'m_provider' of method 'update' must not be null";
        this.m_provider.aboutToUpdate(this);
        if (this.performUpdate(this.getNode())) {
            this.revalidate();
            this.repaint();
            return true;
        }
        return false;
    }

    protected void performPaintFigure(Graphics graphics, N node) {
        assert (graphics != null) : "Parameter 'graphics' of method 'performPaintFigure' must not be null";
        assert (node != null) : "Parameter 'node' of method 'performPaintFigure' must not be null";
    }

    @Override
    protected final void paintFigure(Graphics graphics) {
        assert (graphics != null) : "Parameter 'graphics' of method 'paintFigure' must not be null";
        super.paintFigure(graphics);
        Color initialFgColor = graphics.getForegroundColor();
        Color initialBgColor = graphics.getBackgroundColor();
        int initialLineWidth = graphics.getLineWidth();
        int initialLineStyle = graphics.getLineStyle();
        int initialAntialias = graphics.getAntialias();
        int initialAlpha = graphics.getAlpha();
        graphics.setAntialias(1);
        this.performPaintFigure(graphics, this.m_node);
        graphics.setForegroundColor(initialFgColor);
        graphics.setBackgroundColor(initialBgColor);
        graphics.setLineWidth(initialLineWidth);
        graphics.setLineStyle(initialLineStyle);
        graphics.setAntialias(initialAntialias);
        graphics.setAlpha(initialAlpha);
    }

    @Override
    protected void mouseDownStarted(Figure source, DrawModifier modifier) {
        assert (source != null) : "Parameter 'source' of method 'mouseDownStarted' must not be null";
        assert (modifier != null) : "Parameter 'modifier' of method 'mouseDownStarted' must not be null";
        if (source instanceof DrawExpandCollapseFigure) {
            if (((DrawExpandCollapseFigure)source).toggleIsExpanded()) {
                this.m_provider.expand(this);
            } else {
                this.m_provider.collapse(this);
            }
        } else {
            if (DrawNodeFigure.isDragging()) {
                this.dragCancelled();
            }
            this.m_provider.clicked(this, modifier, source);
        }
    }

    @Override
    protected void mouseDownFinished(Figure source, Point location, DrawModifier modifier) {
        assert (modifier != null) : "Parameter 'modifier' of method 'mouseDownFinished' must not be null";
        if (DrawNodeFigure.isDragging()) {
            if (location != null) {
                if (s_currentTargetNode != null) {
                    s_currentTargetNode.drop(this);
                } else {
                    this.dragFinished(location);
                }
            } else {
                this.dragCancelled();
            }
        } else {
            this.m_provider.clickFinished(this, modifier, source);
        }
    }

    final void expand(DrawExpandCollapseFigure source) {
        assert (source != null) : "Parameter 'source' of method 'mouseEntered' must not be null";
        List<DrawExpandCollapseFigure> expandCollapseFigures = DrawUtilities.findChildFigures(DrawExpandCollapseFigure.class, this, f -> !(f instanceof DrawNodeFigure));
        assert (expandCollapseFigures.size() == 1) : "Exactly 1 expand collapse figure expected";
        assert (expandCollapseFigures.get(0) == source) : "Different instances";
        if (!source.isExpanded() && source.isExpandable()) {
            this.m_provider.expand(this);
            source.setIsExpanded(true);
        }
    }

    @Override
    public final void mouseDragged(MouseEvent event) {
        assert (event != null) : "Parameter 'event' of method 'mouseDragged' must not be null";
        DrawInteractiveFigure inMouseDown = DrawNodeFigure.inMouseDown();
        if (inMouseDown == this && s_currentDraggingNode == null) {
            Point location = new Point(event.getLocation());
            this.translateToParent(location);
            if (this.m_provider.startDrag(this, location)) {
                s_currentDraggingNode = this;
            }
        }
    }

    @Override
    public final void mouseEntered(MouseEvent event) {
        if (DrawNodeFigure.isDragging() && DrawNodeFigure.inMouseDown() != this) {
            s_currentTargetNode = this;
            s_dropPosition = DropPosition.ON;
            this.m_provider.dropCandidateEntered(s_currentDraggingNode, this, s_dropPosition);
        }
    }

    @Override
    public final void mouseExited(MouseEvent event) {
        if (DrawNodeFigure.isDragging() && DrawNodeFigure.inMouseDown() != this) {
            int diff = event.y - this.getLocation().y;
            s_dropPosition = diff < 8 ? DropPosition.BEFORE : DropPosition.AFTER;
            this.m_provider.dropCandidateExited(s_currentDraggingNode, this, s_dropPosition);
        }
    }

    @Override
    public final void mouseHover(MouseEvent event) {
    }

    @Override
    public final void mouseMoved(MouseEvent event) {
    }

    public final String toString() {
        return this.m_node.toString();
    }

    public static enum DropPosition {
        BEFORE,
        ON,
        AFTER;

    }

    public static interface INodeFigureProvider<N>
    extends DrawInteractiveFigure.IInteractiveFigureProvider {
        default public void clicked(DrawNodeFigure<N> nodeFigure, DrawModifier modifier, IFigure source) {
        }

        default public void clickFinished(DrawNodeFigure<N> nodeFigure, DrawModifier modifier, IFigure source) {
        }

        default public void expand(DrawNodeFigure<N> nodeFigure) {
        }

        default public void collapse(DrawNodeFigure<N> nodeFigure) {
        }

        default public boolean startDrag(DrawNodeFigure<N> dragged, Point location) {
            return false;
        }

        default public void dropCandidateEntered(DrawNodeFigure<N> dragged, DrawNodeFigure<N> targetNodeFigure, DropPosition position) {
        }

        default public void dropCandidateExited(DrawNodeFigure<N> dragged, DrawNodeFigure<N> targetNodeFigure, DropPosition position) {
        }

        default public void dragFinishedWithDrop(DrawNodeFigure<N> dragged, DrawNodeFigure<N> targetNodeFigure, DropPosition position) {
        }

        default public void dragFinished(DrawNodeFigure<N> dragged, Point location) {
        }

        default public void dragCancelled(DrawNodeFigure<N> dragged) {
        }

        default public void aboutToUpdate(DrawNodeFigure<N> nodeFigure) {
        }
    }
}

