/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.base.draw;

import com.hello2morrow.draw2d.Dimension;
import com.hello2morrow.draw2d.FigureUtilities;
import com.hello2morrow.draw2d.Graphics;
import com.hello2morrow.draw2d.Rectangle;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import com.hello2morrow.sonargraph.ui.swt.base.draw.DrawFigure;
import com.hello2morrow.sonargraph.ui.swt.base.draw.DrawUtilities;
import org.eclipse.swt.graphics.Font;

public final class DrawLabelFigure
extends DrawFigure {
    private String m_text;
    private int m_offsetY;

    public DrawLabelFigure(String text, boolean bold) {
        this.setFont(bold ? UiResourceManager.getInstance().getFont(DrawUtilities.BOLD_FONT_ID) : UiResourceManager.getInstance().getFont(DrawUtilities.FONT_ID));
        this.update(text);
    }

    public boolean update(String text) {
        assert (text != null) : "Parameter 'text' of method 'update' must not be null";
        boolean updated = false;
        if (!text.equals(this.m_text)) {
            Dimension dimension;
            this.m_text = text;
            if (!this.m_text.isEmpty()) {
                dimension = FigureUtilities.getStringExtents(this.m_text, this.getFont());
                int remainder = 16 - dimension.height;
                this.m_offsetY = remainder > 0 ? Math.max(1, remainder / 2) : 0;
                dimension.height = 16;
            } else {
                this.m_offsetY = 0;
                dimension = new Dimension(0, 16);
            }
            this.prefSize = this.maxSize = dimension;
            this.minSize = this.maxSize;
            updated = true;
        }
        return updated;
    }

    @Override
    protected void paintFigure(Graphics graphics) {
        assert (graphics != null) : "Parameter 'graphics' of method 'paintFigure' must not be null";
        Font initialFont = graphics.getFont();
        Rectangle bounds = this.getBounds();
        graphics.setFont(this.getFont());
        graphics.drawString(this.m_text, bounds.x, bounds.y + this.m_offsetY);
        graphics.setFont(initialFont);
    }

    public String toString() {
        return this.m_text;
    }
}

