/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.base.draw;

import com.hello2morrow.draw2d.Figure;
import com.hello2morrow.draw2d.MouseEvent;
import com.hello2morrow.draw2d.MouseListener;
import com.hello2morrow.draw2d.Point;
import com.hello2morrow.sonargraph.ui.swt.base.draw.DrawFigure;
import com.hello2morrow.sonargraph.ui.swt.base.draw.DrawModifier;
import com.hello2morrow.sonargraph.ui.swt.base.draw.DrawUtilities;

abstract class DrawInteractiveFigure
extends DrawFigure
implements MouseListener {
    private static DrawInteractiveFigure s_inMouseDown;
    private static DrawModifier s_modifierInMouseDown;

    static final DrawInteractiveFigure inMouseDown() {
        return s_inMouseDown;
    }

    static final void finishMouseDown(Figure source, Point point) {
        if (s_inMouseDown != null) {
            assert (s_modifierInMouseDown != null) : "'s_modifierInMouseDown' of method 'finishMouseDown' must not be null";
            s_inMouseDown.mouseDownFinished(source, point, s_modifierInMouseDown);
            s_inMouseDown = null;
            s_modifierInMouseDown = null;
        }
    }

    protected DrawInteractiveFigure() {
    }

    public abstract boolean update();

    protected void mouseDownStarted(Figure source, DrawModifier modifier) {
        assert (source != null) : "Parameter 'source' of method 'mouseDownStarted' must not be null";
        assert (modifier != null) : "Parameter 'modifier' of method 'mouseDownStarted' must not be null";
    }

    protected void mouseDownFinished(Figure source, Point location, DrawModifier modifier) {
        assert (modifier != null) : "Parameter 'modifier' of method 'mouseDownFinished' must not be null";
    }

    @Override
    public final void mousePressed(MouseEvent event) {
        assert (event != null) : "Parameter 'event' of method 'mousePressed' must not be null";
        if (event.button == 1) {
            DrawModifier modifier = DrawUtilities.getModifier(event);
            s_inMouseDown = this;
            s_modifierInMouseDown = modifier;
            assert (event.getSource() != null && event.getSource() instanceof Figure) : "Unexpected class in method 'mousePressed': " + String.valueOf(event.getSource());
            this.mouseDownStarted((Figure)event.getSource(), modifier);
        }
    }

    @Override
    public final void mouseReleased(MouseEvent event) {
        assert (event != null) : "Parameter 'event' of method 'mouseReleased' must not be null";
        if (event.button == 1) {
            assert (event.getSource() != null && event.getSource() instanceof Figure) : "Unexpected class in method 'mouseReleased': " + String.valueOf(event.getSource());
            DrawInteractiveFigure.finishMouseDown((Figure)event.getSource(), event.getLocation());
        }
    }

    @Override
    public final void mouseDoubleClicked(MouseEvent event) {
    }

    public static interface IInteractiveFigureProvider {
        default public boolean hasSelection() {
            return false;
        }
    }
}

