/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.base.compositecommand;

import com.hello2morrow.sonargraph.ui.swt.base.compositecommand.CompositeCommandAdapter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.contributions.IContributionFactory;

public final class CompositeCommandRegistry {
    private static final String EXTENSION_POINT = "com.hello2morrow.sonargraph.ui.swt.compositeCommands";
    private static final String ELEMENT_ADAPTER = "compositeCommandAdapter";
    private static final String ATTRIBUTE_CLASS = "class";
    private static CompositeCommandRegistry s_instance;
    private final IEclipseContext m_eclipseContext;
    private final Map<CompositeCommandAdapter.Type, List<CompositeCommandAdapter>> m_typeToAadpter = new HashMap<CompositeCommandAdapter.Type, List<CompositeCommandAdapter>>();

    private CompositeCommandRegistry(IEclipseContext eclipseContext) {
        assert (eclipseContext != null) : "Parameter 'eclipseContext' of method 'PreferenceRegistry' must not be null";
        this.m_eclipseContext = eclipseContext;
        IExtensionRegistry extensionRegistry = (IExtensionRegistry)this.m_eclipseContext.get(IExtensionRegistry.class);
        IContributionFactory factory = (IContributionFactory)this.m_eclipseContext.get(IContributionFactory.class);
        IConfigurationElement[] iConfigurationElementArray = extensionRegistry.getConfigurationElementsFor(EXTENSION_POINT);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement nextConfigurationElement = iConfigurationElementArray[n2];
            String bundleId = nextConfigurationElement.getNamespaceIdentifier();
            if (nextConfigurationElement.getName().equals(ELEMENT_ADAPTER)) {
                String clazz = nextConfigurationElement.getAttribute(ATTRIBUTE_CLASS);
                if (clazz != null && !clazz.isEmpty()) {
                    Object object = factory.create("bundleclass://" + bundleId + "/" + clazz, this.m_eclipseContext);
                    assert (object != null && object instanceof CompositeCommandAdapter) : "Unexpected class in method 'getWizards': " + String.valueOf(object);
                    CompositeCommandAdapter nextAdapter = (CompositeCommandAdapter)object;
                    List<CompositeCommandAdapter> adapters = this.m_typeToAadpter.get((Object)nextAdapter.getType());
                    if (adapters == null) {
                        adapters = new ArrayList<CompositeCommandAdapter>();
                        this.m_typeToAadpter.put(nextAdapter.getType(), adapters);
                    }
                    adapters.add(nextAdapter);
                } else assert (false) : "Expected element: class: " + clazz;
            } else assert (false) : "Expected element: compositeCommandAdapter";
            ++n2;
        }
    }

    public static void createInstance(IEclipseContext eclipseContext) {
        assert (!CompositeCommandRegistry.hasInstance()) : "Instance already created";
        s_instance = new CompositeCommandRegistry(eclipseContext);
    }

    public static boolean hasInstance() {
        return s_instance != null;
    }

    public static CompositeCommandRegistry getInstance() {
        assert (CompositeCommandRegistry.hasInstance()) : "Instance not created";
        return s_instance;
    }

    public static void delete() {
        if (s_instance != null) {
            s_instance = null;
        }
    }

    public List<CompositeCommandAdapter> get(CompositeCommandAdapter.Type type) {
        assert (type != null) : "Parameter 'type' of method 'get' must not be null";
        List<CompositeCommandAdapter> adapters = this.m_typeToAadpter.get((Object)type);
        if (adapters != null) {
            return Collections.unmodifiableList(adapters);
        }
        return Collections.emptyList();
    }
}

