/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.base.commandhandler;

import com.hello2morrow.sonargraph.core.model.representation.FocusMode;
import com.hello2morrow.sonargraph.core.model.representation.FocusProperties;
import com.hello2morrow.sonargraph.core.model.representation.NodeAndEdgeRepresentation;
import com.hello2morrow.sonargraph.ui.swt.base.commandhandler.FocusBasedHandlerWithMenuEntry;
import com.hello2morrow.sonargraph.ui.swt.base.draw2d.DrawableWidget;
import com.hello2morrow.sonargraph.ui.swt.base.view.IWorkbenchView;
import com.hello2morrow.sonargraph.ui.swt.base.view.RcpUtility;
import com.hello2morrow.sonargraph.ui.swt.base.view.WorkbenchViewSelection;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.DrawableSlaveView;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuItem;

public abstract class FocusBaseHandler
extends FocusBasedHandlerWithMenuEntry {
    @Override
    protected boolean internalCanExecute(IEclipseContext eclipseContext, MMenuItem menuItem, WorkbenchViewSelection selection) {
        IWorkbenchView workbenchView = selection.getWorkbenchView();
        if (workbenchView instanceof DrawableSlaveView && workbenchView.getViewId() == this.getSupportedViewId()) {
            DrawableSlaveView view = (DrawableSlaveView)workbenchView;
            boolean atLeastOneNodeUnselected = view.atLeastOneNodeSelected();
            return view.isReady() && atLeastOneNodeUnselected;
        }
        return false;
    }

    @Execute
    public final void execute(MPart part) {
        assert (part != null) : "Parameter 'part' of method 'execute' must not be null";
        DrawableSlaveView view = RcpUtility.getWorkbenchView(part, DrawableSlaveView.class);
        assert (view != null) : "'view' of method 'execute' must not be null";
        DrawableWidget drawableWidget = view.getDrawableWidget();
        assert (drawableWidget != null) : "Parameter 'drawableWidget' of method 'execute' must not be null";
        NodeAndEdgeRepresentation representation = drawableWidget.getUnderlyingRepresentation();
        assert (representation != null) : "'representation' of method 'execute' must not be null";
        FocusProperties previousProperties = new FocusProperties(this.getFocusMode(), representation.getRepresentationProperties(), representation.getParserDependencyTypesForEdges());
        view.focus(DrawableSlaveView.FocusSelectionType.SELECTED, previousProperties);
    }

    protected abstract FocusMode getFocusMode();
}

