/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.base;

import com.hello2morrow.sonargraph.foundation.utilities.IStandardEnumeration;
import com.hello2morrow.sonargraph.ui.swt.base.SwtUtility;
import java.util.AbstractCollection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public final class StandardEnumerationMultiSelectWidget<T extends Enum<T>>
extends Composite {
    private final Map<T, Button> m_buttons = new HashMap<T, Button>();
    private final IConsumer<T> m_consumer;
    private final EnumSet<T> m_candidates;

    public StandardEnumerationMultiSelectWidget(Composite parent, IConsumer<T> consumer, EnumSet<T> candidates, EnumSet<T> selected, int columns) {
        super(parent, 0);
        assert (candidates != null && !candidates.isEmpty()) : "Parameter 'candidates' of method 'StandardEnumerationMultiSelectWidget' must not be empty";
        assert (selected != null) : "Parameter 'candidates' of method 'StandardEnumerationMultiSelectWidget' must not be null";
        assert (candidates.containsAll(selected)) : "selected must be subset of candidates";
        this.m_consumer = consumer != null ? consumer : t -> {};
        this.m_candidates = candidates;
        if (columns <= 1) {
            this.setRowLayout();
        } else {
            this.setGridLayout(columns);
        }
        this.initSelected(candidates, selected);
    }

    public void enable(EnumSet<T> toBeEnabled) {
        assert (toBeEnabled != null) : "Parameter 'toBeEnabled' of method 'enable' must not be null";
        assert (this.m_candidates.containsAll(toBeEnabled));
        for (Enum t : this.m_buttons.keySet()) {
            Button b = this.m_buttons.get(t);
            if (b == null) continue;
            b.setEnabled(toBeEnabled.contains(t));
        }
        this.selectionChanged();
    }

    public void select(EnumSet<T> toBeSelected) {
        assert (toBeSelected != null) : "Parameter 'toBeSelected' of method 'enable' must not be null";
        assert (this.m_candidates.containsAll(toBeSelected));
        for (Enum t : this.m_buttons.keySet()) {
            Button b = this.m_buttons.get(t);
            if (b == null) continue;
            b.setSelection(toBeSelected.contains(t));
        }
        this.selectionChanged();
    }

    public EnumSet<T> getSelected() {
        EnumSet<T> result = this.getNoneOf();
        for (Enum t : this.m_buttons.keySet()) {
            Button b = this.m_buttons.get(t);
            if (!b.getSelection()) continue;
            result.add(t);
        }
        return result;
    }

    public void setToolTipText(T element, String text) {
        assert (element != null) : "Parameter 'element' of method 'setTooltip' must not be null";
        assert (text != null) : "Parameter 'text' of method 'setTooltip' must not be null";
        Button button = this.m_buttons.get(element);
        button.setToolTipText(text);
    }

    private void initSelected(EnumSet<T> candidates, EnumSet<T> selected) {
        SelectionAdapter selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StandardEnumerationMultiSelectWidget.this.selectionChanged();
            }
        };
        for (Enum next : candidates) {
            Button nextOption = new Button((Composite)this, 32);
            nextOption.setText(((IStandardEnumeration)next).getPresentationName());
            nextOption.setData((Object)next);
            nextOption.setSelection(selected.contains(next));
            nextOption.addSelectionListener((SelectionListener)selectionListener);
            this.m_buttons.put(next, nextOption);
        }
    }

    private void setRowLayout() {
        RowLayout rowLayout = new RowLayout();
        rowLayout.marginTop = 0;
        rowLayout.fill = true;
        this.setLayout((Layout)rowLayout);
    }

    private void setGridLayout(int columns) {
        this.setLayout((Layout)SwtUtility.createMultipleRootWidgetGridLayout(columns));
    }

    private EnumSet<T> getNoneOf() {
        Object noneOf = this.m_candidates.clone();
        ((AbstractCollection)noneOf).clear();
        return noneOf;
    }

    private void selectionChanged() {
        EnumSet<T> selectedButtons = this.getNoneOf();
        for (Button b : this.m_buttons.values()) {
            if (!b.getSelection() || !b.isEnabled()) continue;
            Enum selectedAndEnabled = (Enum)b.getData();
            selectedButtons.add(selectedAndEnabled);
        }
        this.m_consumer.setValue(selectedButtons);
    }

    public static interface IConsumer<T extends Enum<T>> {
        public void setValue(EnumSet<T> var1);
    }
}

