/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.draw2d;

import com.hello2morrow.draw2d.Connection;
import com.hello2morrow.draw2d.ConnectionAnchor;
import com.hello2morrow.draw2d.ConnectionLayer;
import com.hello2morrow.draw2d.IClippingStrategy;
import com.hello2morrow.draw2d.IFigure;
import com.hello2morrow.draw2d.Insets;
import com.hello2morrow.draw2d.PointList;
import com.hello2morrow.draw2d.Rectangle;
import com.hello2morrow.draw2d.Viewport;
import com.hello2morrow.draw2d.ViewportUtilities;
import java.util.List;

public class ViewportAwareConnectionLayerClippingStrategy
implements IClippingStrategy {
    private static final Insets PRIVATE_INSETS = new Insets(0, 0, 1, 1);
    private ConnectionLayer connectionLayer = null;

    public ViewportAwareConnectionLayerClippingStrategy(ConnectionLayer connectionLayer) {
        this.connectionLayer = connectionLayer;
    }

    @Override
    public Rectangle[] getClip(IFigure figure) {
        Rectangle[] clipRect = null;
        clipRect = figure instanceof Connection ? this.getEdgeClippingRectangle((Connection)figure) : new Rectangle[]{this.getNodeClippingRectangle(figure)};
        int i = 0;
        while (i < clipRect.length) {
            figure.translateToRelative(clipRect[i]);
            ++i;
        }
        return clipRect;
    }

    protected Rectangle[] getEdgeClippingRectangle(Connection connection) {
        Viewport nearestEnclosingTargetViewport;
        Viewport nearestEnclosingSourceViewport;
        IFigure targetFigure;
        Rectangle clipRect = this.getAbsoluteBoundsAsCopy(connection);
        ConnectionAnchor sourceAnchor = connection.getSourceAnchor();
        ConnectionAnchor targetAnchor = connection.getTargetAnchor();
        if (sourceAnchor == null || sourceAnchor.getOwner() == null || targetAnchor == null || targetAnchor.getOwner() == null) {
            return new Rectangle[]{clipRect};
        }
        IFigure sourceFigure = sourceAnchor.getOwner();
        Viewport nearestEnclosingCommonViewport = ViewportUtilities.getNearestCommonViewport(sourceFigure, targetFigure = targetAnchor.getOwner());
        if (nearestEnclosingCommonViewport == null) {
            return new Rectangle[]{clipRect};
        }
        if (nearestEnclosingCommonViewport != this.getRootViewport()) {
            clipRect.intersect(this.getNodeClippingRectangle(nearestEnclosingCommonViewport));
        }
        if ((nearestEnclosingSourceViewport = ViewportUtilities.getNearestEnclosingViewport(sourceFigure)) != (nearestEnclosingTargetViewport = ViewportUtilities.getNearestEnclosingViewport(targetFigure))) {
            Rectangle sourceClipRect = clipRect.getCopy();
            if (nearestEnclosingSourceViewport != nearestEnclosingCommonViewport) {
                this.clipAtViewports(sourceClipRect, ViewportUtilities.getViewportsPath(nearestEnclosingSourceViewport, nearestEnclosingCommonViewport, false));
            }
            Rectangle targetClipRect = clipRect.getCopy();
            if (nearestEnclosingTargetViewport != nearestEnclosingCommonViewport) {
                this.clipAtViewports(targetClipRect, ViewportUtilities.getViewportsPath(nearestEnclosingTargetViewport, nearestEnclosingCommonViewport, false));
            }
            PointList absolutePointsAsCopy = this.getAbsolutePointsAsCopy(connection);
            boolean sourceAnchorVisible = sourceClipRect.getExpanded(PRIVATE_INSETS).contains(absolutePointsAsCopy.getFirstPoint());
            boolean targetAnchorVisible = targetClipRect.getExpanded(PRIVATE_INSETS).contains(absolutePointsAsCopy.getLastPoint());
            if (!sourceAnchorVisible || !targetAnchorVisible) {
                return new Rectangle[0];
            }
            return new Rectangle[]{clipRect};
        }
        return new Rectangle[]{clipRect};
    }

    protected Rectangle getNodeClippingRectangle(IFigure figure) {
        Rectangle clipRect = this.getAbsoluteBoundsAsCopy(figure);
        List enclosingViewportsPath = ViewportUtilities.getViewportsPath(ViewportUtilities.getNearestEnclosingViewport(figure), this.getRootViewport(), false);
        this.clipAtViewports(clipRect, enclosingViewportsPath);
        return clipRect;
    }

    protected void clipAtViewports(Rectangle clipRect, List enclosingViewportsPath) {
        for (Viewport viewport : enclosingViewportsPath) {
            clipRect.intersect(this.getAbsoluteViewportAreaAsCopy(viewport));
        }
    }

    protected Viewport getRootViewport() {
        return ViewportUtilities.getNearestEnclosingViewport(this.connectionLayer);
    }

    protected PointList getAbsolutePointsAsCopy(Connection connection) {
        PointList points = connection.getPoints().getCopy();
        connection.translateToAbsolute(points);
        return points;
    }

    protected Rectangle getAbsoluteViewportAreaAsCopy(Viewport viewport) {
        return this.getAbsoluteClientAreaAsCopy(viewport);
    }

    protected Rectangle getAbsoluteClientAreaAsCopy(IFigure figure) {
        Rectangle absoluteClientArea = figure.getClientArea();
        figure.translateToParent(absoluteClientArea);
        figure.translateToAbsolute(absoluteClientArea);
        return absoluteClientArea;
    }

    protected Rectangle getAbsoluteBoundsAsCopy(IFigure figure) {
        Rectangle absoluteFigureBounds = figure.getBounds().getCopy();
        figure.translateToAbsolute(absoluteFigureBounds);
        return absoluteFigureBounds;
    }
}

