/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.draw2d;

import com.hello2morrow.draw2d.AbstractLabeledBorder;
import com.hello2morrow.draw2d.ColorConstants;
import com.hello2morrow.draw2d.Dimension;
import com.hello2morrow.draw2d.Graphics;
import com.hello2morrow.draw2d.IFigure;
import com.hello2morrow.draw2d.Insets;
import com.hello2morrow.draw2d.Rectangle;
import org.eclipse.swt.graphics.Color;

public class TitleBarBorder
extends AbstractLabeledBorder {
    private static Color defaultBackgroundColor = ColorConstants.menuBackgroundSelected;
    private static Color defaultForegroundColor = ColorConstants.menuForegroundSelected;
    private int textAlignment = 1;
    private Insets padding = new Insets(1, 3, 2, 2);
    private Color fillColor = defaultBackgroundColor;

    public TitleBarBorder() {
        this.setTextColor(defaultForegroundColor);
    }

    public TitleBarBorder(String s) {
        this();
        this.setLabel(s);
    }

    @Override
    protected Insets calculateInsets(IFigure figure) {
        return new Insets(this.getTextExtents((IFigure)figure).height + this.padding.getHeight(), 0, 0, 0);
    }

    protected Color getBackgroundColor() {
        return this.fillColor;
    }

    protected Insets getPadding() {
        return this.padding;
    }

    @Override
    public Dimension getPreferredSize(IFigure fig) {
        return super.getPreferredSize(fig).getExpanded(this.padding.getWidth(), 0);
    }

    public int getTextAlignment() {
        return this.textAlignment;
    }

    @Override
    public boolean isOpaque() {
        return true;
    }

    @Override
    public void paint(IFigure figure, Graphics g, Insets insets) {
        tempRect.setBounds(TitleBarBorder.getPaintRectangle(figure, insets));
        Rectangle rec = tempRect;
        rec.height = Math.min(rec.height, this.getTextExtents((IFigure)figure).height + this.padding.getHeight());
        g.clipRect(rec);
        g.setBackgroundColor(this.fillColor);
        g.fillRectangle(rec);
        int x = rec.x + this.padding.left;
        int y = rec.y + this.padding.top;
        int textWidth = this.getTextExtents((IFigure)figure).width;
        int freeSpace = rec.width - this.padding.getWidth() - textWidth;
        if (this.getTextAlignment() == 2) {
            freeSpace /= 2;
        }
        if (this.getTextAlignment() != 1) {
            x += freeSpace;
        }
        g.setFont(this.getFont(figure));
        g.setForegroundColor(this.getTextColor());
        g.drawString(this.getLabel(), x, y);
    }

    public void setBackgroundColor(Color color) {
        this.fillColor = color;
    }

    public void setPadding(int all) {
        this.padding = new Insets(all);
        this.invalidate();
    }

    public void setPadding(Insets pad) {
        this.padding = pad;
        this.invalidate();
    }

    public void setTextAlignment(int align) {
        this.textAlignment = align;
    }
}

