/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.draw2d;

import com.hello2morrow.draw2d.Graphics;
import com.hello2morrow.draw2d.GraphicsSource;
import com.hello2morrow.draw2d.IFigure;
import com.hello2morrow.draw2d.Rectangle;
import com.hello2morrow.draw2d.SWTGraphics;
import com.hello2morrow.draw2d.UpdateManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Display;

public class DeferredUpdateManager
extends UpdateManager {
    private Rectangle damage;
    private Map dirtyRegions = new HashMap();
    private GraphicsSource graphicsSource;
    private List invalidFigures = new ArrayList();
    private IFigure root;
    private boolean updateQueued;
    private boolean updating;
    private boolean validating;
    private RunnableChain afterUpdate;

    public DeferredUpdateManager() {
    }

    public DeferredUpdateManager(GraphicsSource gs) {
        this.setGraphicsSource(gs);
    }

    @Override
    public synchronized void addDirtyRegion(IFigure figure, int x, int y, int w, int h) {
        if (w == 0 || h == 0 || !figure.isShowing()) {
            return;
        }
        Rectangle rect = (Rectangle)this.dirtyRegions.get(figure);
        if (rect == null) {
            rect = new Rectangle(x, y, w, h);
            this.dirtyRegions.put(figure, rect);
        } else {
            rect.union(x, y, w, h);
        }
        this.queueWork();
    }

    @Override
    public synchronized void addInvalidFigure(IFigure f) {
        if (this.invalidFigures.contains(f)) {
            return;
        }
        this.queueWork();
        this.invalidFigures.add(f);
    }

    protected Graphics getGraphics(Rectangle region) {
        if (this.graphicsSource == null) {
            return null;
        }
        return this.graphicsSource.getGraphics(region);
    }

    @Override
    protected void paint(GC gc) {
        if (!this.validating) {
            SWTGraphics graphics = new SWTGraphics(gc);
            if (!this.updating) {
                Rectangle rect = graphics.getClip(new Rectangle());
                HashMap<IFigure, Rectangle> map = new HashMap<IFigure, Rectangle>();
                map.put(this.root, rect);
                this.firePainting(rect, map);
            }
            this.performValidation();
            this.root.paint(graphics);
            graphics.dispose();
        } else {
            this.addDirtyRegion(this.root, new Rectangle(gc.getClipping()));
        }
    }

    @Override
    public synchronized void performUpdate() {
        if (this.isDisposed() || this.updating) {
            return;
        }
        this.updating = true;
        try {
            this.performValidation();
            this.updateQueued = false;
            this.repairDamage();
            if (this.afterUpdate != null) {
                RunnableChain chain = this.afterUpdate;
                this.afterUpdate = null;
                chain.run();
                if (this.afterUpdate != null) {
                    this.queueWork();
                }
            }
        }
        finally {
            this.updating = false;
        }
    }

    @Override
    public synchronized void performValidation() {
        if (this.invalidFigures.isEmpty() || this.validating) {
            return;
        }
        try {
            this.validating = true;
            this.fireValidating();
            int i = 0;
            while (i < this.invalidFigures.size()) {
                IFigure fig = (IFigure)this.invalidFigures.get(i);
                this.invalidFigures.set(i, null);
                fig.validate();
                ++i;
            }
        }
        finally {
            this.invalidFigures.clear();
            this.validating = false;
        }
    }

    @Override
    public synchronized void performUpdate(Rectangle exposed) {
        this.addDirtyRegion(this.root, exposed);
        this.performUpdate();
    }

    protected void queueWork() {
        if (!this.updateQueued) {
            this.sendUpdateRequest();
            this.updateQueued = true;
        }
    }

    protected void sendUpdateRequest() {
        Display display = Display.getCurrent();
        if (display == null) {
            throw new SWTException(22);
        }
        display.asyncExec((Runnable)new UpdateRequest());
    }

    protected void releaseGraphics(Graphics graphics) {
        graphics.dispose();
        this.graphicsSource.flushGraphics(this.damage);
    }

    protected void repairDamage() {
        Graphics graphics;
        for (IFigure figure : this.dirtyRegions.keySet()) {
            IFigure walker = figure.getParent();
            Rectangle contribution = (Rectangle)this.dirtyRegions.get(figure);
            contribution.intersect(figure.getBounds());
            while (!contribution.isEmpty() && walker != null) {
                walker.translateToParent(contribution);
                contribution.intersect(walker.getBounds());
                walker = walker.getParent();
            }
            if (this.damage == null) {
                this.damage = new Rectangle(contribution);
                continue;
            }
            this.damage.union(contribution);
        }
        if (!this.dirtyRegions.isEmpty()) {
            Map oldRegions = this.dirtyRegions;
            this.dirtyRegions = new HashMap();
            this.firePainting(this.damage, oldRegions);
        }
        if (this.damage != null && !this.damage.isEmpty() && (graphics = this.getGraphics(this.damage)) != null) {
            this.root.paint(graphics);
            this.releaseGraphics(graphics);
        }
        this.damage = null;
    }

    @Override
    public synchronized void runWithUpdate(Runnable runnable) {
        this.afterUpdate = new RunnableChain(runnable, this.afterUpdate);
        if (!this.updating) {
            this.queueWork();
        }
    }

    @Override
    public void setGraphicsSource(GraphicsSource gs) {
        this.graphicsSource = gs;
    }

    @Override
    public void setRoot(IFigure figure) {
        this.root = figure;
    }

    protected void validateFigures() {
        this.performValidation();
    }

    private static class RunnableChain {
        RunnableChain next;
        Runnable run;

        RunnableChain(Runnable run, RunnableChain next) {
            this.run = run;
            this.next = next;
        }

        void run() {
            if (this.next != null) {
                this.next.run();
            }
            this.run.run();
        }
    }

    protected class UpdateRequest
    implements Runnable {
        @Override
        public void run() {
            DeferredUpdateManager.this.performUpdate();
        }
    }
}

