/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.scm;

import com.hello2morrow.sonargraph.foundation.persistence.IObjectReader;
import com.hello2morrow.sonargraph.foundation.persistence.IObjectWriter;
import com.hello2morrow.sonargraph.foundation.persistence.IPersistable;
import com.hello2morrow.sonargraph.foundation.persistence.RestoreException;
import com.hello2morrow.sonargraph.scm.Diff;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public final class Commit
implements Diff.ICommit {
    private static final String TIMESTAMP = "timestamp";
    private static final String LOG_MESSAGE = "logMessage";
    private static final String AUTHOR = "author";
    private static final String ID = "id";
    private String m_id;
    private String m_author;
    private String m_logMessage;
    private long m_timeStamp;
    private final List<Diff> m_changes;

    public Commit() {
        this.m_changes = new ArrayList<Diff>();
    }

    public Commit(String id, String author, String logMessage, long timeStamp, List<Diff> changes) {
        assert (id != null && id.length() > 0) : "Parameter 'id' of method 'Commit' must not be empty";
        assert (logMessage != null) : "Parameter 'logMessage' of method 'Commit' must not be null";
        assert (changes != null && !changes.isEmpty()) : "Parameter 'changes' of method 'Commit' must not be empty";
        this.m_id = id;
        this.m_author = author == null || author.length() == 0 ? null : author;
        this.m_logMessage = logMessage;
        this.m_timeStamp = timeStamp;
        this.m_changes = changes;
    }

    public String getId() {
        return this.m_id;
    }

    public String getAuthor() {
        return this.m_author;
    }

    public String getLogMessage() {
        return this.m_logMessage;
    }

    public long getTimeStamp() {
        return this.m_timeStamp;
    }

    public List<Diff> getChanges() {
        return Collections.unmodifiableList(this.m_changes);
    }

    @Override
    public void addChange(Diff change) {
        assert (change != null) : "Parameter 'change' of method 'addChange' must not be null";
        this.m_changes.add(change);
    }

    public void writeAttributes(IObjectWriter writer) throws IOException {
        writer.writeString(ID, this.m_id);
        writer.writeString(AUTHOR, this.m_author);
        if (this.m_logMessage.length() > 256) {
            writer.writeString(LOG_MESSAGE, this.m_logMessage.substring(0, 256));
        } else {
            writer.writeString(LOG_MESSAGE, this.m_logMessage);
        }
        writer.writeLong(TIMESTAMP, this.m_timeStamp);
    }

    public void readAttributes(IObjectReader reader) throws IOException, RestoreException {
        this.m_id = reader.readString(ID);
        this.m_author = reader.readString(AUTHOR);
        this.m_logMessage = reader.readString(LOG_MESSAGE);
        Long val = reader.readLong(TIMESTAMP);
        if (val == null) {
            throw new RestoreException("Missing attribute 'timestamp'");
        }
        this.m_timeStamp = val;
        ((IBranchCommits)reader.getCurrentParent(IBranchCommits.class)).addCommit(this);
    }

    public List<? extends IPersistable> getPersistableChildren() {
        return this.m_changes;
    }

    public boolean isEqualTo(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Commit other = (Commit)obj;
        if (this.m_author == null ? other.m_author != null : !this.m_author.equals(other.m_author)) {
            return false;
        }
        if (this.m_changes == null) {
            if (other.m_changes != null) {
                return false;
            }
        } else {
            if (this.m_changes.size() != other.m_changes.size()) {
                return false;
            }
            int i = 0;
            while (i < this.m_changes.size()) {
                if (!this.m_changes.get(i).isEqualTo(other.m_changes.get(i))) {
                    return false;
                }
                ++i;
            }
        }
        if (!this.m_id.equals(other.m_id)) {
            return false;
        }
        if (!this.m_logMessage.equals(other.m_logMessage)) {
            return false;
        }
        return this.m_timeStamp == other.m_timeStamp;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.m_id).append(" [").append(this.m_author).append("] ");
        sb.append(" [").append(this.m_logMessage).append("] ");
        sb.append(new Date(this.m_timeStamp)).append('\n');
        for (Diff diff : this.m_changes) {
            sb.append("  ").append(diff).append('\n');
        }
        return sb.toString();
    }

    public static interface IBranchCommits
    extends IPersistable {
        public void addCommit(Commit var1);
    }
}

