/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.plugin.swagger;

import com.hello2morrow.sonargraph.api.Aggregator;
import com.hello2morrow.sonargraph.api.AnyFactory;
import com.hello2morrow.sonargraph.api.IAggregatedDependencyAccess;
import com.hello2morrow.sonargraph.api.IDependencyAccess;
import com.hello2morrow.sonargraph.api.IDependencyKind;
import com.hello2morrow.sonargraph.api.IExternalAccess;
import com.hello2morrow.sonargraph.api.IMethodAccess;
import com.hello2morrow.sonargraph.api.INamedElementAccess;
import com.hello2morrow.sonargraph.api.IPluginLanguageBasedAccess;
import com.hello2morrow.sonargraph.api.IPluginProgrammingElementAccess;
import com.hello2morrow.sonargraph.api.IProgrammingElementAccess;
import com.hello2morrow.sonargraph.api.ISourceFileAccess;
import com.hello2morrow.sonargraph.api.PluginDependencyMetaData;
import com.hello2morrow.sonargraph.api.PluginProgrammingElementMetaData;
import com.hello2morrow.sonargraph.api.WebProperty;
import com.hello2morrow.sonargraph.api.WebUtilities;
import com.hello2morrow.sonargraph.api.java.IJavaMethodAccess;
import com.hello2morrow.sonargraph.api.java.IJavaTypeAccess;
import com.hello2morrow.sonargraph.api.java.JavaDependencyKind;
import com.hello2morrow.sonargraph.plugin.IModelPluginContext;
import com.hello2morrow.sonargraph.plugin.java.IPluginJavaAccess;
import gnu.trove.map.hash.THashMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

final class OkHttpWebCallDetector {
    private static final int MAX_LOCAL_VAR_PATH_OFFSET = 8;
    private final Pattern m_pathPattern = Pattern.compile("String localVarPath = \"(.*)\"");
    private final Pattern m_callPattern = Pattern.compile("return apiClient.buildCall\\(localVarPath, \"(.*)\"");
    private final String m_pluginId;
    private final PluginProgrammingElementMetaData m_webResourceMetaData;
    private final PluginProgrammingElementMetaData m_externalWebResourceMetaData;
    private final PluginProgrammingElementMetaData m_webCallMetaData;
    private final PluginDependencyMetaData m_httpCallMetaData;

    public OkHttpWebCallDetector(String pluginId, PluginProgrammingElementMetaData webResourceMetaData, PluginProgrammingElementMetaData externalWebResourceMetaData, PluginProgrammingElementMetaData webCallMetaData, PluginDependencyMetaData httpCallMetaData) {
        assert (pluginId != null && pluginId.length() > 0) : "Parameter 'pluginId' of method 'OkHttpWebCallDetector' must not be empty";
        assert (webResourceMetaData != null) : "Parameter 'webResourceMetaData' of method 'WebCallDetector' must not be null";
        assert (externalWebResourceMetaData != null) : "Parameter 'externalWebResourceMetaData' of method 'WebCallDetector' must not be null";
        assert (webCallMetaData != null) : "Parameter 'webCallMetaData' of method 'WebCallDetector' must not be null";
        assert (httpCallMetaData != null) : "Parameter 'httpCallMetaData' of method 'WebCallDetector' must not be null";
        this.m_pluginId = pluginId;
        this.m_webResourceMetaData = webResourceMetaData;
        this.m_externalWebResourceMetaData = externalWebResourceMetaData;
        this.m_webCallMetaData = webCallMetaData;
        this.m_httpCallMetaData = httpCallMetaData;
    }

    private IPluginProgrammingElementAccess getOrCreateExternalResource(IPluginLanguageBasedAccess coreAccess, String path, List<String> httpMethods) {
        assert (coreAccess != null) : "Parameter 'javaAccess' of method 'getOrCreateExternalResource' must not be null";
        assert (path != null) : "Parameter 'path' of method 'getOrCreateExternalResource' must not be null";
        assert (httpMethods != null && !httpMethods.isEmpty()) : "Parameter 'httpMethods' of method 'getOrCreateExternalResource' must not be empty";
        IExternalAccess externalRoot = coreAccess.getExternalRoot(coreAccess.getLanguageIdentifier(), this.m_pluginId);
        assert (externalRoot != null) : "ExternalRoot for plugin " + this.m_pluginId + ", language " + coreAccess.getLanguageIdentifier() + " must not be null";
        IPluginProgrammingElementAccess programmingElementAccess = (IPluginProgrammingElementAccess)coreAccess.findFirstMatchingElement((INamedElementAccess)externalRoot, e -> e.getShortName().equals(path));
        if (programmingElementAccess == null) {
            THashMap properties = new THashMap();
            properties.put(WebProperty.HTTP_METHOD.getStandardName(), AnyFactory.createFrom(httpMethods));
            properties.put(WebProperty.PATH_TO_MATCH.getStandardName(), AnyFactory.createFrom((Object)WebUtilities.removeVariablesFromPath((String)path)));
            programmingElementAccess = coreAccess.createProgrammingElement(this.m_pluginId, this.m_externalWebResourceMetaData, (INamedElementAccess)externalRoot, path, -1, (Map)properties);
        }
        return programmingElementAccess;
    }

    private IPluginProgrammingElementAccess createWebCall(IPluginJavaAccess javaAccess, IMethodAccess callMethod, String name, String httpMethodType, String target) {
        assert (javaAccess != null) : "Parameter 'javaAccess' of method 'createWebCall' must not be null";
        assert (callMethod != null) : "Parameter 'callMethod' of method 'createWebCall' must not be null";
        assert (name != null && name.length() > 0) : "Parameter 'path' of method 'createWebCall' must not be empty";
        assert (httpMethodType != null && httpMethodType.length() > 0) : "Parameter 'httpMethodType' of method 'createWebCall' must not be empty";
        THashMap properties = new THashMap();
        properties.put(WebProperty.HTTP_METHOD.getStandardName(), AnyFactory.createFrom(Arrays.asList(httpMethodType)));
        properties.put(WebProperty.FRAMEWORK.getStandardName(), AnyFactory.createFrom((Object)"Swagger.OkHttp"));
        properties.put(WebProperty.PATH_TO_MATCH.getStandardName(), AnyFactory.createFrom((Object)target));
        IPluginProgrammingElementAccess call = javaAccess.createProgrammingElement(this.m_pluginId, this.m_webCallMetaData, (INamedElementAccess)callMethod, name, callMethod.getLineNumber(), (Map)properties);
        return call;
    }

    private String determineHttpMethod(IJavaMethodAccess methodWithReturnType, List<String> fileContent) {
        assert (methodWithReturnType != null) : "Parameter 'methodWithReturnType' of method 'determineHttpMethod' must not be null";
        assert (fileContent != null && !fileContent.isEmpty()) : "Parameter 'fileContent' of method 'determineHttpMethod' must not be empty";
        int endLine = methodWithReturnType.getEndLineNumber();
        if (endLine != -1) {
            int index = endLine;
            while (index > endLine - 3) {
                String line = fileContent.get(index - 1);
                Matcher matcher = this.m_callPattern.matcher(line);
                if (matcher.find()) {
                    return matcher.group(1);
                }
                --index;
            }
        }
        return null;
    }

    private List<IAggregatedDependencyAccess> getMethodsWithCallReturnTypeDependency(IPluginJavaAccess javaAccess) {
        assert (javaAccess != null) : "Parameter 'javaAccess' of method 'getMethodsWithCallReturnTypeDependency' must not be null";
        IJavaTypeAccess httpCall = (IJavaTypeAccess)javaAccess.findElementByFqn("Workspace:External [Java]:[Unknown]:com:squareup:okhttp:Call:Call");
        if (httpCall == null) {
            return Collections.emptyList();
        }
        return httpCall.getIncomingDependenciesRecursively(Aggregator.ELEMENT, true, new IDependencyKind[]{JavaDependencyKind.RETURNS});
    }

    private String determineTarget(int startLine, List<String> content) {
        assert (content != null) : "Parameter 'content' of method 'determineTarget' must not be null";
        int index = startLine;
        while (index < startLine + 8) {
            String line = content.get(index);
            Matcher matcher = this.m_pathPattern.matcher(line);
            if (matcher.find()) {
                return matcher.group(1);
            }
            ++index;
        }
        return null;
    }

    void detect(IModelPluginContext context, IPluginJavaAccess javaAccess) {
        assert (context != null) : "Parameter 'context' of method 'detect' must not be null";
        assert (javaAccess != null) : "Parameter 'javaAccess' of method 'detect' must not be null";
        Predicate<INamedElementAccess> predicate = element -> element instanceof IPluginProgrammingElementAccess && ((IPluginProgrammingElementAccess)element).getPluginElementType().equals(this.m_webResourceMetaData.getType());
        List webResources = javaAccess.findAllMatchingElementsRecursively(javaAccess.getWorkspaceRoot(), predicate).stream().filter(e -> e instanceof IPluginProgrammingElementAccess).map(e -> (IPluginProgrammingElementAccess)e).collect(Collectors.toList());
        THashMap lineCache = new THashMap();
        List<IAggregatedDependencyAccess> methodsWithCallReturnTypeDependency = this.getMethodsWithCallReturnTypeDependency(javaAccess);
        for (IAggregatedDependencyAccess nextDependency : methodsWithCallReturnTypeDependency) {
            String httpMethodType;
            String target;
            assert (nextDependency.getNumberOfDependencies() == 1) : "Method must have exactly one dependency to com.sqareup.okhttp.Call, but has " + nextDependency.getNumberOfDependencies() + ", dep: " + String.valueOf(nextDependency);
            if (context.hasBeenCanceled()) {
                return;
            }
            IDependencyAccess dep = (IDependencyAccess)nextDependency.getDependencies().get(0);
            assert (dep.getFrom() instanceof IJavaMethodAccess) : "Unexpected 'from' of dependency: " + dep.getFrom().getClass().getCanonicalName();
            IJavaMethodAccess methodWithReturnType = (IJavaMethodAccess)dep.getFrom();
            if (methodWithReturnType.getShortName().equals("buildCall")) continue;
            int startLine = methodWithReturnType.getLineNumber();
            ISourceFileAccess sourceFile = methodWithReturnType.getSourceFile();
            List content = (List)lineCache.get(sourceFile);
            if (content == null) {
                content = sourceFile.getSourceLines(false);
                lineCache.put(sourceFile, content);
            }
            if ((target = this.determineTarget(startLine, content)) == null || (httpMethodType = this.determineHttpMethod(methodWithReturnType, content)) == null) continue;
            String prefix = methodWithReturnType.getShortName().substring(0, methodWithReturnType.getShortName().length() - "Call".length());
            IMethodAccess callMethod = javaAccess.findFirstMatchingMethod((INamedElementAccess)methodWithReturnType.getParent(), m -> m.getShortName().equals(prefix + "WithHttpInfo"));
            IPluginProgrammingElementAccess webCall = callMethod != null ? this.createWebCall(javaAccess, callMethod, prefix, httpMethodType, target) : null;
            IMethodAccess asyncCallMethod = javaAccess.findFirstMatchingMethod((INamedElementAccess)methodWithReturnType.getParent(), m -> m.getShortName().equals(prefix + "Async"));
            IPluginProgrammingElementAccess asyncWebCall = asyncCallMethod != null ? this.createWebCall(javaAccess, asyncCallMethod, prefix, httpMethodType, target) : null;
            List<String> httpMethodTypes = Collections.singletonList(httpMethodType);
            boolean foundMatch = false;
            for (IPluginProgrammingElementAccess webResource : webResources) {
                if (context.hasBeenCanceled()) {
                    return;
                }
                if (!WebUtilities.match((IPluginProgrammingElementAccess)webResource, (String)target, (String)target, httpMethodTypes)) continue;
                if (webCall != null) {
                    javaAccess.addDependency(this.m_pluginId, this.m_httpCallMetaData, (IProgrammingElementAccess)webCall, (IProgrammingElementAccess)webResource);
                }
                if (asyncWebCall != null) {
                    javaAccess.addDependency(this.m_pluginId, this.m_httpCallMetaData, (IProgrammingElementAccess)asyncWebCall, (IProgrammingElementAccess)webResource);
                }
                foundMatch = true;
                break;
            }
            if (foundMatch) continue;
            IPluginProgrammingElementAccess externalWebResource = this.getOrCreateExternalResource((IPluginLanguageBasedAccess)javaAccess, target, httpMethodTypes);
            if (webCall != null) {
                javaAccess.addDependency(this.m_pluginId, this.m_httpCallMetaData, (IProgrammingElementAccess)webCall, (IProgrammingElementAccess)externalWebResource);
            }
            if (asyncWebCall == null) continue;
            javaAccess.addDependency(this.m_pluginId, this.m_httpCallMetaData, (IProgrammingElementAccess)asyncWebCall, (IProgrammingElementAccess)externalWebResource);
        }
    }
}

