/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.plugin.spring.microservices.model;

import com.hello2morrow.sonargraph.api.java.IJavaModuleAccess;
import de.schlichtherle.truezip.file.TFile;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SpringBootModule {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpringBootModule.class);
    private final IJavaModuleAccess m_module;
    private final TFile m_resourcesDir;
    private boolean m_configServer = false;
    private boolean m_discoveryClient = false;
    private final Map<String, Object> m_configuration = new HashMap<String, Object>();

    public SpringBootModule(IJavaModuleAccess module, TFile resourcesDir) {
        assert (module != null) : "Parameter 'module' of method 'SpringBootModule' must not be null";
        this.m_module = module;
        this.m_resourcesDir = resourcesDir;
    }

    public IJavaModuleAccess getModule() {
        return this.m_module;
    }

    public TFile getResourcesDir() {
        return this.m_resourcesDir;
    }

    public void enableConfigServer() {
        this.m_configServer = true;
    }

    public boolean isConfigServer() {
        return this.m_configServer;
    }

    public void enableDiscoveryClient() {
        this.m_discoveryClient = true;
    }

    public boolean isDiscoveryClient() {
        return this.m_discoveryClient;
    }

    public String getName() {
        return this.m_module.getName();
    }

    public void addConfigurationMap(Map<String, Object> config, String info) {
        assert (config != null) : "Parameter 'config' of method 'addConfigurationMap' must not be null";
        assert (info != null && info.length() > 0) : "Parameter 'info' of method 'addConfigurationMap' must not be empty";
        if (!this.m_configuration.isEmpty()) {
            LOGGER.info("Overriding with configuration values from " + info + " for module " + this.m_module.getName());
        }
        this.m_configuration.putAll(config);
    }

    public Map<String, Object> getConfiguration() {
        return Collections.unmodifiableMap(this.m_configuration);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("SpringBootApplication module '");
        builder.append(this.m_module.getName());
        if (this.m_configServer) {
            builder.append(" (configServer)");
        } else if (this.m_discoveryClient) {
            builder.append(" (discoveryClient)");
        }
        return builder.toString();
    }

    public String getApplicationName() {
        Object applicationName = this.m_configuration.get("spring.application.name");
        return applicationName != null ? applicationName.toString() : null;
    }
}

