/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.plugin.spring.microservices;

import com.hello2morrow.sonargraph.api.PluginDependencyMetaData;
import com.hello2morrow.sonargraph.api.PluginProgrammingElementMetaData;
import com.hello2morrow.sonargraph.plugin.IModelPluginContext;
import com.hello2morrow.sonargraph.plugin.IModelPluginInfoConsumer;
import com.hello2morrow.sonargraph.plugin.IPluginContext;
import com.hello2morrow.sonargraph.plugin.IPluginModelContributor;
import com.hello2morrow.sonargraph.plugin.ISonargraphPluginContributor;
import com.hello2morrow.sonargraph.plugin.SonargraphPlugin;
import com.hello2morrow.sonargraph.plugin.SonargraphPluginManager;
import com.hello2morrow.sonargraph.plugin.java.IPluginJavaAccess;
import com.hello2morrow.sonargraph.plugin.spring.microservices.FeignClientWebCallDetector;
import com.hello2morrow.sonargraph.plugin.spring.microservices.SpringBootDetector;
import com.hello2morrow.sonargraph.plugin.spring.microservices.SpringWebResourceDetector;
import java.util.Collections;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SpringMicroservicesPlugin
extends SonargraphPlugin
implements IPluginModelContributor {
    public static final String ID = "com.hello2morrow.sonargraph.plugin.spring.microservices";
    private static final Logger LOGGER = LoggerFactory.getLogger(SpringMicroservicesPlugin.class);
    private SpringBootDetector m_springBootDetector;
    private SpringWebResourceDetector m_springWebResourceDetector;
    private FeignClientWebCallDetector m_callDetector;

    public SpringMicroservicesPlugin() {
        LOGGER.debug("[" + this.getId() + "] Started");
        SonargraphPluginManager.getInstance().addPlugin((SonargraphPlugin)this);
    }

    public String getId() {
        return ID;
    }

    public String getVendor() {
        return "hello2morrow GmbH";
    }

    public String getVersion() {
        return "n/a";
    }

    public String getDescription() {
        return "Detects and adds web resources of SpringBoot applications and their dependencies.";
    }

    public String getAvailableForLanguages() {
        return "Java";
    }

    public String getPresentationName() {
        return "Sonargraph Spring Microservices Plugin";
    }

    public Set<String> getSupportedLanguages() {
        return Collections.singleton("Java");
    }

    public IPluginModelContributor getModelContributor() {
        return this;
    }

    public void initialize(ISonargraphPluginContributor contributor) {
        assert (contributor != null) : "Parameter 'contributor' of method 'initialize' must not be null";
        PluginProgrammingElementMetaData webResourceMetaData = contributor.createProgrammingElementMetaData("WebResource", "WebResource", false);
        PluginProgrammingElementMetaData externalWebResourceMetaData = contributor.createProgrammingElementMetaData("ExternalWebResource", "WebResource", true);
        PluginProgrammingElementMetaData webCallMetaData = contributor.createProgrammingElementMetaData("WebCall", "WebCall", false);
        PluginDependencyMetaData httpCallMetaData = contributor.createDependencyMetaData("HttpCall", false, true, false);
        this.m_springBootDetector = new SpringBootDetector();
        this.m_springWebResourceDetector = new SpringWebResourceDetector(this.getId(), this.m_springBootDetector, webResourceMetaData);
        this.m_callDetector = new FeignClientWebCallDetector(this.getId(), this.m_springBootDetector, webResourceMetaData, externalWebResourceMetaData, webCallMetaData, httpCallMetaData);
    }

    public void createModelElements(IModelPluginContext context, IModelPluginInfoConsumer infoConsumer) {
        assert (context != null) : "Parameter 'context' of method 'createModelElements' must not be null";
        assert (infoConsumer != null) : "Parameter 'infoConsumer' of method 'createModelElements' must not be null";
        assert (this.m_springBootDetector != null) : "'m_springBootDetector' of method 'createModelElements' must not be null";
        assert (this.m_springWebResourceDetector != null) : "'m_springWebResourceDetector' of method 'createModelElements' must not be null";
        LOGGER.debug("Creating model elements");
        IPluginJavaAccess javaAccess = (IPluginJavaAccess)context.getAccess(IPluginJavaAccess.class);
        assert (javaAccess != null) : "Parameter 'javaAccess' of method 'createModelElements' must not be null";
        this.m_springBootDetector.detect(context, javaAccess);
        this.m_springWebResourceDetector.detect(context, javaAccess);
    }

    public void createDependencies(IModelPluginContext context, IModelPluginInfoConsumer infoConsumer) {
        assert (context != null) : "Parameter 'context' of method 'createDependencies' must not be null";
        assert (infoConsumer != null) : "Parameter 'infoConsumer' of method 'createDependencies' must not be null";
        assert (this.m_callDetector != null) : "'m_callDetector' of method 'createDependencies' must not be null";
        LOGGER.debug("Creating dependencies");
        IPluginJavaAccess javaAccess = (IPluginJavaAccess)context.getAccess(IPluginJavaAccess.class);
        assert (javaAccess != null) : "Parameter 'javaAccess' of method 'createModelElements' must not be null";
        this.m_callDetector.detect(context, javaAccess);
    }

    public void cleared(IPluginContext context) {
    }
}

