/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.plugin.issues.csv;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

final class RangeList {
    private final List<Range> m_ranges;

    private RangeList(List<Range> ranges) {
        assert (ranges != null) : "Parameter 'ranges' of method 'RangeList' must not be null";
        this.m_ranges = ranges;
    }

    static RangeList buildRangeListFromString(String rangeListAsString) {
        assert (rangeListAsString != null);
        if (rangeListAsString.trim().isEmpty()) {
            return new RangeList(Collections.emptyList());
        }
        String[] ranges = rangeListAsString.split(",");
        ArrayList<Range> rangeList = new ArrayList<Range>();
        String[] stringArray = ranges;
        int n = ranges.length;
        int n2 = 0;
        while (n2 < n) {
            String range = stringArray[n2];
            String[] bounds = range.trim().split("-");
            if (bounds.length != 2) {
                throw new IllegalArgumentException("Invalid range: " + range.trim());
            }
            try {
                int from = Integer.valueOf(bounds[0].trim());
                int to = Integer.valueOf(bounds[1].trim());
                if (from > to) {
                    throw new IllegalArgumentException("Invalid range: " + range.trim());
                }
                Range newRange = new Range(from, to);
                if (rangeList.stream().anyMatch(r -> r.overlaps(newRange))) {
                    throw new IllegalArgumentException("Overlapping range: " + range.trim());
                }
                rangeList.add(newRange);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Invalid range: " + range.trim());
            }
            ++n2;
        }
        return new RangeList(rangeList);
    }

    boolean isInside(int value) {
        return this.m_ranges.stream().anyMatch(r -> r.isInside(value));
    }

    boolean overlaps(RangeList other) {
        for (Range range : this.m_ranges) {
            if (!other.m_ranges.stream().anyMatch(r -> r.overlaps(range))) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        if (this.m_ranges.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.m_ranges.get(0).toString());
        int i = 1;
        while (i < this.m_ranges.size()) {
            sb.append(", ").append(this.m_ranges.get(i).toString());
            ++i;
        }
        return sb.toString();
    }

    private static class Range {
        private final int m_from;
        private final int m_to;

        private Range(int from, int to) {
            assert (to >= from);
            this.m_from = from;
            this.m_to = to;
        }

        private boolean isInside(int value) {
            return value >= this.m_from && value <= this.m_to;
        }

        private boolean overlaps(Range other) {
            return other.m_to >= this.m_from && other.m_from <= this.m_to;
        }

        public String toString() {
            return String.format("%d-%d", this.m_from, this.m_to);
        }
    }
}

