/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.plugin;

import com.hello2morrow.sonargraph.plugin.SonargraphPlugin;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SonargraphPluginManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(SonargraphPluginManager.class);
    private static SonargraphPluginManager s_instance;
    private final List<SonargraphPlugin> m_plugins = new ArrayList<SonargraphPlugin>();

    private SonargraphPluginManager() {
        s_instance = this;
        LOGGER.debug("[" + String.valueOf(this) + "] Instantiated");
    }

    public static SonargraphPluginManager getInstance() {
        if (s_instance == null) {
            s_instance = new SonargraphPluginManager();
        }
        return s_instance;
    }

    private SonargraphPlugin getPluginById(String id) {
        assert (id != null && id.length() > 0) : "Parameter 'id' of method 'getPluginById' must not be empty";
        return this.m_plugins.stream().filter(plugin -> plugin.getId().equals(id)).findFirst().orElse(null);
    }

    public boolean isAvailable(String pluginId) {
        assert (pluginId != null && pluginId.length() > 0) : "Parameter 'pluginId' of method 'isAvailable' must not be empty";
        return this.getPluginById(pluginId) != null;
    }

    public void addPlugin(SonargraphPlugin plugin) {
        assert (plugin != null) : "Parameter 'plugin' of method 'addPlugin' must not be null";
        LOGGER.debug("Add Sonargraph Plugin '" + plugin.getId() + "'");
        if (this.getPluginById(plugin.getId()) == null) {
            this.m_plugins.add(plugin);
        } else {
            LOGGER.error("Plugin '" + plugin.getId() + "' already added");
        }
    }

    public List<SonargraphPlugin> getPlugins() {
        return Collections.unmodifiableList(this.m_plugins);
    }
}

