/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.plugin.angular;

import com.hello2morrow.sonargraph.plugin.angular.ElementUsage;
import com.hello2morrow.sonargraph.plugin.angular.PipeUsage;
import com.hello2morrow.sonargraph.plugin.angular.Usage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Attribute;
import org.jsoup.nodes.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class HtmlFile {
    private static final Logger LOGGER = LoggerFactory.getLogger(HtmlFile.class);
    private static final Pattern ATTRIBUTE_WITH_BINDING = Pattern.compile("^(\\[.*]|\\(.*\\))$");
    private static final Pattern DYNAMIC_TEXT = Pattern.compile("\\{\\{(.*)}}");
    private static final Pattern PIPE = Pattern.compile("\\|\\s*([a-zA-Z0-9\\-_$]+)(\\s*:[^|]+)*");

    HtmlFile() {
    }

    private static List<Usage> findUsages(Element element) {
        assert (element != null) : "Parameter 'element' of method 'findUsages' must not be null";
        ArrayList<Usage> usages = new ArrayList<Usage>();
        List<String> attributes = element.attributes().asList().stream().map(Attribute::getKey).map(it -> it.replaceAll("[(\\[\\])]", "")).collect(Collectors.toList());
        usages.add(new ElementUsage(element.tagName(), attributes));
        element.attributes().asList().stream().filter(a -> ATTRIBUTE_WITH_BINDING.matcher(a.getKey()).matches()).map(Attribute::getValue).flatMap(HtmlFile::findPipeUsagesInTypescriptCode).forEach(usages::add);
        element.attributes().asList().stream().filter(a -> !ATTRIBUTE_WITH_BINDING.matcher(a.getKey()).matches()).map(Attribute::getValue).flatMap(HtmlFile::findPipeUsagesInTemplateText).forEach(usages::add);
        if (element.hasText()) {
            HtmlFile.findPipeUsagesInTemplateText(element.ownText()).forEach(usages::add);
        }
        for (Element child : element.children()) {
            usages.addAll(HtmlFile.findUsages(child));
        }
        return usages;
    }

    private static Stream<PipeUsage> findPipeUsagesInTemplateText(String text) {
        return DYNAMIC_TEXT.matcher(text).results().map(r -> r.group(1)).flatMap(HtmlFile::findPipeUsagesInTypescriptCode);
    }

    private static Stream<PipeUsage> findPipeUsagesInTypescriptCode(String code) {
        return PIPE.matcher(code).results().map(r -> r.group(1)).map(String::trim).map(PipeUsage::new);
    }

    static List<Usage> findUsages(File input) {
        assert (input != null) : "Parameter 'input' of method 'findUsages' must not be null";
        try {
            Element parsed = Jsoup.parse((File)input, (String)"UTF-8").body();
            return HtmlFile.findUsages(parsed);
        }
        catch (IOException e) {
            LOGGER.warn("Error while parsing " + input.getPath() + ":\n" + e.getMessage());
            return Collections.emptyList();
        }
    }

    static List<Usage> findUsages(String html) {
        assert (html != null) : "Parameter 'html' of method 'findUsages' must not be null";
        Element parsed = Jsoup.parse((String)html, (String)"UTF-8").body();
        return HtmlFile.findUsages(parsed);
    }
}

