/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.plugin.angular;

import com.hello2morrow.sonargraph.plugin.angular.IExecutionContext;
import com.hello2morrow.sonargraph.plugin.angular.IJsonFileManager;
import com.hello2morrow.sonargraph.plugin.angular.JsonFile;
import com.jayway.jsonpath.Predicate;
import gnu.trove.map.hash.THashMap;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;

final class AngularJsonFile
extends JsonFile {
    private final Map<Path, Path> m_rootsByConfig = new THashMap();

    AngularJsonFile(Path path, IJsonFileManager manager, IExecutionContext context) throws IOException {
        super(path, manager);
        assert (context != null) : "Parameter 'context' of method 'AngularJsonFile' must not be null";
        List sourceRoots = (List)this.getDocumentContext().read("$.projects[*].sourceRoot", new Predicate[0]);
        for (String sourceRoot : sourceRoots) {
            if (context.hasBeenCanceled()) {
                return;
            }
            List tsConfig = (List)this.getDocumentContext().read(String.format("$.projects.*[?(@.sourceRoot == '%s')].architect.build.options.tsConfig", sourceRoot), new Predicate[0]);
            if (tsConfig == null || tsConfig.isEmpty()) continue;
            Path tsConfigPath = this.getPath().getParent().resolve((String)tsConfig.get(0)).normalize();
            Path sourceRootPath = this.getPath().getParent().resolve(sourceRoot).normalize();
            this.m_rootsByConfig.put(tsConfigPath, sourceRootPath);
        }
    }

    protected final Map<Path, Path> getRootsByConfig() {
        return this.m_rootsByConfig;
    }
}

