/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.license.controller;

import com.hello2morrow.sonargraph.foundation.utilities.HttpConnectionCheck;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResultWithOutcome;
import com.hello2morrow.sonargraph.foundation.utilities.Pair;
import com.hello2morrow.sonargraph.foundation.utilities.Platform;
import com.hello2morrow.sonargraph.foundation.utilities.PropertiesParser;
import com.hello2morrow.sonargraph.foundation.utilities.ProxySettings;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.httpclient.controller.HttpClientWrapper;
import com.hello2morrow.sonargraph.httpclient.model.HttpClientInfo;
import com.hello2morrow.sonargraph.license.foundation.LicenseUtilities;
import com.hello2morrow.sonargraph.license.model.LicenseMessageCause;
import com.hello2morrow.sonargraph.license.model.LicenseServerHost;
import com.hello2morrow.sonargraph.license.model.ProductDescriptor;
import java.io.Closeable;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Timer;
import java.util.TimerTask;
import java.util.function.Consumer;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.message.BasicNameValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class LicenseTicketRequester
extends HttpClientWrapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(LicenseTicketRequester.class);
    private static final String DELIMITERS = ", \n";
    private static final String UNKNOWN_USER = "<unknown user>";
    private static final String HEART_BEAT_SECONDS = "HeartBeatSeconds";
    private static final String TICKET_ID = "TicketId";
    private static final String TICKET_MAGIC = "TicketMagic";
    private static final String NONE = "NONE";
    private static final String RENEWED = "RENEWED";
    private static final String INVALID_TICKET = "INVALID_TICKET";
    private static final String CONTRACT_EXPORTED = "CONTRACT_EXPORTED";
    private static final String SERVER_ERROR = "SERVER_ERROR";
    private static final String INVALID_ACTIVATION_CODE = "INVALID_ACTIVATION_CODE";
    private static final String INVALID_REQUEST = "INVALID_REQUEST";
    private static final String INACTIVE_ACTIVATION_CODE = "INACTIVE_ACTIVATION_CODE";
    private static final String UNAUTHORIZED_LICENSE_SERVER = "UNAUTHORIZED_LICENSE_SERVER";
    private static final String VERSION_NOT_LICENSED = "VERSION_NOT_LICENSED";
    private static final String WRONG_PRODUCT = "WRONG_PRODUCT";
    private static final String LICENSE_EXPIRED = "LICENSE_EXPIRED";
    private static final String NO_LICENSE_AVAILABLE = "NO_LICENSE_AVAILABLE";
    private final LicenseServerHost m_licenseServerHost;
    private final Consumer<String> m_lostLicenseEventConsumer;
    private HttpClientInfo m_httpClientInfo;
    private ProductDescriptor m_productDescriptor;
    private String m_activationCode;
    private String m_lastResponse;
    private String m_ticketId;
    private String m_ticketMagic;
    private boolean m_ticketReleased = false;
    private int m_failedHeartBeats = 0;
    private Timer m_timer;
    private int m_heartBeatinSeconds;

    LicenseTicketRequester(List<String> hosts, ProxySettings proxySettings, Consumer<String> lostLicenseEventConsumer, LicenseServerHost licenseServerHost) {
        super(hosts, proxySettings);
        assert (lostLicenseEventConsumer != null) : "Parameter 'lostLicenseEventConsumer' of method 'LicenseTicketRequester' must not be null";
        this.m_lostLicenseEventConsumer = lostLicenseEventConsumer;
        this.m_licenseServerHost = licenseServerHost;
    }

    private List<NameValuePair> initializeParameters() {
        ArrayList<NameValuePair> formparams = new ArrayList<NameValuePair>();
        formparams.add((NameValuePair)new BasicNameValuePair("product", this.m_productDescriptor.getProduct()));
        formparams.add((NameValuePair)new BasicNameValuePair("serial_number", this.m_activationCode));
        formparams.add((NameValuePair)new BasicNameValuePair("build_date", this.m_productDescriptor.getBuildDate()));
        formparams.add((NameValuePair)new BasicNameValuePair("version", this.m_productDescriptor.getVersion()));
        formparams.add((NameValuePair)new BasicNameValuePair("user_name", Platform.getUserName()));
        formparams.add((NameValuePair)new BasicNameValuePair("os_name", System.getProperty("os.name")));
        formparams.add((NameValuePair)new BasicNameValuePair("os_version", System.getProperty("os.version")));
        formparams.add((NameValuePair)new BasicNameValuePair("lease_duration", "1"));
        return formparams;
    }

    /*
     * Unable to fully structure code
     */
    private void post(OperationResultWithOutcome<Map<String, String>> result, String path, List<NameValuePair> params) {
        block83: {
            if (!LicenseTicketRequester.$assertionsDisabled && result == null) {
                throw new AssertionError((Object)"Parameter 'result' of method 'post' must not be null");
            }
            if (!(LicenseTicketRequester.$assertionsDisabled || path != null && path.length() > 0)) {
                throw new AssertionError((Object)"Parameter 'path' of method 'post' must not be empty");
            }
            if (!LicenseTicketRequester.$assertionsDisabled && params == null) {
                throw new AssertionError((Object)"Parameter 'params' of method 'post' must not be null");
            }
            this.m_lastResponse = "NONE";
            try {
                entity = new UrlEncodedFormEntity(params, StandardCharsets.UTF_8.name());
                httpPost = new HttpPost(this.m_httpClientInfo.getHost() + path);
                httpPost.setEntity((HttpEntity)entity);
                LicenseTicketRequester.LOGGER.debug("Requesting ticket from '" + String.valueOf(httpPost.getURI()) + "'");
                httpClient = HttpClientWrapper.createHttpClient(this.m_httpClientInfo.getProxySettings(), this.m_productDescriptor.getTimeoutMultiplier());
                try {
                    response = httpClient.execute((HttpUriRequest)httpPost);
                    reply = response.getEntity();
                    if (reply == null) {
                        result.addError((OperationResult.IMessageCause)LicenseMessageCause.NO_SERVER_REPLY);
                        break block83;
                    }
                    var9_10 = null;
                    var10_12 = null;
                    try {
                        instream = reply.getContent();
                        try {
                            streamReader = new InputStreamReader(instream, StandardCharsets.UTF_8.name());
                            try {
                                block84: {
                                    reader = new LineNumberReader(streamReader);
                                    try {
                                        this.m_lastResponse = reader.readLine();
                                        LicenseTicketRequester.LOGGER.debug("Response is {}", (Object)this.m_lastResponse);
                                        dataBuffer = new StringBuffer(1024);
                                        while ((c = reader.read()) != -1) {
                                            dataBuffer.append((char)c);
                                        }
                                        if (this.m_lastResponse == null) {
                                            result.addError((OperationResult.IMessageCause)LicenseMessageCause.INTERNAL_LICENSE_SERVER_ERROR, "Invalid server reply.", new Object[0]);
                                            this.m_lastResponse = "NONE";
                                            LicenseTicketRequester.LOGGER.error("Invalid server reply: null");
                                            break block84;
                                        }
                                        var16_21 = this.m_lastResponse;
                                        tmp = -1;
                                        switch (var16_21.hashCode()) {
                                            case -2049951513: {
                                                if (var16_21.equals("LICENSE_EXPIRED")) {
                                                    tmp = 1;
                                                }
                                                break;
                                            }
                                            case -1718584202: {
                                                if (var16_21.equals("VERSION_NOT_LICENSED")) {
                                                    tmp = 2;
                                                }
                                                break;
                                            }
                                            case -1623975006: {
                                                if (var16_21.equals("INACTIVE_ACTIVATION_CODE")) {
                                                    tmp = 3;
                                                }
                                                break;
                                            }
                                            case -1438279651: {
                                                if (var16_21.equals("WRONG_PRODUCT")) {
                                                    tmp = 4;
                                                }
                                                break;
                                            }
                                            case -1125000185: {
                                                if (var16_21.equals("INVALID_REQUEST")) {
                                                    tmp = 5;
                                                }
                                                break;
                                            }
                                            case -1018658868: {
                                                if (var16_21.equals("UNAUTHORIZED_LICENSE_SERVER")) {
                                                    tmp = 6;
                                                }
                                                break;
                                            }
                                            case -2558706: {
                                                if (var16_21.equals("INVALID_ACTIVATION_CODE")) {
                                                    tmp = 7;
                                                }
                                                break;
                                            }
                                            case 2524: {
                                                if (var16_21.equals("OK")) {
                                                    tmp = 8;
                                                }
                                                break;
                                            }
                                            case 301330036: {
                                                if (var16_21.equals("INVALID_TICKET")) {
                                                    tmp = 9;
                                                }
                                                break;
                                            }
                                            case 352589069: {
                                                if (var16_21.equals("NO_LICENSE_AVAILABLE")) {
                                                    tmp = 10;
                                                }
                                                break;
                                            }
                                            case 1178575340: {
                                                if (var16_21.equals("SERVER_ERROR")) {
                                                    tmp = 11;
                                                }
                                                break;
                                            }
                                            case 1810445260: {
                                                if (var16_21.equals("RENEWED")) {
                                                    tmp = 12;
                                                }
                                                break;
                                            }
                                            case 1902000096: {
                                                if (var16_21.equals("CONTRACT_EXPORTED")) {
                                                    tmp = 13;
                                                }
                                                break;
                                            }
                                        }
                                        switch (tmp) {
                                            case 8: {
                                                result.setOutcome((Object)PropertiesParser.parse((String)dataBuffer.toString()));
                                                ** break;
lbl115:
                                                // 1 sources

                                                break;
                                            }
                                            case 12: {
                                                result.setOutcome((Object)PropertiesParser.parse((String)dataBuffer.toString()));
                                                ** break;
lbl119:
                                                // 1 sources

                                                break;
                                            }
                                            case 9: {
                                                result.addError((OperationResult.IMessageCause)LicenseMessageCause.INVALID_TICKET);
                                                ** break;
lbl123:
                                                // 1 sources

                                                break;
                                            }
                                            case 7: {
                                                result.addError((OperationResult.IMessageCause)LicenseMessageCause.INVALID_ACTIVATION_CODE);
                                                ** break;
lbl127:
                                                // 1 sources

                                                break;
                                            }
                                            case 2: {
                                                result.addError((OperationResult.IMessageCause)LicenseMessageCause.VERSION_NOT_LICENSED);
                                                ** break;
lbl131:
                                                // 1 sources

                                                break;
                                            }
                                            case 4: {
                                                result.addError((OperationResult.IMessageCause)LicenseMessageCause.INVALID_PRODUCT);
                                                ** break;
lbl135:
                                                // 1 sources

                                                break;
                                            }
                                            case 1: {
                                                result.addError((OperationResult.IMessageCause)LicenseMessageCause.LICENSE_EXPIRED);
                                                ** break;
lbl139:
                                                // 1 sources

                                                break;
                                            }
                                            case 11: {
                                                result.addError((OperationResult.IMessageCause)LicenseMessageCause.INTERNAL_LICENSE_SERVER_ERROR);
                                                ** break;
lbl143:
                                                // 1 sources

                                                break;
                                            }
                                            case 10: {
                                                builder = new StringBuilder();
                                                if (dataBuffer.length() > 0 && !(lines = StringUtility.multiLineStringToList((String)dataBuffer.toString())).isEmpty()) {
                                                    builder.append("Total number of tickets: ").append(lines.size()).append("\n");
                                                    builder.append("Users currently using a ticket:").append("\n");
                                                    i = 0;
                                                    for (String nextLine : lines) {
                                                        nextUser = "<unknown user>";
                                                        nextTokenizer = new StringTokenizer(nextLine, ", \n");
                                                        if (nextTokenizer.hasMoreTokens()) {
                                                            nextUser = nextTokenizer.nextToken();
                                                        }
                                                        builder.append(" (").append(++i).append(") ").append(nextUser).append("\n");
                                                    }
                                                }
                                                if (builder.length() > 0) {
                                                    result.addError((OperationResult.IMessageCause)LicenseMessageCause.NO_LICENSE_TICKETS_AVAILABLE, builder.toString(), new Object[0]);
                                                    ** break;
lbl163:
                                                    // 1 sources

                                                } else {
                                                    result.addError((OperationResult.IMessageCause)LicenseMessageCause.NO_LICENSE_TICKETS_AVAILABLE);
                                                    ** break;
                                                }
lbl166:
                                                // 1 sources

                                                break;
                                            }
                                            case 5: {
                                                result.addError((OperationResult.IMessageCause)LicenseMessageCause.INVALID_REQUEST);
                                                ** break;
lbl170:
                                                // 1 sources

                                                break;
                                            }
                                            case 3: {
                                                result.addError((OperationResult.IMessageCause)LicenseMessageCause.INACTIVE_ACTIVATION_CODE);
                                                ** break;
lbl174:
                                                // 1 sources

                                                break;
                                            }
                                            case 6: {
                                                result.addError((OperationResult.IMessageCause)LicenseMessageCause.UNAUTHORIZED_LICENSE_SERVER);
                                                ** break;
lbl178:
                                                // 1 sources

                                                break;
                                            }
                                            case 13: {
                                                result.addError((OperationResult.IMessageCause)LicenseMessageCause.LICENSE_SERVER_REQUIRED, "A license server must be configured. Please contact your Sonargraph administrator for details.", new Object[0]);
                                                ** break;
lbl182:
                                                // 1 sources

                                                break;
                                            }
                                            default: {
                                                result.addError((OperationResult.IMessageCause)LicenseMessageCause.UNABLE_TO_PERFORM_REQUEST, "Unknown response %s.", new Object[]{this.m_lastResponse + "\n" + dataBuffer.toString() + " from " + String.valueOf(httpPost.getURI())});
                                                break;
                                            }
                                        }
                                    }
                                    finally {
                                        if (reader != null) {
                                            reader.close();
                                        }
                                    }
                                }
                                ** if (streamReader == null) goto lbl-1000
                            }
                            catch (Throwable var10_13) {
                                if (var9_10 == null) {
                                    var9_10 = var10_13;
                                } else if (var9_10 != var10_13) {
                                    var9_10.addSuppressed(var10_13);
                                }
                                if (streamReader != null) {
                                    streamReader.close();
                                }
                                throw var9_10;
                            }
lbl-1000:
                            // 1 sources

                            {
                                streamReader.close();
                            }
lbl-1000:
                            // 2 sources

                            {
                            }
                            ** if (instream == null) goto lbl-1000
                        }
                        catch (Throwable var10_14) {
                            if (var9_10 == null) {
                                var9_10 = var10_14;
                            } else if (var9_10 != var10_14) {
                                var9_10.addSuppressed(var10_14);
                            }
                            if (instream != null) {
                                instream.close();
                            }
                            throw var9_10;
                        }
lbl-1000:
                        // 1 sources

                        {
                            instream.close();
                        }
lbl-1000:
                        // 2 sources

                        {
                        }
                    }
                    catch (Throwable var10_15) {
                        if (var9_10 == null) {
                            var9_10 = var10_15;
                        } else if (var9_10 != var10_15) {
                            var9_10.addSuppressed(var10_15);
                        }
                        throw var9_10;
                    }
                }
                finally {
                    if (httpClient instanceof Closeable) {
                        ((Closeable)httpClient).close();
                    }
                }
            }
            catch (Exception e) {
                result.addError((OperationResult.IMessageCause)LicenseMessageCause.INTERNAL_LICENSE_CLIENT_ERROR, (Throwable)e);
            }
        }
    }

    private void receiveLicenseDetails(OperationResultWithOutcome<Map<String, String>> result, String ticketId, String ticketMagic) {
        assert (result != null) : "Parameter 'result' of method 'receiveLicenseDetails' must not be null";
        assert (this.m_activationCode != null) : "'m_activationCode' of method 'receiveLicenseDetails' must not be null";
        assert (this.m_httpClientInfo != null) : "'m_httpClientInfo' of method 'receiveLicenseDetails' must not be null";
        assert (this.m_productDescriptor != null) : "'m_productDescriptor' of method 'receiveLicenseDetails' must not be null";
        List<NameValuePair> formparams = this.initializeParameters();
        if (ticketId != null) {
            assert (ticketMagic != null) : "Parameter 'ticketMagic' of method 'receiveLicenseDetails' must not be null if ticketId is not null";
            formparams.add((NameValuePair)new BasicNameValuePair("id", ticketId));
            formparams.add((NameValuePair)new BasicNameValuePair("magic", ticketMagic));
        } else {
            Map<String, String> physicalAddresses = LicenseUtilities.getMacAdresses();
            if (physicalAddresses.size() == 0) {
                result.addError((OperationResult.IMessageCause)LicenseMessageCause.UNABLE_TO_DETECT_MAC_ADDRESSES, "Could not detect any MAC addresses.", new Object[0]);
                return;
            }
            StringBuffer macAddressList = new StringBuffer(256);
            for (Map.Entry<String, String> nextEntry : physicalAddresses.entrySet()) {
                if (macAddressList.length() > 0) {
                    macAddressList.append(',');
                }
                macAddressList.append(nextEntry.getKey());
            }
            formparams.add((NameValuePair)new BasicNameValuePair("node_id", macAddressList.toString()));
        }
        this.post(result, "/license_contracts/request_ticket", formparams);
    }

    @Override
    protected Pair<String, ProxySettings> getHostAndProxySettings() {
        if (this.m_licenseServerHost != null && this.m_licenseServerHost.isActive()) {
            String host = this.m_licenseServerHost.getUrl();
            if (!HttpConnectionCheck.canConnect((String)(host + "/license_contracts/test_connection"), (String)"OK\n", null)) {
                LOGGER.error("Failed to connect to license server '" + host + "'");
                host = null;
            }
            return new Pair((Object)host, null);
        }
        return super.getHostAndProxySettings();
    }

    Map<String, String> request(ProductDescriptor productDescriptor, String activationCode, String ticketId, String ticketMagic, OperationResult result) {
        assert (productDescriptor != null) : "Parameter 'productDescriptor' of method 'request' must not be null";
        assert (activationCode != null) : "Parameter 'activationCode' of method 'request' must not be null";
        assert (result != null) : "Parameter 'result' of method 'request' must not be null";
        this.m_productDescriptor = productDescriptor;
        this.m_activationCode = activationCode;
        this.m_httpClientInfo = this.getAvailableHost();
        if (this.m_httpClientInfo == null) {
            result.addError((OperationResult.IMessageCause)LicenseMessageCause.UNABLE_TO_CONTACT_LICENSE_SERVER);
            LOGGER.warn(LicenseMessageCause.UNABLE_TO_CONTACT_LICENSE_SERVER.getPresentationName());
            return null;
        }
        OperationResultWithOutcome internalResult = new OperationResultWithOutcome("Receive license details");
        this.receiveLicenseDetails((OperationResultWithOutcome<Map<String, String>>)internalResult, ticketId, ticketMagic);
        result.addMessagesFrom((OperationResult)internalResult);
        Map props = (Map)internalResult.getOutcome();
        if (props != null) {
            String heartBeatSecondsStr = (String)props.get(HEART_BEAT_SECONDS);
            if (heartBeatSecondsStr != null) {
                this.m_heartBeatinSeconds = Integer.parseInt(heartBeatSecondsStr);
                this.m_ticketId = (String)props.get(TICKET_ID);
                this.m_ticketMagic = (String)props.get(TICKET_MAGIC);
                assert (this.m_ticketId != null) : "No ticket id from server";
                assert (this.m_ticketMagic != null) : "No ticket magic from server";
                this.activateHeartBeatTimer();
            }
        } else {
            this.m_ticketId = null;
            this.m_ticketMagic = null;
        }
        return props;
    }

    private void activateHeartBeatTimer() {
        this.m_timer = new Timer();
        this.m_timer.scheduleAtFixedRate((TimerTask)new HeartBeatTask(), this.m_heartBeatinSeconds * 1000, (long)(this.m_heartBeatinSeconds * 1000));
    }

    boolean isFloatingLicense() {
        return this.m_ticketId != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean heartBeat(OperationResultWithOutcome<Map<String, String>> result, boolean reportError) {
        assert (result != null) : "Parameter 'result' of method 'heartBeat' must not be null";
        Map props = null;
        boolean errorOccured = false;
        LicenseTicketRequester licenseTicketRequester = this;
        synchronized (licenseTicketRequester) {
            if (this.m_ticketReleased) {
                return false;
            }
            List<NameValuePair> formparams = this.initializeParameters();
            formparams.add((NameValuePair)new BasicNameValuePair("id", this.m_ticketId));
            formparams.add((NameValuePair)new BasicNameValuePair("magic", this.m_ticketMagic));
            this.post(result, "/license_contracts/heart_beat", formparams);
            props = (Map)result.getOutcome();
            switch (this.m_lastResponse) {
                case "RENEWED": {
                    this.m_failedHeartBeats = 0;
                    break;
                }
                case "OK": {
                    this.m_failedHeartBeats = 0;
                    this.m_ticketId = (String)props.get(TICKET_ID);
                    this.m_ticketMagic = (String)props.get(TICKET_MAGIC);
                    break;
                }
                case "NONE": {
                    ++this.m_failedHeartBeats;
                    if (this.m_failedHeartBeats < 2) break;
                }
                default: {
                    if (this.m_timer != null) {
                        this.m_timer.cancel();
                        this.m_timer = null;
                    }
                    errorOccured = true;
                }
            }
        }
        if (errorOccured && reportError) {
            this.m_lostLicenseEventConsumer.accept(this.m_lastResponse.equals(NONE) ? "Lost license server connection" : this.m_lastResponse);
        }
        if (!errorOccured && this.m_timer == null) {
            this.activateHeartBeatTimer();
        }
        if (!errorOccured) return true;
        return false;
    }

    synchronized void releaseTicket() {
        this.m_ticketReleased = true;
        if (this.m_ticketId == null) {
            assert (this.m_timer == null) : "Timer should not exist here";
            return;
        }
        if (this.m_timer != null) {
            this.m_timer.cancel();
        }
        List<NameValuePair> formparams = this.initializeParameters();
        formparams.add((NameValuePair)new BasicNameValuePair("id", this.m_ticketId));
        formparams.add((NameValuePair)new BasicNameValuePair("magic", this.m_ticketMagic));
        OperationResultWithOutcome result = new OperationResultWithOutcome("Floating license release ticket");
        this.post((OperationResultWithOutcome<Map<String, String>>)result, "/license_contracts/release_ticket", formparams);
    }

    boolean refetchLicense() {
        OperationResultWithOutcome result = new OperationResultWithOutcome("Floating license heart beat");
        return this.heartBeat((OperationResultWithOutcome<Map<String, String>>)result, false);
    }

    private class HeartBeatTask
    extends TimerTask {
        private HeartBeatTask() {
        }

        @Override
        public void run() {
            OperationResultWithOutcome result = new OperationResultWithOutcome("Floating license heart beat");
            LicenseTicketRequester.this.heartBeat((OperationResultWithOutcome<Map<String, String>>)result, true);
        }
    }
}

